/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BugReporterObserver;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.ProjectStats;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.visitclass.PreorderVisitor;
import java.io.PrintStream;
import java.util.BitSet;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumber;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class FindBugsSummaryStats
extends PreorderVisitor
implements Detector,
BugReporterObserver,
NonReportingDetector {
    private final ProjectStats stats;
    BitSet lines = new BitSet(500);
    int methods = 0;
    int fields = 0;
    int classCodeSize;
    int totalNCSS = 0;
    int totalCodeSize = 0;
    int totalMethods = 0;
    int totalFields = 0;
    boolean sawLineNumbers;

    @Override
    public void visitJavaClass(JavaClass obj) {
        if (AnalysisContext.currentAnalysisContext().isApplicationClass(obj)) {
            super.visitJavaClass(obj);
        }
    }

    @Override
    public void visit(JavaClass obj) {
        this.lines.clear();
        this.methods = 0;
        this.fields = 0;
        this.classCodeSize = 0;
        this.sawLineNumbers = false;
    }

    @Override
    public void visit(Method obj) {
        ++this.methods;
    }

    @Override
    public void visit(Field obj) {
        ++this.fields;
    }

    @Override
    public void visit(Code obj) {
        this.classCodeSize += obj.getCode().length;
    }

    @Override
    public void visitAfter(JavaClass obj) {
        int linesNCSS = 1 + this.methods + this.fields;
        linesNCSS = this.sawLineNumbers ? (linesNCSS += this.lines.cardinality()) : (linesNCSS += this.classCodeSize / 10);
        if (this.stats != null) {
            this.stats.addClass(this.getDottedClassName(), obj.getSourceFileName(), obj.isInterface(), linesNCSS);
        }
        this.totalCodeSize += this.classCodeSize;
        this.totalNCSS += linesNCSS;
        this.totalMethods += this.methods;
        this.totalFields += this.fields;
    }

    @Override
    public void visit(LineNumber obj) {
        this.sawLineNumbers = true;
        int line = obj.getLineNumber();
        this.lines.set(line);
    }

    public FindBugsSummaryStats(BugReporter bugReporter) {
        this.stats = bugReporter.getProjectStats();
        bugReporter.addObserver(this);
    }

    public FindBugsSummaryStats() {
        this.stats = null;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        classContext.getJavaClass().accept((Visitor)this);
    }

    @Override
    public void report() {
    }

    @Override
    public void report(PrintStream out) {
        out.println("NCSS\t" + this.totalNCSS);
        out.println("codeSz\t" + this.totalCodeSize);
        out.println("methods\t" + this.totalMethods);
        out.println("fields\t" + this.totalFields);
    }

    @Override
    public void reportBug(BugInstance bug) {
    }
}

