/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugAccumulator;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.Detector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.FindBugsAnalysisFeatures;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.UseAnnotationDatabase;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowValueChooser;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Hierarchy;
import edu.umd.cs.findbugs.ba.JavaClassAndMethod;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.MissingClassException;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.OpcodeStackScanner;
import edu.umd.cs.findbugs.ba.SignatureConverter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;
import edu.umd.cs.findbugs.ba.interproc.ParameterProperty;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierAnnotation;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierApplications;
import edu.umd.cs.findbugs.ba.jsr305.TypeQualifierValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueDataflow;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonCollector;
import edu.umd.cs.findbugs.ba.npe.NullDerefAndRedundantComparisonFinder;
import edu.umd.cs.findbugs.ba.npe.NullValueUnconditionalDeref;
import edu.umd.cs.findbugs.ba.npe.ParameterNullnessPropertyDatabase;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.npe.RedundantBranch;
import edu.umd.cs.findbugs.ba.npe.ReturnPathType;
import edu.umd.cs.findbugs.ba.npe.ReturnPathTypeDataflow;
import edu.umd.cs.findbugs.ba.npe.TypeQualifierNullnessAnnotationDatabase;
import edu.umd.cs.findbugs.ba.npe.UsagesRequiringNonNullValues;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.ba.vna.ValueNumberSourceInfo;
import edu.umd.cs.findbugs.bcel.generic.NullnessConversationInstruction;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.DescriptorFactory;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.analysis.AnnotationValue;
import edu.umd.cs.findbugs.detect.DoomedCodeWarningProperty;
import edu.umd.cs.findbugs.detect.NullArgumentWarningProperty;
import edu.umd.cs.findbugs.detect.NullDerefProperty;
import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import edu.umd.cs.findbugs.log.Profiler;
import edu.umd.cs.findbugs.props.GeneralWarningProperty;
import edu.umd.cs.findbugs.props.WarningProperty;
import edu.umd.cs.findbugs.props.WarningPropertySet;
import edu.umd.cs.findbugs.props.WarningPropertyUtil;
import edu.umd.cs.findbugs.visitclass.Util;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.meta.When;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.CodeException;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LineNumberTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.IFNULL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionTargeter;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.ReturnInstruction;
import org.objectweb.asm.Type;

public class FindNullDeref
implements Detector,
UseAnnotationDatabase,
NullDerefAndRedundantComparisonCollector {
    public static final boolean DEBUG = SystemProperties.getBoolean("fnd.debug");
    private static final boolean DEBUG_NULLARG = SystemProperties.getBoolean("fnd.debug.nullarg");
    private static final boolean DEBUG_NULLRETURN = SystemProperties.getBoolean("fnd.debug.nullreturn");
    private static final boolean MARK_DOOMED = SystemProperties.getBoolean("fnd.markdoomed", true);
    private static final String METHOD = SystemProperties.getProperty("fnd.method");
    private static final String CLASS = SystemProperties.getProperty("fnd.class");
    private final BugReporter bugReporter;
    private final BugAccumulator bugAccumulator;
    private ParameterNullnessPropertyDatabase unconditionalDerefParamDatabase;
    private boolean checkedDatabases = false;
    private ClassContext classContext;
    private Method method;
    private IsNullValueDataflow invDataflow;
    private ValueNumberDataflow vnaDataflow;
    private BitSet previouslyDeadBlocks;
    private NullnessAnnotation methodAnnotation;
    @StaticConstant
    public static final Set<String> catchTypesForNull = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java/lang/NullPointerException", "java/lang/RuntimeException", "java/lang/Exception")));

    public FindNullDeref(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
        this.bugAccumulator = new BugAccumulator(bugReporter);
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        this.classContext = classContext;
        String currentMethod = null;
        JavaClass jclass = classContext.getJavaClass();
        String className = jclass.getClassName();
        if (CLASS != null && !className.equals(CLASS)) {
            return;
        }
        List<Method> methodsInCallOrder = classContext.getMethodsInCallOrder();
        for (Method method : methodsInCallOrder) {
            try {
                if (method.isAbstract() || method.isNative() || method.getCode() == null) continue;
                currentMethod = SignatureConverter.convertMethodSignature(jclass, method);
                if (METHOD != null && !method.getName().equals(METHOD)) continue;
                if (DEBUG || DEBUG_NULLARG) {
                    System.out.println("Checking for NP in " + currentMethod);
                }
                this.analyzeMethod(classContext, method);
            }
            catch (MissingClassException e) {
                this.bugReporter.reportMissingClass(e.getClassNotFoundException());
            }
            catch (DataflowAnalysisException e) {
                this.bugReporter.logError("While analyzing " + currentMethod + ": FindNullDeref caught dae exception", e);
            }
            catch (CFGBuilderException e) {
                this.bugReporter.logError("While analyzing " + currentMethod + ": FindNullDeref caught cfgb exception", e);
            }
            this.bugAccumulator.reportAccumulatedBugs();
        }
    }

    private void analyzeMethod(ClassContext classContext, Method method) throws DataflowAnalysisException, CFGBuilderException {
        String className;
        Object value;
        ClassDescriptor junitTestAnnotation;
        XMethod xMethod;
        AnnotationValue av;
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println("Pre FND ");
        }
        if ((method.getAccessFlags() & 0x40) != 0) {
            return;
        }
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen == null) {
            return;
        }
        if (!this.checkedDatabases) {
            this.checkDatabases();
            this.checkedDatabases = true;
        }
        if ((av = (xMethod = XFactory.createXMethod(classContext.getJavaClass(), method)).getAnnotation(junitTestAnnotation = DescriptorFactory.createClassDescriptor("org/junit/Test"))) != null && (value = av.getValue("expected")) instanceof Type && "java.lang.NullPointerException".equals(className = ((Type)value).getClassName())) {
            return;
        }
        this.method = method;
        this.methodAnnotation = this.getMethodNullnessAnnotation();
        if (DEBUG || DEBUG_NULLARG) {
            System.out.println("FND: " + SignatureConverter.convertMethodSignature(methodGen));
        }
        this.previouslyDeadBlocks = this.findPreviouslyDeadBlocks();
        this.invDataflow = classContext.getIsNullValueDataflow(method);
        this.vnaDataflow = classContext.getValueNumberDataflow(method);
        NullDerefAndRedundantComparisonFinder worker = new NullDerefAndRedundantComparisonFinder(classContext, method, this);
        worker.execute();
        this.checkCallSitesAndReturnInstructions();
    }

    private BitSet findPreviouslyDeadBlocks() throws DataflowAnalysisException, CFGBuilderException {
        BitSet deadBlocks = new BitSet();
        ValueNumberDataflow vnaDataflow = this.classContext.getValueNumberDataflow(this.method);
        Iterator<BasicBlock> i = vnaDataflow.getCFG().blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            ValueNumberFrame vnaFrame = (ValueNumberFrame)vnaDataflow.getStartFact(block);
            if (!vnaFrame.isTop()) continue;
            deadBlocks.set(block.getLabel());
        }
        return deadBlocks;
    }

    private void checkDatabases() {
        AnalysisContext analysisContext = AnalysisContext.currentAnalysisContext();
        this.unconditionalDerefParamDatabase = analysisContext.getUnconditionalDerefParamDatabase();
    }

    private NullnessAnnotation getMethodNullnessAnnotation() {
        if (this.method.getSignature().indexOf(")L") >= 0 || this.method.getSignature().indexOf(")[") >= 0) {
            if (DEBUG_NULLRETURN) {
                System.out.println("Checking return annotation for " + SignatureConverter.convertMethodSignature(this.classContext.getJavaClass(), this.method));
            }
            XMethod m = XFactory.createXMethod(this.classContext.getJavaClass(), this.method);
            return AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(m, false);
        }
        return NullnessAnnotation.UNKNOWN_NULLNESS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkCallSitesAndReturnInstructions() {
        Profiler profiler = Global.getAnalysisCache().getProfiler();
        profiler.start(CheckCallSitesAndReturnInstructions.class);
        try {
            ConstantPoolGen cpg = this.classContext.getConstantPoolGen();
            TypeDataflow typeDataflow = this.classContext.getTypeDataflow(this.method);
            Iterator<Location> i = this.classContext.getCFG(this.method).locationIterator();
            while (i.hasNext()) {
                Location location = i.next();
                Instruction ins = location.getHandle().getInstruction();
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    if (!vnaFrame.isValid()) continue;
                    if (ins instanceof InvokeInstruction) {
                        this.examineCallSite(location, cpg, typeDataflow);
                        continue;
                    }
                    if (this.methodAnnotation == NullnessAnnotation.NONNULL && ins.getOpcode() == 176) {
                        this.examineReturnInstruction(location);
                        continue;
                    }
                    if (!(ins instanceof PUTFIELD)) continue;
                    this.examinePutfieldInstruction(location, (PUTFIELD)ins, cpg);
                }
                catch (ClassNotFoundException e) {
                    this.bugReporter.reportMissingClass(e);
                }
            }
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("error:", e);
        }
        finally {
            profiler.end(CheckCallSitesAndReturnInstructions.class);
        }
    }

    private void examineCallSite(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow) throws DataflowAnalysisException, CFGBuilderException, ClassNotFoundException {
        InvokeInstruction invokeInstruction = (InvokeInstruction)location.getHandle().getInstruction();
        String methodName = invokeInstruction.getName(cpg);
        String signature = invokeInstruction.getSignature(cpg);
        if ("equals".equals(methodName) && "(Ljava/lang/Object;)Z".equals(signature)) {
            return;
        }
        int returnTypeStart = signature.indexOf(41);
        if (returnTypeStart < 0) {
            return;
        }
        String paramList = signature.substring(0, returnTypeStart + 1);
        if ("()".equals(paramList) || paramList.indexOf(76) < 0 && paramList.indexOf(91) < 0) {
            return;
        }
        IsNullValueFrame frame = (IsNullValueFrame)this.classContext.getIsNullValueDataflow(this.method).getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        BitSet nullArgSet = frame.getArgumentSet(invokeInstruction, cpg, new DataflowValueChooser<IsNullValue>(){

            @Override
            public boolean choose(IsNullValue value) {
                return value.mightBeNull() && !value.isException() && !value.isReturnValue();
            }
        });
        BitSet definitelyNullArgSet = frame.getArgumentSet(invokeInstruction, cpg, new DataflowValueChooser<IsNullValue>(){

            @Override
            public boolean choose(IsNullValue value) {
                return value.isDefinitelyNull();
            }
        });
        nullArgSet.and(definitelyNullArgSet);
        if (nullArgSet.isEmpty()) {
            return;
        }
        if (DEBUG_NULLARG) {
            System.out.println("Null arguments passed: " + nullArgSet);
            System.out.println("Frame is: " + frame);
            System.out.println("# arguments: " + frame.getNumArguments(invokeInstruction, cpg));
            XMethod xm = XFactory.createXMethod(invokeInstruction, cpg);
            System.out.print("Signature: " + xm.getSignature());
        }
        if (this.unconditionalDerefParamDatabase != null) {
            this.checkUnconditionallyDereferencedParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
        }
        if (DEBUG_NULLARG) {
            System.out.println("Checking nonnull params");
        }
        this.checkNonNullParam(location, cpg, typeDataflow, invokeInstruction, nullArgSet, definitelyNullArgSet);
    }

    private void examinePutfieldInstruction(Location location, PUTFIELD ins, ConstantPoolGen cpg) throws DataflowAnalysisException {
        IsNullValueFrame frame = (IsNullValueFrame)this.invDataflow.getFactAtLocation(location);
        if (!frame.isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.isDefinitelyNull()) {
            XField field = XFactory.createXField((FieldInstruction)ins, cpg);
            NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
            if (annotation == NullnessAnnotation.NONNULL) {
                BugAnnotation variableAnnotation = null;
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
                    variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError("error", e);
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError("error", e);
                }
                BugInstance warning = new BugInstance(this, "NP_STORE_INTO_NONNULL_FIELD", tos.isDefinitelyNull() ? 1 : 2).addClassAndMethod(this.classContext.getJavaClass(), this.method).addField(field).addOptionalAnnotation(variableAnnotation).addSourceLine(this.classContext, this.method, location);
                this.bugReporter.reportBug(warning);
            }
        }
    }

    private void examineReturnInstruction(Location location) throws DataflowAnalysisException, CFGBuilderException {
        if (DEBUG_NULLRETURN) {
            System.out.println("Checking null return at " + location);
        }
        IsNullValueDataflow invDataflow = this.classContext.getIsNullValueDataflow(this.method);
        IsNullValueFrame frame = (IsNullValueFrame)invDataflow.getFactAtLocation(location);
        ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            return;
        }
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getTopValue();
        if (!frame.isValid()) {
            return;
        }
        IsNullValue tos = (IsNullValue)frame.getTopValue();
        if (tos.isDefinitelyNull()) {
            String methodName;
            BugAnnotation variable = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
            String bugPattern = "NP_NONNULL_RETURN_VIOLATION";
            int priority = 2;
            if (tos.isDefinitelyNull() && !tos.isException()) {
                priority = 1;
            }
            if ("clone".equals(methodName = this.method.getName())) {
                bugPattern = "NP_CLONE_COULD_RETURN_NULL";
                priority = 2;
            } else if ("toString".equals(methodName)) {
                bugPattern = "NP_TOSTRING_COULD_RETURN_NULL";
                priority = 2;
            }
            BugInstance warning = new BugInstance(this, bugPattern, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addOptionalAnnotation(variable);
            this.bugAccumulator.accumulateBug(warning, SourceLineAnnotation.fromVisitedInstruction(this.classContext, this.method, location));
        }
    }

    private boolean hasManyPreceedingNullTests(int pc) {
        int ifNullTests = 0;
        BitSet seen = new BitSet();
        try {
            Iterator<Location> i = this.classContext.getCFG(this.method).locationIterator();
            while (i.hasNext()) {
                Instruction ins;
                Location loc = i.next();
                int pc2 = loc.getHandle().getPosition();
                if (pc2 >= pc || pc2 < pc - 30 || !((ins = loc.getHandle().getInstruction()) instanceof IFNONNULL) && !(ins instanceof IFNULL) && !(ins instanceof NullnessConversationInstruction) || seen.get(pc2)) continue;
                ++ifNullTests;
                seen.set(pc2);
            }
            boolean result = ifNullTests > 2;
            return result;
        }
        catch (CFGBuilderException e) {
            return false;
        }
    }

    public static boolean catchesNull(ConstantPool constantPool, Code code, Location location) {
        int position = location.getHandle().getPosition();
        for (String t : catchTypesForNull) {
            int catchSize = Util.getSizeOfSurroundingTryBlock(constantPool, code, t, position);
            if (catchSize >= Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    private boolean safeCallToPrimateParseMethod(XMethod calledMethod, Location location) {
        int position = location.getHandle().getPosition();
        if ("java.lang.Integer".equals(calledMethod.getClassName())) {
            Code code;
            ConstantPool constantPool = this.classContext.getJavaClass().getConstantPool();
            int catchSize = Util.getSizeOfSurroundingTryBlock(constantPool, code = this.method.getCode(), "java/lang/NumberFormatException", position);
            if (catchSize < Integer.MAX_VALUE) {
                return true;
            }
            catchSize = Util.getSizeOfSurroundingTryBlock(constantPool, code, "java/lang/IllegalArgumentException", position);
            if (catchSize < Integer.MAX_VALUE) {
                return true;
            }
            catchSize = Util.getSizeOfSurroundingTryBlock(constantPool, code, "java/lang/RuntimeException", position);
            if (catchSize < Integer.MAX_VALUE) {
                return true;
            }
            catchSize = Util.getSizeOfSurroundingTryBlock(constantPool, code, "java/lang/Exception", position);
            if (catchSize < Integer.MAX_VALUE) {
                return true;
            }
        }
        return false;
    }

    private void checkUnconditionallyDereferencedParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) throws DataflowAnalysisException, ClassNotFoundException {
        int priority;
        String bugType;
        boolean privateCall;
        if (this.inExplictCatchNullBlock(location)) {
            return;
        }
        boolean caught = this.inIndirectCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        XMethod calledMethod = XFactory.createXMethod(invokeInstruction, cpg);
        nullArgSet = (BitSet)nullArgSet.clone();
        definitelyNullArgSet = (BitSet)definitelyNullArgSet.clone();
        ClassDescriptor nonnullClassDesc = DescriptorFactory.createClassDescriptor(Nonnull.class);
        TypeQualifierValue<?> nonnullTypeQualifierValue = TypeQualifierValue.getValue(nonnullClassDesc, null);
        int i = nullArgSet.nextSetBit(0);
        while (i >= 0) {
            TypeQualifierAnnotation tqa = TypeQualifierApplications.getEffectiveTypeQualifierAnnotation(calledMethod, i, nonnullTypeQualifierValue);
            if (tqa != null && tqa.when == When.ALWAYS) {
                nullArgSet.clear(i);
                definitelyNullArgSet.clear(i);
            }
            i = nullArgSet.nextSetBit(i + 1);
        }
        TypeFrame typeFrame = (TypeFrame)typeDataflow.getFactAtLocation(location);
        Set<JavaClassAndMethod> targetMethodSet = Hierarchy.resolveMethodCallTargets(invokeInstruction, typeFrame, cpg);
        if (DEBUG_NULLARG) {
            System.out.println("Possibly called methods: " + targetMethodSet);
        }
        BitSet unconditionallyDereferencedNullArgSet = new BitSet();
        LinkedList<JavaClassAndMethod> dangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        LinkedList<JavaClassAndMethod> veryDangerousCallTargetList = new LinkedList<JavaClassAndMethod>();
        for (JavaClassAndMethod targetMethod : targetMethodSet) {
            BitSet targetUnconditionallyDereferencedNullArgSet;
            ParameterProperty property;
            if (DEBUG_NULLARG) {
                System.out.println("For target method " + targetMethod);
            }
            if ((property = (ParameterProperty)this.unconditionalDerefParamDatabase.getProperty(targetMethod.toMethodDescriptor())) == null) continue;
            if (DEBUG_NULLARG) {
                System.out.println("\tUnconditionally dereferenced params: " + property);
            }
            if ((targetUnconditionallyDereferencedNullArgSet = property.getMatchingParameters(nullArgSet)).isEmpty()) continue;
            dangerousCallTargetList.add(targetMethod);
            unconditionallyDereferencedNullArgSet.or(targetUnconditionallyDereferencedNullArgSet);
            if (property.getMatchingParameters(definitelyNullArgSet).isEmpty()) continue;
            veryDangerousCallTargetList.add(targetMethod);
        }
        if (dangerousCallTargetList.isEmpty()) {
            return;
        }
        WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
        HashSet<JavaClassAndMethod> safeCallTargetSet = new HashSet<JavaClassAndMethod>();
        safeCallTargetSet.addAll(targetMethodSet);
        safeCallTargetSet.removeAll(dangerousCallTargetList);
        if (safeCallTargetSet.isEmpty()) {
            propertySet.addProperty(NullArgumentWarningProperty.ALL_DANGEROUS_TARGETS);
            if (dangerousCallTargetList.size() == 1) {
                propertySet.addProperty(NullArgumentWarningProperty.MONOMORPHIC_CALL_SITE);
            }
        }
        boolean bl = privateCall = safeCallTargetSet.isEmpty() && dangerousCallTargetList.size() == 1 && ((JavaClassAndMethod)dangerousCallTargetList.get(0)).getMethod().isPrivate();
        if (privateCall || invokeInstruction.getOpcode() == 184 || invokeInstruction.getOpcode() == 183) {
            bugType = "NP_NULL_PARAM_DEREF_NONVIRTUAL";
            priority = 1;
        } else if (safeCallTargetSet.isEmpty()) {
            bugType = "NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS";
            priority = 2;
        } else {
            return;
        }
        if (caught) {
            ++priority;
        }
        if (dangerousCallTargetList.size() > veryDangerousCallTargetList.size()) {
            ++priority;
        } else {
            propertySet.addProperty(NullArgumentWarningProperty.ACTUAL_PARAMETER_GUARANTEED_NULL);
        }
        XMethod calledFrom = XFactory.createXMethod(this.classContext.getJavaClass(), this.method);
        if (this.safeCallToPrimateParseMethod(calledMethod, location)) {
            return;
        }
        BugInstance warning = new BugInstance(this, bugType, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addMethod(calledMethod).describe("METHOD_CALLED").addSourceLine(this.classContext, this.method, location);
        if (!AnalysisContext.currentXFactory().isCalledDirectlyOrIndirectly(calledFrom) && calledFrom.isPrivate()) {
            propertySet.addProperty(GeneralWarningProperty.IN_UNCALLABLE_METHOD);
        }
        this.addParamAnnotations(location, definitelyNullArgSet, unconditionallyDereferencedNullArgSet, propertySet, warning);
        if ("NP_NULL_PARAM_DEREF_ALL_TARGETS_DANGEROUS".equals(bugType)) {
            for (JavaClassAndMethod dangerousCallTarget : veryDangerousCallTargetList) {
                warning.addMethod(dangerousCallTarget).describe("METHOD_DANGEROUS_TARGET_ACTUAL_GUARANTEED_NULL");
            }
            dangerousCallTargetList.removeAll(veryDangerousCallTargetList);
            if (DEBUG_NULLARG) {
                for (JavaClassAndMethod dangerousCallTarget : dangerousCallTargetList) {
                    warning.addMethod(dangerousCallTarget).describe("METHOD_DANGEROUS_TARGET");
                }
                for (JavaClassAndMethod safeMethod : safeCallTargetSet) {
                    warning.addMethod(safeMethod).describe("METHOD_SAFE_TARGET");
                }
            }
        }
        this.decorateWarning(location, propertySet, warning);
        this.bugReporter.reportBug(warning);
    }

    private void decorateWarning(Location location, WarningPropertySet<WarningProperty> propertySet, BugInstance warning) {
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForDataMining(propertySet, this.classContext, this.method, location);
        }
        propertySet.decorateBugInstance(warning);
    }

    private void addParamAnnotations(Location location, BitSet definitelyNullArgSet, BitSet violatedParamSet, WarningPropertySet<? super NullArgumentWarningProperty> propertySet, BugInstance warning) {
        ValueNumberFrame vnaFrame = null;
        try {
            vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("error", e);
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("error", e);
        }
        InvokeInstruction instruction = (InvokeInstruction)location.getHandle().getInstruction();
        SignatureParser sigParser = new SignatureParser(instruction.getSignature(this.classContext.getConstantPoolGen()));
        int i = violatedParamSet.nextSetBit(0);
        while (i >= 0) {
            boolean definitelyNull = definitelyNullArgSet.get(i);
            if (definitelyNull) {
                propertySet.addProperty(NullArgumentWarningProperty.ARG_DEFINITELY_NULL);
            }
            ValueNumber valueNumber = null;
            if (vnaFrame != null) {
                try {
                    valueNumber = (ValueNumber)vnaFrame.getArgument(instruction, this.classContext.getConstantPoolGen(), i, sigParser);
                    BugAnnotation variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
                    warning.addOptionalAnnotation(variableAnnotation);
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError("error", e);
                }
            }
            warning.addParameterAnnotation(i, definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG");
            i = violatedParamSet.nextSetBit(i + 1);
        }
    }

    private void checkNonNullParam(Location location, ConstantPoolGen cpg, TypeDataflow typeDataflow, InvokeInstruction invokeInstruction, BitSet nullArgSet, BitSet definitelyNullArgSet) {
        if (this.inExplictCatchNullBlock(location)) {
            return;
        }
        boolean caught = this.inIndirectCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        XMethod m = XFactory.createXMethod(invokeInstruction, cpg);
        TypeQualifierNullnessAnnotationDatabase db = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase();
        SignatureParser sigParser = new SignatureParser(invokeInstruction.getSignature(cpg));
        int i = nullArgSet.nextSetBit(0);
        while (i >= 0) {
            if (db.parameterMustBeNonNull(m, i)) {
                int priority;
                boolean definitelyNull = definitelyNullArgSet.get(i);
                if (DEBUG_NULLARG) {
                    System.out.println("Checking " + m);
                    System.out.println("QQQ2: " + i + " -- " + i + " is null");
                    System.out.println("QQQ nullArgSet: " + nullArgSet);
                    System.out.println("QQQ dnullArgSet: " + definitelyNullArgSet);
                }
                BugAnnotation variableAnnotation = null;
                try {
                    ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
                    ValueNumber valueNumber = (ValueNumber)vnaFrame.getArgument(invokeInstruction, cpg, i, sigParser);
                    variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
                }
                catch (DataflowAnalysisException e) {
                    AnalysisContext.logError("error", e);
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError("error", e);
                }
                int n = priority = definitelyNull ? 1 : 2;
                if (caught) {
                    ++priority;
                }
                if (m.isPrivate() && priority == 1) {
                    priority = 2;
                }
                String description = definitelyNull ? "INT_NULL_ARG" : "INT_MAYBE_NULL_ARG";
                WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
                Set<Location> derefLocationSet = Collections.singleton(location);
                this.addPropertiesForDereferenceLocations(propertySet, derefLocationSet, false);
                boolean duplicated = this.isDuplicated(propertySet, location.getHandle().getPosition(), false);
                if (duplicated) {
                    return;
                }
                BugInstance warning = new BugInstance(this, "NP_NONNULL_PARAM_VIOLATION", priority).addClassAndMethod(this.classContext.getJavaClass(), this.method).addMethod(m).describe("METHOD_CALLED").addParameterAnnotation(i, description).addOptionalAnnotation(variableAnnotation).addSourceLine(this.classContext, this.method, location);
                propertySet.decorateBugInstance(warning);
                this.bugReporter.reportBug(warning);
            }
            i = nullArgSet.nextSetBit(i + 1);
        }
    }

    @Override
    public void report() {
    }

    public boolean skipIfInsideCatchNull() {
        return this.classContext.getJavaClass().getClassName().indexOf("Test") >= 0 || this.method.getName().indexOf("test") >= 0 || this.method.getName().indexOf("Test") >= 0;
    }

    @Override
    @Deprecated
    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue, ValueNumberFrame vnaFrame) {
        this.foundNullDeref(location, valueNumber, refValue, vnaFrame, true);
    }

    @Override
    public void foundNullDeref(Location location, ValueNumber valueNumber, IsNullValue refValue, ValueNumberFrame vnaFrame, boolean isConsistent) {
        InvokeInstruction iins;
        WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
        if (valueNumber.hasFlag(4)) {
            return;
        }
        boolean onExceptionPath = refValue.isException();
        if (onExceptionPath) {
            propertySet.addProperty(GeneralWarningProperty.ON_EXCEPTION_PATH);
        }
        int pc = location.getHandle().getPosition();
        BugAnnotation variable = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
        this.addPropertiesForDereferenceLocations(propertySet, Collections.singleton(location), isConsistent);
        Instruction ins = location.getHandle().getInstruction();
        if (ins instanceof InvokeInstruction && refValue.isDefinitelyNull() && "close".equals((iins = (InvokeInstruction)ins).getMethodName(this.classContext.getConstantPoolGen())) && "()V".equals(iins.getSignature(this.classContext.getConstantPoolGen()))) {
            propertySet.addProperty(NullDerefProperty.CLOSING_NULL);
        }
        boolean duplicated = this.isDuplicated(propertySet, pc, isConsistent);
        if (this.inExplictCatchNullBlock(location)) {
            return;
        }
        boolean caught = this.inIndirectCatchNullBlock(location);
        if (caught && this.skipIfInsideCatchNull()) {
            return;
        }
        if (refValue.isDefinitelyNull()) {
            int priority;
            String type = "NP_ALWAYS_NULL";
            if (propertySet.containsProperty(NullDerefProperty.CLOSING_NULL) && !propertySet.containsProperty(NullDerefProperty.DEREFS_ARE_CLONED)) {
                type = "NP_CLOSING_NULL";
            } else if (onExceptionPath) {
                type = "NP_ALWAYS_NULL_EXCEPTION";
            } else if (duplicated) {
                type = "NP_NULL_ON_SOME_PATH";
            }
            int n = priority = onExceptionPath ? 2 : 1;
            if (caught) {
                ++priority;
            }
            this.reportNullDeref(propertySet, location, type, priority, variable);
        } else if (refValue.mightBeNull() && refValue.isParamValue()) {
            String type;
            int priority = 2;
            if (caught) {
                ++priority;
            }
            if ("equals".equals(this.method.getName()) && "(Ljava/lang/Object;)Z".equals(this.method.getSignature())) {
                if (caught) {
                    return;
                }
                type = "NP_EQUALS_SHOULD_HANDLE_NULL_ARGUMENT";
            } else {
                type = "NP_ARGUMENT_MIGHT_BE_NULL";
            }
            if (DEBUG) {
                System.out.println("Reporting null on some path: value=" + refValue);
            }
            this.reportNullDeref(propertySet, location, type, priority, variable);
        }
    }

    public boolean isDuplicated(WarningPropertySet<WarningProperty> propertySet, int pc, boolean isConsistent) {
        boolean duplicated = false;
        if (!isConsistent) {
            if (propertySet.containsProperty(NullDerefProperty.DEREFS_ARE_CLONED)) {
                duplicated = true;
            } else {
                try {
                    CFG cfg = this.classContext.getCFG(this.method);
                    if (cfg.getLocationsContainingInstructionWithOffset(pc).size() > 1) {
                        propertySet.addProperty(NullDerefProperty.DEREFS_ARE_INLINED_FINALLY_BLOCKS);
                        duplicated = true;
                    }
                }
                catch (CFGBuilderException e) {
                    AnalysisContext.logError("Error while analyzing " + this.classContext.getFullyQualifiedMethodName(this.method), e);
                }
            }
        }
        return duplicated;
    }

    private void reportNullDeref(WarningPropertySet<WarningProperty> propertySet, Location location, String type, int priority, @CheckForNull BugAnnotation variable) {
        BugInstance bugInstance = new BugInstance(this, type, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        if (variable != null) {
            bugInstance.add(variable);
        } else {
            bugInstance.add(new LocalVariableAnnotation("?", -1, -1));
        }
        bugInstance.addSourceLine(this.classContext, this.method, location).describe("SOURCE_LINE_DEREF");
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertyUtil.addPropertiesForDataMining(propertySet, this.classContext, this.method, location);
        }
        this.addPropertiesForDereferenceLocations(propertySet, Collections.singleton(location), false);
        propertySet.decorateBugInstance(bugInstance);
        this.bugReporter.reportBug(bugInstance);
    }

    public static boolean isThrower(BasicBlock target) {
        int maxCount = 7;
        for (InstructionHandle ins = target.getFirstInstruction(); ins != null && maxCount-- > 0; ins = ins.getNext()) {
            Instruction i = ins.getInstruction();
            if (i instanceof ATHROW) {
                return true;
            }
            if (!(i instanceof InstructionTargeter) && !(i instanceof ReturnInstruction)) continue;
            return false;
        }
        return false;
    }

    @Override
    public void foundRedundantNullCheck(Location location, RedundantBranch redundantBranch) {
        int priority;
        String warning;
        OpcodeStack.Item item2;
        OpcodeStack.Item item1;
        OpcodeStack stack;
        boolean valueIsNull;
        boolean infeasibleEdgeSimplyThrowsException;
        boolean createdDeadCode;
        Location locationOfKaBoom;
        boolean wouldHaveBeenAKaboom;
        boolean isChecked;
        block48: {
            isChecked = redundantBranch.firstValue.isChecked();
            wouldHaveBeenAKaboom = redundantBranch.firstValue.wouldHaveBeenAKaboom();
            boolean isParameter = redundantBranch.firstValue.isParamValue();
            locationOfKaBoom = redundantBranch.firstValue.getLocationOfKaBoom();
            if (isParameter && !wouldHaveBeenAKaboom) {
                return;
            }
            createdDeadCode = false;
            infeasibleEdgeSimplyThrowsException = false;
            Edge infeasibleEdge = redundantBranch.infeasibleEdge;
            if (infeasibleEdge != null) {
                boolean empty;
                if (DEBUG) {
                    System.out.println("Check if " + redundantBranch + " creates dead code");
                }
                BasicBlock target = (BasicBlock)infeasibleEdge.getTarget();
                if (DEBUG) {
                    System.out.println("Target block is  " + (target.isExceptionThrower() ? " exception thrower" : " not exception thrower"));
                }
                boolean bl = empty = !target.isExceptionThrower() && (target.isEmpty() || this.isGoto(target.getFirstInstruction().getInstruction()));
                if (!empty) {
                    try {
                        if (this.classContext.getCFG(this.method).getNumIncomingEdges(target) > 1) {
                            if (DEBUG) {
                                System.out.println("Target of infeasible edge has multiple incoming edges");
                            }
                            empty = true;
                        }
                    }
                    catch (CFGBuilderException e) {
                        // empty catch block
                    }
                }
                if (DEBUG) {
                    System.out.println("Target block is  " + (empty ? "empty" : "not empty"));
                }
                if (!empty && FindNullDeref.isThrower(target)) {
                    infeasibleEdgeSimplyThrowsException = true;
                }
                if (!empty && !this.previouslyDeadBlocks.get(target.getLabel())) {
                    if (DEBUG) {
                        System.out.println("target was alive previously");
                    }
                    IsNullValueFrame invFrame = (IsNullValueFrame)this.invDataflow.getStartFact(target);
                    createdDeadCode = invFrame.isTop();
                    if (DEBUG) {
                        System.out.println("target is now " + (createdDeadCode ? "dead" : "alive"));
                    }
                }
            }
            valueIsNull = true;
            int pc = location.getHandle().getPosition();
            stack = null;
            item1 = null;
            item2 = null;
            try {
                stack = OpcodeStackScanner.getStackAt(this.classContext.getJavaClass(), this.method, pc);
                item1 = stack.getStackItem(0);
            }
            catch (RuntimeException e) {
                if (!SystemProperties.ASSERTIONS_ENABLED) break block48;
                AnalysisContext.logError("Error getting stack at specific PC", e);
            }
        }
        if (redundantBranch.secondValue == null) {
            if (redundantBranch.firstValue.isDefinitelyNull()) {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE";
                valueIsNull = false;
                int n = priority = isChecked ? 1 : 2;
            }
            if (infeasibleEdgeSimplyThrowsException) {
                ++priority;
            }
        } else {
            boolean bothNull;
            if (stack != null) {
                item2 = stack.getStackItem(1);
            }
            boolean bl = bothNull = redundantBranch.firstValue.isDefinitelyNull() && redundantBranch.secondValue.isDefinitelyNull();
            if (redundantBranch.secondValue.isChecked()) {
                isChecked = true;
            }
            if (redundantBranch.secondValue.wouldHaveBeenAKaboom()) {
                wouldHaveBeenAKaboom = true;
                locationOfKaBoom = redundantBranch.secondValue.getLocationOfKaBoom();
            }
            if (bothNull) {
                warning = "RCN_REDUNDANT_COMPARISON_TWO_NULL_VALUES";
                priority = 2;
            } else {
                warning = "RCN_REDUNDANT_COMPARISON_OF_NULL_AND_NONNULL_VALUE";
                int n = priority = isChecked ? 2 : 3;
            }
        }
        if (wouldHaveBeenAKaboom) {
            priority = 1;
            warning = "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE";
            if (locationOfKaBoom == null) {
                throw new NullPointerException("location of KaBoom is null");
            }
        }
        if (DEBUG) {
            System.out.println(createdDeadCode + " " + infeasibleEdgeSimplyThrowsException + " " + valueIsNull + " " + priority);
        }
        priority = createdDeadCode && !infeasibleEdgeSimplyThrowsException ? (priority += 0) : (createdDeadCode && infeasibleEdgeSimplyThrowsException ? (valueIsNull ? (priority += 0) : ++priority) : ++priority);
        if (DEBUG) {
            System.out.println("RCN " + priority + " " + redundantBranch.firstValue + " =? " + redundantBranch.secondValue + " : " + warning);
            if (isChecked) {
                System.out.println("isChecked");
            }
            if (wouldHaveBeenAKaboom) {
                System.out.println("wouldHaveBeenAKaboom");
            }
            if (createdDeadCode) {
                System.out.println("createdDeadCode");
            }
        }
        if (priority > 3) {
            return;
        }
        BugAnnotation variableAnnotation = null;
        try {
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
            if (vnaFrame.isValid()) {
                LocalVariableAnnotation local;
                Instruction ins = location.getHandle().getInstruction();
                ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(ins, this.classContext.getConstantPoolGen());
                if (valueNumber.hasFlag(4)) {
                    return;
                }
                variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
                if (variableAnnotation instanceof LocalVariableAnnotation && !(local = (LocalVariableAnnotation)variableAnnotation).isNamed()) {
                    if ("RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE".equals(warning)) {
                        return;
                    }
                    ++priority;
                }
            }
        }
        catch (DataflowAnalysisException e) {
        }
        catch (CFGBuilderException e) {
            // empty catch block
        }
        BugInstance bugInstance = new BugInstance(this, warning, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        LocalVariableAnnotation fallback = new LocalVariableAnnotation("?", -1, -1);
        boolean foundSource = bugInstance.tryAddingOptionalUniqueAnnotations(variableAnnotation, BugInstance.getFieldOrMethodValueSource(item1), BugInstance.getFieldOrMethodValueSource(item2));
        if (!foundSource) {
            if ("RCN_REDUNDANT_NULLCHECK_OF_NULL_VALUE".equals(warning)) {
                return;
            }
            bugInstance.setPriority(priority + 1);
            bugInstance.add(fallback);
        }
        if (wouldHaveBeenAKaboom) {
            bugInstance.addSourceLine(this.classContext, this.method, locationOfKaBoom);
        }
        if (FindBugsAnalysisFeatures.isRelaxedMode()) {
            WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
            WarningPropertyUtil.addPropertiesForDataMining(propertySet, this.classContext, this.method, location);
            if (isChecked) {
                propertySet.addProperty(NullDerefProperty.CHECKED_VALUE);
            }
            if (wouldHaveBeenAKaboom) {
                propertySet.addProperty(NullDerefProperty.WOULD_HAVE_BEEN_A_KABOOM);
            }
            if (createdDeadCode) {
                propertySet.addProperty(NullDerefProperty.CREATED_DEAD_CODE);
            }
            propertySet.decorateBugInstance(bugInstance);
        }
        SourceLineAnnotation sourceLine = SourceLineAnnotation.fromVisitedInstruction(this.classContext, this.method, location);
        sourceLine.setDescription("SOURCE_REDUNDANT_NULL_CHECK");
        this.bugAccumulator.accumulateBug(bugInstance, sourceLine);
    }

    BugAnnotation getVariableAnnotation(Location location) {
        BugAnnotation variableAnnotation = null;
        try {
            ValueNumberFrame vnaFrame = (ValueNumberFrame)this.classContext.getValueNumberDataflow(this.method).getFactAtLocation(location);
            if (vnaFrame.isValid()) {
                Instruction ins = location.getHandle().getInstruction();
                ValueNumber valueNumber = (ValueNumber)vnaFrame.getInstance(ins, this.classContext.getConstantPoolGen());
                if (valueNumber.hasFlag(4)) {
                    return null;
                }
                variableAnnotation = ValueNumberSourceInfo.findAnnotationFromValueNumber(this.method, location, valueNumber, vnaFrame, "VALUE_OF");
            }
        }
        catch (DataflowAnalysisException e) {
        }
        catch (CFGBuilderException cFGBuilderException) {
            // empty catch block
        }
        return variableAnnotation;
    }

    private boolean isGoto(Instruction instruction) {
        return instruction.getOpcode() == 167 || instruction.getOpcode() == 200;
    }

    int minPC(Collection<Location> locs) {
        int result = 1000000;
        for (Location l : locs) {
            if (result <= l.getHandle().getPosition()) continue;
            result = l.getHandle().getPosition();
        }
        return result;
    }

    int maxPC(Collection<Location> locs) {
        int result = -1000000;
        for (Location l : locs) {
            if (result >= l.getHandle().getPosition()) continue;
            result = l.getHandle().getPosition();
        }
        return result;
    }

    boolean callToAssertionMethod(Location loc) {
        int firstLine;
        InstructionHandle h;
        int firstPos = h.getPosition();
        LineNumberTable ln = this.method.getLineNumberTable();
        int n = firstLine = ln == null ? -1 : ln.getSourceLine(firstPos);
        for (h = loc.getHandle(); h != null; h = h.getNext()) {
            InvokeInstruction ii;
            String name;
            int line;
            int pos = h.getPosition();
            if (ln != null ? (line = ln.getSourceLine(pos)) != firstLine : pos > firstPos + 15) break;
            Instruction i = h.getInstruction();
            if (!(i instanceof InvokeInstruction) || !(name = (ii = (InvokeInstruction)i).getMethodName(this.classContext.getConstantPoolGen())).startsWith("check") && !name.startsWith("assert")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void foundGuaranteedNullDeref(@Nonnull Set<Location> assignedNullLocationSet, @Nonnull Set<Location> derefLocationSet, SortedSet<Location> doomedLocations, ValueNumberDataflow vna, ValueNumber refValue, @CheckForNull BugAnnotation variableAnnotation, NullValueUnconditionalDeref deref, boolean npeIfStatementCovered) {
        int priority;
        if (refValue.hasFlag(4)) {
            return;
        }
        if (DEBUG) {
            System.out.println("Found guaranteed null deref in " + this.method.getName());
            for (Location loc : doomedLocations) {
                System.out.println("Doomed at " + loc);
            }
        }
        int n = priority = npeIfStatementCovered ? 1 : 2;
        String bugType = deref.isMethodReturnValue() ? (deref.isReadlineValue() ? "NP_DEREFERENCE_OF_READLINE_VALUE" : "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE") : (derefLocationSet.size() > 1 ? (!deref.isAlwaysOnExceptionPath() ? "NP_GUARANTEED_DEREF" : "NP_GUARANTEED_DEREF_ON_EXCEPTION_PATH") : (!deref.isAlwaysOnExceptionPath() ? "NP_NULL_ON_SOME_PATH" : "NP_NULL_ON_SOME_PATH_EXCEPTION"));
        boolean allCallToAssertionMethod = !doomedLocations.isEmpty();
        for (Location loc : doomedLocations) {
            if (this.callToAssertionMethod(loc)) continue;
            allCallToAssertionMethod = false;
        }
        if (allCallToAssertionMethod) {
            return;
        }
        SortedSet<Location> sourceLocations = doomedLocations.isEmpty() || doomedLocations.size() > 3 && doomedLocations.size() > assignedNullLocationSet.size() ? new TreeSet<Location>(assignedNullLocationSet) : doomedLocations;
        if (doomedLocations.isEmpty() || derefLocationSet.isEmpty()) {
            return;
        }
        WarningPropertySet<WarningProperty> propertySet = new WarningPropertySet<WarningProperty>();
        this.addPropertiesForDereferenceLocations(propertySet, derefLocationSet, false);
        int minDereferencePC = this.minPC(derefLocationSet);
        int distance1 = minDereferencePC - this.maxPC(assignedNullLocationSet);
        int distance2 = minDereferencePC - this.maxPC(doomedLocations);
        int distance = Math.max(distance1, distance2);
        BitSet knownNull = new BitSet();
        TreeSet<SourceLineAnnotation> knownNullLocations = new TreeSet<SourceLineAnnotation>();
        for (Location loc : sourceLocations) {
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedInstruction(this.classContext, this.method, loc);
            if (sourceLineAnnotation == null) continue;
            int startLine = sourceLineAnnotation.getStartLine();
            if (startLine == -1) {
                knownNullLocations.add(sourceLineAnnotation);
                continue;
            }
            if (knownNull.get(startLine)) continue;
            knownNull.set(startLine);
            knownNullLocations.add(sourceLineAnnotation);
        }
        FieldAnnotation storedField = null;
        MethodAnnotation invokedMethod = null;
        XMethod invokedXMethod = null;
        int parameterNumber = -1;
        if (derefLocationSet.size() == 1) {
            Location loc = derefLocationSet.iterator().next();
            PointerUsageRequiringNonNullValue pu = null;
            try {
                UsagesRequiringNonNullValues usages = this.classContext.getUsagesRequiringNonNullValues(this.method);
                pu = usages.get(loc, refValue, this.vnaDataflow);
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            }
            catch (CFGBuilderException e) {
                AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            }
            if (pu != null) {
                if (deref.isReadlineValue()) {
                    bugType = "NP_DEREFERENCE_OF_READLINE_VALUE";
                    priority = 2;
                } else if (deref.isMethodReturnValue() && !deref.isReadlineValue()) {
                    bugType = "NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE";
                    priority = 2;
                } else if (pu.isReturnFromNonNullMethod()) {
                    bugType = "NP_NONNULL_RETURN_VIOLATION";
                    String methodName = this.method.getName();
                    String methodSig = this.method.getSignature();
                    if ("clone".equals(methodName) && "()Ljava/lang/Object;".equals(methodSig)) {
                        bugType = "NP_CLONE_COULD_RETURN_NULL";
                        priority = 2;
                    } else if ("toString".equals(methodName) && "()Ljava/lang/String;".equals(methodSig)) {
                        bugType = "NP_TOSTRING_COULD_RETURN_NULL";
                        priority = 2;
                    }
                } else {
                    XField f = pu.getNonNullField();
                    if (f != null) {
                        storedField = FieldAnnotation.fromXField(f);
                        bugType = "NP_STORE_INTO_NONNULL_FIELD";
                    } else {
                        XMethodParameter mp = pu.getNonNullParameter();
                        if (mp != null) {
                            invokedXMethod = mp.getMethod();
                            for (Location derefLoc : derefLocationSet) {
                                if (!this.safeCallToPrimateParseMethod(invokedXMethod, derefLoc)) continue;
                                return;
                            }
                            invokedMethod = MethodAnnotation.fromXMethod(mp.getMethod());
                            if (mp.getParameterNumber() == 0 && TypeQualifierNullnessAnnotationDatabase.assertsFirstParameterIsNonnull(invokedXMethod)) {
                                return;
                            }
                            parameterNumber = mp.getParameterNumber();
                            bugType = "NP_NULL_PARAM_DEREF";
                        }
                    }
                }
            }
        }
        boolean hasManyNullTests = true;
        for (SourceLineAnnotation sourceLineAnnotation : knownNullLocations) {
            if (this.hasManyPreceedingNullTests(sourceLineAnnotation.getStartBytecode())) continue;
            hasManyNullTests = false;
        }
        if (hasManyNullTests) {
            if ("NP_NULL_ON_SOME_PATH".equals(bugType) || "NP_GUARANTEED_DEREF".equals(bugType)) {
                bugType = "NP_NULL_ON_SOME_PATH_MIGHT_BE_INFEASIBLE";
            } else {
                ++priority;
            }
        }
        BugInstance bugInstance = new BugInstance(this, bugType, priority).addClassAndMethod(this.classContext.getJavaClass(), this.method);
        if (invokedMethod != null) {
            assert (invokedXMethod != null);
            XMethod i = invokedXMethod.resolveAccessMethodForMethod();
            if (i != invokedXMethod) {
                bugInstance.addMethod(i).describe("METHOD_CALLED");
            } else {
                bugInstance.addMethod(invokedMethod).describe("METHOD_CALLED").addParameterAnnotation(parameterNumber, "INT_MAYBE_NULL_ARG");
            }
        }
        if (storedField != null) {
            bugInstance.addField(storedField).describe("FIELD_STORED");
        }
        bugInstance.addOptionalAnnotation(variableAnnotation);
        if (variableAnnotation instanceof FieldAnnotation) {
            bugInstance.describe("FIELD_CONTAINS_VALUE");
        }
        this.addPropertiesForDereferenceLocations(propertySet, derefLocationSet, false);
        if (deref.isAlwaysOnExceptionPath()) {
            propertySet.addProperty(NullDerefProperty.ALWAYS_ON_EXCEPTION_PATH);
        }
        if (!assignedNullLocationSet.isEmpty() && distance > 100) {
            propertySet.addProperty(NullDerefProperty.LONG_RANGE_NULL_SOURCE);
        }
        propertySet.decorateBugInstance(bugInstance);
        if ("NP_DEREFERENCE_OF_READLINE_VALUE".equals(bugType)) {
            int source = -9999;
            if (knownNullLocations.size() == 1) {
                source = ((SourceLineAnnotation)knownNullLocations.iterator().next()).getEndBytecode();
            }
            for (Location loc : derefLocationSet) {
                int pos = loc.getHandle().getPosition();
                if (pos == source + 3) continue;
                this.bugAccumulator.accumulateBug(bugInstance, SourceLineAnnotation.fromVisitedInstruction(this.classContext, this.method, loc));
            }
        } else {
            int startLine;
            Location assignedNull;
            SourceLineAnnotation sourceLineAnnotation2;
            for (Location loc : derefLocationSet) {
                bugInstance.addSourceLine(this.classContext, this.method, loc).describe(this.getDescription(loc, refValue));
            }
            if (sourceLocations == doomedLocations && assignedNullLocationSet.size() == 1 && (sourceLineAnnotation2 = SourceLineAnnotation.fromVisitedInstruction(this.classContext, this.method, assignedNull = assignedNullLocationSet.iterator().next())) != null && (startLine = sourceLineAnnotation2.getStartLine()) > 0 && !knownNull.get(startLine)) {
                bugInstance.add(sourceLineAnnotation2).describe("SOURCE_LINE_NULL_VALUE");
            }
            for (SourceLineAnnotation sourceLineAnnotation2 : knownNullLocations) {
                bugInstance.add(sourceLineAnnotation2).describe("SOURCE_LINE_KNOWN_NULL");
            }
            this.bugReporter.reportBug(bugInstance);
        }
    }

    private void addPropertiesForDereferenceLocations(WarningPropertySet<WarningProperty> propertySet, Collection<Location> derefLocationSet, boolean isConsistent) {
        boolean derefOutsideCatchBlock = false;
        boolean derefOutsideCatchNullBlock = false;
        boolean allDerefsAtDoomedLocations = true;
        for (Location loc : derefLocationSet) {
            if (!this.inExplictCatchNullBlock(loc)) {
                derefOutsideCatchNullBlock = true;
                if (!this.inIndirectCatchNullBlock(loc)) {
                    derefOutsideCatchBlock = true;
                }
            }
            if (this.isDoomed(loc)) continue;
            allDerefsAtDoomedLocations = false;
        }
        if (!derefOutsideCatchNullBlock) {
            propertySet.addProperty(GeneralWarningProperty.FALSE_POSITIVE);
            return;
        }
        if (allDerefsAtDoomedLocations) {
            propertySet.addProperty(DoomedCodeWarningProperty.DOOMED_CODE);
        }
        boolean uniqueDereferenceLocations = this.uniqueLocations(derefLocationSet);
        if (!derefOutsideCatchBlock) {
            if (!uniqueDereferenceLocations || this.skipIfInsideCatchNull()) {
                propertySet.addProperty(GeneralWarningProperty.FALSE_POSITIVE);
            } else {
                propertySet.addProperty(NullDerefProperty.DEREFS_IN_CATCH_BLOCKS);
            }
        }
        if (!isConsistent && !uniqueDereferenceLocations) {
            propertySet.addProperty(NullDerefProperty.DEREFS_ARE_CLONED);
        }
        this.addPropertiesForMethodContainingWarning(propertySet);
    }

    private boolean uniqueLocations(Collection<Location> derefLocationSet) {
        boolean uniqueDereferenceLocations;
        block6: {
            uniqueDereferenceLocations = false;
            CodeException[] exceptionTable = this.method.getCode().getExceptionTable();
            if (exceptionTable == null) {
                return true;
            }
            for (CodeException e : exceptionTable) {
                if (e.getCatchType() != 0) {
                    continue;
                }
                break block6;
            }
            return true;
        }
        LineNumberTable table = this.method.getLineNumberTable();
        if (table == null) {
            uniqueDereferenceLocations = true;
        } else {
            BitSet linesMentionedMultipleTimes = this.classContext.linesMentionedMultipleTimes(this.method);
            for (Location loc : derefLocationSet) {
                int lineNumber = table.getSourceLine(loc.getHandle().getPosition());
                if (lineNumber <= 0 || linesMentionedMultipleTimes.get(lineNumber)) continue;
                uniqueDereferenceLocations = true;
            }
        }
        return uniqueDereferenceLocations;
    }

    private void addPropertiesForMethodContainingWarning(WarningPropertySet<WarningProperty> propertySet) {
        boolean uncallable;
        XMethod xMethod = XFactory.createXMethod(this.classContext.getJavaClass(), this.method);
        boolean bl = uncallable = !AnalysisContext.currentXFactory().isCalledDirectlyOrIndirectly(xMethod) && xMethod.isPrivate();
        if (uncallable) {
            propertySet.addProperty(GeneralWarningProperty.IN_UNCALLABLE_METHOD);
        }
    }

    private boolean isDoomed(Location loc) {
        if (!MARK_DOOMED) {
            return false;
        }
        try {
            ReturnPathTypeDataflow rptDataflow = this.classContext.getReturnPathTypeDataflow(this.method);
            ReturnPathType rpt = (ReturnPathType)rptDataflow.getFactAtLocation(loc);
            return !rpt.canReturnNormally();
        }
        catch (CheckedAnalysisException e) {
            AnalysisContext.logError("Error getting return path type", e);
            return false;
        }
    }

    String getDescription(Location loc, ValueNumber refValue) {
        try {
            UsagesRequiringNonNullValues usages = this.classContext.getUsagesRequiringNonNullValues(this.method);
            PointerUsageRequiringNonNullValue pu = usages.get(loc, refValue, this.vnaDataflow);
            if (pu == null) {
                return "SOURCE_LINE_DEREF";
            }
            return pu.getDescription();
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            return "SOURCE_LINE_DEREF";
        }
        catch (CFGBuilderException e) {
            AnalysisContext.logError("Error getting UsagesRequiringNonNullValues for " + this.method, e);
            return "SOURCE_LINE_DEREF";
        }
    }

    boolean inExplictCatchNullBlock(Location loc) {
        int pc = loc.getHandle().getPosition();
        int catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/NullPointerException", pc);
        return catchSize < Integer.MAX_VALUE;
    }

    boolean inIndirectCatchNullBlock(Location loc) {
        int pc = loc.getHandle().getPosition();
        int catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/Exception", pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/RuntimeException", pc);
        if (catchSize < 5) {
            return true;
        }
        catchSize = Util.getSizeOfSurroundingTryBlock(this.classContext.getJavaClass().getConstantPool(), this.method.getCode(), "java/lang/Throwable", pc);
        return catchSize < 5;
    }

    static class CheckCallSitesAndReturnInstructions {
        CheckCallSitesAndReturnInstructions() {
        }
    }
}

