/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import edu.umd.cs.findbugs.ba.ClassContext;
import java.util.BitSet;
import java.util.Collections;
import org.apache.bcel.classfile.Method;

public class SuspiciousThreadInterrupted
extends BytecodeScanningDetector
implements StatelessDetector {
    public static final int SEEN_NOTHING = 0;
    public static final int SEEN_CURRENTTHREAD = 1;
    public static final int SEEN_POP_AFTER_CURRENTTHREAD = 2;
    public static final int SEEN_UNKNOWNCONTEXT_POP = 3;
    public static final int SEEN_POSSIBLE_THREAD = 4;
    private final BugReporter bugReporter;
    private BitSet localsWithCurrentThreadValue;
    private int state;

    public SuspiciousThreadInterrupted(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    @Override
    public void visitClassContext(ClassContext classContext) {
        if (SuspiciousThreadInterrupted.hasInterestingClass(classContext.getJavaClass().getConstantPool(), Collections.singleton("java/lang/Thread"))) {
            super.visitClassContext(classContext);
        }
    }

    @Override
    public void visit(Method obj) {
        this.localsWithCurrentThreadValue = new BitSet();
        this.state = 0;
        super.visit(obj);
    }

    @Override
    public void sawOpcode(int seen) {
        if (this.state == 4) {
            if (seen == 87) {
                this.state = 3;
                return;
            }
            this.state = 0;
        }
        switch (this.state) {
            case 0: {
                if (seen == 184 && "java/lang/Thread".equals(this.getClassConstantOperand()) && "currentThread".equals(this.getNameConstantOperand()) && "()Ljava/lang/Thread;".equals(this.getSigConstantOperand())) {
                    this.state = 1;
                    break;
                }
                if ((seen == 184 || seen == 185 || seen == 182 || seen == 183) && this.getSigConstantOperand().endsWith("Ljava/lang/Thread;")) {
                    this.state = 4;
                    break;
                }
                if (seen == 25) {
                    if (this.localsWithCurrentThreadValue.get(this.getRegisterOperand())) {
                        this.state = 1;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                if (seen >= 42 && seen <= 45) {
                    if (this.localsWithCurrentThreadValue.get(seen - 42)) {
                        this.state = 1;
                        break;
                    }
                    this.state = 4;
                    break;
                }
                if (seen != 180 && seen != 178 || !"Ljava/lang/Thread;".equals(this.getSigConstantOperand())) break;
                this.state = 4;
                break;
            }
            case 1: {
                if (seen == 87) {
                    this.state = 2;
                    break;
                }
                if (seen == 58) {
                    this.localsWithCurrentThreadValue.set(this.getRegisterOperand());
                    this.state = 0;
                    break;
                }
                if (seen >= 75 && seen <= 78) {
                    this.localsWithCurrentThreadValue.set(seen - 75);
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            default: {
                if (seen == 184 && "java/lang/Thread".equals(this.getClassConstantOperand()) && "interrupted".equals(this.getNameConstantOperand()) && "()Z".equals(this.getSigConstantOperand())) {
                    if (this.state == 2) {
                        this.bugReporter.reportBug(new BugInstance(this, "STI_INTERRUPTED_ON_CURRENTTHREAD", 3).addClassAndMethod(this).addSourceLine(this));
                    } else if (this.state == 3) {
                        this.bugReporter.reportBug(new BugInstance(this, "STI_INTERRUPTED_ON_UNKNOWNTHREAD", 2).addClassAndMethod(this).addSourceLine(this));
                    }
                }
                this.state = 0;
            }
        }
    }
}

