/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.internalAnnotations;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.meta.TypeQualifier;
import javax.annotation.meta.TypeQualifierValidator;
import javax.annotation.meta.When;

@Documented
@TypeQualifier(applicableTo=CharSequence.class)
@Retention(value=RetentionPolicy.RUNTIME)
public @interface SlashedClassName {
    public static final String NOT_AVAILABLE = "./.";

    public When when() default When.ALWAYS;

    public static class Checker
    implements TypeQualifierValidator<SlashedClassName> {
        static final String simpleName = "(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*)";
        static final String slashedClassName = "(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*)(/(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*))*";
        static final Pattern simplePattern = Pattern.compile("(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*)");
        static final Pattern pattern = Pattern.compile("(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*)(/(\\p{javaJavaIdentifierStart}(\\p{javaJavaIdentifierPart}|\\$)*))*");

        @Nonnull
        public When forConstantValue(@Nonnull SlashedClassName annotation, Object value) {
            if (!(value instanceof String)) {
                return When.UNKNOWN;
            }
            if (pattern.matcher((String)value).matches()) {
                return When.ALWAYS;
            }
            if (value.equals(SlashedClassName.NOT_AVAILABLE)) {
                return When.MAYBE;
            }
            return When.NEVER;
        }
    }
}

