/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wickedcharts.highcharts.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.googlecode.wickedcharts.highcharts.jackson.ColorReferenceSerializer;
import com.googlecode.wickedcharts.highcharts.options.color.RgbaColor;
import java.io.IOException;
import java.util.Locale;

public class RgbaColorReferenceSerializer
extends ColorReferenceSerializer<RgbaColor> {
    private static final String RGBA = "rgba(%d,%d,%d,%.2f)";

    @Override
    protected void serializeIfNotNull(RgbaColor color, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        if (color.getBrightness() == null) {
            jgen.writeString(String.format(Locale.ENGLISH, RGBA, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            String colorString = this.brighten("\"" + String.format(Locale.ENGLISH, RGBA, color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()) + "\"", color.getBrightness().floatValue());
            jgen.writeRawValue(colorString);
        }
    }
}

