/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.DefaultSQLIdNameConversion;
import org.beetl.sql.core.SQLIdNameConversion;
import org.beetl.sql.core.SQLLoader;
import org.beetl.sql.core.SQLSource;
import org.beetl.sql.core.SQLTableSource;
import org.beetl.sql.core.db.DBStyle;
import org.beetl.sql.core.db.MySqlStyle;
import org.beetl.sql.core.kit.MDParser;

public class ClasspathLoader
implements SQLLoader {
    protected String sqlRoot = null;
    protected String lineSeparator = System.getProperty("line.separator", "\n");
    protected Map<String, SQLSource> sqlSourceMap = new ConcurrentHashMap<String, SQLSource>();
    protected DBStyle dbs = null;
    protected boolean autoCheck = true;
    protected String charset = null;
    protected SQLIdNameConversion sqlIdNameConversion = new DefaultSQLIdNameConversion();
    protected SQLSource NO_EXIST = new SQLSource();
    protected ClassLoader classLoader = null;

    public ClasspathLoader() {
        this("/sql");
    }

    public ClasspathLoader(String root) {
        this(root, new MySqlStyle());
    }

    public ClasspathLoader(String root, DBStyle dbs) {
        this.sqlRoot = root;
        this.dbs = dbs;
    }

    @Override
    public SQLSource getSQL(String id) {
        SQLSource ss = this.tryLoadSQL(id);
        return ss;
    }

    private SQLSource tryLoadSQL(String id) {
        SQLSource ss = this.sqlSourceMap.get(id);
        boolean hasLoad = false;
        if (ss == null) {
            this.loadSql(id);
            hasLoad = true;
        }
        if (!hasLoad && this.autoCheck && this.isModified(id)) {
            this.loadSql(id);
        }
        if ((ss = this.sqlSourceMap.get(id)) == null) {
            this.sqlSourceMap.put(id, this.NO_EXIST);
            return null;
        }
        if (ss == this.NO_EXIST) {
            return null;
        }
        return ss;
    }

    @Override
    public boolean isModified(String id) {
        SQLSource source = this.sqlSourceMap.get(id);
        if (source != null && source instanceof SQLTableSource && source == this.NO_EXIST) {
            return false;
        }
        long oldRootVersion = source.getVersion().root;
        long oldDbVersion = source.getVersion().db;
        URL root = this.getRootFile(id);
        URL db = this.getDBRootFile(id);
        return ClasspathLoader.getURLVersion(root) != oldRootVersion || ClasspathLoader.getURLVersion(db) != oldDbVersion;
    }

    protected static Long getURLVersion(URL url) {
        if (url == null) {
            return 0L;
        }
        if (url.getProtocol().equals("file")) {
            String path = url.getFile();
            return new File(path).lastModified();
        }
        return 0L;
    }

    @Override
    public boolean exist(String id) {
        return this.tryLoadSQL(id) != null;
    }

    @Override
    public void addSQL(String id, SQLSource source) {
        this.sqlSourceMap.put(id, source);
    }

    private boolean loadSql(String id) {
        URL ins = this.getRootFile(id);
        boolean rootResult = this.readSqlFile(id, ins, true);
        ins = this.getDBRootFile(id);
        boolean dbResult = this.readSqlFile(id, ins, false);
        return rootResult || dbResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readSqlFile(String id, URL url, boolean isRoot) {
        InputStream ins;
        if (url == null) {
            return false;
        }
        try {
            ins = url.openStream();
        }
        catch (IOException e1) {
            return false;
        }
        String modelName = id.substring(0, id.lastIndexOf(".") + 1);
        if (ins == null) {
            return false;
        }
        String filePath = this.sqlIdNameConversion.getPath(id);
        long lastModified = ClasspathLoader.getURLVersion(url);
        LinkedList list = new LinkedList();
        BufferedReader bf = null;
        try {
            bf = new BufferedReader(new InputStreamReader(ins, this.charset));
            MDParser parser = new MDParser(modelName, bf);
            SQLSource source = null;
            while ((source = parser.next()) != null) {
                SQLFileVersion version = new SQLFileVersion();
                version.url = url;
                if (isRoot) {
                    version.root = lastModified;
                } else {
                    version.db = lastModified;
                }
                source.setVersion(version);
                this.sqlSourceMap.put(source.getId(), source);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bf != null) {
                try {
                    bf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public Map<String, SQLSource> getSqlSourceMap() {
        return this.sqlSourceMap;
    }

    public String getSqlRoot() {
        return this.sqlRoot;
    }

    public void setSqlRoot(String sqlRoot) {
        this.sqlRoot = sqlRoot;
    }

    private URL getRootFile(String id) {
        String path = this.sqlIdNameConversion.getPath(id);
        String filePath0 = this.sqlRoot + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + path + ".md";
        URL is = this.getFile(filePath0);
        if (is == null && (is = this.getFile(filePath1)) == null) {
            return null;
        }
        return is;
    }

    private URL getDBRootFile(String id) {
        String path = this.sqlIdNameConversion.getPath(id);
        String filePath0 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".sql";
        String filePath1 = this.sqlRoot + "/" + this.dbs.getName() + "/" + path + ".md";
        URL is = this.getFile(filePath0);
        if (is == null && (is = this.getFile(filePath1)) == null) {
            return null;
        }
        return is;
    }

    public boolean exsitResource(String id) {
        return this.getRootFile(id) != null || this.getDBRootFile(id) != null;
    }

    private URL getFile(String filePath) {
        ClassLoader loader = null;
        URL url = null;
        if (this.classLoader != null && (url = this.classLoader.getResource(filePath)) != null) {
            return url;
        }
        loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            url = loader.getResource(filePath);
            if (url != null) {
                return url;
            }
            url = this.getClass().getResource(filePath);
            return url;
        }
        url = this.getClass().getResource(filePath);
        return url;
    }

    @Override
    public boolean isAutoCheck() {
        return this.autoCheck;
    }

    @Override
    public void setAutoCheck(boolean check) {
        this.autoCheck = check;
    }

    public DBStyle getDbs() {
        return this.dbs;
    }

    public void setDbs(DBStyle dbs) {
        this.dbs = dbs;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(String charset) {
        this.charset = charset;
    }

    public String toString() {
        return this.sqlRoot;
    }

    @Override
    public void setSQLIdNameConversion(SQLIdNameConversion sqlIdNc) {
        this.sqlIdNameConversion = sqlIdNc;
    }

    @Override
    public void setDbStyle(DBStyle dbStyle) {
        this.dbs = dbStyle;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public void refresh() {
        this.sqlSourceMap = new ConcurrentHashMap<String, SQLSource>();
    }

    public static class SQLFileVersion {
        public URL url;
        public long root = 0L;
        public long db = 0L;

        public boolean isModified(SQLFileVersion newVersion) {
            return newVersion.root != this.root || newVersion.db != this.db;
        }
    }
}

