/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.kit;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.beetl.sql.core.SQLSource;

public class MDParser {
    BufferedReader br;
    String modelName;
    int linNumber;
    String lastLine;
    String lastlastLine;
    int status = 0;
    private static int END = 1;
    protected static String lineSeparator = System.getProperty("line.separator", "\n");

    public MDParser(String modelName, BufferedReader br) throws IOException {
        this.modelName = modelName;
        this.br = br;
        this.skipHeader();
    }

    public void skipHeader() throws IOException {
        String line;
        do {
            line = this.nextLine();
            if (this.status != END) continue;
            return;
        } while (!line.startsWith("==="));
    }

    public SQLSource next() throws IOException {
        String sqlId = this.readSqlId();
        if (this.status == END) {
            return null;
        }
        sqlId = sqlId.trim();
        this.skipComment();
        if (this.status == END) {
            return null;
        }
        int sqlLine = this.linNumber;
        String sql = this.readSql();
        SQLSource source = new SQLSource(this.modelName + sqlId, sql);
        source.setLine(sqlLine);
        return source;
    }

    public void skipComment() throws IOException {
        boolean findComment = false;
        while (true) {
            String line = this.nextLine();
            if (this.status == END) {
                return;
            }
            line = line.trim();
            if (!findComment && line.length() == 0) continue;
            if (line.startsWith("*")) {
                findComment = true;
                continue;
            }
            String s = line.trim();
            if (s.length() != 0 && !s.startsWith("```") && !s.startsWith("~~~")) break;
        }
    }

    public String readSql() throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        list.add(this.lastLine);
        while (true) {
            String line = this.nextLine();
            if (this.status == END) {
                return this.getBuildSql(list);
            }
            if (line.startsWith("===")) {
                list.remove(list.size() - 1);
                return this.getBuildSql(list);
            }
            list.add(line);
        }
    }

    private String getBuildSql(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String str : list) {
            String s = str.trim();
            if (s.startsWith("```") || s.startsWith("~~~")) continue;
            sb.append(str).append(lineSeparator);
        }
        return sb.toString();
    }

    public String readSqlId() {
        return this.lastlastLine;
    }

    public String nextLine() throws IOException {
        String line = this.br.readLine();
        ++this.linNumber;
        if (line == null) {
            this.status = END;
        }
        this.lastlastLine = this.lastLine;
        this.lastLine = line;
        return line;
    }
}

