/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.core.mapper.para;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.beetl.sql.core.BeetlSQLException;
import org.beetl.sql.core.JavaType;
import org.beetl.sql.core.annotatoin.Param;
import org.beetl.sql.core.annotatoin.RowSize;
import org.beetl.sql.core.annotatoin.RowStart;
import org.beetl.sql.core.kit.BeanKit;

public abstract class MapperParameter {
    String annoParam = null;
    Method m = null;
    String[] paramsName = null;

    public MapperParameter(Method m) {
        this.m = m;
    }

    public MapperParameter(Method m, String annoParam) {
        this.m = m;
        this.annoParam = annoParam;
    }

    public abstract Object get(Object[] var1);

    protected Map buildByParam(Object[] array) {
        String[] names = this.annoParam.split(",");
        if (names.length != array.length) {
            throw new BeetlSQLException(11, this.annoParam + " \u4e0e\u5b9e\u9645\u8c03\u7528\u53c2\u6570\u4e0d\u5339\u914d");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < names.length; ++i) {
            map.put(names[i], array[i]);
        }
        return map;
    }

    protected String[] getParaName(int start) {
        if (JavaType.isJdk8()) {
            return this.getJDK8ParaName(start);
        }
        return this.getGeneralName(start);
    }

    protected String[] getJDK8ParaName(int start) {
        ArrayList<String> list = new ArrayList<String>();
        Parameter[] paras = this.m.getParameters();
        Annotation[][] anns = this.m.getParameterAnnotations();
        for (int i = start; i < paras.length; ++i) {
            String name = this.getParaNameByAnnation(anns[i]);
            if (name != null) {
                list.add(name);
                continue;
            }
            list.add(paras[i].getName());
        }
        return list.toArray(new String[0]);
    }

    protected String[] getGeneralName(int start) {
        ArrayList<String> list = new ArrayList<String>();
        Annotation[][] anns = this.m.getParameterAnnotations();
        for (int i = start; i < anns.length; ++i) {
            String name = this.getParaNameByAnnation(anns[i]);
            if (name == null) {
                throw new BeetlSQLException(11, "\u672a\u547d\u540d\u7684\u53c2\u6570 " + start + " " + this.m);
            }
            list.add(name);
        }
        return list.toArray(new String[0]);
    }

    protected String getParaNameByAnnation(Annotation[] annons) {
        if (annons.length == 0) {
            return null;
        }
        Annotation p = annons[0];
        String name = null;
        if (p instanceof RowStart) {
            name = "_st";
        } else if (p instanceof RowSize) {
            name = "_sz";
        } else if (p instanceof Param) {
            name = ((Param)p).value();
        } else {
            throw new BeetlSQLException(11, "\u4e0d\u652f\u6301\u7684Sql\u6ce8\u89e3 " + p + this.m);
        }
        return name;
    }

    protected String[] checkFirst(Method m) {
        Class<?>[] paras = m.getParameterTypes();
        String[] parameterNames = null;
        if (paras.length >= 1 && this.isRoot(paras[0])) {
            Annotation[][] anns = m.getParameterAnnotations();
            if (anns[0].length == 0) {
                String[] names = this.getParaName(1);
                String[] temp = new String[names.length + 1];
                System.arraycopy(names, 0, temp, 1, names.length);
                temp[0] = "_root";
                parameterNames = temp;
            } else {
                parameterNames = this.getParaName(0);
            }
        } else {
            parameterNames = this.getParaName(0);
        }
        return parameterNames;
    }

    protected boolean isRoot(Class c) {
        if (Map.class.isAssignableFrom(c)) {
            return true;
        }
        if (c.isArray()) {
            return false;
        }
        if (c.isPrimitive()) {
            return false;
        }
        String name = BeanKit.getPackageName(c);
        return !name.startsWith("java.") && !name.startsWith("javax.");
    }
}

