/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.sql.ext;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.beetl.sql.core.Interceptor;
import org.beetl.sql.core.InterceptorContext;
import org.beetl.sql.core.engine.SQLParameter;

public class SimpleCacheInterceptor
implements Interceptor {
    Set<String> nsSet = null;
    CacheManager cm = null;

    public SimpleCacheInterceptor(List<String> namespaces) {
        this(namespaces, new MapCacheManager());
    }

    public SimpleCacheInterceptor(List<String> namespaces, CacheManager cm) {
        this.cm = cm;
        this.nsSet = new HashSet<String>();
        for (String ns : namespaces) {
            this.nsSet.add(ns);
            this.cm.initCache(ns);
        }
    }

    @Override
    public void before(InterceptorContext ctx) {
        String ns = this.getSqlIdNameSpace(ctx.getSqlId());
        if (!this.cacheRequire(ns)) {
            return;
        }
        ctx.put("cache.required", Boolean.TRUE);
        ctx.put("cache.ns", ns);
        if (ctx.isUpdate()) {
            return;
        }
        Object cacheKey = this.getCacheKey(ctx);
        ctx.put("cache.key", cacheKey);
        Object cacheObject = this.getCacheObject(ns, cacheKey);
        if (cacheObject == null) {
            ctx.put("cache.hit", Boolean.FALSE);
        } else {
            ctx.put("cache.hit", Boolean.TRUE);
            ctx.setResult(cacheObject);
        }
    }

    @Override
    public void after(InterceptorContext ctx) {
        if (ctx.get("cache.required") == null) {
            return;
        }
        String ns = (String)ctx.get("cache.ns");
        if (ctx.isUpdate()) {
            this.clearCache(ns);
        } else {
            Boolean hit = (Boolean)ctx.get("cache.hit");
            if (!hit.booleanValue()) {
                Object key = ctx.get("cache.key");
                this.putCache(ns, key, ctx);
            }
        }
    }

    public Object getCacheKey(InterceptorContext ctx) {
        return this.getCacheKey(ctx.getSqlId(), ctx.getSql(), ctx.getParas());
    }

    private Object getCacheKey(String sqlId, String sql, List<SQLParameter> paras) {
        StringBuilder sb = new StringBuilder();
        sb.append("sqlId : " + sqlId).append("\nsql:").append(sql).append("\nparas : " + paras);
        return sb.toString();
    }

    public Object getCacheObject(String ns, Object cacheKey) {
        return this.cm.getCache(ns, cacheKey);
    }

    public void clearCache(String ns) {
        this.cm.clearCache(ns);
    }

    public void putCache(String ns, Object key, InterceptorContext ctx) {
        this.cm.putCache(ns, key, ctx.getResult());
    }

    protected String getSqlIdNameSpace(String sqlId) {
        int index = sqlId.lastIndexOf(46);
        return sqlId.substring(0, index);
    }

    protected boolean cacheRequire(String ns) {
        return this.nsSet.contains(ns);
    }

    public CacheManager getCacheManger() {
        return this.cm;
    }

    public Set<String> getNsSet() {
        return this.nsSet;
    }

    public boolean containCache(String ns, Object key) {
        return this.cm.containCache(ns, key);
    }

    @Override
    public void exception(InterceptorContext ctx, Exception ex) {
    }

    public static class MapCacheManager
    implements CacheManager {
        Map<String, Map<Object, Object>> cache = new ConcurrentHashMap<String, Map<Object, Object>>();

        @Override
        public void initCache(String ns) {
            this.cache.put(ns, new ConcurrentHashMap());
        }

        @Override
        public void putCache(String ns, Object key, Object value) {
            this.cache.get(ns).put(key, value);
        }

        @Override
        public Object getCache(String ns, Object key) {
            return this.cache.get(ns).get(key);
        }

        @Override
        public void clearCache(String ns) {
            for (Map.Entry<String, Map<Object, Object>> entry : this.cache.entrySet()) {
                entry.getValue().clear();
            }
        }

        @Override
        public boolean containCache(String ns, Object key) {
            return this.cache.get(ns).containsKey(key);
        }
    }

    public static interface CacheManager {
        public void initCache(String var1);

        public void putCache(String var1, Object var2, Object var3);

        public Object getCache(String var1, Object var2);

        public void clearCache(String var1);

        public boolean containCache(String var1, Object var2);
    }
}

