/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.data.handlers;

import com.ibm.db2.cmx.runtime.ResultIterator;
import com.ibm.db2.cmx.runtime.exception.DataRuntimeException;
import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.handlers.RowHandler;
import com.ibm.db2.cmx.runtime.handlers.RowHandlerWithParameters;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BaseResultIterator<T>
implements ResultIterator<T> {
    protected ResultSet resultSet_;
    private RowHandler<T> singleRowHandler_;
    protected boolean hasNext_;
    protected boolean nextCalled_;
    protected boolean isOpen_;
    protected boolean rowHandlerWithParameters_;
    protected Object[] methodParameters_;

    public BaseResultIterator(ResultSet resultSet, RowHandler<T> rowHandler) {
        this.resultSet_ = resultSet;
        this.singleRowHandler_ = rowHandler;
        this.rowHandlerWithParameters_ = false;
        this.isOpen_ = true;
    }

    public BaseResultIterator(ResultSet resultSet, RowHandler<T> rowHandler, Object[] objectArray) {
        this.resultSet_ = resultSet;
        this.singleRowHandler_ = rowHandler;
        this.rowHandlerWithParameters_ = true;
        this.methodParameters_ = objectArray;
        this.isOpen_ = true;
    }

    @Override
    public boolean hasNext() {
        if (!this.isOpen_) {
            return false;
        }
        if (!this.nextCalled_) {
            try {
                this.doNext();
            }
            catch (SQLException sQLException) {
                this.hasNext_ = false;
                this.nextCalled_ = true;
                this.close();
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_UNABLE_CALL_NXT", new Object[0]), sQLException, 10148);
            }
            this.nextCalled_ = true;
        }
        if (!this.hasNext_) {
            this.close();
        }
        return this.hasNext_;
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            this.nextCalled_ = false;
            try {
                if (this.rowHandlerWithParameters_) {
                    return ((RowHandlerWithParameters)this.singleRowHandler_).handle(this.resultSet_, null, this.methodParameters_);
                }
                return this.singleRowHandler_.handle(this.resultSet_, null);
            }
            catch (SQLException sQLException) {
                sQLException.printStackTrace();
                throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_UNABLE_FETCH", new Object[0]), sQLException, 10149);
            }
        }
        this.close();
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_NO_NXT_EL", new Object[0]), null, 10244);
    }

    @Override
    public void close() {
        Statement statement = null;
        if (this.isOpen_ && this.resultSet_ != null) {
            try {
                try {
                    statement = this.resultSet_.getStatement();
                }
                catch (DataRuntimeException dataRuntimeException) {
                    // empty catch block
                }
                this.resultSet_.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException sQLException) {}
                this.isOpen_ = false;
                this.resultSet_ = null;
                this.hasNext_ = false;
            }
        }
    }

    @Override
    public void remove() {
        throw ExceptionFactory.createDataRuntimeExceptionForRuntimeOnly(null, Messages.getText("ERR_METHOD_NOT_SUP", "remove()"), null, 10245);
    }

    protected void doNext() throws SQLException {
        this.hasNext_ = this.resultSet_.next();
    }
}

