/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.client;

import com.j256.simplejmx.client.ClientUtils;
import com.j256.simplejmx.common.ObjectNameUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxClient {
    private JMXConnector jmxConnector;
    private JMXServiceURL serviceUrl;
    private MBeanServerConnection mbeanConn;

    public JmxClient(String jmxUrl) throws JMException {
        this(jmxUrl, null, null);
    }

    public JmxClient(String jmxUrl, String userName, String password) throws JMException {
        if (jmxUrl == null) {
            throw new IllegalArgumentException("Jmx URL cannot be null");
        }
        HashMap<String, String[]> map = null;
        if (userName != null || password != null) {
            map = new HashMap<String, String[]>();
            String[] credentials = new String[]{userName, password};
            map.put("jmx.remote.credentials", credentials);
        }
        try {
            this.serviceUrl = new JMXServiceURL(jmxUrl);
        }
        catch (MalformedURLException e) {
            throw this.createJmException("JmxServiceUrl was malformed: " + jmxUrl, e);
        }
        try {
            this.jmxConnector = JMXConnectorFactory.connect(this.serviceUrl, map);
            this.mbeanConn = this.jmxConnector.getMBeanServerConnection();
        }
        catch (IOException e) {
            if (this.jmxConnector != null) {
                try {
                    this.jmxConnector.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                this.jmxConnector = null;
            }
            throw this.createJmException("Problems connecting to the server" + e, e);
        }
    }

    public JmxClient(int localPort) throws JMException {
        this(JmxClient.generalJmxUrlForHostNamePort("", localPort));
    }

    public JmxClient(String hostName, int port) throws JMException {
        this(JmxClient.generalJmxUrlForHostNamePort(hostName, port));
    }

    public JmxClient(InetAddress address, int port) throws JMException {
        this(address.getHostAddress(), port);
    }

    public static String generalJmxUrlForHostNamePort(String hostName, int port) {
        return "service:jmx:rmi:///jndi/rmi://" + hostName + ":" + port + "/jmxrmi";
    }

    public synchronized void close() {
        try {
            this.closeThrow();
        }
        catch (JMException jMException) {
            // empty catch block
        }
    }

    public synchronized void closeThrow() throws JMException {
        try {
            if (this.jmxConnector != null) {
                this.jmxConnector.close();
                this.jmxConnector = null;
            }
            this.mbeanConn = null;
        }
        catch (IOException e) {
            throw this.createJmException("Could not close the jmx connector", e);
        }
    }

    public String[] getBeanDomains() throws JMException {
        this.checkClientConnected();
        try {
            return this.mbeanConn.getDomains();
        }
        catch (IOException e) {
            throw this.createJmException("Problems getting jmx domains: " + e, e);
        }
    }

    public Set<ObjectName> getBeanNames() throws JMException {
        this.checkClientConnected();
        try {
            return this.mbeanConn.queryNames(null, null);
        }
        catch (IOException e) {
            throw this.createJmException("Problems querying for jmx bean names: " + e, e);
        }
    }

    public Set<ObjectName> getBeanNames(String domain) throws JMException {
        this.checkClientConnected();
        try {
            return this.mbeanConn.queryNames(ObjectName.getInstance(domain + ":*"), null);
        }
        catch (IOException e) {
            throw this.createJmException("Problems querying for jmx bean names: " + e, e);
        }
    }

    public MBeanAttributeInfo[] getAttributesInfo(String domainName, String beanName) throws JMException {
        return this.getAttributesInfo(ObjectNameUtil.makeObjectName(domainName, beanName));
    }

    public MBeanAttributeInfo[] getAttributesInfo(ObjectName name) throws JMException {
        this.checkClientConnected();
        try {
            return this.mbeanConn.getMBeanInfo(name).getAttributes();
        }
        catch (Exception e) {
            throw this.createJmException("Problems getting bean information from " + name, e);
        }
    }

    public MBeanAttributeInfo getAttributeInfo(ObjectName name, String attrName) throws JMException {
        this.checkClientConnected();
        return this.getAttrInfo(name, attrName);
    }

    public MBeanOperationInfo[] getOperationsInfo(String domainName, String beanName) throws JMException {
        return this.getOperationsInfo(ObjectNameUtil.makeObjectName(domainName, beanName));
    }

    public MBeanOperationInfo[] getOperationsInfo(ObjectName name) throws JMException {
        this.checkClientConnected();
        try {
            return this.mbeanConn.getMBeanInfo(name).getOperations();
        }
        catch (Exception e) {
            throw this.createJmException("Problems getting bean information from " + name, e);
        }
    }

    public MBeanOperationInfo getOperationInfo(ObjectName name, String oper) throws JMException {
        MBeanInfo mbeanInfo;
        this.checkClientConnected();
        try {
            mbeanInfo = this.mbeanConn.getMBeanInfo(name);
        }
        catch (Exception e) {
            throw this.createJmException("Problems getting bean information from " + name, e);
        }
        for (MBeanOperationInfo info : mbeanInfo.getOperations()) {
            if (!oper.equals(info.getName())) continue;
            return info;
        }
        return null;
    }

    public Object getAttribute(String domain, String beanName, String attributeName) throws Exception {
        return this.getAttribute(ObjectNameUtil.makeObjectName(domain, beanName), attributeName);
    }

    public Object getAttribute(ObjectName name, String attributeName) throws Exception {
        this.checkClientConnected();
        return this.mbeanConn.getAttribute(name, attributeName);
    }

    public String getAttributeString(String domain, String beanName, String attributeName) throws Exception {
        return this.getAttributeString(ObjectNameUtil.makeObjectName(domain, beanName), attributeName);
    }

    public String getAttributeString(ObjectName name, String attributeName) throws Exception {
        Object bean = this.getAttribute(name, attributeName);
        if (bean == null) {
            return null;
        }
        return ClientUtils.valueToString(bean);
    }

    public List<Attribute> getAttributes(ObjectName name, String[] attributes) throws Exception {
        this.checkClientConnected();
        return this.mbeanConn.getAttributes(name, attributes).asList();
    }

    public List<Attribute> getAttributes(String domain, String beanName, String[] attributes) throws Exception {
        this.checkClientConnected();
        return this.getAttributes(ObjectNameUtil.makeObjectName(domain, beanName), attributes);
    }

    public void setAttribute(String domainName, String beanName, String attrName, String value) throws Exception {
        this.setAttribute(ObjectNameUtil.makeObjectName(domainName, beanName), attrName, value);
    }

    public void setAttribute(ObjectName name, String attrName, String value) throws Exception {
        MBeanAttributeInfo info = this.getAttrInfo(name, attrName);
        if (info == null) {
            throw new IllegalArgumentException("Cannot find attribute named '" + attrName + "'");
        }
        this.setAttribute(name, attrName, ClientUtils.stringToParam(value, info.getType()));
    }

    public void setAttribute(String domainName, String beanName, String attrName, Object value) throws Exception {
        this.setAttribute(ObjectNameUtil.makeObjectName(domainName, beanName), attrName, value);
    }

    public void setAttribute(ObjectName name, String attrName, Object value) throws Exception {
        this.checkClientConnected();
        Attribute attribute = new Attribute(attrName, value);
        this.mbeanConn.setAttribute(name, attribute);
    }

    public void setAttributes(ObjectName name, List<Attribute> attributes) throws Exception {
        this.checkClientConnected();
        this.mbeanConn.setAttributes(name, new AttributeList(attributes));
    }

    public void setAttributes(String domainName, String beanName, List<Attribute> attributes) throws Exception {
        this.setAttributes(ObjectNameUtil.makeObjectName(domainName, beanName), attributes);
    }

    public Object invokeOperation(String domain, String beanName, String operName, String ... paramStrings) throws Exception {
        return this.invokeOperation(ObjectNameUtil.makeObjectName(domain, beanName), operName, paramStrings);
    }

    public Object invokeOperation(ObjectName name, String operName, String ... paramStrings) throws Exception {
        Object[] paramObjs;
        String[] paramTypes = this.lookupParamTypes(name, operName, paramStrings);
        if (paramStrings.length == 0) {
            paramObjs = null;
        } else {
            paramObjs = new Object[paramStrings.length];
            for (int i = 0; i < paramStrings.length; ++i) {
                paramObjs[i] = ClientUtils.stringToParam(paramStrings[i], paramTypes[i]);
            }
        }
        return this.invokeOperation(name, operName, paramTypes, paramObjs);
    }

    public String invokeOperationToString(ObjectName name, String operName, String ... paramStrings) throws Exception {
        return ClientUtils.valueToString(this.invokeOperation(name, operName, paramStrings));
    }

    public Object invokeOperation(String domain, String beanName, String operName, Object ... params) throws Exception {
        return this.invokeOperation(ObjectNameUtil.makeObjectName(domain, beanName), operName, params);
    }

    public Object invokeOperation(ObjectName objectName, String operName, Object ... params) throws Exception {
        String[] paramTypes = this.lookupParamTypes(objectName, operName, params);
        return this.invokeOperation(objectName, operName, paramTypes, params);
    }

    private Object invokeOperation(ObjectName objectName, String operName, String[] paramTypes, Object[] params) throws Exception {
        if (params != null && params.length == 0) {
            params = null;
        }
        return this.mbeanConn.invoke(objectName, operName, params, paramTypes);
    }

    private String[] lookupParamTypes(ObjectName objectName, String operName, Object[] params) throws JMException {
        MBeanOperationInfo[] operations;
        this.checkClientConnected();
        try {
            operations = this.mbeanConn.getMBeanInfo(objectName).getOperations();
        }
        catch (Exception e) {
            throw this.createJmException("Cannot get attribute info from " + objectName, e);
        }
        Object[] paramTypes = new String[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass().toString();
        }
        int nameC = 0;
        Object[] first = null;
        for (MBeanOperationInfo info : operations) {
            MBeanParameterInfo[] mbeanParams;
            if (!info.getName().equals(operName) || params.length != (mbeanParams = info.getSignature()).length) continue;
            Object[] signatureTypes = new String[mbeanParams.length];
            for (int i = 0; i < params.length; ++i) {
                signatureTypes[i] = mbeanParams[i].getType();
            }
            if (Arrays.equals(paramTypes, signatureTypes)) {
                return signatureTypes;
            }
            first = signatureTypes;
            ++nameC;
        }
        if (first == null) {
            throw new IllegalArgumentException("Cannot find operation named '" + operName + "'");
        }
        if (nameC > 1) {
            throw new IllegalArgumentException("Cannot find operation named '" + operName + "' with matching argument types");
        }
        return first;
    }

    private void checkClientConnected() {
        if (this.mbeanConn == null) {
            throw new IllegalArgumentException("JmxClient is not connected");
        }
    }

    private MBeanAttributeInfo getAttrInfo(ObjectName objectName, String attrName) throws JMException {
        MBeanAttributeInfo[] attributes;
        try {
            attributes = this.mbeanConn.getMBeanInfo(objectName).getAttributes();
        }
        catch (Exception e) {
            throw this.createJmException("Cannot get attribute info from " + objectName, e);
        }
        for (MBeanAttributeInfo info : attributes) {
            if (!info.getName().equals(attrName)) continue;
            return info;
        }
        return null;
    }

    private JMException createJmException(String message, Exception e) {
        JMException jmException = new JMException(message);
        jmException.initCause(e);
        return jmException;
    }
}

