/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.server;

import com.j256.simplejmx.common.JmxAttributeFieldInfo;
import com.j256.simplejmx.common.JmxAttributeMethodInfo;
import com.j256.simplejmx.common.JmxOperationInfo;
import com.j256.simplejmx.common.JmxResourceInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PublishAllBeanWrapper {
    private Object delegate;
    private JmxResourceInfo jmxResourceInfo;
    private static final Set<String> ignoredMethods = new HashSet<String>();

    public PublishAllBeanWrapper() {
    }

    public PublishAllBeanWrapper(Object delegate, JmxResourceInfo jmxResourceInfo) {
        this.delegate = delegate;
        this.jmxResourceInfo = jmxResourceInfo;
        if (jmxResourceInfo.getJmxBeanName() == null) {
            jmxResourceInfo.setJmxBeanName(delegate.getClass().getSimpleName());
        }
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public JmxResourceInfo getJmxResourceInfo() {
        return this.jmxResourceInfo;
    }

    public void setJmxResourceInfo(JmxResourceInfo jmxResourceInfo) {
        this.jmxResourceInfo = jmxResourceInfo;
    }

    public JmxAttributeFieldInfo[] getAttributeFieldInfos() {
        Field[] fields;
        ArrayList<JmxAttributeFieldInfo> fieldInfos = new ArrayList<JmxAttributeFieldInfo>();
        for (Field field : fields = this.delegate.getClass().getFields()) {
            fieldInfos.add(new JmxAttributeFieldInfo(field.getName(), true, !Modifier.isFinal(field.getModifiers()), null));
        }
        return fieldInfos.toArray(new JmxAttributeFieldInfo[fieldInfos.size()]);
    }

    public JmxAttributeMethodInfo[] getAttributeMethodInfos() {
        Method[] methods;
        ArrayList<JmxAttributeMethodInfo> methodInfos = new ArrayList<JmxAttributeMethodInfo>();
        for (Method method : methods = this.delegate.getClass().getMethods()) {
            String name = method.getName();
            if (ignoredMethods.contains(name) || !this.isGetGetAttributeMethod(name)) continue;
            methodInfos.add(new JmxAttributeMethodInfo(name, (String)null));
        }
        return methodInfos.toArray(new JmxAttributeMethodInfo[methodInfos.size()]);
    }

    public JmxOperationInfo[] getOperationInfos() {
        Method[] methods;
        ArrayList<JmxOperationInfo> operationInfos = new ArrayList<JmxOperationInfo>();
        for (Method method : methods = this.delegate.getClass().getMethods()) {
            String name = method.getName();
            if (ignoredMethods.contains(name) || this.isGetGetAttributeMethod(name)) continue;
            operationInfos.add(new JmxOperationInfo(name, null, null, JmxOperationInfo.OperationAction.UNKNOWN, null));
        }
        return operationInfos.toArray(new JmxOperationInfo[operationInfos.size()]);
    }

    private boolean isGetGetAttributeMethod(String name) {
        if (name.startsWith("is") && name.length() > 2) {
            return true;
        }
        if (name.startsWith("get") && name.length() > 3) {
            return true;
        }
        return name.startsWith("set") && name.length() > 3;
    }

    static {
        ignoredMethods.add("getClass");
        ignoredMethods.add("wait");
        ignoredMethods.add("equals");
        ignoredMethods.add("toString");
        ignoredMethods.add("hashCode");
        ignoredMethods.add("notify");
        ignoredMethods.add("notifyAll");
    }
}

