/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplejmx.web;

import com.j256.simplejmx.client.ClientUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JmxHandler
extends AbstractHandler {
    private static final String COMMAND_LIST_BEANS_IN_DOMAIN = "d";
    private static final String COMMAND_SHOW_BEAN = "b";
    private static final String COMMAND_ASSIGN_ATTRIBUTE = "a";
    private static final String COMMAND_INVOKE_OPERATION = "o";
    private static final String PARAM_ATTRIBUTE_VALUE = "v";
    private static final String PARAM_OPERATION_PREFIX = "p";
    private static final String PARAM_TEXT_ONLY = "t";
    private MBeanServer mbeanServer;
    private ObjectNameComparator objectNameComparator = new ObjectNameComparator();

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        if (this.mbeanServer == null) {
            this.mbeanServer = ManagementFactory.getPlatformMBeanServer();
        }
        this.processRequest(request, response, writer);
        baseRequest.setHandled(true);
        writer.close();
    }

    private void processRequest(HttpServletRequest request, HttpServletResponse response, BufferedWriter writer) throws IOException {
        boolean textOnly;
        String pathInfo = request.getPathInfo();
        if (pathInfo == null) {
            pathInfo = "";
        } else if (pathInfo.charAt(0) == '/') {
            pathInfo = pathInfo.substring(1);
        }
        boolean bl = textOnly = request.getParameter(PARAM_TEXT_ONLY) != null;
        if (textOnly) {
            response.setContentType("text/plain");
        } else {
            response.setContentType("text/html");
        }
        int slashIndex = pathInfo.indexOf(47);
        if (slashIndex < 0) {
            if (!textOnly) {
                this.appendHeader(writer);
            }
            this.listDomains(writer, textOnly);
            if (!textOnly) {
                writer.append("<br />\n");
                this.appendFooter(writer);
            }
            return;
        }
        String command = pathInfo.substring(0, slashIndex);
        pathInfo = pathInfo.substring(slashIndex + 1);
        if (command.equals(COMMAND_LIST_BEANS_IN_DOMAIN)) {
            if (!textOnly) {
                this.appendHeader(writer);
            }
            this.listBeansInDomain(writer, textOnly, pathInfo);
            if (!textOnly) {
                this.appendFooter(writer);
            }
        } else if (command.equals(COMMAND_SHOW_BEAN)) {
            if (!textOnly) {
                this.appendHeader(writer);
            }
            this.showBean(writer, textOnly, pathInfo);
            if (!textOnly) {
                this.appendFooter(writer);
            }
        } else if (command.equals(COMMAND_ASSIGN_ATTRIBUTE)) {
            this.assignAttribute(request, response, writer, textOnly, pathInfo);
        } else if (command.equals(COMMAND_INVOKE_OPERATION)) {
            if (!textOnly) {
                this.appendHeader(writer);
            }
            this.invokeOperation(request, writer, textOnly, pathInfo);
            if (!textOnly) {
                this.appendFooter(writer);
            }
        } else if (textOnly) {
            response.sendError(404);
        } else {
            this.appendHeader(writer);
            writer.append("Unknown command: " + command + " <br />\n");
            this.appendBackToRoot(writer);
            this.appendFooter(writer);
        }
    }

    private void listDomains(BufferedWriter writer, boolean textOnly) throws IOException {
        if (!textOnly) {
            writer.append("<h1> JMX Domains </h1>\n");
        }
        ArrayList<String> domainNames = new ArrayList<String>();
        for (String domainName : this.mbeanServer.getDomains()) {
            domainNames.add(domainName);
        }
        Collections.sort(domainNames);
        for (String domainName : domainNames) {
            this.appendLink(writer, textOnly, "/d/" + domainName, domainName);
            this.appendLine(writer, textOnly, null);
        }
    }

    private void listBeansInDomain(BufferedWriter writer, boolean textOnly, String domainName) throws IOException {
        if (!textOnly) {
            writer.append("<h1> Beans in domain " + domainName + " </h1>\n");
        }
        Set<ObjectInstance> mbeans = this.mbeanServer.queryMBeans(null, new DomainQueryExp(domainName));
        ArrayList<ObjectName> objectNames = new ArrayList<ObjectName>();
        for (ObjectInstance mbean : mbeans) {
            objectNames.add(mbean.getObjectName());
        }
        Collections.sort(objectNames, this.objectNameComparator);
        for (ObjectName objectName : objectNames) {
            String nameString = objectName.toString();
            if (textOnly) {
                writer.append(nameString + '\n');
                continue;
            }
            String display = nameString;
            int index = nameString.indexOf(58);
            if (index > 0) {
                display = nameString.substring(index + 1, nameString.length());
            }
            this.appendLink(writer, textOnly, "/b/" + nameString, display);
            this.appendLine(writer, textOnly, null);
        }
        if (!textOnly) {
            this.appendBackToRoot(writer);
        }
    }

    private void showBean(BufferedWriter writer, boolean textOnly, String objectNameString) throws IOException {
        MBeanInfo mbeanInfo;
        ObjectName objectName;
        try {
            objectName = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException mone) {
            this.appendLine(writer, textOnly, "Invalid object name: " + objectNameString);
            if (!textOnly) {
                this.appendBackToRoot(writer);
            }
            return;
        }
        try {
            mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            this.appendLine(writer, textOnly, "Investigating object threw exception: " + e);
            if (!textOnly) {
                this.appendBackToRoot(writer);
            }
            return;
        }
        if (!textOnly) {
            writer.append("<h1> Information about object: " + objectNameString + " </h1>\n");
            this.displayClassInfo(writer, mbeanInfo);
        }
        this.displayAttributes(writer, textOnly, objectName, mbeanInfo);
        this.displayOperations(writer, textOnly, objectName, mbeanInfo);
        if (!textOnly) {
            this.appendBackToDomains(writer, objectName);
        }
    }

    private void displayAttributes(BufferedWriter writer, boolean textOnly, ObjectName objectName, MBeanInfo mbeanInfo) throws IOException {
        if (!textOnly) {
            writer.append("<table cellpadding='3' cellspacing='1' border='3'>\n");
            writer.append("<tr><th colspan='3'> Attributes: </th></tr>\n");
            writer.append("<tr><th> Name </th><th> Type </th><th> Value </th></tr>\n");
        }
        for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
            String name = attribute.getName();
            Object value = null;
            if (attribute.isReadable()) {
                try {
                    value = this.mbeanServer.getAttribute(objectName, name);
                }
                catch (Exception e) {
                    value = "error getting value";
                }
            } else {
                value = "not readable";
            }
            if (Character.isUpperCase(name.charAt(0))) {
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
            }
            String valueString = ClientUtils.valueToString(value);
            if (textOnly) {
                writer.append(name + (attribute.isWritable() ? "*" : "") + "=" + valueString + "\n");
                continue;
            }
            if (attribute.isWritable()) {
                writer.append("<form action=\"/a/" + objectName + "/" + name + "\">\n");
            }
            writer.append("<tr><td> " + name + " </td>");
            writer.append("<td> " + ClientUtils.displayType(attribute.getType(), value) + " </td>");
            if (attribute.isWritable()) {
                writer.append("<td><input name=\"v\" value=\"" + valueString + "\" ></td>");
            } else {
                writer.append("<td> " + ClientUtils.valueToString(value) + " </td>");
            }
            writer.append("</tr>\n");
            if (!attribute.isWritable()) continue;
            writer.append("</form>\n");
        }
        if (!textOnly) {
            writer.append("</table>\n");
        }
    }

    private void displayOperations(BufferedWriter writer, boolean textOnly, ObjectName objectName, MBeanInfo mbeanInfo) throws IOException {
        int maxParams = 1;
        boolean noOperations = true;
        for (MBeanOperationInfo operation : mbeanInfo.getOperations()) {
            if (this.isGetSet(operation.getName())) continue;
            MBeanParameterInfo[] params = operation.getSignature();
            if (params.length > maxParams) {
                maxParams = params.length;
            }
            noOperations = false;
        }
        if (noOperations) {
            if (!textOnly) {
                writer.append("No operations. <br />\n");
            }
            return;
        }
        if (!textOnly) {
            writer.append("<table cellpadding='3' cellspacing='1' border='3'>\n");
            writer.append("<tr><th colspan='" + (maxParams + 3) + "'> Operations: </th></tr>\n");
            writer.append("<tr><th> Name </th><th> Return </th><th colspan='" + maxParams + "'> Params </th><th> Invoke </th></tr>\n");
        }
        for (MBeanOperationInfo operation : mbeanInfo.getOperations()) {
            String name = operation.getName();
            if (this.isGetSet(name)) continue;
            if (textOnly) {
                writer.append(name);
            } else {
                writer.append("<form action=\"/o/" + objectName + "/" + name + "\">\n");
                writer.append("<tr><td> " + name + " </td>");
                writer.append("<td> " + ClientUtils.displayType(operation.getReturnType(), null) + " </td>");
            }
            MBeanParameterInfo[] params = operation.getSignature();
            int paramCount = 0;
            for (MBeanParameterInfo param : params) {
                if (textOnly) {
                    writer.append(" " + param.getType());
                    continue;
                }
                writer.append("<td> <input name=\"p" + paramCount++ + "\" value=\"" + param.getName() + "\" > (" + param.getType() + ")</td>");
            }
            if (textOnly) {
                writer.append("\n");
                continue;
            }
            while (paramCount < maxParams) {
                writer.append("<td> &nbsp; </td>");
                ++paramCount;
            }
            writer.append("<td><input type='submit' value='" + name + "' /></td>");
            writer.append("</tr>\n");
            writer.append("</form>\n");
        }
        if (!textOnly) {
            writer.append("</table>\n");
        }
    }

    private void assignAttribute(HttpServletRequest request, HttpServletResponse response, BufferedWriter writer, boolean textOnly, String pathInfo) throws IOException {
        MBeanInfo mbeanInfo;
        ObjectName objectName;
        String[] parts = pathInfo.split("/");
        if (parts.length != 2) {
            this.appendLine(writer, textOnly, "Invalid number of parameters to assign command");
            if (!textOnly) {
                this.appendBackToRoot(writer);
            }
            return;
        }
        try {
            objectName = new ObjectName(parts[0]);
        }
        catch (Exception e) {
            if (!textOnly) {
                this.appendHeader(writer);
                writer.append("<h1> Setting Bean Attribute </h1>\n");
            }
            this.appendLine(writer, textOnly, "Invalid object name: " + parts[0] + ": " + e);
            if (!textOnly) {
                this.appendBackToRoot(writer);
                this.appendFooter(writer);
            }
            return;
        }
        String attributeName = parts[1];
        try {
            mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            if (!textOnly) {
                this.appendHeader(writer);
                writer.append("<h1> Setting Bean Attribute </h1>\n");
            }
            this.appendLine(writer, textOnly, "Could not get mbean info for: " + objectName + ": " + e);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
                this.appendFooter(writer);
            }
            return;
        }
        MBeanAttributeInfo info = null;
        for (MBeanAttributeInfo attribute : mbeanInfo.getAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            info = attribute;
            break;
        }
        if (info == null) {
            if (!textOnly) {
                this.appendHeader(writer);
                writer.append("<h1> Setting Bean Attribute </h1>\n");
            }
            this.appendLine(writer, textOnly, "Cannot find attribute: " + attributeName);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
                this.appendFooter(writer);
            }
            return;
        }
        String result = request.getParameter(PARAM_ATTRIBUTE_VALUE);
        Object value = ClientUtils.stringToParam(result, info.getType());
        try {
            Attribute attribute = new Attribute(attributeName, value);
            this.mbeanServer.setAttribute(objectName, attribute);
            if (textOnly) {
                this.appendLine(writer, textOnly, "set attributeName to " + value);
            } else {
                response.sendRedirect("/b/" + objectName);
            }
        }
        catch (Exception e) {
            if (!textOnly) {
                this.appendHeader(writer);
                writer.append("<h1> Setting Bean Attribute </h1>\n");
            }
            this.appendLine(writer, textOnly, "Could not set attribute: " + attributeName + ": " + e);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
                this.appendFooter(writer);
            }
            return;
        }
    }

    private void invokeOperation(HttpServletRequest request, BufferedWriter writer, boolean textOnly, String pathInfo) throws IOException {
        Object result;
        MBeanInfo mbeanInfo;
        ObjectName objectName;
        String[] parts = pathInfo.split("/");
        if (parts.length != 2) {
            this.appendLine(writer, textOnly, "Invalid number of parameters to invoke command");
            if (!textOnly) {
                this.appendBackToRoot(writer);
            }
            return;
        }
        try {
            objectName = new ObjectName(parts[0]);
        }
        catch (MalformedObjectNameException mone) {
            this.appendLine(writer, textOnly, "Invalid object name: " + parts[0]);
            if (!textOnly) {
                this.appendBackToRoot(writer);
            }
            return;
        }
        String operationName = parts[1];
        if (!textOnly) {
            writer.append("<h1> Invoking Operation " + operationName + " </h1>\n");
        }
        try {
            mbeanInfo = this.mbeanServer.getMBeanInfo(objectName);
        }
        catch (Exception e) {
            this.appendLine(writer, textOnly, "Could not get mbean info for: " + objectName + ": " + e);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
            }
            return;
        }
        if (!textOnly) {
            this.displayClassInfo(writer, mbeanInfo);
        }
        MBeanOperationInfo operation = null;
        for (MBeanOperationInfo info : mbeanInfo.getOperations()) {
            if (!info.getName().equals(operationName)) continue;
            operation = info;
            break;
        }
        if (operation == null) {
            this.appendLine(writer, textOnly, "Cannot find operation in " + objectName);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
            }
            return;
        }
        MBeanParameterInfo[] paramInfos = operation.getSignature();
        Object[] params = new Object[paramInfos.length];
        String[] paramTypes = new String[paramInfos.length];
        for (int i = 0; i < paramInfos.length; ++i) {
            paramTypes[i] = paramInfos[i].getType();
            params[i] = ClientUtils.stringToParam(request.getParameter(PARAM_OPERATION_PREFIX + i), paramTypes[i]);
        }
        try {
            result = this.mbeanServer.invoke(objectName, operationName, params, paramTypes);
        }
        catch (Exception e) {
            this.appendLine(writer, textOnly, "Invoking threw exception: " + e);
            if (!textOnly) {
                this.appendBackToBean(writer, objectName);
            }
            e.printStackTrace();
            return;
        }
        if (result == null) {
            this.appendLine(writer, textOnly, "Method successfully invoked.");
        } else {
            this.appendLine(writer, textOnly, "Result is: " + result);
        }
        if (!textOnly) {
            this.appendBackToBean(writer, objectName);
        }
    }

    private void displayClassInfo(BufferedWriter writer, MBeanInfo mbeanInfo) throws IOException {
        writer.append("ClassName: " + mbeanInfo.getClassName() + "<br />\n");
        if (mbeanInfo.getDescription() != null) {
            writer.append("Description: " + mbeanInfo.getDescription() + "<br />\n");
        }
        writer.append("<br />\n");
    }

    private void appendLine(BufferedWriter writer, boolean textOnly, String line) throws IOException {
        if (line != null) {
            writer.append(line);
        }
        if (!textOnly) {
            writer.append("<br />");
        }
        writer.append("\n");
    }

    private void appendHeader(BufferedWriter writer) throws IOException {
        writer.append("<html><body>\n");
    }

    private void appendFooter(BufferedWriter writer) throws IOException {
        writer.append("<a href=\"?t=1\">Text version</a>.  Produced by <a href=\"http://256.com/sources/simplejmx/\">SimpleJMX</a> <br />\n");
        writer.append("</body></html>\n");
    }

    private void appendBackToBean(BufferedWriter writer, ObjectName objectName) throws IOException {
        writer.append("<br />\n");
        this.appendLink(writer, false, "/b/" + objectName.toString(), "Back to bean information");
        writer.append("<br />\n");
    }

    private void appendBackToRoot(BufferedWriter writer) throws IOException {
        writer.append("<br />\n");
        this.appendLink(writer, false, "/", "Back to root");
        writer.append("<br />\n");
    }

    private void appendBackToDomains(BufferedWriter writer, ObjectName objectName) throws IOException {
        writer.append("<br />\n");
        this.appendLink(writer, false, "/d/" + objectName.getDomain(), "Back to beans in domain");
        writer.append("<br />\n");
    }

    private void appendLink(BufferedWriter writer, boolean textOnly, String url, String text) throws IOException {
        if (!textOnly) {
            writer.append("<a href=\"" + url + "\" >");
        }
        writer.append(text);
        if (!textOnly) {
            writer.append("</a>");
        }
    }

    private boolean isGetSet(String name) {
        return name.startsWith("is") || name.startsWith("get") || name.startsWith("set");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ObjectNameComparator
    implements Comparator<ObjectName> {
        private ObjectNameComparator() {
        }

        @Override
        public int compare(ObjectName o1, ObjectName o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }

    private static class DomainQueryExp
    implements QueryExp {
        private static final long serialVersionUID = 6041820913324186392L;
        private final String domain;

        public DomainQueryExp(String domain) {
            this.domain = domain;
        }

        public void setMBeanServer(MBeanServer s) {
        }

        public boolean apply(ObjectName name) {
            return this.domain.equals(name.getDomain());
        }
    }
}

