/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.DNSAddParameters;
import com.microsoft.windowsazure.management.compute.models.DNSUpdateParameters;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

/**
* The Compute Management API includes operations for managing the dns servers
* for your subscription.
*/
public interface DNSServerOperations {
    /**
    * Add a definition for a DNS server to an existing deployment. VM's in this
    * deployment will be programmed to use this DNS server for all DNS
    * resolutions
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Add DNS Server
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse addDNSServer(String serviceName, String deploymentName, DNSAddParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Add a definition for a DNS server to an existing deployment. VM's in this
    * deployment will be programmed to use this DNS server for all DNS
    * resolutions
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Add DNS Server
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> addDNSServerAsync(String serviceName, String deploymentName, DNSAddParameters parameters);
    
    /**
    * Add a definition for a DNS server to an existing deployment. VM's in this
    * deployment will be programmed to use this DNS server for all DNS
    * resolutions
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Add DNS Server
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginAddingDNSServer(String serviceName, String deploymentName, DNSAddParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Add a definition for a DNS server to an existing deployment. VM's in this
    * deployment will be programmed to use this DNS server for all DNS
    * resolutions
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Add DNS Server
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginAddingDNSServerAsync(String serviceName, String deploymentName, DNSAddParameters parameters);
    
    /**
    * Deletes a definition for an existing DNS server from the deployment
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginDeletingDNSServer(String serviceName, String deploymentName, String dnsServerName) throws IOException, ServiceException;
    
    /**
    * Deletes a definition for an existing DNS server from the deployment
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginDeletingDNSServerAsync(String serviceName, String deploymentName, String dnsServerName);
    
    /**
    * Updates a definition for an existing DNS server. Updates to address is
    * the only change allowed. DNS server name cannot be changed
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @param parameters Required. Parameters supplied to the Update DNS Server
    * operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginUpdatingDNSServer(String serviceName, String deploymentName, String dnsServerName, DNSUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates a definition for an existing DNS server. Updates to address is
    * the only change allowed. DNS server name cannot be changed
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @param parameters Required. Parameters supplied to the Update DNS Server
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginUpdatingDNSServerAsync(String serviceName, String deploymentName, String dnsServerName, DNSUpdateParameters parameters);
    
    /**
    * Deletes a definition for an existing DNS server from the deployment
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse deleteDNSServer(String serviceName, String deploymentName, String dnsServerName) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Deletes a definition for an existing DNS server from the deployment
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> deleteDNSServerAsync(String serviceName, String deploymentName, String dnsServerName);
    
    /**
    * Updates a definition for an existing DNS server. Updates to address is
    * the only change allowed. DNS server name cannot be changed
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @param parameters Required. Parameters supplied to the Update DNS Server
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse updateDNSServer(String serviceName, String deploymentName, String dnsServerName, DNSUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException;
    
    /**
    * Updates a definition for an existing DNS server. Updates to address is
    * the only change allowed. DNS server name cannot be changed
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param dnsServerName Required. The name of the dns server.
    * @param parameters Required. Parameters supplied to the Update DNS Server
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> updateDNSServerAsync(String serviceName, String deploymentName, String dnsServerName, DNSUpdateParameters parameters);
}
