/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.LazyCollection;
import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatus;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.core.ServiceOperations;
import com.microsoft.windowsazure.core.pipeline.apache.CustomHttpDelete;
import com.microsoft.windowsazure.core.utils.BOMInputStream;
import com.microsoft.windowsazure.core.utils.Base64;
import com.microsoft.windowsazure.core.utils.XmlUtility;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.AccessControlListRule;
import com.microsoft.windowsazure.management.compute.models.ConfigurationSet;
import com.microsoft.windowsazure.management.compute.models.DataVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.DeploymentChangeConfigurationParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentCreateParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentDeleteRoleInstanceParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentEventListResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetPackageParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentGetResponse;
import com.microsoft.windowsazure.management.compute.models.DeploymentRollbackUpdateOrUpgradeParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentSlot;
import com.microsoft.windowsazure.management.compute.models.DeploymentStatus;
import com.microsoft.windowsazure.management.compute.models.DeploymentSwapParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpdateStatusParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpgradeParameters;
import com.microsoft.windowsazure.management.compute.models.DeploymentUpgradeType;
import com.microsoft.windowsazure.management.compute.models.DeploymentWalkUpgradeDomainParameters;
import com.microsoft.windowsazure.management.compute.models.DnsServer;
import com.microsoft.windowsazure.management.compute.models.DnsSettings;
import com.microsoft.windowsazure.management.compute.models.DomainJoinCredentials;
import com.microsoft.windowsazure.management.compute.models.DomainJoinProvisioning;
import com.microsoft.windowsazure.management.compute.models.DomainJoinSettings;
import com.microsoft.windowsazure.management.compute.models.EndpointAcl;
import com.microsoft.windowsazure.management.compute.models.ExtensionConfiguration;
import com.microsoft.windowsazure.management.compute.models.FrontendIPConfiguration;
import com.microsoft.windowsazure.management.compute.models.GuestAgentFormattedMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentMessage;
import com.microsoft.windowsazure.management.compute.models.GuestAgentStatus;
import com.microsoft.windowsazure.management.compute.models.IPConfiguration;
import com.microsoft.windowsazure.management.compute.models.IPConfigurationInstance;
import com.microsoft.windowsazure.management.compute.models.InputEndpoint;
import com.microsoft.windowsazure.management.compute.models.InstanceEndpoint;
import com.microsoft.windowsazure.management.compute.models.LoadBalancer;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbe;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerProbeTransportProtocol;
import com.microsoft.windowsazure.management.compute.models.NetworkInterface;
import com.microsoft.windowsazure.management.compute.models.NetworkInterfaceInstance;
import com.microsoft.windowsazure.management.compute.models.OSVirtualHardDisk;
import com.microsoft.windowsazure.management.compute.models.PersistentVMDowntime;
import com.microsoft.windowsazure.management.compute.models.RebootEvent;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionConfigurationStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionParameterValue;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionReference;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionStatus;
import com.microsoft.windowsazure.management.compute.models.ResourceExtensionSubStatus;
import com.microsoft.windowsazure.management.compute.models.Role;
import com.microsoft.windowsazure.management.compute.models.RoleInstance;
import com.microsoft.windowsazure.management.compute.models.RoleInstancePowerState;
import com.microsoft.windowsazure.management.compute.models.SshSettingKeyPair;
import com.microsoft.windowsazure.management.compute.models.SshSettingPublicKey;
import com.microsoft.windowsazure.management.compute.models.SshSettings;
import com.microsoft.windowsazure.management.compute.models.StoredCertificateSettings;
import com.microsoft.windowsazure.management.compute.models.UpgradeDomainState;
import com.microsoft.windowsazure.management.compute.models.UpgradeStatus;
import com.microsoft.windowsazure.management.compute.models.VirtualIPAddress;
import com.microsoft.windowsazure.management.compute.models.VirtualMachineWindowsRemoteManagementListenerType;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementListener;
import com.microsoft.windowsazure.management.compute.models.WindowsRemoteManagementSettings;
import com.microsoft.windowsazure.tracing.ClientRequestTrackingHandler;
import com.microsoft.windowsazure.tracing.CloudTracing;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

/**
* The Service Management API includes operations for managing the deployments
* in your subscription.  (see
* http://msdn.microsoft.com/en-us/library/windowsazure/ee460812.aspx for more
* information)
*/
public class DeploymentOperationsImpl implements ServiceOperations<ComputeManagementClientImpl>, DeploymentOperations {
    /**
    * Initializes a new instance of the DeploymentOperationsImpl class.
    *
    * @param client Reference to the service client.
    */
    DeploymentOperationsImpl(ComputeManagementClientImpl client) {
        this.client = client;
    }
    
    private ComputeManagementClientImpl client;
    
    /**
    * Gets a reference to the
    * microsoft.windowsazure.management.compute.ComputeManagementClientImpl.
    * @return The Client value.
    */
    public ComputeManagementClientImpl getClient() {
        return this.client;
    }
    
    /**
    * The Begin Changing Deployment Configuration By Name operation initiates a
    * change to the deployment configuration. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentName Required. The deployment to change configuration
    * for.
    * @param parameters Required. Parameters supplied to the Begin Changing
    * Configuration Deployment By Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginChangingConfigurationByNameAsync(final String serviceName, final String deploymentName, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginChangingConfigurationByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Begin Changing Deployment Configuration By Name operation initiates a
    * change to the deployment configuration. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentName Required. The deployment to change configuration
    * for.
    * @param parameters Required. Parameters supplied to the Begin Changing
    * Configuration Deployment By Name operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginChangingConfigurationByName(String serviceName, String deploymentName, DeploymentChangeConfigurationParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                    }
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() == null) {
                                throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                            }
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                    }
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginChangingConfigurationByNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/" + "?" + "comp=config";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element changeConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ChangeConfiguration");
        requestDoc.appendChild(changeConfigurationElement);
        
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getConfiguration().getBytes())));
        changeConfigurationElement.appendChild(configurationElement);
        
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            changeConfigurationElement.appendChild(treatWarningsAsErrorElement);
        }
        
        if (parameters.getMode() != null) {
            Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
            modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
            changeConfigurationElement.appendChild(modeElement);
        }
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                changeConfigurationElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            changeConfigurationElement.appendChild(extensionConfigurationElement);
            
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                if (parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getAllRoles()).isInitialized()) {
                    Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                    for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        allRolesSequenceElement.appendChild(extensionElement);
                        
                        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                        extensionElement.appendChild(idElement);
                    }
                    extensionConfigurationElement.appendChild(allRolesSequenceElement);
                }
            }
            
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                if (parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getNamedRoles()).isInitialized()) {
                    Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                        Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                        namedRolesSequenceElement.appendChild(roleElement);
                        
                        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                        roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                        roleElement.appendChild(roleNameElement);
                        
                        if (namedRolesItem.getExtensions() instanceof LazyCollection == false || ((LazyCollection) namedRolesItem.getExtensions()).isInitialized()) {
                            Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                            for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                                Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                                extensionsSequenceElement.appendChild(extensionElement2);
                                
                                Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                                idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                                extensionElement2.appendChild(idElement2);
                            }
                            roleElement.appendChild(extensionsSequenceElement);
                        }
                    }
                    extensionConfigurationElement.appendChild(namedRolesSequenceElement);
                }
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Changing Deployment Configuration By Slot operation initiates a
    * change to the deployment configuration. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentSlot Required. The slot to change deployment
    * configuration for.
    * @param parameters Required. Parameters supplied to the Begin Changing
    * Configuration Deployment By Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginChangingConfigurationBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginChangingConfigurationBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Begin Changing Deployment Configuration By Slot operation initiates a
    * change to the deployment configuration. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentSlot Required. The slot to change deployment
    * configuration for.
    * @param parameters Required. Parameters supplied to the Begin Changing
    * Configuration Deployment By Slot operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginChangingConfigurationBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentChangeConfigurationParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                    }
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() == null) {
                                throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                            }
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                    }
                }
            }
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginChangingConfigurationBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/" + "?" + "comp=config";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element changeConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ChangeConfiguration");
        requestDoc.appendChild(changeConfigurationElement);
        
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getConfiguration().getBytes())));
        changeConfigurationElement.appendChild(configurationElement);
        
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            changeConfigurationElement.appendChild(treatWarningsAsErrorElement);
        }
        
        if (parameters.getMode() != null) {
            Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
            modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
            changeConfigurationElement.appendChild(modeElement);
        }
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                changeConfigurationElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            changeConfigurationElement.appendChild(extensionConfigurationElement);
            
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                if (parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getAllRoles()).isInitialized()) {
                    Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                    for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        allRolesSequenceElement.appendChild(extensionElement);
                        
                        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                        extensionElement.appendChild(idElement);
                    }
                    extensionConfigurationElement.appendChild(allRolesSequenceElement);
                }
            }
            
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                if (parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getNamedRoles()).isInitialized()) {
                    Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                        Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                        namedRolesSequenceElement.appendChild(roleElement);
                        
                        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                        roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                        roleElement.appendChild(roleNameElement);
                        
                        if (namedRolesItem.getExtensions() instanceof LazyCollection == false || ((LazyCollection) namedRolesItem.getExtensions()).isInitialized()) {
                            Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                            for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                                Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                                extensionsSequenceElement.appendChild(extensionElement2);
                                
                                Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                                idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                                extensionElement2.appendChild(idElement2);
                            }
                            roleElement.appendChild(extensionsSequenceElement);
                        }
                    }
                    extensionConfigurationElement.appendChild(namedRolesSequenceElement);
                }
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Creating Deployment operation uploads a new service package and
    * creates a new deployment in the staging or production environments. This
    * operation is an asynchronous operation. To determine whether the
    * management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460813.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to create a deployment for.
    * @param deploymentSlot Required. The slot to create a deployment for.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Deployment operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginCreatingAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginCreating(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Begin Creating Deployment operation uploads a new service package and
    * creates a new deployment in the staging or production environments. This
    * operation is an asynchronous operation. To determine whether the
    * management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460813.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to create a deployment for.
    * @param deploymentSlot Required. The slot to create a deployment for.
    * @param parameters Required. Parameters supplied to the Begin Creating
    * Deployment operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginCreating(String serviceName, DeploymentSlot deploymentSlot, DeploymentCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                    }
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() == null) {
                                throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                            }
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                    }
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getName() == null) {
            throw new NullPointerException("parameters.Name");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginCreatingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot;
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element createDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "CreateDeployment");
        requestDoc.appendChild(createDeploymentElement);
        
        Element nameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
        nameElement.appendChild(requestDoc.createTextNode(parameters.getName()));
        createDeploymentElement.appendChild(nameElement);
        
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        createDeploymentElement.appendChild(packageUrlElement);
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getLabel().getBytes())));
        createDeploymentElement.appendChild(labelElement);
        
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getConfiguration().getBytes())));
        createDeploymentElement.appendChild(configurationElement);
        
        if (parameters.isStartDeployment() != null) {
            Element startDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "StartDeployment");
            startDeploymentElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isStartDeployment()).toLowerCase()));
            createDeploymentElement.appendChild(startDeploymentElement);
        }
        
        if (parameters.isTreatWarningsAsError() != null) {
            Element treatWarningsAsErrorElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "TreatWarningsAsError");
            treatWarningsAsErrorElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isTreatWarningsAsError()).toLowerCase()));
            createDeploymentElement.appendChild(treatWarningsAsErrorElement);
        }
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                createDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            createDeploymentElement.appendChild(extensionConfigurationElement);
            
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                if (parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getAllRoles()).isInitialized()) {
                    Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                    for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        allRolesSequenceElement.appendChild(extensionElement);
                        
                        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                        extensionElement.appendChild(idElement);
                    }
                    extensionConfigurationElement.appendChild(allRolesSequenceElement);
                }
            }
            
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                if (parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getNamedRoles()).isInitialized()) {
                    Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                        Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                        namedRolesSequenceElement.appendChild(roleElement);
                        
                        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                        roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                        roleElement.appendChild(roleNameElement);
                        
                        if (namedRolesItem.getExtensions() instanceof LazyCollection == false || ((LazyCollection) namedRolesItem.getExtensions()).isInitialized()) {
                            Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                            for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                                Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                                extensionsSequenceElement.appendChild(extensionElement2);
                                
                                Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                                idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                                extensionElement2.appendChild(idElement2);
                            }
                            roleElement.appendChild(extensionsSequenceElement);
                        }
                    }
                    extensionConfigurationElement.appendChild(namedRolesSequenceElement);
                }
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Deleting Deployment By Name operation deletes the specified
    * deployment. This operation is an asynchronous operation. To determine
    * whether the Management service has finished processing the request, call
    * Get Operation Status. For more information on asynchronous operations,
    * see Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingByNameAsync(final String serviceName, final String deploymentName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeletingByName(serviceName, deploymentName, deleteFromStorage);
            }
         });
    }
    
    /**
    * The Begin Deleting Deployment By Name operation deletes the specified
    * deployment. This operation is an asynchronous operation. To determine
    * whether the Management service has finished processing the request, call
    * Get Operation Status. For more information on asynchronous operations,
    * see Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeletingByName(String serviceName, String deploymentName, boolean deleteFromStorage) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter(invocationId, this, "beginDeletingByNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "?";
        if (deleteFromStorage == true) {
            url = url + "comp=" + "media";
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Deleting Deployment By Slot operation deletes the specified
    * deployment. This operation is an asynchronous operation. To determine
    * whether the Management service has finished processing the request, call
    * Get Operation Status. For more information on asynchronous operations,
    * see Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeletingBySlot(serviceName, deploymentSlot);
            }
         });
    }
    
    /**
    * The Begin Deleting Deployment By Slot operation deletes the specified
    * deployment. This operation is an asynchronous operation. To determine
    * whether the Management service has finished processing the request, call
    * Get Operation Status. For more information on asynchronous operations,
    * see Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeletingBySlot(String serviceName, DeploymentSlot deploymentSlot) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            CloudTracing.enter(invocationId, this, "beginDeletingBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot;
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        CustomHttpDelete httpRequest = new CustomHttpDelete(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The name of the deployment slot.
    * @param parameters Required. The parameters to delete the role.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingRoleInstanceByBeploymentSlotAsync(final String serviceName, final String deploymentSlot, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeletingRoleInstanceByBeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The name of the deployment slot.
    * @param parameters Required. The parameters to delete the role.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeletingRoleInstanceByBeploymentSlot(String serviceName, String deploymentSlot, DeploymentDeleteRoleInstanceParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginDeletingRoleInstanceByBeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot.trim() + "/roleinstances/" + "?" + "comp=delete";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        if (parameters.getName() != null) {
            if (parameters.getName() instanceof LazyCollection == false || ((LazyCollection) parameters.getName()).isInitialized()) {
                Element roleInstancesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleInstances");
                for (String roleInstancesItem : parameters.getName()) {
                    Element roleInstancesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    roleInstancesItemElement.appendChild(requestDoc.createTextNode(roleInstancesItem));
                    roleInstancesSequenceElement.appendChild(roleInstancesItemElement);
                }
                requestDoc.appendChild(roleInstancesSequenceElement);
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. The parameters to delete the role.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginDeletingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginDeletingRoleInstanceByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. The parameters to delete the role.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginDeletingRoleInstanceByDeploymentName(String serviceName, String deploymentName, DeploymentDeleteRoleInstanceParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginDeletingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roleinstances/" + "?" + "comp=delete";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        if (parameters.getName() != null) {
            if (parameters.getName() instanceof LazyCollection == false || ((LazyCollection) parameters.getName()).isInitialized()) {
                Element roleInstancesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleInstances");
                for (String roleInstancesItem : parameters.getName()) {
                    Element roleInstancesItemElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    roleInstancesItemElement.appendChild(requestDoc.createTextNode(roleInstancesItem));
                    roleInstancesSequenceElement.appendChild(roleInstancesItemElement);
                }
                requestDoc.appendChild(roleInstancesSequenceElement);
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Package By Name operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginGettingPackageByNameAsync(final String serviceName, final String deploymentName, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginGettingPackageByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Get Package By Name operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Name operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginGettingPackageByName(String serviceName, String deploymentName, DeploymentGetPackageParameters parameters) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getContainerUri() == null) {
            throw new NullPointerException("parameters.ContainerUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginGettingPackageByNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/package" + "?";
        url = url + "containerUri=" + URLEncoder.encode(parameters.getContainerUri().toString(), "UTF-8") + " +";
        if (parameters.isOverwriteExisting() != null) {
            url = url + "&" + "overwriteExisting=" + URLEncoder.encode(Boolean.toString(parameters.isOverwriteExisting()).toLowerCase(), "UTF-8");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Package By Slot operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginGettingPackageBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginGettingPackageBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Get Package By Slot operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Slot operation.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginGettingPackageBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentGetPackageParameters parameters) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getContainerUri() == null) {
            throw new NullPointerException("parameters.ContainerUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginGettingPackageBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/package" + "?";
        url = url + "containerUri=" + URLEncoder.encode(parameters.getContainerUri().toString(), "UTF-8") + " +";
        if (parameters.isOverwriteExisting() != null) {
            url = url + "&" + "overwriteExisting=" + URLEncoder.encode(Boolean.toString(parameters.isOverwriteExisting()).toLowerCase(), "UTF-8");
        }
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Rebooting Role Instance By Deployment Name operation requests a
    * reboot of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginRebootingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginRebootingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
         });
    }
    
    /**
    * The Begin Rebooting Role Instance By Deployment Name operation requests a
    * reboot of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginRebootingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "beginRebootingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roleinstances/" + roleInstanceName.trim() + "?" + "comp=reboot";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Rebooting Role Instance By Deployment Slot operation requests a
    * reboot of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginRebootingRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginRebootingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
         });
    }
    
    /**
    * The Begin Rebooting Role Instance By Deployment Slot operation requests a
    * reboot of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginRebootingRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "beginRebootingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/roleinstances/" + roleInstanceName.trim() + "?" + "comp=reboot";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginRebuildingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginRebuildingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName, resources);
            }
         });
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginRebuildingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName, String resources) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter(invocationId, this, "beginRebuildingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roleinstances/" + roleInstanceName.trim() + "?";
        url = url + "comp=rebuild";
        url = url + "&" + "resources=" + URLEncoder.encode(resources.trim(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginRebuildingRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginRebuildingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName, resources);
            }
         });
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginRebuildingRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, String roleInstanceName, String resources) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentSlot == null) {
            throw new NullPointerException("deploymentSlot");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        if (resources == null) {
            throw new NullPointerException("resources");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter(invocationId, this, "beginRebuildingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot.trim() + "/roleinstances/" + roleInstanceName.trim() + "?";
        url = url + "comp=rebuild";
        url = url + "&" + "resources=" + URLEncoder.encode(resources.trim(), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Reimaging Role Instance By Deployment Name operation requests a
    * reimage of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginReimagingRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginReimagingRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
         });
    }
    
    /**
    * The Begin Reimaging Role Instance By Deployment Name operation requests a
    * reimage of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginReimagingRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "beginReimagingRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/roleinstances/" + roleInstanceName.trim() + "?" + "comp=reimage";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Reimaging Role Instance By Deployment Slot operation requests a
    * reimage of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginReimagingRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginReimagingRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
         });
    }
    
    /**
    * The Begin Reimaging Role Instance By Deployment Slot operation requests a
    * reimage of a role instance that is running in a deployment. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginReimagingRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (roleInstanceName == null) {
            throw new NullPointerException("roleInstanceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "beginReimagingRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/roleinstances/" + roleInstanceName.trim() + "?" + "comp=reimage";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Swapping Deployment operation initiates a virtual IP address
    * swap between the staging and production deployment environments for a
    * service. If the service is currently running in the staging environment,
    * it will be swapped to the production environment. If it is running in
    * the production environment, it will be swapped to staging. For more
    * information on this type of upgrade, see Performing Virtual IP Swap
    * Upgrades at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee517253.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460814.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param parameters Required. Parameters supplied to the Begin Swapping
    * Deployment operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginSwappingAsync(final String serviceName, final DeploymentSwapParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginSwapping(serviceName, parameters);
            }
         });
    }
    
    /**
    * The Begin Swapping Deployment operation initiates a virtual IP address
    * swap between the staging and production deployment environments for a
    * service. If the service is currently running in the staging environment,
    * it will be swapped to the production environment. If it is running in
    * the production environment, it will be swapped to staging. For more
    * information on this type of upgrade, see Performing Virtual IP Swap
    * Upgrades at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee517253.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460814.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param parameters Required. Parameters supplied to the Begin Swapping
    * Deployment operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginSwapping(String serviceName, DeploymentSwapParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getSourceDeployment() == null) {
            throw new NullPointerException("parameters.SourceDeployment");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginSwappingAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element swapElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Swap");
        requestDoc.appendChild(swapElement);
        
        if (parameters.getProductionDeployment() != null) {
            Element productionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Production");
            productionElement.appendChild(requestDoc.createTextNode(parameters.getProductionDeployment()));
            swapElement.appendChild(productionElement);
        }
        
        Element sourceDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "SourceDeployment");
        sourceDeploymentElement.appendChild(requestDoc.createTextNode(parameters.getSourceDeployment()));
        swapElement.appendChild(sourceDeploymentElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Updating Deployment Status By Deployment Name operation
    * initiates a change in the running status of a deployment. The status of
    * a deployment can be running or suspended. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Deployment Status By Deployment Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginUpdatingStatusByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginUpdatingStatusByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Begin Updating Deployment Status By Deployment Name operation
    * initiates a change in the running status of a deployment. The status of
    * a deployment can be running or suspended. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Deployment Status By Deployment Name operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginUpdatingStatusByDeploymentName(String serviceName, String deploymentName, DeploymentUpdateStatusParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginUpdatingStatusByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/" + "?" + "comp=status";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element updateDeploymentStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateDeploymentStatus");
        requestDoc.appendChild(updateDeploymentStatusElement);
        
        Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Status");
        statusElement.appendChild(requestDoc.createTextNode(parameters.getStatus().toString()));
        updateDeploymentStatusElement.appendChild(statusElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Updating Deployment Status By Deployment Slot operation
    * initiates a change in the running status of a deployment. The status of
    * a deployment can be running or suspended. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Deployment Status By Deployment Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginUpdatingStatusByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginUpdatingStatusByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Begin Updating Deployment Status By Deployment Slot operation
    * initiates a change in the running status of a deployment. The status of
    * a deployment can be running or suspended. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Begin Updating
    * Deployment Status By Deployment Slot operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginUpdatingStatusByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpdateStatusParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginUpdatingStatusByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/" + "?" + "comp=status";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element updateDeploymentStatusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpdateDeploymentStatus");
        requestDoc.appendChild(updateDeploymentStatusElement);
        
        Element statusElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Status");
        statusElement.appendChild(requestDoc.createTextNode(parameters.getStatus().toString()));
        updateDeploymentStatusElement.appendChild(statusElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Upgrading Deployment By Name operation initiates an update of
    * role instances in a deployment using the package and configuration that
    * you specify. For more information about updating role instances, see
    * Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentName Required. The deployment to upgrade.
    * @param parameters Required. Parameters supplied to the Begin Upgrading
    * Deployment By Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginUpgradingByNameAsync(final String serviceName, final String deploymentName, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginUpgradingByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Begin Upgrading Deployment By Name operation initiates an update of
    * role instances in a deployment using the package and configuration that
    * you specify. For more information about updating role instances, see
    * Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentName Required. The deployment to upgrade.
    * @param parameters Required. Parameters supplied to the Begin Upgrading
    * Deployment By Name operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginUpgradingByName(String serviceName, String deploymentName, DeploymentUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                    }
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() == null) {
                                throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                            }
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                    }
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginUpgradingByNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/" + "?" + "comp=upgrade";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element upgradeDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDeployment");
        requestDoc.appendChild(upgradeDeploymentElement);
        
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        upgradeDeploymentElement.appendChild(modeElement);
        
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        upgradeDeploymentElement.appendChild(packageUrlElement);
        
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getConfiguration().getBytes())));
        upgradeDeploymentElement.appendChild(configurationElement);
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getLabel().getBytes())));
        upgradeDeploymentElement.appendChild(labelElement);
        
        if (parameters.getRoleToUpgrade() != null) {
            Element roleToUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleToUpgrade");
            roleToUpgradeElement.appendChild(requestDoc.createTextNode(parameters.getRoleToUpgrade()));
            upgradeDeploymentElement.appendChild(roleToUpgradeElement);
        }
        
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        upgradeDeploymentElement.appendChild(forceElement);
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                upgradeDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            upgradeDeploymentElement.appendChild(extensionConfigurationElement);
            
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                if (parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getAllRoles()).isInitialized()) {
                    Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                    for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        allRolesSequenceElement.appendChild(extensionElement);
                        
                        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                        extensionElement.appendChild(idElement);
                    }
                    extensionConfigurationElement.appendChild(allRolesSequenceElement);
                }
            }
            
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                if (parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getNamedRoles()).isInitialized()) {
                    Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                        Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                        namedRolesSequenceElement.appendChild(roleElement);
                        
                        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                        roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                        roleElement.appendChild(roleNameElement);
                        
                        if (namedRolesItem.getExtensions() instanceof LazyCollection == false || ((LazyCollection) namedRolesItem.getExtensions()).isInitialized()) {
                            Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                            for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                                Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                                extensionsSequenceElement.appendChild(extensionElement2);
                                
                                Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                                idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                                extensionElement2.appendChild(idElement2);
                            }
                            roleElement.appendChild(extensionsSequenceElement);
                        }
                    }
                    extensionConfigurationElement.appendChild(namedRolesSequenceElement);
                }
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Upgrading Deployment By Slot operation initiates an update of
    * role instances in a deployment using the package and configuration that
    * you specify. For more information about updating role instances, see
    * Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentSlot Required. The slot to upgrade.
    * @param parameters Required. Parameters supplied to the Begin Upgrading
    * Deployment By Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginUpgradingBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginUpgradingBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Begin Upgrading Deployment By Slot operation initiates an update of
    * role instances in a deployment using the package and configuration that
    * you specify. For more information about updating role instances, see
    * Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentSlot Required. The slot to upgrade.
    * @param parameters Required. Parameters supplied to the Begin Upgrading
    * Deployment By Slot operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginUpgradingBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        if (parameters.getConfiguration() == null) {
            throw new NullPointerException("parameters.Configuration");
        }
        if (parameters.getExtensionConfiguration() != null) {
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                for (ExtensionConfiguration.Extension allRolesParameterItem : parameters.getExtensionConfiguration().getAllRoles()) {
                    if (allRolesParameterItem.getId() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.AllRoles.Id");
                    }
                }
            }
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                for (ExtensionConfiguration.NamedRole namedRolesParameterItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                    if (namedRolesParameterItem.getExtensions() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions");
                    }
                    if (namedRolesParameterItem.getExtensions() != null) {
                        for (ExtensionConfiguration.Extension extensionsParameterItem : namedRolesParameterItem.getExtensions()) {
                            if (extensionsParameterItem.getId() == null) {
                                throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.Extensions.Id");
                            }
                        }
                    }
                    if (namedRolesParameterItem.getRoleName() == null) {
                        throw new NullPointerException("parameters.ExtensionConfiguration.NamedRoles.RoleName");
                    }
                }
            }
        }
        if (parameters.getLabel() == null) {
            throw new NullPointerException("parameters.Label");
        }
        if (parameters.getLabel().length() > 100) {
            throw new IllegalArgumentException("parameters.Label");
        }
        if (parameters.getPackageUri() == null) {
            throw new NullPointerException("parameters.PackageUri");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginUpgradingBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/" + "?" + "comp=upgrade";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element upgradeDeploymentElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDeployment");
        requestDoc.appendChild(upgradeDeploymentElement);
        
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        upgradeDeploymentElement.appendChild(modeElement);
        
        Element packageUrlElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "PackageUrl");
        packageUrlElement.appendChild(requestDoc.createTextNode(parameters.getPackageUri().toString()));
        upgradeDeploymentElement.appendChild(packageUrlElement);
        
        Element configurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Configuration");
        configurationElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getConfiguration().getBytes())));
        upgradeDeploymentElement.appendChild(configurationElement);
        
        Element labelElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Label");
        labelElement.appendChild(requestDoc.createTextNode(Base64.encode(parameters.getLabel().getBytes())));
        upgradeDeploymentElement.appendChild(labelElement);
        
        if (parameters.getRoleToUpgrade() != null) {
            Element roleToUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleToUpgrade");
            roleToUpgradeElement.appendChild(requestDoc.createTextNode(parameters.getRoleToUpgrade()));
            upgradeDeploymentElement.appendChild(roleToUpgradeElement);
        }
        
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        upgradeDeploymentElement.appendChild(forceElement);
        
        if (parameters.getExtendedProperties() != null) {
            if (parameters.getExtendedProperties() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtendedProperties()).isInitialized()) {
                Element extendedPropertiesDictionaryElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                for (Map.Entry<String, String> entry : parameters.getExtendedProperties().entrySet()) {
                    String extendedPropertiesKey = entry.getKey();
                    String extendedPropertiesValue = entry.getValue();
                    Element extendedPropertiesElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtendedProperty");
                    extendedPropertiesDictionaryElement.appendChild(extendedPropertiesElement);
                    
                    Element extendedPropertiesKeyElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Name");
                    extendedPropertiesKeyElement.appendChild(requestDoc.createTextNode(extendedPropertiesKey));
                    extendedPropertiesElement.appendChild(extendedPropertiesKeyElement);
                    
                    Element extendedPropertiesValueElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Value");
                    extendedPropertiesValueElement.appendChild(requestDoc.createTextNode(extendedPropertiesValue));
                    extendedPropertiesElement.appendChild(extendedPropertiesValueElement);
                }
                upgradeDeploymentElement.appendChild(extendedPropertiesDictionaryElement);
            }
        }
        
        if (parameters.getExtensionConfiguration() != null) {
            Element extensionConfigurationElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
            upgradeDeploymentElement.appendChild(extensionConfigurationElement);
            
            if (parameters.getExtensionConfiguration().getAllRoles() != null) {
                if (parameters.getExtensionConfiguration().getAllRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getAllRoles()).isInitialized()) {
                    Element allRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "AllRoles");
                    for (ExtensionConfiguration.Extension allRolesItem : parameters.getExtensionConfiguration().getAllRoles()) {
                        Element extensionElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                        allRolesSequenceElement.appendChild(extensionElement);
                        
                        Element idElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                        idElement.appendChild(requestDoc.createTextNode(allRolesItem.getId()));
                        extensionElement.appendChild(idElement);
                    }
                    extensionConfigurationElement.appendChild(allRolesSequenceElement);
                }
            }
            
            if (parameters.getExtensionConfiguration().getNamedRoles() != null) {
                if (parameters.getExtensionConfiguration().getNamedRoles() instanceof LazyCollection == false || ((LazyCollection) parameters.getExtensionConfiguration().getNamedRoles()).isInitialized()) {
                    Element namedRolesSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    for (ExtensionConfiguration.NamedRole namedRolesItem : parameters.getExtensionConfiguration().getNamedRoles()) {
                        Element roleElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Role");
                        namedRolesSequenceElement.appendChild(roleElement);
                        
                        Element roleNameElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RoleName");
                        roleNameElement.appendChild(requestDoc.createTextNode(namedRolesItem.getRoleName()));
                        roleElement.appendChild(roleNameElement);
                        
                        if (namedRolesItem.getExtensions() instanceof LazyCollection == false || ((LazyCollection) namedRolesItem.getExtensions()).isInitialized()) {
                            Element extensionsSequenceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extensions");
                            for (ExtensionConfiguration.Extension extensionsItem : namedRolesItem.getExtensions()) {
                                Element extensionElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Extension");
                                extensionsSequenceElement.appendChild(extensionElement2);
                                
                                Element idElement2 = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Id");
                                idElement2.appendChild(requestDoc.createTextNode(extensionsItem.getId()));
                                extensionElement2.appendChild(idElement2);
                            }
                            roleElement.appendChild(extensionsSequenceElement);
                        }
                    }
                    extensionConfigurationElement.appendChild(namedRolesSequenceElement);
                }
            }
        }
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Walking Upgrade Domain By Deployment Name operation specifies
    * an update domain in which a role instance must be updated. For more
    * information about updating role instances, see Update an Azure Service
    * at http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Walking
    * Upgrade Domain By Deployment Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginWalkingUpgradeDomainByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginWalkingUpgradeDomainByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Begin Walking Upgrade Domain By Deployment Name operation specifies
    * an update domain in which a role instance must be updated. For more
    * information about updating role instances, see Update an Azure Service
    * at http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Begin Walking
    * Upgrade Domain By Deployment Name operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginWalkingUpgradeDomainByDeploymentName(String serviceName, String deploymentName, DeploymentWalkUpgradeDomainParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginWalkingUpgradeDomainByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "?" + "comp=walkupgradedomain";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element walkUpgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WalkUpgradeDomain");
        requestDoc.appendChild(walkUpgradeDomainElement);
        
        Element upgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDomain");
        upgradeDomainElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getUpgradeDomain())));
        walkUpgradeDomainElement.appendChild(upgradeDomainElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Begin Walking Upgrade Domain By Deployment Slot operation specifies
    * an update domain in which a role instance must be updated. For more
    * information about updating role instances, see Update an Azure Service
    * at http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Begin Walking
    * Upgrade Domain By Deployment Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> beginWalkingUpgradeDomainByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return beginWalkingUpgradeDomainByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Begin Walking Upgrade Domain By Deployment Slot operation specifies
    * an update domain in which a role instance must be updated. For more
    * information about updating role instances, see Update an Azure Service
    * at http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Begin Walking
    * Upgrade Domain By Deployment Slot operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse beginWalkingUpgradeDomainByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentWalkUpgradeDomainParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "beginWalkingUpgradeDomainByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/" + "?" + "comp=walkupgradedomain";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element walkUpgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "WalkUpgradeDomain");
        requestDoc.appendChild(walkUpgradeDomainElement);
        
        Element upgradeDomainElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "UpgradeDomain");
        upgradeDomainElement.appendChild(requestDoc.createTextNode(Integer.toString(parameters.getUpgradeDomain())));
        walkUpgradeDomainElement.appendChild(upgradeDomainElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Change Deployment Configuration By Name operation initiates a change
    * to the deployment configuration. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentName Required. The deployment to change configuration
    * for.
    * @param parameters Required. Parameters supplied to the Change
    * ConfigurationDeployment By Name operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> changeConfigurationByNameAsync(final String serviceName, final String deploymentName, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return changeConfigurationByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Change Deployment Configuration By Name operation initiates a change
    * to the deployment configuration. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentName Required. The deployment to change configuration
    * for.
    * @param parameters Required. Parameters supplied to the Change
    * ConfigurationDeployment By Name operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse changeConfigurationByName(String serviceName, String deploymentName, DeploymentChangeConfigurationParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "changeConfigurationByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginChangingConfigurationByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Change Deployment Configuration By Slot operation initiates a change
    * to the deployment configuration. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentSlot Required. The slot to change deployment
    * configuration for.
    * @param parameters Required. Parameters supplied to the Change
    * Configuration Deployment By Slot operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> changeConfigurationBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentChangeConfigurationParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return changeConfigurationBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Change Deployment Configuration By Slot operation initiates a change
    * to the deployment configuration. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460809.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to change deployment
    * configuration for.
    * @param deploymentSlot Required. The slot to change deployment
    * configuration for.
    * @param parameters Required. Parameters supplied to the Change
    * Configuration Deployment By Slot operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse changeConfigurationBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentChangeConfigurationParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "changeConfigurationBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginChangingConfigurationBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Create Deployment operation uploads a new service package and creates
    * a new deployment in the staging or production environments. This
    * operation is an asynchronous operation. To determine whether the
    * management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460813.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to create a deployment for.
    * @param deploymentSlot Required. The slot to create a deployment for.
    * @param parameters Required. Parameters supplied to the Create Deployment
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> createAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentCreateParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return create(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Create Deployment operation uploads a new service package and creates
    * a new deployment in the staging or production environments. This
    * operation is an asynchronous operation. To determine whether the
    * management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460813.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to create a deployment for.
    * @param deploymentSlot Required. The slot to create a deployment for.
    * @param parameters Required. Parameters supplied to the Create Deployment
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse create(String serviceName, DeploymentSlot deploymentSlot, DeploymentCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "createAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginCreatingAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Deployment By Name operation deletes the specified deployment.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteByNameAsync(final String serviceName, final String deploymentName, final boolean deleteFromStorage) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteByName(serviceName, deploymentName, deleteFromStorage);
            }
         });
    }
    
    /**
    * The Delete Deployment By Name operation deletes the specified deployment.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param deleteFromStorage Required. Specifies that the source blob for the
    * disk should also be deleted from storage.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse deleteByName(String serviceName, String deploymentName, boolean deleteFromStorage) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("deleteFromStorage", deleteFromStorage);
            CloudTracing.enter(invocationId, this, "deleteByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingByNameAsync(serviceName, deploymentName, deleteFromStorage).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Deployment By Slot operation deletes the specified deployment.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteBySlot(serviceName, deploymentSlot);
            }
         });
    }
    
    /**
    * The Delete Deployment By Slot operation deletes the specified deployment.
    * This operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460815.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse deleteBySlot(String serviceName, DeploymentSlot deploymentSlot) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            CloudTracing.enter(invocationId, this, "deleteBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingBySlotAsync(serviceName, deploymentSlot).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleInstanceName Required. The parameters to delete the role.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentDeleteRoleInstanceParameters roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
         });
    }
    
    /**
    * The Delete Role Instances operation deletes a role instance from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param roleInstanceName Required. The parameters to delete the role.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse deleteRoleInstanceByDeploymentName(String serviceName, String deploymentName, DeploymentDeleteRoleInstanceParameters roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "deleteRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Delete Role Instances operation deletes the role instances from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The name of the deployment slot.
    * @param parameters Required. The parameters to delete the role.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> deleteRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final DeploymentDeleteRoleInstanceParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return deleteRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Delete Role Instances operation deletes the role instances from a
    * deployment in a cloud service.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/dn469418.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The name of the deployment slot.
    * @param parameters Required. The parameters to delete the role.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse deleteRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, DeploymentDeleteRoleInstanceParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "deleteRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginDeletingRoleInstanceByBeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get Deployment By Name operation returns configuration information,
    * status, and system properties for a deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460804.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @return A deployment that exists in the cloud service.
    */
    @Override
    public Future<DeploymentGetResponse> getByNameAsync(final String serviceName, final String deploymentName) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResponse>() { 
            @Override
            public DeploymentGetResponse call() throws Exception {
                return getByName(serviceName, deploymentName);
            }
         });
    }
    
    /**
    * The Get Deployment By Name operation returns configuration information,
    * status, and system properties for a deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460804.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A deployment that exists in the cloud service.
    */
    @Override
    public DeploymentGetResponse getByName(String serviceName, String deploymentName) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            CloudTracing.enter(invocationId, this, "getByNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim();
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DeploymentGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element deploymentElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Deployment");
            if (deploymentElement != null) {
                Element nameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Name");
                if (nameElement != null) {
                    String nameInstance;
                    nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                
                Element deploymentSlotElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "DeploymentSlot");
                if (deploymentSlotElement != null) {
                    DeploymentSlot deploymentSlotInstance;
                    deploymentSlotInstance = DeploymentSlot.valueOf(deploymentSlotElement.getTextContent());
                    result.setDeploymentSlot(deploymentSlotInstance);
                }
                
                Element privateIDElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "PrivateID");
                if (privateIDElement != null) {
                    String privateIDInstance;
                    privateIDInstance = privateIDElement.getTextContent();
                    result.setPrivateId(privateIDInstance);
                }
                
                Element statusElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Status");
                if (statusElement != null) {
                    DeploymentStatus statusInstance;
                    statusInstance = DeploymentStatus.valueOf(statusElement.getTextContent());
                    result.setStatus(statusInstance);
                }
                
                Element labelElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Label");
                if (labelElement != null) {
                    String labelInstance;
                    labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode(labelElement.getTextContent())) : null;
                    result.setLabel(labelInstance);
                }
                
                Element urlElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Url");
                if (urlElement != null) {
                    URI urlInstance;
                    urlInstance = new URI(urlElement.getTextContent());
                    result.setUri(urlInstance);
                }
                
                Element configurationElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Configuration");
                if (configurationElement != null) {
                    String configurationInstance;
                    configurationInstance = configurationElement.getTextContent() != null ? new String(Base64.decode(configurationElement.getTextContent())) : null;
                    result.setConfiguration(configurationInstance);
                }
                
                Element roleInstanceListSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RoleInstanceList");
                if (roleInstanceListSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleInstanceListSequenceElement, "http://schemas.microsoft.com/windowsazure", "RoleInstance").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element roleInstanceListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleInstanceListSequenceElement, "http://schemas.microsoft.com/windowsazure", "RoleInstance").get(i1));
                        RoleInstance roleInstanceInstance = new RoleInstance();
                        result.getRoleInstances().add(roleInstanceInstance);
                        
                        Element roleNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement != null) {
                            String roleNameInstance;
                            roleNameInstance = roleNameElement.getTextContent();
                            roleInstanceInstance.setRoleName(roleNameInstance);
                        }
                        
                        Element instanceNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceName");
                        if (instanceNameElement != null) {
                            String instanceNameInstance;
                            instanceNameInstance = instanceNameElement.getTextContent();
                            roleInstanceInstance.setInstanceName(instanceNameInstance);
                        }
                        
                        Element instanceStatusElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceStatus");
                        if (instanceStatusElement != null) {
                            String instanceStatusInstance;
                            instanceStatusInstance = instanceStatusElement.getTextContent();
                            roleInstanceInstance.setInstanceStatus(instanceStatusInstance);
                        }
                        
                        Element instanceUpgradeDomainElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceUpgradeDomain");
                        if (instanceUpgradeDomainElement != null && (instanceUpgradeDomainElement.getTextContent() == null || instanceUpgradeDomainElement.getTextContent().isEmpty() == true) == false) {
                            int instanceUpgradeDomainInstance;
                            instanceUpgradeDomainInstance = DatatypeConverter.parseInt(instanceUpgradeDomainElement.getTextContent());
                            roleInstanceInstance.setInstanceUpgradeDomain(instanceUpgradeDomainInstance);
                        }
                        
                        Element instanceFaultDomainElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceFaultDomain");
                        if (instanceFaultDomainElement != null && (instanceFaultDomainElement.getTextContent() == null || instanceFaultDomainElement.getTextContent().isEmpty() == true) == false) {
                            int instanceFaultDomainInstance;
                            instanceFaultDomainInstance = DatatypeConverter.parseInt(instanceFaultDomainElement.getTextContent());
                            roleInstanceInstance.setInstanceFaultDomain(instanceFaultDomainInstance);
                        }
                        
                        Element instanceSizeElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceSize");
                        if (instanceSizeElement != null) {
                            String instanceSizeInstance;
                            instanceSizeInstance = instanceSizeElement.getTextContent();
                            roleInstanceInstance.setInstanceSize(instanceSizeInstance);
                        }
                        
                        Element instanceStateDetailsElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceStateDetails");
                        if (instanceStateDetailsElement != null) {
                            String instanceStateDetailsInstance;
                            instanceStateDetailsInstance = instanceStateDetailsElement.getTextContent();
                            roleInstanceInstance.setInstanceStateDetails(instanceStateDetailsInstance);
                        }
                        
                        Element instanceErrorCodeElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceErrorCode");
                        if (instanceErrorCodeElement != null) {
                            String instanceErrorCodeInstance;
                            instanceErrorCodeInstance = instanceErrorCodeElement.getTextContent();
                            roleInstanceInstance.setInstanceErrorCode(instanceErrorCodeInstance);
                        }
                        
                        Element ipAddressElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "IpAddress");
                        if (ipAddressElement != null) {
                            InetAddress ipAddressInstance;
                            ipAddressInstance = InetAddress.getByName(ipAddressElement.getTextContent());
                            roleInstanceInstance.setIPAddress(ipAddressInstance);
                        }
                        
                        Element instanceEndpointsSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoints");
                        if (instanceEndpointsSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(instanceEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoint").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element instanceEndpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(instanceEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoint").get(i2));
                                InstanceEndpoint instanceEndpointInstance = new InstanceEndpoint();
                                roleInstanceInstance.getInstanceEndpoints().add(instanceEndpointInstance);
                                
                                Element localPortElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LocalPort");
                                if (localPortElement != null && (localPortElement.getTextContent() == null || localPortElement.getTextContent().isEmpty() == true) == false) {
                                    int localPortInstance;
                                    localPortInstance = DatatypeConverter.parseInt(localPortElement.getTextContent());
                                    instanceEndpointInstance.setLocalPort(localPortInstance);
                                }
                                
                                Element nameElement2 = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement2 != null) {
                                    String nameInstance2;
                                    nameInstance2 = nameElement2.getTextContent();
                                    instanceEndpointInstance.setName(nameInstance2);
                                }
                                
                                Element publicPortElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "PublicPort");
                                if (publicPortElement != null) {
                                    int publicPortInstance;
                                    publicPortInstance = DatatypeConverter.parseInt(publicPortElement.getTextContent());
                                    instanceEndpointInstance.setPort(publicPortInstance);
                                }
                                
                                Element protocolElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                if (protocolElement != null) {
                                    String protocolInstance;
                                    protocolInstance = protocolElement.getTextContent();
                                    instanceEndpointInstance.setProtocol(protocolInstance);
                                }
                                
                                Element vipElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Vip");
                                if (vipElement != null) {
                                    InetAddress vipInstance;
                                    vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                    instanceEndpointInstance.setVirtualIPAddress(vipInstance);
                                }
                                
                                Element idleTimeoutInMinutesElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                if (idleTimeoutInMinutesElement != null && (idleTimeoutInMinutesElement.getTextContent() == null || idleTimeoutInMinutesElement.getTextContent().isEmpty() == true) == false) {
                                    int idleTimeoutInMinutesInstance;
                                    idleTimeoutInMinutesInstance = DatatypeConverter.parseInt(idleTimeoutInMinutesElement.getTextContent());
                                    instanceEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                            }
                        }
                        
                        Element guestAgentStatusElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "GuestAgentStatus");
                        if (guestAgentStatusElement != null) {
                            GuestAgentStatus guestAgentStatusInstance = new GuestAgentStatus();
                            roleInstanceInstance.setGuestAgentStatus(guestAgentStatusInstance);
                            
                            Element protocolVersionElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "ProtocolVersion");
                            if (protocolVersionElement != null) {
                                String protocolVersionInstance;
                                protocolVersionInstance = protocolVersionElement.getTextContent();
                                guestAgentStatusInstance.setProtocolVersion(protocolVersionInstance);
                            }
                            
                            Element timestampElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Timestamp");
                            if (timestampElement != null && (timestampElement.getTextContent() == null || timestampElement.getTextContent().isEmpty() == true) == false) {
                                Calendar timestampInstance;
                                timestampInstance = DatatypeConverter.parseDateTime(timestampElement.getTextContent());
                                guestAgentStatusInstance.setTimestamp(timestampInstance);
                            }
                            
                            Element guestAgentVersionElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "GuestAgentVersion");
                            if (guestAgentVersionElement != null) {
                                String guestAgentVersionInstance;
                                guestAgentVersionInstance = guestAgentVersionElement.getTextContent();
                                guestAgentStatusInstance.setGuestAgentVersion(guestAgentVersionInstance);
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Status");
                            if (statusElement2 != null) {
                                String statusInstance2;
                                statusInstance2 = statusElement2.getTextContent();
                                guestAgentStatusInstance.setStatus(statusInstance2);
                            }
                            
                            Element codeElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Code");
                            if (codeElement != null && (codeElement.getTextContent() == null || codeElement.getTextContent().isEmpty() == true) == false) {
                                int codeInstance;
                                codeInstance = DatatypeConverter.parseInt(codeElement.getTextContent());
                                guestAgentStatusInstance.setCode(codeInstance);
                            }
                            
                            Element messageElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Message");
                            if (messageElement != null) {
                                GuestAgentMessage messageInstance = new GuestAgentMessage();
                                guestAgentStatusInstance.setMessage(messageInstance);
                                
                                Element messageResourceIdElement = XmlUtility.getElementByTagNameNS(messageElement, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                if (messageResourceIdElement != null) {
                                    String messageResourceIdInstance;
                                    messageResourceIdInstance = messageResourceIdElement.getTextContent();
                                    messageInstance.setMessageResourceId(messageResourceIdInstance);
                                }
                                
                                Element paramListSequenceElement = XmlUtility.getElementByTagNameNS(messageElement, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                if (paramListSequenceElement != null) {
                                    for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Param").size(); i3 = i3 + 1) {
                                        org.w3c.dom.Element paramListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Param").get(i3));
                                        messageInstance.getParamList().add(paramListElement.getTextContent());
                                    }
                                }
                            }
                            
                            Element formattedMessageElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                            if (formattedMessageElement != null) {
                                GuestAgentFormattedMessage formattedMessageInstance = new GuestAgentFormattedMessage();
                                guestAgentStatusInstance.setFormattedMessage(formattedMessageInstance);
                                
                                Element languageElement = XmlUtility.getElementByTagNameNS(formattedMessageElement, "http://schemas.microsoft.com/windowsazure", "Language");
                                if (languageElement != null) {
                                    String languageInstance;
                                    languageInstance = languageElement.getTextContent();
                                    formattedMessageInstance.setLanguage(languageInstance);
                                }
                                
                                Element messageElement2 = XmlUtility.getElementByTagNameNS(formattedMessageElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                if (messageElement2 != null) {
                                    String messageInstance2;
                                    messageInstance2 = messageElement2.getTextContent();
                                    formattedMessageInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        Element resourceExtensionStatusListSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatusList");
                        if (resourceExtensionStatusListSequenceElement != null) {
                            for (int i4 = 0; i4 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatus").size(); i4 = i4 + 1) {
                                org.w3c.dom.Element resourceExtensionStatusListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatus").get(i4));
                                ResourceExtensionStatus resourceExtensionStatusInstance = new ResourceExtensionStatus();
                                roleInstanceInstance.getResourceExtensionStatusList().add(resourceExtensionStatusInstance);
                                
                                Element handlerNameElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "HandlerName");
                                if (handlerNameElement != null) {
                                    String handlerNameInstance;
                                    handlerNameInstance = handlerNameElement.getTextContent();
                                    resourceExtensionStatusInstance.setHandlerName(handlerNameInstance);
                                }
                                
                                Element versionElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Version");
                                if (versionElement != null) {
                                    String versionInstance;
                                    versionInstance = versionElement.getTextContent();
                                    resourceExtensionStatusInstance.setVersion(versionInstance);
                                }
                                
                                Element statusElement3 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                if (statusElement3 != null) {
                                    String statusInstance3;
                                    statusInstance3 = statusElement3.getTextContent();
                                    resourceExtensionStatusInstance.setStatus(statusInstance3);
                                }
                                
                                Element codeElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                if (codeElement2 != null && (codeElement2.getTextContent() == null || codeElement2.getTextContent().isEmpty() == true) == false) {
                                    int codeInstance2;
                                    codeInstance2 = DatatypeConverter.parseInt(codeElement2.getTextContent());
                                    resourceExtensionStatusInstance.setCode(codeInstance2);
                                }
                                
                                Element messageElement3 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                if (messageElement3 != null) {
                                    GuestAgentMessage messageInstance3 = new GuestAgentMessage();
                                    resourceExtensionStatusInstance.setMessage(messageInstance3);
                                    
                                    Element messageResourceIdElement2 = XmlUtility.getElementByTagNameNS(messageElement3, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                    if (messageResourceIdElement2 != null) {
                                        String messageResourceIdInstance2;
                                        messageResourceIdInstance2 = messageResourceIdElement2.getTextContent();
                                        messageInstance3.setMessageResourceId(messageResourceIdInstance2);
                                    }
                                    
                                    Element paramListSequenceElement2 = XmlUtility.getElementByTagNameNS(messageElement3, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                    if (paramListSequenceElement2 != null) {
                                        for (int i5 = 0; i5 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement2, "http://schemas.microsoft.com/windowsazure", "Param").size(); i5 = i5 + 1) {
                                            org.w3c.dom.Element paramListElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement2, "http://schemas.microsoft.com/windowsazure", "Param").get(i5));
                                            messageInstance3.getParamList().add(paramListElement2.getTextContent());
                                        }
                                    }
                                }
                                
                                Element formattedMessageElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                if (formattedMessageElement2 != null) {
                                    GuestAgentFormattedMessage formattedMessageInstance2 = new GuestAgentFormattedMessage();
                                    resourceExtensionStatusInstance.setFormattedMessage(formattedMessageInstance2);
                                    
                                    Element languageElement2 = XmlUtility.getElementByTagNameNS(formattedMessageElement2, "http://schemas.microsoft.com/windowsazure", "Language");
                                    if (languageElement2 != null) {
                                        String languageInstance2;
                                        languageInstance2 = languageElement2.getTextContent();
                                        formattedMessageInstance2.setLanguage(languageInstance2);
                                    }
                                    
                                    Element messageElement4 = XmlUtility.getElementByTagNameNS(formattedMessageElement2, "http://schemas.microsoft.com/windowsazure", "Message");
                                    if (messageElement4 != null) {
                                        String messageInstance4;
                                        messageInstance4 = messageElement4.getTextContent();
                                        formattedMessageInstance2.setMessage(messageInstance4);
                                    }
                                }
                                
                                Element extensionSettingStatusElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "ExtensionSettingStatus");
                                if (extensionSettingStatusElement != null) {
                                    ResourceExtensionConfigurationStatus extensionSettingStatusInstance = new ResourceExtensionConfigurationStatus();
                                    resourceExtensionStatusInstance.setExtensionSettingStatus(extensionSettingStatusInstance);
                                    
                                    Element timestampElement2 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Timestamp");
                                    if (timestampElement2 != null && (timestampElement2.getTextContent() == null || timestampElement2.getTextContent().isEmpty() == true) == false) {
                                        Calendar timestampInstance2;
                                        timestampInstance2 = DatatypeConverter.parseDateTime(timestampElement2.getTextContent());
                                        extensionSettingStatusInstance.setTimestamp(timestampInstance2);
                                    }
                                    
                                    Element configurationAppliedTimeElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationAppliedTime");
                                    if (configurationAppliedTimeElement != null && (configurationAppliedTimeElement.getTextContent() == null || configurationAppliedTimeElement.getTextContent().isEmpty() == true) == false) {
                                        Calendar configurationAppliedTimeInstance;
                                        configurationAppliedTimeInstance = DatatypeConverter.parseDateTime(configurationAppliedTimeElement.getTextContent());
                                        extensionSettingStatusInstance.setConfigurationAppliedTime(configurationAppliedTimeInstance);
                                    }
                                    
                                    Element nameElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                    if (nameElement3 != null) {
                                        String nameInstance3;
                                        nameInstance3 = nameElement3.getTextContent();
                                        extensionSettingStatusInstance.setName(nameInstance3);
                                    }
                                    
                                    Element operationElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Operation");
                                    if (operationElement != null) {
                                        String operationInstance;
                                        operationInstance = operationElement.getTextContent();
                                        extensionSettingStatusInstance.setOperation(operationInstance);
                                    }
                                    
                                    Element statusElement4 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                    if (statusElement4 != null) {
                                        String statusInstance4;
                                        statusInstance4 = statusElement4.getTextContent();
                                        extensionSettingStatusInstance.setStatus(statusInstance4);
                                    }
                                    
                                    Element codeElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                    if (codeElement3 != null && (codeElement3.getTextContent() == null || codeElement3.getTextContent().isEmpty() == true) == false) {
                                        int codeInstance3;
                                        codeInstance3 = DatatypeConverter.parseInt(codeElement3.getTextContent());
                                        extensionSettingStatusInstance.setCode(codeInstance3);
                                    }
                                    
                                    Element messageElement5 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                    if (messageElement5 != null) {
                                        GuestAgentMessage messageInstance5 = new GuestAgentMessage();
                                        extensionSettingStatusInstance.setMessage(messageInstance5);
                                        
                                        Element messageResourceIdElement3 = XmlUtility.getElementByTagNameNS(messageElement5, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                        if (messageResourceIdElement3 != null) {
                                            String messageResourceIdInstance3;
                                            messageResourceIdInstance3 = messageResourceIdElement3.getTextContent();
                                            messageInstance5.setMessageResourceId(messageResourceIdInstance3);
                                        }
                                        
                                        Element paramListSequenceElement3 = XmlUtility.getElementByTagNameNS(messageElement5, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                        if (paramListSequenceElement3 != null) {
                                            for (int i6 = 0; i6 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement3, "http://schemas.microsoft.com/windowsazure", "Param").size(); i6 = i6 + 1) {
                                                org.w3c.dom.Element paramListElement3 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement3, "http://schemas.microsoft.com/windowsazure", "Param").get(i6));
                                                messageInstance5.getParamList().add(paramListElement3.getTextContent());
                                            }
                                        }
                                    }
                                    
                                    Element formattedMessageElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                    if (formattedMessageElement3 != null) {
                                        GuestAgentFormattedMessage formattedMessageInstance3 = new GuestAgentFormattedMessage();
                                        extensionSettingStatusInstance.setFormattedMessage(formattedMessageInstance3);
                                        
                                        Element languageElement3 = XmlUtility.getElementByTagNameNS(formattedMessageElement3, "http://schemas.microsoft.com/windowsazure", "Language");
                                        if (languageElement3 != null) {
                                            String languageInstance3;
                                            languageInstance3 = languageElement3.getTextContent();
                                            formattedMessageInstance3.setLanguage(languageInstance3);
                                        }
                                        
                                        Element messageElement6 = XmlUtility.getElementByTagNameNS(formattedMessageElement3, "http://schemas.microsoft.com/windowsazure", "Message");
                                        if (messageElement6 != null) {
                                            String messageInstance6;
                                            messageInstance6 = messageElement6.getTextContent();
                                            formattedMessageInstance3.setMessage(messageInstance6);
                                        }
                                    }
                                    
                                    Element subStatusListSequenceElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "SubStatusList");
                                    if (subStatusListSequenceElement != null) {
                                        for (int i7 = 0; i7 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubStatus").size(); i7 = i7 + 1) {
                                            org.w3c.dom.Element subStatusListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubStatus").get(i7));
                                            ResourceExtensionSubStatus subStatusInstance = new ResourceExtensionSubStatus();
                                            extensionSettingStatusInstance.getSubStatusList().add(subStatusInstance);
                                            
                                            Element nameElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                            if (nameElement4 != null) {
                                                String nameInstance4;
                                                nameInstance4 = nameElement4.getTextContent();
                                                subStatusInstance.setName(nameInstance4);
                                            }
                                            
                                            Element statusElement5 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                            if (statusElement5 != null) {
                                                String statusInstance5;
                                                statusInstance5 = statusElement5.getTextContent();
                                                subStatusInstance.setStatus(statusInstance5);
                                            }
                                            
                                            Element codeElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                            if (codeElement4 != null && (codeElement4.getTextContent() == null || codeElement4.getTextContent().isEmpty() == true) == false) {
                                                int codeInstance4;
                                                codeInstance4 = DatatypeConverter.parseInt(codeElement4.getTextContent());
                                                subStatusInstance.setCode(codeInstance4);
                                            }
                                            
                                            Element messageElement7 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                            if (messageElement7 != null) {
                                                GuestAgentMessage messageInstance7 = new GuestAgentMessage();
                                                subStatusInstance.setMessage(messageInstance7);
                                                
                                                Element messageResourceIdElement4 = XmlUtility.getElementByTagNameNS(messageElement7, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                                if (messageResourceIdElement4 != null) {
                                                    String messageResourceIdInstance4;
                                                    messageResourceIdInstance4 = messageResourceIdElement4.getTextContent();
                                                    messageInstance7.setMessageResourceId(messageResourceIdInstance4);
                                                }
                                                
                                                Element paramListSequenceElement4 = XmlUtility.getElementByTagNameNS(messageElement7, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                                if (paramListSequenceElement4 != null) {
                                                    for (int i8 = 0; i8 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement4, "http://schemas.microsoft.com/windowsazure", "Param").size(); i8 = i8 + 1) {
                                                        org.w3c.dom.Element paramListElement4 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement4, "http://schemas.microsoft.com/windowsazure", "Param").get(i8));
                                                        messageInstance7.getParamList().add(paramListElement4.getTextContent());
                                                    }
                                                }
                                            }
                                            
                                            Element formattedMessageElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                            if (formattedMessageElement4 != null) {
                                                GuestAgentFormattedMessage formattedMessageInstance4 = new GuestAgentFormattedMessage();
                                                subStatusInstance.setFormattedMessage(formattedMessageInstance4);
                                                
                                                Element languageElement4 = XmlUtility.getElementByTagNameNS(formattedMessageElement4, "http://schemas.microsoft.com/windowsazure", "Language");
                                                if (languageElement4 != null) {
                                                    String languageInstance4;
                                                    languageInstance4 = languageElement4.getTextContent();
                                                    formattedMessageInstance4.setLanguage(languageInstance4);
                                                }
                                                
                                                Element messageElement8 = XmlUtility.getElementByTagNameNS(formattedMessageElement4, "http://schemas.microsoft.com/windowsazure", "Message");
                                                if (messageElement8 != null) {
                                                    String messageInstance8;
                                                    messageInstance8 = messageElement8.getTextContent();
                                                    formattedMessageInstance4.setMessage(messageInstance8);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        Element powerStateElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "PowerState");
                        if (powerStateElement != null) {
                            RoleInstancePowerState powerStateInstance;
                            powerStateInstance = RoleInstancePowerState.valueOf(powerStateElement.getTextContent());
                            roleInstanceInstance.setPowerState(powerStateInstance);
                        }
                        
                        Element hostNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "HostName");
                        if (hostNameElement != null) {
                            String hostNameInstance;
                            hostNameInstance = hostNameElement.getTextContent();
                            roleInstanceInstance.setHostName(hostNameInstance);
                        }
                        
                        Element remoteAccessCertificateThumbprintElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "RemoteAccessCertificateThumbprint");
                        if (remoteAccessCertificateThumbprintElement != null) {
                            String remoteAccessCertificateThumbprintInstance;
                            remoteAccessCertificateThumbprintInstance = remoteAccessCertificateThumbprintElement.getTextContent();
                            roleInstanceInstance.setRemoteAccessCertificateThumbprint(remoteAccessCertificateThumbprintInstance);
                        }
                        
                        Element publicIPsSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "PublicIPs");
                        if (publicIPsSequenceElement != null) {
                            for (int i9 = 0; i9 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicIP").size(); i9 = i9 + 1) {
                                org.w3c.dom.Element publicIPsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicIP").get(i9));
                                RoleInstance.PublicIP publicIPInstance = new RoleInstance.PublicIP();
                                roleInstanceInstance.getPublicIPs().add(publicIPInstance);
                                
                                Element nameElement5 = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement5 != null) {
                                    String nameInstance5;
                                    nameInstance5 = nameElement5.getTextContent();
                                    publicIPInstance.setName(nameInstance5);
                                }
                                
                                Element addressElement = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                                if (addressElement != null) {
                                    InetAddress addressInstance;
                                    addressInstance = InetAddress.getByName(addressElement.getTextContent());
                                    publicIPInstance.setAddress(addressInstance);
                                }
                                
                                Element idleTimeoutInMinutesElement2 = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                if (idleTimeoutInMinutesElement2 != null && (idleTimeoutInMinutesElement2.getTextContent() == null || idleTimeoutInMinutesElement2.getTextContent().isEmpty() == true) == false) {
                                    int idleTimeoutInMinutesInstance2;
                                    idleTimeoutInMinutesInstance2 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement2.getTextContent());
                                    publicIPInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                }
                            }
                        }
                        
                        Element networkInterfacesSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                        if (networkInterfacesSequenceElement != null) {
                            for (int i10 = 0; i10 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").size(); i10 = i10 + 1) {
                                org.w3c.dom.Element networkInterfacesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").get(i10));
                                NetworkInterfaceInstance networkInterfaceInstance = new NetworkInterfaceInstance();
                                roleInstanceInstance.getNetworkInterfaces().add(networkInterfaceInstance);
                                
                                Element nameElement6 = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement6 != null) {
                                    String nameInstance6;
                                    nameInstance6 = nameElement6.getTextContent();
                                    networkInterfaceInstance.setName(nameInstance6);
                                }
                                
                                Element macAddressElement = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "MacAddress");
                                if (macAddressElement != null) {
                                    String macAddressInstance;
                                    macAddressInstance = macAddressElement.getTextContent();
                                    networkInterfaceInstance.setMacAddress(macAddressInstance);
                                }
                                
                                Element iPConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                                if (iPConfigurationsSequenceElement != null) {
                                    for (int i11 = 0; i11 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").size(); i11 = i11 + 1) {
                                        org.w3c.dom.Element iPConfigurationsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").get(i11));
                                        IPConfigurationInstance iPConfigurationInstance = new IPConfigurationInstance();
                                        networkInterfaceInstance.getIPConfigurations().add(iPConfigurationInstance);
                                        
                                        Element subnetNameElement = XmlUtility.getElementByTagNameNS(iPConfigurationsElement, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                                        if (subnetNameElement != null) {
                                            String subnetNameInstance;
                                            subnetNameInstance = subnetNameElement.getTextContent();
                                            iPConfigurationInstance.setSubnetName(subnetNameInstance);
                                        }
                                        
                                        Element addressElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                                        if (addressElement2 != null) {
                                            String addressInstance2;
                                            addressInstance2 = addressElement2.getTextContent();
                                            iPConfigurationInstance.setAddress(addressInstance2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
                Element upgradeStatusElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "UpgradeStatus");
                if (upgradeStatusElement != null) {
                    UpgradeStatus upgradeStatusInstance = new UpgradeStatus();
                    result.setUpgradeStatus(upgradeStatusInstance);
                    
                    Element upgradeTypeElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "UpgradeType");
                    if (upgradeTypeElement != null) {
                        DeploymentUpgradeType upgradeTypeInstance;
                        upgradeTypeInstance = DeploymentUpgradeType.valueOf(upgradeTypeElement.getTextContent());
                        upgradeStatusInstance.setUpgradeType(upgradeTypeInstance);
                    }
                    
                    Element currentUpgradeDomainStateElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "CurrentUpgradeDomainState");
                    if (currentUpgradeDomainStateElement != null) {
                        UpgradeDomainState currentUpgradeDomainStateInstance;
                        currentUpgradeDomainStateInstance = UpgradeDomainState.valueOf(currentUpgradeDomainStateElement.getTextContent());
                        upgradeStatusInstance.setCurrentUpgradeDomainState(currentUpgradeDomainStateInstance);
                    }
                    
                    Element currentUpgradeDomainElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "CurrentUpgradeDomain");
                    if (currentUpgradeDomainElement != null) {
                        int currentUpgradeDomainInstance;
                        currentUpgradeDomainInstance = DatatypeConverter.parseInt(currentUpgradeDomainElement.getTextContent());
                        upgradeStatusInstance.setCurrentUpgradeDomain(currentUpgradeDomainInstance);
                    }
                }
                
                Element upgradeDomainCountElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "UpgradeDomainCount");
                if (upgradeDomainCountElement != null) {
                    int upgradeDomainCountInstance;
                    upgradeDomainCountInstance = DatatypeConverter.parseInt(upgradeDomainCountElement.getTextContent());
                    result.setUpgradeDomainCount(upgradeDomainCountInstance);
                }
                
                Element roleListSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RoleList");
                if (roleListSequenceElement != null) {
                    for (int i12 = 0; i12 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").size(); i12 = i12 + 1) {
                        org.w3c.dom.Element roleListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").get(i12));
                        Role roleInstance = new Role();
                        result.getRoles().add(roleInstance);
                        
                        Element roleNameElement2 = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement2 != null) {
                            String roleNameInstance2;
                            roleNameInstance2 = roleNameElement2.getTextContent();
                            roleInstance.setRoleName(roleNameInstance2);
                        }
                        
                        Element osVersionElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "OsVersion");
                        if (osVersionElement != null) {
                            String osVersionInstance;
                            osVersionInstance = osVersionElement.getTextContent();
                            roleInstance.setOSVersion(osVersionInstance);
                        }
                        
                        Element roleTypeElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleType");
                        if (roleTypeElement != null) {
                            String roleTypeInstance;
                            roleTypeInstance = roleTypeElement.getTextContent();
                            roleInstance.setRoleType(roleTypeInstance);
                        }
                        
                        Element configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSets");
                        if (configurationSetsSequenceElement != null) {
                            for (int i13 = 0; i13 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(configurationSetsSequenceElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSet").size(); i13 = i13 + 1) {
                                org.w3c.dom.Element configurationSetsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(configurationSetsSequenceElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSet").get(i13));
                                ConfigurationSet configurationSetInstance = new ConfigurationSet();
                                roleInstance.getConfigurationSets().add(configurationSetInstance);
                                
                                Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                                if (configurationSetTypeElement != null) {
                                    String configurationSetTypeInstance;
                                    configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                    configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                                }
                                
                                Element inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                                if (inputEndpointsSequenceElement != null) {
                                    for (int i14 = 0; i14 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(inputEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoint").size(); i14 = i14 + 1) {
                                        org.w3c.dom.Element inputEndpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(inputEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoint").get(i14));
                                        InputEndpoint inputEndpointInstance = new InputEndpoint();
                                        configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                        
                                        Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                                        if (loadBalancedEndpointSetNameElement != null) {
                                            String loadBalancedEndpointSetNameInstance;
                                            loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                        }
                                        
                                        Element localPortElement2 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LocalPort");
                                        if (localPortElement2 != null && (localPortElement2.getTextContent() == null || localPortElement2.getTextContent().isEmpty() == true) == false) {
                                            int localPortInstance2;
                                            localPortInstance2 = DatatypeConverter.parseInt(localPortElement2.getTextContent());
                                            inputEndpointInstance.setLocalPort(localPortInstance2);
                                        }
                                        
                                        Element nameElement7 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement7 != null) {
                                            String nameInstance7;
                                            nameInstance7 = nameElement7.getTextContent();
                                            inputEndpointInstance.setName(nameInstance7);
                                        }
                                        
                                        Element portElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Port");
                                        if (portElement != null && (portElement.getTextContent() == null || portElement.getTextContent().isEmpty() == true) == false) {
                                            int portInstance;
                                            portInstance = DatatypeConverter.parseInt(portElement.getTextContent());
                                            inputEndpointInstance.setPort(portInstance);
                                        }
                                        
                                        Element loadBalancerProbeElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                                        if (loadBalancerProbeElement != null) {
                                            LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                            inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                            
                                            Element pathElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement != null) {
                                                String pathInstance;
                                                pathInstance = pathElement.getTextContent();
                                                loadBalancerProbeInstance.setPath(pathInstance);
                                            }
                                            
                                            Element portElement2 = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Port");
                                            if (portElement2 != null) {
                                                int portInstance2;
                                                portInstance2 = DatatypeConverter.parseInt(portElement2.getTextContent());
                                                loadBalancerProbeInstance.setPort(portInstance2);
                                            }
                                            
                                            Element protocolElement2 = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                            if (protocolElement2 != null) {
                                                LoadBalancerProbeTransportProtocol protocolInstance2;
                                                protocolInstance2 = com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement2.getTextContent());
                                                loadBalancerProbeInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            Element intervalInSecondsElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                                            if (intervalInSecondsElement != null && (intervalInSecondsElement.getTextContent() == null || intervalInSecondsElement.getTextContent().isEmpty() == true) == false) {
                                                int intervalInSecondsInstance;
                                                intervalInSecondsInstance = DatatypeConverter.parseInt(intervalInSecondsElement.getTextContent());
                                                loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            
                                            Element timeoutInSecondsElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                                            if (timeoutInSecondsElement != null && (timeoutInSecondsElement.getTextContent() == null || timeoutInSecondsElement.getTextContent().isEmpty() == true) == false) {
                                                int timeoutInSecondsInstance;
                                                timeoutInSecondsInstance = DatatypeConverter.parseInt(timeoutInSecondsElement.getTextContent());
                                                loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                            }
                                        }
                                        
                                        Element protocolElement3 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                        if (protocolElement3 != null) {
                                            String protocolInstance3;
                                            protocolInstance3 = protocolElement3.getTextContent();
                                            inputEndpointInstance.setProtocol(protocolInstance3);
                                        }
                                        
                                        Element vipElement2 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Vip");
                                        if (vipElement2 != null) {
                                            InetAddress vipInstance2;
                                            vipInstance2 = InetAddress.getByName(vipElement2.getTextContent());
                                            inputEndpointInstance.setVirtualIPAddress(vipInstance2);
                                        }
                                        
                                        Element enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                                        if (enableDirectServerReturnElement != null && (enableDirectServerReturnElement.getTextContent() == null || enableDirectServerReturnElement.getTextContent().isEmpty() == true) == false) {
                                            boolean enableDirectServerReturnInstance;
                                            enableDirectServerReturnInstance = DatatypeConverter.parseBoolean(enableDirectServerReturnElement.getTextContent().toLowerCase());
                                            inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                        }
                                        
                                        Element loadBalancerNameElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                                        if (loadBalancerNameElement != null) {
                                            String loadBalancerNameInstance;
                                            loadBalancerNameInstance = loadBalancerNameElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancerName(loadBalancerNameInstance);
                                        }
                                        
                                        Element endpointAclElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                                        if (endpointAclElement != null) {
                                            EndpointAcl endpointAclInstance = new EndpointAcl();
                                            inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                            
                                            Element rulesSequenceElement = XmlUtility.getElementByTagNameNS(endpointAclElement, "http://schemas.microsoft.com/windowsazure", "Rules");
                                            if (rulesSequenceElement != null) {
                                                for (int i15 = 0; i15 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rulesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Rule").size(); i15 = i15 + 1) {
                                                    org.w3c.dom.Element rulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rulesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Rule").get(i15));
                                                    AccessControlListRule ruleInstance = new AccessControlListRule();
                                                    endpointAclInstance.getRules().add(ruleInstance);
                                                    
                                                    Element orderElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Order");
                                                    if (orderElement != null && (orderElement.getTextContent() == null || orderElement.getTextContent().isEmpty() == true) == false) {
                                                        int orderInstance;
                                                        orderInstance = DatatypeConverter.parseInt(orderElement.getTextContent());
                                                        ruleInstance.setOrder(orderInstance);
                                                    }
                                                    
                                                    Element actionElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Action");
                                                    if (actionElement != null) {
                                                        String actionInstance;
                                                        actionInstance = actionElement.getTextContent();
                                                        ruleInstance.setAction(actionInstance);
                                                    }
                                                    
                                                    Element remoteSubnetElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                                    if (remoteSubnetElement != null) {
                                                        String remoteSubnetInstance;
                                                        remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                        ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                    }
                                                    
                                                    Element descriptionElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                                                    if (descriptionElement != null) {
                                                        String descriptionInstance;
                                                        descriptionInstance = descriptionElement.getTextContent();
                                                        ruleInstance.setDescription(descriptionInstance);
                                                    }
                                                }
                                            }
                                        }
                                        
                                        Element idleTimeoutInMinutesElement3 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                        if (idleTimeoutInMinutesElement3 != null && (idleTimeoutInMinutesElement3.getTextContent() == null || idleTimeoutInMinutesElement3.getTextContent().isEmpty() == true) == false) {
                                            int idleTimeoutInMinutesInstance3;
                                            idleTimeoutInMinutesInstance3 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement3.getTextContent());
                                            inputEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance3);
                                        }
                                        
                                        Element loadBalancerDistributionElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                                        if (loadBalancerDistributionElement != null) {
                                            String loadBalancerDistributionInstance;
                                            loadBalancerDistributionInstance = loadBalancerDistributionElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancerDistribution(loadBalancerDistributionInstance);
                                        }
                                    }
                                }
                                
                                Element subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "SubnetNames");
                                if (subnetNamesSequenceElement != null) {
                                    for (int i16 = 0; i16 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subnetNamesSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubnetName").size(); i16 = i16 + 1) {
                                        org.w3c.dom.Element subnetNamesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subnetNamesSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubnetName").get(i16));
                                        configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                    }
                                }
                                
                                Element staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                if (staticVirtualNetworkIPAddressElement != null) {
                                    String staticVirtualNetworkIPAddressInstance;
                                    staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                    configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                                }
                                
                                Element publicIPsSequenceElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "PublicIPs");
                                if (publicIPsSequenceElement2 != null) {
                                    for (int i17 = 0; i17 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "PublicIP").size(); i17 = i17 + 1) {
                                        org.w3c.dom.Element publicIPsElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "PublicIP").get(i17));
                                        ConfigurationSet.PublicIP publicIPInstance2 = new ConfigurationSet.PublicIP();
                                        configurationSetInstance.getPublicIPs().add(publicIPInstance2);
                                        
                                        Element nameElement8 = XmlUtility.getElementByTagNameNS(publicIPsElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement8 != null) {
                                            String nameInstance8;
                                            nameInstance8 = nameElement8.getTextContent();
                                            publicIPInstance2.setName(nameInstance8);
                                        }
                                        
                                        Element idleTimeoutInMinutesElement4 = XmlUtility.getElementByTagNameNS(publicIPsElement2, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                        if (idleTimeoutInMinutesElement4 != null && (idleTimeoutInMinutesElement4.getTextContent() == null || idleTimeoutInMinutesElement4.getTextContent().isEmpty() == true) == false) {
                                            int idleTimeoutInMinutesInstance4;
                                            idleTimeoutInMinutesInstance4 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement4.getTextContent());
                                            publicIPInstance2.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance4);
                                        }
                                    }
                                }
                                
                                Element networkInterfacesSequenceElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                                if (networkInterfacesSequenceElement2 != null) {
                                    for (int i18 = 0; i18 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement2, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").size(); i18 = i18 + 1) {
                                        org.w3c.dom.Element networkInterfacesElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement2, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").get(i18));
                                        NetworkInterface networkInterfaceInstance2 = new NetworkInterface();
                                        configurationSetInstance.getNetworkInterfaces().add(networkInterfaceInstance2);
                                        
                                        Element nameElement9 = XmlUtility.getElementByTagNameNS(networkInterfacesElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement9 != null) {
                                            String nameInstance9;
                                            nameInstance9 = nameElement9.getTextContent();
                                            networkInterfaceInstance2.setName(nameInstance9);
                                        }
                                        
                                        Element iPConfigurationsSequenceElement2 = XmlUtility.getElementByTagNameNS(networkInterfacesElement2, "http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                                        if (iPConfigurationsSequenceElement2 != null) {
                                            for (int i19 = 0; i19 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").size(); i19 = i19 + 1) {
                                                org.w3c.dom.Element iPConfigurationsElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").get(i19));
                                                IPConfiguration iPConfigurationInstance2 = new IPConfiguration();
                                                networkInterfaceInstance2.getIPConfigurations().add(iPConfigurationInstance2);
                                                
                                                Element subnetNameElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement2, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                                                if (subnetNameElement2 != null) {
                                                    String subnetNameInstance2;
                                                    subnetNameInstance2 = subnetNameElement2.getTextContent();
                                                    iPConfigurationInstance2.setSubnetName(subnetNameInstance2);
                                                }
                                                
                                                Element staticVirtualNetworkIPAddressElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement2, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                                if (staticVirtualNetworkIPAddressElement2 != null) {
                                                    String staticVirtualNetworkIPAddressInstance2;
                                                    staticVirtualNetworkIPAddressInstance2 = staticVirtualNetworkIPAddressElement2.getTextContent();
                                                    iPConfigurationInstance2.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance2);
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                Element networkSecurityGroupElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                                if (networkSecurityGroupElement != null) {
                                    String networkSecurityGroupInstance;
                                    networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                                    configurationSetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                }
                                
                                Element computerNameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ComputerName");
                                if (computerNameElement != null) {
                                    String computerNameInstance;
                                    computerNameInstance = computerNameElement.getTextContent();
                                    configurationSetInstance.setComputerName(computerNameInstance);
                                }
                                
                                Element adminPasswordElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "AdminPassword");
                                if (adminPasswordElement != null) {
                                    String adminPasswordInstance;
                                    adminPasswordInstance = adminPasswordElement.getTextContent();
                                    configurationSetInstance.setAdminPassword(adminPasswordInstance);
                                }
                                
                                Element resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                                if (resetPasswordOnFirstLogonElement != null && (resetPasswordOnFirstLogonElement.getTextContent() == null || resetPasswordOnFirstLogonElement.getTextContent().isEmpty() == true) == false) {
                                    boolean resetPasswordOnFirstLogonInstance;
                                    resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean(resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                                }
                                
                                Element enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                                if (enableAutomaticUpdatesElement != null && (enableAutomaticUpdatesElement.getTextContent() == null || enableAutomaticUpdatesElement.getTextContent().isEmpty() == true) == false) {
                                    boolean enableAutomaticUpdatesInstance;
                                    enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean(enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                
                                Element timeZoneElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "TimeZone");
                                if (timeZoneElement != null) {
                                    String timeZoneInstance;
                                    timeZoneInstance = timeZoneElement.getTextContent();
                                    configurationSetInstance.setTimeZone(timeZoneInstance);
                                }
                                
                                Element domainJoinElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "DomainJoin");
                                if (domainJoinElement != null) {
                                    DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                    configurationSetInstance.setDomainJoin(domainJoinInstance);
                                    
                                    Element credentialsElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "Credentials");
                                    if (credentialsElement != null) {
                                        DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                        domainJoinInstance.setCredentials(credentialsInstance);
                                        
                                        Element domainElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Domain");
                                        if (domainElement != null) {
                                            String domainInstance;
                                            domainInstance = domainElement.getTextContent();
                                            credentialsInstance.setDomain(domainInstance);
                                        }
                                        
                                        Element usernameElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Username");
                                        if (usernameElement != null) {
                                            String usernameInstance;
                                            usernameInstance = usernameElement.getTextContent();
                                            credentialsInstance.setUserName(usernameInstance);
                                        }
                                        
                                        Element passwordElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Password");
                                        if (passwordElement != null) {
                                            String passwordInstance;
                                            passwordInstance = passwordElement.getTextContent();
                                            credentialsInstance.setPassword(passwordInstance);
                                        }
                                    }
                                    
                                    Element joinDomainElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "JoinDomain");
                                    if (joinDomainElement != null) {
                                        String joinDomainInstance;
                                        joinDomainInstance = joinDomainElement.getTextContent();
                                        domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                    }
                                    
                                    Element machineObjectOUElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                                    if (machineObjectOUElement != null) {
                                        String machineObjectOUInstance;
                                        machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                        domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                    }
                                    
                                    Element provisioningElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "Provisioning");
                                    if (provisioningElement != null) {
                                        DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                        domainJoinInstance.setProvisioning(provisioningInstance);
                                        
                                        Element accountDataElement = XmlUtility.getElementByTagNameNS(provisioningElement, "http://schemas.microsoft.com/windowsazure", "AccountData");
                                        if (accountDataElement != null) {
                                            String accountDataInstance;
                                            accountDataInstance = accountDataElement.getTextContent();
                                            provisioningInstance.setAccountData(accountDataInstance);
                                        }
                                    }
                                }
                                
                                Element storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                                if (storedCertificateSettingsSequenceElement != null) {
                                    for (int i20 = 0; i20 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storedCertificateSettingsSequenceElement, "http://schemas.microsoft.com/windowsazure", "CertificateSetting").size(); i20 = i20 + 1) {
                                        org.w3c.dom.Element storedCertificateSettingsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storedCertificateSettingsSequenceElement, "http://schemas.microsoft.com/windowsazure", "CertificateSetting").get(i20));
                                        StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                        configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                        
                                        Element storeLocationElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "StoreLocation");
                                        if (storeLocationElement != null) {
                                        }
                                        
                                        Element storeNameElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "StoreName");
                                        if (storeNameElement != null) {
                                            String storeNameInstance;
                                            storeNameInstance = storeNameElement.getTextContent();
                                            certificateSettingInstance.setStoreName(storeNameInstance);
                                        }
                                        
                                        Element thumbprintElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "Thumbprint");
                                        if (thumbprintElement != null) {
                                            String thumbprintInstance;
                                            thumbprintInstance = thumbprintElement.getTextContent();
                                            certificateSettingInstance.setThumbprint(thumbprintInstance);
                                        }
                                    }
                                }
                                
                                Element winRMElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "WinRM");
                                if (winRMElement != null) {
                                    WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                    configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                    
                                    Element listenersSequenceElement = XmlUtility.getElementByTagNameNS(winRMElement, "http://schemas.microsoft.com/windowsazure", "Listeners");
                                    if (listenersSequenceElement != null) {
                                        for (int i21 = 0; i21 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(listenersSequenceElement, "http://schemas.microsoft.com/windowsazure", "Listener").size(); i21 = i21 + 1) {
                                            org.w3c.dom.Element listenersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(listenersSequenceElement, "http://schemas.microsoft.com/windowsazure", "Listener").get(i21));
                                            WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                            winRMInstance.getListeners().add(listenerInstance);
                                            
                                            Element protocolElement4 = XmlUtility.getElementByTagNameNS(listenersElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                            if (protocolElement4 != null) {
                                                VirtualMachineWindowsRemoteManagementListenerType protocolInstance4;
                                                protocolInstance4 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement4.getTextContent());
                                                listenerInstance.setListenerType(protocolInstance4);
                                            }
                                            
                                            Element certificateThumbprintElement = XmlUtility.getElementByTagNameNS(listenersElement, "http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                                            if (certificateThumbprintElement != null) {
                                                String certificateThumbprintInstance;
                                                certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                                listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                            }
                                        }
                                    }
                                }
                                
                                Element adminUsernameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "AdminUsername");
                                if (adminUsernameElement != null) {
                                    String adminUsernameInstance;
                                    adminUsernameInstance = adminUsernameElement.getTextContent();
                                    configurationSetInstance.setAdminUserName(adminUsernameInstance);
                                }
                                
                                Element hostNameElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "HostName");
                                if (hostNameElement2 != null) {
                                    String hostNameInstance2;
                                    hostNameInstance2 = hostNameElement2.getTextContent();
                                    configurationSetInstance.setHostName(hostNameInstance2);
                                }
                                
                                Element userNameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "UserName");
                                if (userNameElement != null) {
                                    String userNameInstance;
                                    userNameInstance = userNameElement.getTextContent();
                                    configurationSetInstance.setUserName(userNameInstance);
                                }
                                
                                Element userPasswordElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "UserPassword");
                                if (userPasswordElement != null) {
                                    String userPasswordInstance;
                                    userPasswordInstance = userPasswordElement.getTextContent();
                                    configurationSetInstance.setUserPassword(userPasswordInstance);
                                }
                                
                                Element disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                                if (disableSshPasswordAuthenticationElement != null && (disableSshPasswordAuthenticationElement.getTextContent() == null || disableSshPasswordAuthenticationElement.getTextContent().isEmpty() == true) == false) {
                                    boolean disableSshPasswordAuthenticationInstance;
                                    disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean(disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                                }
                                
                                Element sSHElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "SSH");
                                if (sSHElement != null) {
                                    SshSettings sSHInstance = new SshSettings();
                                    configurationSetInstance.setSshSettings(sSHInstance);
                                    
                                    Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS(sSHElement, "http://schemas.microsoft.com/windowsazure", "PublicKeys");
                                    if (publicKeysSequenceElement != null) {
                                        for (int i22 = 0; i22 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicKeysSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicKey").size(); i22 = i22 + 1) {
                                            org.w3c.dom.Element publicKeysElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicKeysSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicKey").get(i22));
                                            SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                            sSHInstance.getPublicKeys().add(publicKeyInstance);
                                            
                                            Element fingerprintElement = XmlUtility.getElementByTagNameNS(publicKeysElement, "http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                            if (fingerprintElement != null) {
                                                String fingerprintInstance;
                                                fingerprintInstance = fingerprintElement.getTextContent();
                                                publicKeyInstance.setFingerprint(fingerprintInstance);
                                            }
                                            
                                            Element pathElement2 = XmlUtility.getElementByTagNameNS(publicKeysElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement2 != null) {
                                                String pathInstance2;
                                                pathInstance2 = pathElement2.getTextContent();
                                                publicKeyInstance.setPath(pathInstance2);
                                            }
                                        }
                                    }
                                    
                                    Element keyPairsSequenceElement = XmlUtility.getElementByTagNameNS(sSHElement, "http://schemas.microsoft.com/windowsazure", "KeyPairs");
                                    if (keyPairsSequenceElement != null) {
                                        for (int i23 = 0; i23 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(keyPairsSequenceElement, "http://schemas.microsoft.com/windowsazure", "KeyPair").size(); i23 = i23 + 1) {
                                            org.w3c.dom.Element keyPairsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(keyPairsSequenceElement, "http://schemas.microsoft.com/windowsazure", "KeyPair").get(i23));
                                            SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                            sSHInstance.getKeyPairs().add(keyPairInstance);
                                            
                                            Element fingerprintElement2 = XmlUtility.getElementByTagNameNS(keyPairsElement, "http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                            if (fingerprintElement2 != null) {
                                                String fingerprintInstance2;
                                                fingerprintInstance2 = fingerprintElement2.getTextContent();
                                                keyPairInstance.setFingerprint(fingerprintInstance2);
                                            }
                                            
                                            Element pathElement3 = XmlUtility.getElementByTagNameNS(keyPairsElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement3 != null) {
                                                String pathInstance3;
                                                pathInstance3 = pathElement3.getTextContent();
                                                keyPairInstance.setPath(pathInstance3);
                                            }
                                        }
                                    }
                                }
                                
                                Element customDataElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "CustomData");
                                if (customDataElement != null) {
                                    String customDataInstance;
                                    customDataInstance = customDataElement.getTextContent();
                                    configurationSetInstance.setCustomData(customDataInstance);
                                }
                            }
                        }
                        
                        Element resourceExtensionReferencesSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReferences");
                        if (resourceExtensionReferencesSequenceElement != null) {
                            for (int i24 = 0; i24 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionReferencesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference").size(); i24 = i24 + 1) {
                                org.w3c.dom.Element resourceExtensionReferencesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionReferencesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference").get(i24));
                                ResourceExtensionReference resourceExtensionReferenceInstance = new ResourceExtensionReference();
                                roleInstance.getResourceExtensionReferences().add(resourceExtensionReferenceInstance);
                                
                                Element referenceNameElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "ReferenceName");
                                if (referenceNameElement != null) {
                                    String referenceNameInstance;
                                    referenceNameInstance = referenceNameElement.getTextContent();
                                    resourceExtensionReferenceInstance.setReferenceName(referenceNameInstance);
                                }
                                
                                Element publisherElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Publisher");
                                if (publisherElement != null) {
                                    String publisherInstance;
                                    publisherInstance = publisherElement.getTextContent();
                                    resourceExtensionReferenceInstance.setPublisher(publisherInstance);
                                }
                                
                                Element nameElement10 = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement10 != null) {
                                    String nameInstance10;
                                    nameInstance10 = nameElement10.getTextContent();
                                    resourceExtensionReferenceInstance.setName(nameInstance10);
                                }
                                
                                Element versionElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Version");
                                if (versionElement2 != null) {
                                    String versionInstance2;
                                    versionInstance2 = versionElement2.getTextContent();
                                    resourceExtensionReferenceInstance.setVersion(versionInstance2);
                                }
                                
                                Element resourceExtensionParameterValuesSequenceElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValues");
                                if (resourceExtensionParameterValuesSequenceElement != null) {
                                    for (int i25 = 0; i25 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionParameterValuesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue").size(); i25 = i25 + 1) {
                                        org.w3c.dom.Element resourceExtensionParameterValuesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionParameterValuesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue").get(i25));
                                        ResourceExtensionParameterValue resourceExtensionParameterValueInstance = new ResourceExtensionParameterValue();
                                        resourceExtensionReferenceInstance.getResourceExtensionParameterValues().add(resourceExtensionParameterValueInstance);
                                        
                                        Element keyElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Key");
                                        if (keyElement != null) {
                                            String keyInstance;
                                            keyInstance = keyElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setKey(keyInstance);
                                        }
                                        
                                        Element valueElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Value");
                                        if (valueElement != null) {
                                            String valueInstance;
                                            valueInstance = valueElement.getTextContent() != null ? new String(Base64.decode(valueElement.getTextContent())) : null;
                                            resourceExtensionParameterValueInstance.setValue(valueInstance);
                                        }
                                        
                                        Element typeElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                        if (typeElement != null) {
                                            String typeInstance;
                                            typeInstance = typeElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setType(typeInstance);
                                        }
                                    }
                                }
                                
                                Element stateElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "State");
                                if (stateElement != null) {
                                    String stateInstance;
                                    stateInstance = stateElement.getTextContent();
                                    resourceExtensionReferenceInstance.setState(stateInstance);
                                }
                            }
                        }
                        
                        Element vMImageNameElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "VMImageName");
                        if (vMImageNameElement != null) {
                            String vMImageNameInstance;
                            vMImageNameInstance = vMImageNameElement.getTextContent();
                            roleInstance.setVMImageName(vMImageNameInstance);
                        }
                        
                        Element mediaLocationElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "MediaLocation");
                        if (mediaLocationElement != null) {
                            URI mediaLocationInstance;
                            mediaLocationInstance = new URI(mediaLocationElement.getTextContent());
                            roleInstance.setMediaLocation(mediaLocationInstance);
                        }
                        
                        Element availabilitySetNameElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "AvailabilitySetName");
                        if (availabilitySetNameElement != null) {
                            String availabilitySetNameInstance;
                            availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                            roleInstance.setAvailabilitySetName(availabilitySetNameInstance);
                        }
                        
                        Element dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisks");
                        if (dataVirtualHardDisksSequenceElement != null) {
                            for (int i26 = 0; i26 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dataVirtualHardDisksSequenceElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk").size(); i26 = i26 + 1) {
                                org.w3c.dom.Element dataVirtualHardDisksElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dataVirtualHardDisksSequenceElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk").get(i26));
                                DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                                roleInstance.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                                
                                Element hostCachingElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "HostCaching");
                                if (hostCachingElement != null) {
                                    String hostCachingInstance;
                                    hostCachingInstance = hostCachingElement.getTextContent();
                                    dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                                }
                                
                                Element diskLabelElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "DiskLabel");
                                if (diskLabelElement != null) {
                                    String diskLabelInstance;
                                    diskLabelInstance = diskLabelElement.getTextContent();
                                    dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                                }
                                
                                Element diskNameElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "DiskName");
                                if (diskNameElement != null) {
                                    String diskNameInstance;
                                    diskNameInstance = diskNameElement.getTextContent();
                                    dataVirtualHardDiskInstance.setName(diskNameInstance);
                                }
                                
                                Element lunElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "Lun");
                                if (lunElement != null && (lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty() == true) == false) {
                                    int lunInstance;
                                    lunInstance = DatatypeConverter.parseInt(lunElement.getTextContent());
                                    dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                                }
                                
                                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                                if (logicalDiskSizeInGBElement != null && (logicalDiskSizeInGBElement.getTextContent() == null || logicalDiskSizeInGBElement.getTextContent().isEmpty() == true) == false) {
                                    int logicalDiskSizeInGBInstance;
                                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                                    dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                                }
                                
                                Element mediaLinkElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                                if (mediaLinkElement != null) {
                                    URI mediaLinkInstance;
                                    mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                    dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                                }
                                
                                Element sourceMediaLinkElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
                                if (sourceMediaLinkElement != null) {
                                    URI sourceMediaLinkInstance;
                                    sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                    dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                                }
                                
                                Element iOTypeElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                                if (iOTypeElement != null) {
                                    String iOTypeInstance;
                                    iOTypeInstance = iOTypeElement.getTextContent();
                                    dataVirtualHardDiskInstance.setIOType(iOTypeInstance);
                                }
                            }
                        }
                        
                        Element labelElement2 = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "Label");
                        if (labelElement2 != null) {
                            String labelInstance2;
                            labelInstance2 = labelElement2.getTextContent();
                            roleInstance.setLabel(labelInstance2);
                        }
                        
                        Element oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "OSVirtualHardDisk");
                        if (oSVirtualHardDiskElement != null) {
                            OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                            roleInstance.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                            
                            Element hostCachingElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "HostCaching");
                            if (hostCachingElement2 != null) {
                                String hostCachingInstance2;
                                hostCachingInstance2 = hostCachingElement2.getTextContent();
                                oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                            }
                            
                            Element diskLabelElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskLabel");
                            if (diskLabelElement2 != null) {
                                String diskLabelInstance2;
                                diskLabelInstance2 = diskLabelElement2.getTextContent();
                                oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                            }
                            
                            Element diskNameElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskName");
                            if (diskNameElement2 != null) {
                                String diskNameInstance2;
                                diskNameInstance2 = diskNameElement2.getTextContent();
                                oSVirtualHardDiskInstance.setName(diskNameInstance2);
                            }
                            
                            Element mediaLinkElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                            if (mediaLinkElement2 != null) {
                                URI mediaLinkInstance2;
                                mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                            }
                            
                            Element sourceImageNameElement = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "SourceImageName");
                            if (sourceImageNameElement != null) {
                                String sourceImageNameInstance;
                                sourceImageNameInstance = sourceImageNameElement.getTextContent();
                                oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                            }
                            
                            Element osElement = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "OS");
                            if (osElement != null) {
                                String osInstance;
                                osInstance = osElement.getTextContent();
                                oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                            }
                            
                            Element iOTypeElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                            if (iOTypeElement2 != null) {
                                String iOTypeInstance2;
                                iOTypeInstance2 = iOTypeElement2.getTextContent();
                                oSVirtualHardDiskInstance.setIOType(iOTypeInstance2);
                            }
                        }
                        
                        Element roleSizeElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleSize");
                        if (roleSizeElement != null) {
                            String roleSizeInstance;
                            roleSizeInstance = roleSizeElement.getTextContent();
                            roleInstance.setRoleSize(roleSizeInstance);
                        }
                        
                        Element defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "DefaultWinRmCertificateThumbprint");
                        if (defaultWinRmCertificateThumbprintElement != null) {
                            String defaultWinRmCertificateThumbprintInstance;
                            defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                            roleInstance.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                        }
                        
                        Element provisionGuestAgentElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ProvisionGuestAgent");
                        if (provisionGuestAgentElement != null && (provisionGuestAgentElement.getTextContent() == null || provisionGuestAgentElement.getTextContent().isEmpty() == true) == false) {
                            boolean provisionGuestAgentInstance;
                            provisionGuestAgentInstance = DatatypeConverter.parseBoolean(provisionGuestAgentElement.getTextContent().toLowerCase());
                            roleInstance.setProvisionGuestAgent(provisionGuestAgentInstance);
                        }
                    }
                }
                
                Element sdkVersionElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "SdkVersion");
                if (sdkVersionElement != null) {
                    String sdkVersionInstance;
                    sdkVersionInstance = sdkVersionElement.getTextContent();
                    result.setSdkVersion(sdkVersionInstance);
                }
                
                Element lockedElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Locked");
                if (lockedElement != null && (lockedElement.getTextContent() == null || lockedElement.getTextContent().isEmpty() == true) == false) {
                    boolean lockedInstance;
                    lockedInstance = DatatypeConverter.parseBoolean(lockedElement.getTextContent().toLowerCase());
                    result.setLocked(lockedInstance);
                }
                
                Element rollbackAllowedElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RollbackAllowed");
                if (rollbackAllowedElement != null && (rollbackAllowedElement.getTextContent() == null || rollbackAllowedElement.getTextContent().isEmpty() == true) == false) {
                    boolean rollbackAllowedInstance;
                    rollbackAllowedInstance = DatatypeConverter.parseBoolean(rollbackAllowedElement.getTextContent().toLowerCase());
                    result.setRollbackAllowed(rollbackAllowedInstance);
                }
                
                Element virtualNetworkNameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "VirtualNetworkName");
                if (virtualNetworkNameElement != null) {
                    String virtualNetworkNameInstance;
                    virtualNetworkNameInstance = virtualNetworkNameElement.getTextContent();
                    result.setVirtualNetworkName(virtualNetworkNameInstance);
                }
                
                Element createdTimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "CreatedTime");
                if (createdTimeElement != null) {
                    Calendar createdTimeInstance;
                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                    result.setCreatedTime(createdTimeInstance);
                }
                
                Element lastModifiedTimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "LastModifiedTime");
                if (lastModifiedTimeElement != null) {
                    Calendar lastModifiedTimeInstance;
                    lastModifiedTimeInstance = DatatypeConverter.parseDateTime(lastModifiedTimeElement.getTextContent());
                    result.setLastModifiedTime(lastModifiedTimeInstance);
                }
                
                Element extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                if (extendedPropertiesSequenceElement != null) {
                    for (int i27 = 0; i27 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").size(); i27 = i27 + 1) {
                        org.w3c.dom.Element extendedPropertiesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").get(i27));
                        String extendedPropertiesKey = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Name").getTextContent();
                        String extendedPropertiesValue = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                        result.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                    }
                }
                
                Element dnsElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Dns");
                if (dnsElement != null) {
                    DnsSettings dnsInstance = new DnsSettings();
                    result.setDnsSettings(dnsInstance);
                    
                    Element dnsServersSequenceElement = XmlUtility.getElementByTagNameNS(dnsElement, "http://schemas.microsoft.com/windowsazure", "DnsServers");
                    if (dnsServersSequenceElement != null) {
                        for (int i28 = 0; i28 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dnsServersSequenceElement, "http://schemas.microsoft.com/windowsazure", "DnsServer").size(); i28 = i28 + 1) {
                            org.w3c.dom.Element dnsServersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dnsServersSequenceElement, "http://schemas.microsoft.com/windowsazure", "DnsServer").get(i28));
                            DnsServer dnsServerInstance = new DnsServer();
                            dnsInstance.getDnsServers().add(dnsServerInstance);
                            
                            Element nameElement11 = XmlUtility.getElementByTagNameNS(dnsServersElement, "http://schemas.microsoft.com/windowsazure", "Name");
                            if (nameElement11 != null) {
                                String nameInstance11;
                                nameInstance11 = nameElement11.getTextContent();
                                dnsServerInstance.setName(nameInstance11);
                            }
                            
                            Element addressElement3 = XmlUtility.getElementByTagNameNS(dnsServersElement, "http://schemas.microsoft.com/windowsazure", "Address");
                            if (addressElement3 != null) {
                                InetAddress addressInstance3;
                                addressInstance3 = InetAddress.getByName(addressElement3.getTextContent());
                                dnsServerInstance.setAddress(addressInstance3);
                            }
                        }
                    }
                }
                
                Element persistentVMDowntimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "PersistentVMDowntime");
                if (persistentVMDowntimeElement != null) {
                    PersistentVMDowntime persistentVMDowntimeInstance = new PersistentVMDowntime();
                    result.setPersistentVMDowntime(persistentVMDowntimeInstance);
                    
                    Element startTimeElement = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "StartTime");
                    if (startTimeElement != null) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeElement.getTextContent());
                        persistentVMDowntimeInstance.setStartTime(startTimeInstance);
                    }
                    
                    Element endTimeElement = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "EndTime");
                    if (endTimeElement != null) {
                        Calendar endTimeInstance;
                        endTimeInstance = DatatypeConverter.parseDateTime(endTimeElement.getTextContent());
                        persistentVMDowntimeInstance.setEndTime(endTimeInstance);
                    }
                    
                    Element statusElement6 = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "Status");
                    if (statusElement6 != null) {
                        String statusInstance6;
                        statusInstance6 = statusElement6.getTextContent();
                        persistentVMDowntimeInstance.setStatus(statusInstance6);
                    }
                }
                
                Element virtualIPsSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "VirtualIPs");
                if (virtualIPsSequenceElement != null) {
                    for (int i29 = 0; i29 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(virtualIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "VirtualIP").size(); i29 = i29 + 1) {
                        org.w3c.dom.Element virtualIPsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(virtualIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "VirtualIP").get(i29));
                        VirtualIPAddress virtualIPInstance = new VirtualIPAddress();
                        result.getVirtualIPAddresses().add(virtualIPInstance);
                        
                        Element addressElement4 = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                        if (addressElement4 != null) {
                            InetAddress addressInstance4;
                            addressInstance4 = InetAddress.getByName(addressElement4.getTextContent());
                            virtualIPInstance.setAddress(addressInstance4);
                        }
                        
                        Element nameElement12 = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement12 != null) {
                            String nameInstance12;
                            nameInstance12 = nameElement12.getTextContent();
                            virtualIPInstance.setName(nameInstance12);
                        }
                        
                        Element isDnsProgrammedElement = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "IsDnsProgrammed");
                        if (isDnsProgrammedElement != null && (isDnsProgrammedElement.getTextContent() == null || isDnsProgrammedElement.getTextContent().isEmpty() == true) == false) {
                            boolean isDnsProgrammedInstance;
                            isDnsProgrammedInstance = DatatypeConverter.parseBoolean(isDnsProgrammedElement.getTextContent().toLowerCase());
                            virtualIPInstance.setIsDnsProgrammed(isDnsProgrammedInstance);
                        }
                    }
                }
                
                Element extensionConfigurationElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
                if (extensionConfigurationElement != null) {
                    ExtensionConfiguration extensionConfigurationInstance = new ExtensionConfiguration();
                    result.setExtensionConfiguration(extensionConfigurationInstance);
                    
                    Element allRolesSequenceElement = XmlUtility.getElementByTagNameNS(extensionConfigurationElement, "http://schemas.microsoft.com/windowsazure", "AllRoles");
                    if (allRolesSequenceElement != null) {
                        for (int i30 = 0; i30 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(allRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").size(); i30 = i30 + 1) {
                            org.w3c.dom.Element allRolesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(allRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").get(i30));
                            ExtensionConfiguration.Extension extensionInstance = new ExtensionConfiguration.Extension();
                            extensionConfigurationInstance.getAllRoles().add(extensionInstance);
                            
                            Element idElement = XmlUtility.getElementByTagNameNS(allRolesElement, "http://schemas.microsoft.com/windowsazure", "Id");
                            if (idElement != null) {
                                String idInstance;
                                idInstance = idElement.getTextContent();
                                extensionInstance.setId(idInstance);
                            }
                        }
                    }
                    
                    Element namedRolesSequenceElement = XmlUtility.getElementByTagNameNS(extensionConfigurationElement, "http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    if (namedRolesSequenceElement != null) {
                        for (int i31 = 0; i31 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(namedRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").size(); i31 = i31 + 1) {
                            org.w3c.dom.Element namedRolesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(namedRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").get(i31));
                            ExtensionConfiguration.NamedRole roleInstance2 = new ExtensionConfiguration.NamedRole();
                            extensionConfigurationInstance.getNamedRoles().add(roleInstance2);
                            
                            Element roleNameElement3 = XmlUtility.getElementByTagNameNS(namedRolesElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                            if (roleNameElement3 != null) {
                                String roleNameInstance3;
                                roleNameInstance3 = roleNameElement3.getTextContent();
                                roleInstance2.setRoleName(roleNameInstance3);
                            }
                            
                            Element extensionsSequenceElement = XmlUtility.getElementByTagNameNS(namedRolesElement, "http://schemas.microsoft.com/windowsazure", "Extensions");
                            if (extensionsSequenceElement != null) {
                                for (int i32 = 0; i32 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extensionsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").size(); i32 = i32 + 1) {
                                    org.w3c.dom.Element extensionsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extensionsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").get(i32));
                                    ExtensionConfiguration.Extension extensionInstance2 = new ExtensionConfiguration.Extension();
                                    roleInstance2.getExtensions().add(extensionInstance2);
                                    
                                    Element idElement2 = XmlUtility.getElementByTagNameNS(extensionsElement, "http://schemas.microsoft.com/windowsazure", "Id");
                                    if (idElement2 != null) {
                                        String idInstance2;
                                        idInstance2 = idElement2.getTextContent();
                                        extensionInstance2.setId(idInstance2);
                                    }
                                }
                            }
                        }
                    }
                }
                
                Element reservedIPNameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ReservedIPName");
                if (reservedIPNameElement != null) {
                    String reservedIPNameInstance;
                    reservedIPNameInstance = reservedIPNameElement.getTextContent();
                    result.setReservedIPName(reservedIPNameInstance);
                }
                
                Element loadBalancersSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancers");
                if (loadBalancersSequenceElement != null) {
                    for (int i33 = 0; i33 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(loadBalancersSequenceElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancer").size(); i33 = i33 + 1) {
                        org.w3c.dom.Element loadBalancersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(loadBalancersSequenceElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancer").get(i33));
                        LoadBalancer loadBalancerInstance = new LoadBalancer();
                        result.getLoadBalancers().add(loadBalancerInstance);
                        
                        Element nameElement13 = XmlUtility.getElementByTagNameNS(loadBalancersElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement13 != null) {
                            String nameInstance13;
                            nameInstance13 = nameElement13.getTextContent();
                            loadBalancerInstance.setName(nameInstance13);
                        }
                        
                        Element frontendIpConfigurationElement = XmlUtility.getElementByTagNameNS(loadBalancersElement, "http://schemas.microsoft.com/windowsazure", "FrontendIpConfiguration");
                        if (frontendIpConfigurationElement != null) {
                            FrontendIPConfiguration frontendIpConfigurationInstance = new FrontendIPConfiguration();
                            loadBalancerInstance.setFrontendIPConfiguration(frontendIpConfigurationInstance);
                            
                            Element typeElement2 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "Type");
                            if (typeElement2 != null) {
                                String typeInstance2;
                                typeInstance2 = typeElement2.getTextContent();
                                frontendIpConfigurationInstance.setType(typeInstance2);
                            }
                            
                            Element subnetNameElement3 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                            if (subnetNameElement3 != null) {
                                String subnetNameInstance3;
                                subnetNameInstance3 = subnetNameElement3.getTextContent();
                                frontendIpConfigurationInstance.setSubnetName(subnetNameInstance3);
                            }
                            
                            Element staticVirtualNetworkIPAddressElement3 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                            if (staticVirtualNetworkIPAddressElement3 != null) {
                                InetAddress staticVirtualNetworkIPAddressInstance3;
                                staticVirtualNetworkIPAddressInstance3 = InetAddress.getByName(staticVirtualNetworkIPAddressElement3.getTextContent());
                                frontendIpConfigurationInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance3);
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Deployment By Slot operation returns configuration information,
    * status, and system properties for a deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460804.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @return A deployment that exists in the cloud service.
    */
    @Override
    public Future<DeploymentGetResponse> getBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentGetResponse>() { 
            @Override
            public DeploymentGetResponse call() throws Exception {
                return getBySlot(serviceName, deploymentSlot);
            }
         });
    }
    
    /**
    * The Get Deployment By Slot operation returns configuration information,
    * status, and system properties for a deployment.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460804.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return A deployment that exists in the cloud service.
    */
    @Override
    public DeploymentGetResponse getBySlot(String serviceName, DeploymentSlot deploymentSlot) throws IOException, ServiceException, ParserConfigurationException, SAXException, URISyntaxException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            CloudTracing.enter(invocationId, this, "getBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot;
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentGetResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DeploymentGetResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element deploymentElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "Deployment");
            if (deploymentElement != null) {
                Element nameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Name");
                if (nameElement != null) {
                    String nameInstance;
                    nameInstance = nameElement.getTextContent();
                    result.setName(nameInstance);
                }
                
                Element deploymentSlotElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "DeploymentSlot");
                if (deploymentSlotElement != null) {
                    DeploymentSlot deploymentSlotInstance;
                    deploymentSlotInstance = DeploymentSlot.valueOf(deploymentSlotElement.getTextContent());
                    result.setDeploymentSlot(deploymentSlotInstance);
                }
                
                Element privateIDElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "PrivateID");
                if (privateIDElement != null) {
                    String privateIDInstance;
                    privateIDInstance = privateIDElement.getTextContent();
                    result.setPrivateId(privateIDInstance);
                }
                
                Element statusElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Status");
                if (statusElement != null) {
                    DeploymentStatus statusInstance;
                    statusInstance = DeploymentStatus.valueOf(statusElement.getTextContent());
                    result.setStatus(statusInstance);
                }
                
                Element labelElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Label");
                if (labelElement != null) {
                    String labelInstance;
                    labelInstance = labelElement.getTextContent() != null ? new String(Base64.decode(labelElement.getTextContent())) : null;
                    result.setLabel(labelInstance);
                }
                
                Element urlElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Url");
                if (urlElement != null) {
                    URI urlInstance;
                    urlInstance = new URI(urlElement.getTextContent());
                    result.setUri(urlInstance);
                }
                
                Element configurationElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Configuration");
                if (configurationElement != null) {
                    String configurationInstance;
                    configurationInstance = configurationElement.getTextContent() != null ? new String(Base64.decode(configurationElement.getTextContent())) : null;
                    result.setConfiguration(configurationInstance);
                }
                
                Element roleInstanceListSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RoleInstanceList");
                if (roleInstanceListSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleInstanceListSequenceElement, "http://schemas.microsoft.com/windowsazure", "RoleInstance").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element roleInstanceListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleInstanceListSequenceElement, "http://schemas.microsoft.com/windowsazure", "RoleInstance").get(i1));
                        RoleInstance roleInstanceInstance = new RoleInstance();
                        result.getRoleInstances().add(roleInstanceInstance);
                        
                        Element roleNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement != null) {
                            String roleNameInstance;
                            roleNameInstance = roleNameElement.getTextContent();
                            roleInstanceInstance.setRoleName(roleNameInstance);
                        }
                        
                        Element instanceNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceName");
                        if (instanceNameElement != null) {
                            String instanceNameInstance;
                            instanceNameInstance = instanceNameElement.getTextContent();
                            roleInstanceInstance.setInstanceName(instanceNameInstance);
                        }
                        
                        Element instanceStatusElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceStatus");
                        if (instanceStatusElement != null) {
                            String instanceStatusInstance;
                            instanceStatusInstance = instanceStatusElement.getTextContent();
                            roleInstanceInstance.setInstanceStatus(instanceStatusInstance);
                        }
                        
                        Element instanceUpgradeDomainElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceUpgradeDomain");
                        if (instanceUpgradeDomainElement != null && (instanceUpgradeDomainElement.getTextContent() == null || instanceUpgradeDomainElement.getTextContent().isEmpty() == true) == false) {
                            int instanceUpgradeDomainInstance;
                            instanceUpgradeDomainInstance = DatatypeConverter.parseInt(instanceUpgradeDomainElement.getTextContent());
                            roleInstanceInstance.setInstanceUpgradeDomain(instanceUpgradeDomainInstance);
                        }
                        
                        Element instanceFaultDomainElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceFaultDomain");
                        if (instanceFaultDomainElement != null && (instanceFaultDomainElement.getTextContent() == null || instanceFaultDomainElement.getTextContent().isEmpty() == true) == false) {
                            int instanceFaultDomainInstance;
                            instanceFaultDomainInstance = DatatypeConverter.parseInt(instanceFaultDomainElement.getTextContent());
                            roleInstanceInstance.setInstanceFaultDomain(instanceFaultDomainInstance);
                        }
                        
                        Element instanceSizeElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceSize");
                        if (instanceSizeElement != null) {
                            String instanceSizeInstance;
                            instanceSizeInstance = instanceSizeElement.getTextContent();
                            roleInstanceInstance.setInstanceSize(instanceSizeInstance);
                        }
                        
                        Element instanceStateDetailsElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceStateDetails");
                        if (instanceStateDetailsElement != null) {
                            String instanceStateDetailsInstance;
                            instanceStateDetailsInstance = instanceStateDetailsElement.getTextContent();
                            roleInstanceInstance.setInstanceStateDetails(instanceStateDetailsInstance);
                        }
                        
                        Element instanceErrorCodeElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceErrorCode");
                        if (instanceErrorCodeElement != null) {
                            String instanceErrorCodeInstance;
                            instanceErrorCodeInstance = instanceErrorCodeElement.getTextContent();
                            roleInstanceInstance.setInstanceErrorCode(instanceErrorCodeInstance);
                        }
                        
                        Element ipAddressElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "IpAddress");
                        if (ipAddressElement != null) {
                            InetAddress ipAddressInstance;
                            ipAddressInstance = InetAddress.getByName(ipAddressElement.getTextContent());
                            roleInstanceInstance.setIPAddress(ipAddressInstance);
                        }
                        
                        Element instanceEndpointsSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoints");
                        if (instanceEndpointsSequenceElement != null) {
                            for (int i2 = 0; i2 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(instanceEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoint").size(); i2 = i2 + 1) {
                                org.w3c.dom.Element instanceEndpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(instanceEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InstanceEndpoint").get(i2));
                                InstanceEndpoint instanceEndpointInstance = new InstanceEndpoint();
                                roleInstanceInstance.getInstanceEndpoints().add(instanceEndpointInstance);
                                
                                Element localPortElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LocalPort");
                                if (localPortElement != null && (localPortElement.getTextContent() == null || localPortElement.getTextContent().isEmpty() == true) == false) {
                                    int localPortInstance;
                                    localPortInstance = DatatypeConverter.parseInt(localPortElement.getTextContent());
                                    instanceEndpointInstance.setLocalPort(localPortInstance);
                                }
                                
                                Element nameElement2 = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement2 != null) {
                                    String nameInstance2;
                                    nameInstance2 = nameElement2.getTextContent();
                                    instanceEndpointInstance.setName(nameInstance2);
                                }
                                
                                Element publicPortElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "PublicPort");
                                if (publicPortElement != null) {
                                    int publicPortInstance;
                                    publicPortInstance = DatatypeConverter.parseInt(publicPortElement.getTextContent());
                                    instanceEndpointInstance.setPort(publicPortInstance);
                                }
                                
                                Element protocolElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                if (protocolElement != null) {
                                    String protocolInstance;
                                    protocolInstance = protocolElement.getTextContent();
                                    instanceEndpointInstance.setProtocol(protocolInstance);
                                }
                                
                                Element vipElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Vip");
                                if (vipElement != null) {
                                    InetAddress vipInstance;
                                    vipInstance = InetAddress.getByName(vipElement.getTextContent());
                                    instanceEndpointInstance.setVirtualIPAddress(vipInstance);
                                }
                                
                                Element idleTimeoutInMinutesElement = XmlUtility.getElementByTagNameNS(instanceEndpointsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                if (idleTimeoutInMinutesElement != null && (idleTimeoutInMinutesElement.getTextContent() == null || idleTimeoutInMinutesElement.getTextContent().isEmpty() == true) == false) {
                                    int idleTimeoutInMinutesInstance;
                                    idleTimeoutInMinutesInstance = DatatypeConverter.parseInt(idleTimeoutInMinutesElement.getTextContent());
                                    instanceEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance);
                                }
                            }
                        }
                        
                        Element guestAgentStatusElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "GuestAgentStatus");
                        if (guestAgentStatusElement != null) {
                            GuestAgentStatus guestAgentStatusInstance = new GuestAgentStatus();
                            roleInstanceInstance.setGuestAgentStatus(guestAgentStatusInstance);
                            
                            Element protocolVersionElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "ProtocolVersion");
                            if (protocolVersionElement != null) {
                                String protocolVersionInstance;
                                protocolVersionInstance = protocolVersionElement.getTextContent();
                                guestAgentStatusInstance.setProtocolVersion(protocolVersionInstance);
                            }
                            
                            Element timestampElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Timestamp");
                            if (timestampElement != null && (timestampElement.getTextContent() == null || timestampElement.getTextContent().isEmpty() == true) == false) {
                                Calendar timestampInstance;
                                timestampInstance = DatatypeConverter.parseDateTime(timestampElement.getTextContent());
                                guestAgentStatusInstance.setTimestamp(timestampInstance);
                            }
                            
                            Element guestAgentVersionElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "GuestAgentVersion");
                            if (guestAgentVersionElement != null) {
                                String guestAgentVersionInstance;
                                guestAgentVersionInstance = guestAgentVersionElement.getTextContent();
                                guestAgentStatusInstance.setGuestAgentVersion(guestAgentVersionInstance);
                            }
                            
                            Element statusElement2 = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Status");
                            if (statusElement2 != null) {
                                String statusInstance2;
                                statusInstance2 = statusElement2.getTextContent();
                                guestAgentStatusInstance.setStatus(statusInstance2);
                            }
                            
                            Element codeElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Code");
                            if (codeElement != null && (codeElement.getTextContent() == null || codeElement.getTextContent().isEmpty() == true) == false) {
                                int codeInstance;
                                codeInstance = DatatypeConverter.parseInt(codeElement.getTextContent());
                                guestAgentStatusInstance.setCode(codeInstance);
                            }
                            
                            Element messageElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "Message");
                            if (messageElement != null) {
                                GuestAgentMessage messageInstance = new GuestAgentMessage();
                                guestAgentStatusInstance.setMessage(messageInstance);
                                
                                Element messageResourceIdElement = XmlUtility.getElementByTagNameNS(messageElement, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                if (messageResourceIdElement != null) {
                                    String messageResourceIdInstance;
                                    messageResourceIdInstance = messageResourceIdElement.getTextContent();
                                    messageInstance.setMessageResourceId(messageResourceIdInstance);
                                }
                                
                                Element paramListSequenceElement = XmlUtility.getElementByTagNameNS(messageElement, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                if (paramListSequenceElement != null) {
                                    for (int i3 = 0; i3 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Param").size(); i3 = i3 + 1) {
                                        org.w3c.dom.Element paramListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Param").get(i3));
                                        messageInstance.getParamList().add(paramListElement.getTextContent());
                                    }
                                }
                            }
                            
                            Element formattedMessageElement = XmlUtility.getElementByTagNameNS(guestAgentStatusElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                            if (formattedMessageElement != null) {
                                GuestAgentFormattedMessage formattedMessageInstance = new GuestAgentFormattedMessage();
                                guestAgentStatusInstance.setFormattedMessage(formattedMessageInstance);
                                
                                Element languageElement = XmlUtility.getElementByTagNameNS(formattedMessageElement, "http://schemas.microsoft.com/windowsazure", "Language");
                                if (languageElement != null) {
                                    String languageInstance;
                                    languageInstance = languageElement.getTextContent();
                                    formattedMessageInstance.setLanguage(languageInstance);
                                }
                                
                                Element messageElement2 = XmlUtility.getElementByTagNameNS(formattedMessageElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                if (messageElement2 != null) {
                                    String messageInstance2;
                                    messageInstance2 = messageElement2.getTextContent();
                                    formattedMessageInstance.setMessage(messageInstance2);
                                }
                            }
                        }
                        
                        Element resourceExtensionStatusListSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatusList");
                        if (resourceExtensionStatusListSequenceElement != null) {
                            for (int i4 = 0; i4 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatus").size(); i4 = i4 + 1) {
                                org.w3c.dom.Element resourceExtensionStatusListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionStatus").get(i4));
                                ResourceExtensionStatus resourceExtensionStatusInstance = new ResourceExtensionStatus();
                                roleInstanceInstance.getResourceExtensionStatusList().add(resourceExtensionStatusInstance);
                                
                                Element handlerNameElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "HandlerName");
                                if (handlerNameElement != null) {
                                    String handlerNameInstance;
                                    handlerNameInstance = handlerNameElement.getTextContent();
                                    resourceExtensionStatusInstance.setHandlerName(handlerNameInstance);
                                }
                                
                                Element versionElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Version");
                                if (versionElement != null) {
                                    String versionInstance;
                                    versionInstance = versionElement.getTextContent();
                                    resourceExtensionStatusInstance.setVersion(versionInstance);
                                }
                                
                                Element statusElement3 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                if (statusElement3 != null) {
                                    String statusInstance3;
                                    statusInstance3 = statusElement3.getTextContent();
                                    resourceExtensionStatusInstance.setStatus(statusInstance3);
                                }
                                
                                Element codeElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                if (codeElement2 != null && (codeElement2.getTextContent() == null || codeElement2.getTextContent().isEmpty() == true) == false) {
                                    int codeInstance2;
                                    codeInstance2 = DatatypeConverter.parseInt(codeElement2.getTextContent());
                                    resourceExtensionStatusInstance.setCode(codeInstance2);
                                }
                                
                                Element messageElement3 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                if (messageElement3 != null) {
                                    GuestAgentMessage messageInstance3 = new GuestAgentMessage();
                                    resourceExtensionStatusInstance.setMessage(messageInstance3);
                                    
                                    Element messageResourceIdElement2 = XmlUtility.getElementByTagNameNS(messageElement3, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                    if (messageResourceIdElement2 != null) {
                                        String messageResourceIdInstance2;
                                        messageResourceIdInstance2 = messageResourceIdElement2.getTextContent();
                                        messageInstance3.setMessageResourceId(messageResourceIdInstance2);
                                    }
                                    
                                    Element paramListSequenceElement2 = XmlUtility.getElementByTagNameNS(messageElement3, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                    if (paramListSequenceElement2 != null) {
                                        for (int i5 = 0; i5 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement2, "http://schemas.microsoft.com/windowsazure", "Param").size(); i5 = i5 + 1) {
                                            org.w3c.dom.Element paramListElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement2, "http://schemas.microsoft.com/windowsazure", "Param").get(i5));
                                            messageInstance3.getParamList().add(paramListElement2.getTextContent());
                                        }
                                    }
                                }
                                
                                Element formattedMessageElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                if (formattedMessageElement2 != null) {
                                    GuestAgentFormattedMessage formattedMessageInstance2 = new GuestAgentFormattedMessage();
                                    resourceExtensionStatusInstance.setFormattedMessage(formattedMessageInstance2);
                                    
                                    Element languageElement2 = XmlUtility.getElementByTagNameNS(formattedMessageElement2, "http://schemas.microsoft.com/windowsazure", "Language");
                                    if (languageElement2 != null) {
                                        String languageInstance2;
                                        languageInstance2 = languageElement2.getTextContent();
                                        formattedMessageInstance2.setLanguage(languageInstance2);
                                    }
                                    
                                    Element messageElement4 = XmlUtility.getElementByTagNameNS(formattedMessageElement2, "http://schemas.microsoft.com/windowsazure", "Message");
                                    if (messageElement4 != null) {
                                        String messageInstance4;
                                        messageInstance4 = messageElement4.getTextContent();
                                        formattedMessageInstance2.setMessage(messageInstance4);
                                    }
                                }
                                
                                Element extensionSettingStatusElement = XmlUtility.getElementByTagNameNS(resourceExtensionStatusListElement, "http://schemas.microsoft.com/windowsazure", "ExtensionSettingStatus");
                                if (extensionSettingStatusElement != null) {
                                    ResourceExtensionConfigurationStatus extensionSettingStatusInstance = new ResourceExtensionConfigurationStatus();
                                    resourceExtensionStatusInstance.setExtensionSettingStatus(extensionSettingStatusInstance);
                                    
                                    Element timestampElement2 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Timestamp");
                                    if (timestampElement2 != null && (timestampElement2.getTextContent() == null || timestampElement2.getTextContent().isEmpty() == true) == false) {
                                        Calendar timestampInstance2;
                                        timestampInstance2 = DatatypeConverter.parseDateTime(timestampElement2.getTextContent());
                                        extensionSettingStatusInstance.setTimestamp(timestampInstance2);
                                    }
                                    
                                    Element configurationAppliedTimeElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationAppliedTime");
                                    if (configurationAppliedTimeElement != null && (configurationAppliedTimeElement.getTextContent() == null || configurationAppliedTimeElement.getTextContent().isEmpty() == true) == false) {
                                        Calendar configurationAppliedTimeInstance;
                                        configurationAppliedTimeInstance = DatatypeConverter.parseDateTime(configurationAppliedTimeElement.getTextContent());
                                        extensionSettingStatusInstance.setConfigurationAppliedTime(configurationAppliedTimeInstance);
                                    }
                                    
                                    Element nameElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                    if (nameElement3 != null) {
                                        String nameInstance3;
                                        nameInstance3 = nameElement3.getTextContent();
                                        extensionSettingStatusInstance.setName(nameInstance3);
                                    }
                                    
                                    Element operationElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Operation");
                                    if (operationElement != null) {
                                        String operationInstance;
                                        operationInstance = operationElement.getTextContent();
                                        extensionSettingStatusInstance.setOperation(operationInstance);
                                    }
                                    
                                    Element statusElement4 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                    if (statusElement4 != null) {
                                        String statusInstance4;
                                        statusInstance4 = statusElement4.getTextContent();
                                        extensionSettingStatusInstance.setStatus(statusInstance4);
                                    }
                                    
                                    Element codeElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                    if (codeElement3 != null && (codeElement3.getTextContent() == null || codeElement3.getTextContent().isEmpty() == true) == false) {
                                        int codeInstance3;
                                        codeInstance3 = DatatypeConverter.parseInt(codeElement3.getTextContent());
                                        extensionSettingStatusInstance.setCode(codeInstance3);
                                    }
                                    
                                    Element messageElement5 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                    if (messageElement5 != null) {
                                        GuestAgentMessage messageInstance5 = new GuestAgentMessage();
                                        extensionSettingStatusInstance.setMessage(messageInstance5);
                                        
                                        Element messageResourceIdElement3 = XmlUtility.getElementByTagNameNS(messageElement5, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                        if (messageResourceIdElement3 != null) {
                                            String messageResourceIdInstance3;
                                            messageResourceIdInstance3 = messageResourceIdElement3.getTextContent();
                                            messageInstance5.setMessageResourceId(messageResourceIdInstance3);
                                        }
                                        
                                        Element paramListSequenceElement3 = XmlUtility.getElementByTagNameNS(messageElement5, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                        if (paramListSequenceElement3 != null) {
                                            for (int i6 = 0; i6 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement3, "http://schemas.microsoft.com/windowsazure", "Param").size(); i6 = i6 + 1) {
                                                org.w3c.dom.Element paramListElement3 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement3, "http://schemas.microsoft.com/windowsazure", "Param").get(i6));
                                                messageInstance5.getParamList().add(paramListElement3.getTextContent());
                                            }
                                        }
                                    }
                                    
                                    Element formattedMessageElement3 = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                    if (formattedMessageElement3 != null) {
                                        GuestAgentFormattedMessage formattedMessageInstance3 = new GuestAgentFormattedMessage();
                                        extensionSettingStatusInstance.setFormattedMessage(formattedMessageInstance3);
                                        
                                        Element languageElement3 = XmlUtility.getElementByTagNameNS(formattedMessageElement3, "http://schemas.microsoft.com/windowsazure", "Language");
                                        if (languageElement3 != null) {
                                            String languageInstance3;
                                            languageInstance3 = languageElement3.getTextContent();
                                            formattedMessageInstance3.setLanguage(languageInstance3);
                                        }
                                        
                                        Element messageElement6 = XmlUtility.getElementByTagNameNS(formattedMessageElement3, "http://schemas.microsoft.com/windowsazure", "Message");
                                        if (messageElement6 != null) {
                                            String messageInstance6;
                                            messageInstance6 = messageElement6.getTextContent();
                                            formattedMessageInstance3.setMessage(messageInstance6);
                                        }
                                    }
                                    
                                    Element subStatusListSequenceElement = XmlUtility.getElementByTagNameNS(extensionSettingStatusElement, "http://schemas.microsoft.com/windowsazure", "SubStatusList");
                                    if (subStatusListSequenceElement != null) {
                                        for (int i7 = 0; i7 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubStatus").size(); i7 = i7 + 1) {
                                            org.w3c.dom.Element subStatusListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subStatusListSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubStatus").get(i7));
                                            ResourceExtensionSubStatus subStatusInstance = new ResourceExtensionSubStatus();
                                            extensionSettingStatusInstance.getSubStatusList().add(subStatusInstance);
                                            
                                            Element nameElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                            if (nameElement4 != null) {
                                                String nameInstance4;
                                                nameInstance4 = nameElement4.getTextContent();
                                                subStatusInstance.setName(nameInstance4);
                                            }
                                            
                                            Element statusElement5 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Status");
                                            if (statusElement5 != null) {
                                                String statusInstance5;
                                                statusInstance5 = statusElement5.getTextContent();
                                                subStatusInstance.setStatus(statusInstance5);
                                            }
                                            
                                            Element codeElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Code");
                                            if (codeElement4 != null && (codeElement4.getTextContent() == null || codeElement4.getTextContent().isEmpty() == true) == false) {
                                                int codeInstance4;
                                                codeInstance4 = DatatypeConverter.parseInt(codeElement4.getTextContent());
                                                subStatusInstance.setCode(codeInstance4);
                                            }
                                            
                                            Element messageElement7 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "Message");
                                            if (messageElement7 != null) {
                                                GuestAgentMessage messageInstance7 = new GuestAgentMessage();
                                                subStatusInstance.setMessage(messageInstance7);
                                                
                                                Element messageResourceIdElement4 = XmlUtility.getElementByTagNameNS(messageElement7, "http://schemas.microsoft.com/windowsazure", "MessageResourceId");
                                                if (messageResourceIdElement4 != null) {
                                                    String messageResourceIdInstance4;
                                                    messageResourceIdInstance4 = messageResourceIdElement4.getTextContent();
                                                    messageInstance7.setMessageResourceId(messageResourceIdInstance4);
                                                }
                                                
                                                Element paramListSequenceElement4 = XmlUtility.getElementByTagNameNS(messageElement7, "http://schemas.microsoft.com/windowsazure", "ParamList");
                                                if (paramListSequenceElement4 != null) {
                                                    for (int i8 = 0; i8 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement4, "http://schemas.microsoft.com/windowsazure", "Param").size(); i8 = i8 + 1) {
                                                        org.w3c.dom.Element paramListElement4 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(paramListSequenceElement4, "http://schemas.microsoft.com/windowsazure", "Param").get(i8));
                                                        messageInstance7.getParamList().add(paramListElement4.getTextContent());
                                                    }
                                                }
                                            }
                                            
                                            Element formattedMessageElement4 = XmlUtility.getElementByTagNameNS(subStatusListElement, "http://schemas.microsoft.com/windowsazure", "FormattedMessage");
                                            if (formattedMessageElement4 != null) {
                                                GuestAgentFormattedMessage formattedMessageInstance4 = new GuestAgentFormattedMessage();
                                                subStatusInstance.setFormattedMessage(formattedMessageInstance4);
                                                
                                                Element languageElement4 = XmlUtility.getElementByTagNameNS(formattedMessageElement4, "http://schemas.microsoft.com/windowsazure", "Language");
                                                if (languageElement4 != null) {
                                                    String languageInstance4;
                                                    languageInstance4 = languageElement4.getTextContent();
                                                    formattedMessageInstance4.setLanguage(languageInstance4);
                                                }
                                                
                                                Element messageElement8 = XmlUtility.getElementByTagNameNS(formattedMessageElement4, "http://schemas.microsoft.com/windowsazure", "Message");
                                                if (messageElement8 != null) {
                                                    String messageInstance8;
                                                    messageInstance8 = messageElement8.getTextContent();
                                                    formattedMessageInstance4.setMessage(messageInstance8);
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        
                        Element powerStateElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "PowerState");
                        if (powerStateElement != null) {
                            RoleInstancePowerState powerStateInstance;
                            powerStateInstance = RoleInstancePowerState.valueOf(powerStateElement.getTextContent());
                            roleInstanceInstance.setPowerState(powerStateInstance);
                        }
                        
                        Element hostNameElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "HostName");
                        if (hostNameElement != null) {
                            String hostNameInstance;
                            hostNameInstance = hostNameElement.getTextContent();
                            roleInstanceInstance.setHostName(hostNameInstance);
                        }
                        
                        Element remoteAccessCertificateThumbprintElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "RemoteAccessCertificateThumbprint");
                        if (remoteAccessCertificateThumbprintElement != null) {
                            String remoteAccessCertificateThumbprintInstance;
                            remoteAccessCertificateThumbprintInstance = remoteAccessCertificateThumbprintElement.getTextContent();
                            roleInstanceInstance.setRemoteAccessCertificateThumbprint(remoteAccessCertificateThumbprintInstance);
                        }
                        
                        Element publicIPsSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "PublicIPs");
                        if (publicIPsSequenceElement != null) {
                            for (int i9 = 0; i9 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicIP").size(); i9 = i9 + 1) {
                                org.w3c.dom.Element publicIPsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicIP").get(i9));
                                RoleInstance.PublicIP publicIPInstance = new RoleInstance.PublicIP();
                                roleInstanceInstance.getPublicIPs().add(publicIPInstance);
                                
                                Element nameElement5 = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement5 != null) {
                                    String nameInstance5;
                                    nameInstance5 = nameElement5.getTextContent();
                                    publicIPInstance.setName(nameInstance5);
                                }
                                
                                Element addressElement = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                                if (addressElement != null) {
                                    InetAddress addressInstance;
                                    addressInstance = InetAddress.getByName(addressElement.getTextContent());
                                    publicIPInstance.setAddress(addressInstance);
                                }
                                
                                Element idleTimeoutInMinutesElement2 = XmlUtility.getElementByTagNameNS(publicIPsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                if (idleTimeoutInMinutesElement2 != null && (idleTimeoutInMinutesElement2.getTextContent() == null || idleTimeoutInMinutesElement2.getTextContent().isEmpty() == true) == false) {
                                    int idleTimeoutInMinutesInstance2;
                                    idleTimeoutInMinutesInstance2 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement2.getTextContent());
                                    publicIPInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance2);
                                }
                            }
                        }
                        
                        Element networkInterfacesSequenceElement = XmlUtility.getElementByTagNameNS(roleInstanceListElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                        if (networkInterfacesSequenceElement != null) {
                            for (int i10 = 0; i10 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").size(); i10 = i10 + 1) {
                                org.w3c.dom.Element networkInterfacesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").get(i10));
                                NetworkInterfaceInstance networkInterfaceInstance = new NetworkInterfaceInstance();
                                roleInstanceInstance.getNetworkInterfaces().add(networkInterfaceInstance);
                                
                                Element nameElement6 = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement6 != null) {
                                    String nameInstance6;
                                    nameInstance6 = nameElement6.getTextContent();
                                    networkInterfaceInstance.setName(nameInstance6);
                                }
                                
                                Element macAddressElement = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "MacAddress");
                                if (macAddressElement != null) {
                                    String macAddressInstance;
                                    macAddressInstance = macAddressElement.getTextContent();
                                    networkInterfaceInstance.setMacAddress(macAddressInstance);
                                }
                                
                                Element iPConfigurationsSequenceElement = XmlUtility.getElementByTagNameNS(networkInterfacesElement, "http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                                if (iPConfigurationsSequenceElement != null) {
                                    for (int i11 = 0; i11 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").size(); i11 = i11 + 1) {
                                        org.w3c.dom.Element iPConfigurationsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").get(i11));
                                        IPConfigurationInstance iPConfigurationInstance = new IPConfigurationInstance();
                                        networkInterfaceInstance.getIPConfigurations().add(iPConfigurationInstance);
                                        
                                        Element subnetNameElement = XmlUtility.getElementByTagNameNS(iPConfigurationsElement, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                                        if (subnetNameElement != null) {
                                            String subnetNameInstance;
                                            subnetNameInstance = subnetNameElement.getTextContent();
                                            iPConfigurationInstance.setSubnetName(subnetNameInstance);
                                        }
                                        
                                        Element addressElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                                        if (addressElement2 != null) {
                                            String addressInstance2;
                                            addressInstance2 = addressElement2.getTextContent();
                                            iPConfigurationInstance.setAddress(addressInstance2);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                
                Element upgradeStatusElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "UpgradeStatus");
                if (upgradeStatusElement != null) {
                    UpgradeStatus upgradeStatusInstance = new UpgradeStatus();
                    result.setUpgradeStatus(upgradeStatusInstance);
                    
                    Element upgradeTypeElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "UpgradeType");
                    if (upgradeTypeElement != null) {
                        DeploymentUpgradeType upgradeTypeInstance;
                        upgradeTypeInstance = DeploymentUpgradeType.valueOf(upgradeTypeElement.getTextContent());
                        upgradeStatusInstance.setUpgradeType(upgradeTypeInstance);
                    }
                    
                    Element currentUpgradeDomainStateElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "CurrentUpgradeDomainState");
                    if (currentUpgradeDomainStateElement != null) {
                        UpgradeDomainState currentUpgradeDomainStateInstance;
                        currentUpgradeDomainStateInstance = UpgradeDomainState.valueOf(currentUpgradeDomainStateElement.getTextContent());
                        upgradeStatusInstance.setCurrentUpgradeDomainState(currentUpgradeDomainStateInstance);
                    }
                    
                    Element currentUpgradeDomainElement = XmlUtility.getElementByTagNameNS(upgradeStatusElement, "http://schemas.microsoft.com/windowsazure", "CurrentUpgradeDomain");
                    if (currentUpgradeDomainElement != null) {
                        int currentUpgradeDomainInstance;
                        currentUpgradeDomainInstance = DatatypeConverter.parseInt(currentUpgradeDomainElement.getTextContent());
                        upgradeStatusInstance.setCurrentUpgradeDomain(currentUpgradeDomainInstance);
                    }
                }
                
                Element upgradeDomainCountElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "UpgradeDomainCount");
                if (upgradeDomainCountElement != null) {
                    int upgradeDomainCountInstance;
                    upgradeDomainCountInstance = DatatypeConverter.parseInt(upgradeDomainCountElement.getTextContent());
                    result.setUpgradeDomainCount(upgradeDomainCountInstance);
                }
                
                Element roleListSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RoleList");
                if (roleListSequenceElement != null) {
                    for (int i12 = 0; i12 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").size(); i12 = i12 + 1) {
                        org.w3c.dom.Element roleListElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(roleListSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").get(i12));
                        Role roleInstance = new Role();
                        result.getRoles().add(roleInstance);
                        
                        Element roleNameElement2 = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement2 != null) {
                            String roleNameInstance2;
                            roleNameInstance2 = roleNameElement2.getTextContent();
                            roleInstance.setRoleName(roleNameInstance2);
                        }
                        
                        Element osVersionElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "OsVersion");
                        if (osVersionElement != null) {
                            String osVersionInstance;
                            osVersionInstance = osVersionElement.getTextContent();
                            roleInstance.setOSVersion(osVersionInstance);
                        }
                        
                        Element roleTypeElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleType");
                        if (roleTypeElement != null) {
                            String roleTypeInstance;
                            roleTypeInstance = roleTypeElement.getTextContent();
                            roleInstance.setRoleType(roleTypeInstance);
                        }
                        
                        Element configurationSetsSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSets");
                        if (configurationSetsSequenceElement != null) {
                            for (int i13 = 0; i13 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(configurationSetsSequenceElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSet").size(); i13 = i13 + 1) {
                                org.w3c.dom.Element configurationSetsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(configurationSetsSequenceElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSet").get(i13));
                                ConfigurationSet configurationSetInstance = new ConfigurationSet();
                                roleInstance.getConfigurationSets().add(configurationSetInstance);
                                
                                Element configurationSetTypeElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ConfigurationSetType");
                                if (configurationSetTypeElement != null) {
                                    String configurationSetTypeInstance;
                                    configurationSetTypeInstance = configurationSetTypeElement.getTextContent();
                                    configurationSetInstance.setConfigurationSetType(configurationSetTypeInstance);
                                }
                                
                                Element inputEndpointsSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoints");
                                if (inputEndpointsSequenceElement != null) {
                                    for (int i14 = 0; i14 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(inputEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoint").size(); i14 = i14 + 1) {
                                        org.w3c.dom.Element inputEndpointsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(inputEndpointsSequenceElement, "http://schemas.microsoft.com/windowsazure", "InputEndpoint").get(i14));
                                        InputEndpoint inputEndpointInstance = new InputEndpoint();
                                        configurationSetInstance.getInputEndpoints().add(inputEndpointInstance);
                                        
                                        Element loadBalancedEndpointSetNameElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancedEndpointSetName");
                                        if (loadBalancedEndpointSetNameElement != null) {
                                            String loadBalancedEndpointSetNameInstance;
                                            loadBalancedEndpointSetNameInstance = loadBalancedEndpointSetNameElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancedEndpointSetName(loadBalancedEndpointSetNameInstance);
                                        }
                                        
                                        Element localPortElement2 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LocalPort");
                                        if (localPortElement2 != null && (localPortElement2.getTextContent() == null || localPortElement2.getTextContent().isEmpty() == true) == false) {
                                            int localPortInstance2;
                                            localPortInstance2 = DatatypeConverter.parseInt(localPortElement2.getTextContent());
                                            inputEndpointInstance.setLocalPort(localPortInstance2);
                                        }
                                        
                                        Element nameElement7 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement7 != null) {
                                            String nameInstance7;
                                            nameInstance7 = nameElement7.getTextContent();
                                            inputEndpointInstance.setName(nameInstance7);
                                        }
                                        
                                        Element portElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Port");
                                        if (portElement != null && (portElement.getTextContent() == null || portElement.getTextContent().isEmpty() == true) == false) {
                                            int portInstance;
                                            portInstance = DatatypeConverter.parseInt(portElement.getTextContent());
                                            inputEndpointInstance.setPort(portInstance);
                                        }
                                        
                                        Element loadBalancerProbeElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerProbe");
                                        if (loadBalancerProbeElement != null) {
                                            LoadBalancerProbe loadBalancerProbeInstance = new LoadBalancerProbe();
                                            inputEndpointInstance.setLoadBalancerProbe(loadBalancerProbeInstance);
                                            
                                            Element pathElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement != null) {
                                                String pathInstance;
                                                pathInstance = pathElement.getTextContent();
                                                loadBalancerProbeInstance.setPath(pathInstance);
                                            }
                                            
                                            Element portElement2 = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Port");
                                            if (portElement2 != null) {
                                                int portInstance2;
                                                portInstance2 = DatatypeConverter.parseInt(portElement2.getTextContent());
                                                loadBalancerProbeInstance.setPort(portInstance2);
                                            }
                                            
                                            Element protocolElement2 = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                            if (protocolElement2 != null) {
                                                LoadBalancerProbeTransportProtocol protocolInstance2;
                                                protocolInstance2 = com.microsoft.windowsazure.management.compute.ComputeManagementClientImpl.parseLoadBalancerProbeTransportProtocol(protocolElement2.getTextContent());
                                                loadBalancerProbeInstance.setProtocol(protocolInstance2);
                                            }
                                            
                                            Element intervalInSecondsElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "IntervalInSeconds");
                                            if (intervalInSecondsElement != null && (intervalInSecondsElement.getTextContent() == null || intervalInSecondsElement.getTextContent().isEmpty() == true) == false) {
                                                int intervalInSecondsInstance;
                                                intervalInSecondsInstance = DatatypeConverter.parseInt(intervalInSecondsElement.getTextContent());
                                                loadBalancerProbeInstance.setIntervalInSeconds(intervalInSecondsInstance);
                                            }
                                            
                                            Element timeoutInSecondsElement = XmlUtility.getElementByTagNameNS(loadBalancerProbeElement, "http://schemas.microsoft.com/windowsazure", "TimeoutInSeconds");
                                            if (timeoutInSecondsElement != null && (timeoutInSecondsElement.getTextContent() == null || timeoutInSecondsElement.getTextContent().isEmpty() == true) == false) {
                                                int timeoutInSecondsInstance;
                                                timeoutInSecondsInstance = DatatypeConverter.parseInt(timeoutInSecondsElement.getTextContent());
                                                loadBalancerProbeInstance.setTimeoutInSeconds(timeoutInSecondsInstance);
                                            }
                                        }
                                        
                                        Element protocolElement3 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                        if (protocolElement3 != null) {
                                            String protocolInstance3;
                                            protocolInstance3 = protocolElement3.getTextContent();
                                            inputEndpointInstance.setProtocol(protocolInstance3);
                                        }
                                        
                                        Element vipElement2 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "Vip");
                                        if (vipElement2 != null) {
                                            InetAddress vipInstance2;
                                            vipInstance2 = InetAddress.getByName(vipElement2.getTextContent());
                                            inputEndpointInstance.setVirtualIPAddress(vipInstance2);
                                        }
                                        
                                        Element enableDirectServerReturnElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "EnableDirectServerReturn");
                                        if (enableDirectServerReturnElement != null && (enableDirectServerReturnElement.getTextContent() == null || enableDirectServerReturnElement.getTextContent().isEmpty() == true) == false) {
                                            boolean enableDirectServerReturnInstance;
                                            enableDirectServerReturnInstance = DatatypeConverter.parseBoolean(enableDirectServerReturnElement.getTextContent().toLowerCase());
                                            inputEndpointInstance.setEnableDirectServerReturn(enableDirectServerReturnInstance);
                                        }
                                        
                                        Element loadBalancerNameElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerName");
                                        if (loadBalancerNameElement != null) {
                                            String loadBalancerNameInstance;
                                            loadBalancerNameInstance = loadBalancerNameElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancerName(loadBalancerNameInstance);
                                        }
                                        
                                        Element endpointAclElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "EndpointAcl");
                                        if (endpointAclElement != null) {
                                            EndpointAcl endpointAclInstance = new EndpointAcl();
                                            inputEndpointInstance.setEndpointAcl(endpointAclInstance);
                                            
                                            Element rulesSequenceElement = XmlUtility.getElementByTagNameNS(endpointAclElement, "http://schemas.microsoft.com/windowsazure", "Rules");
                                            if (rulesSequenceElement != null) {
                                                for (int i15 = 0; i15 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rulesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Rule").size(); i15 = i15 + 1) {
                                                    org.w3c.dom.Element rulesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rulesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Rule").get(i15));
                                                    AccessControlListRule ruleInstance = new AccessControlListRule();
                                                    endpointAclInstance.getRules().add(ruleInstance);
                                                    
                                                    Element orderElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Order");
                                                    if (orderElement != null && (orderElement.getTextContent() == null || orderElement.getTextContent().isEmpty() == true) == false) {
                                                        int orderInstance;
                                                        orderInstance = DatatypeConverter.parseInt(orderElement.getTextContent());
                                                        ruleInstance.setOrder(orderInstance);
                                                    }
                                                    
                                                    Element actionElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Action");
                                                    if (actionElement != null) {
                                                        String actionInstance;
                                                        actionInstance = actionElement.getTextContent();
                                                        ruleInstance.setAction(actionInstance);
                                                    }
                                                    
                                                    Element remoteSubnetElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "RemoteSubnet");
                                                    if (remoteSubnetElement != null) {
                                                        String remoteSubnetInstance;
                                                        remoteSubnetInstance = remoteSubnetElement.getTextContent();
                                                        ruleInstance.setRemoteSubnet(remoteSubnetInstance);
                                                    }
                                                    
                                                    Element descriptionElement = XmlUtility.getElementByTagNameNS(rulesElement, "http://schemas.microsoft.com/windowsazure", "Description");
                                                    if (descriptionElement != null) {
                                                        String descriptionInstance;
                                                        descriptionInstance = descriptionElement.getTextContent();
                                                        ruleInstance.setDescription(descriptionInstance);
                                                    }
                                                }
                                            }
                                        }
                                        
                                        Element idleTimeoutInMinutesElement3 = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                        if (idleTimeoutInMinutesElement3 != null && (idleTimeoutInMinutesElement3.getTextContent() == null || idleTimeoutInMinutesElement3.getTextContent().isEmpty() == true) == false) {
                                            int idleTimeoutInMinutesInstance3;
                                            idleTimeoutInMinutesInstance3 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement3.getTextContent());
                                            inputEndpointInstance.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance3);
                                        }
                                        
                                        Element loadBalancerDistributionElement = XmlUtility.getElementByTagNameNS(inputEndpointsElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancerDistribution");
                                        if (loadBalancerDistributionElement != null) {
                                            String loadBalancerDistributionInstance;
                                            loadBalancerDistributionInstance = loadBalancerDistributionElement.getTextContent();
                                            inputEndpointInstance.setLoadBalancerDistribution(loadBalancerDistributionInstance);
                                        }
                                    }
                                }
                                
                                Element subnetNamesSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "SubnetNames");
                                if (subnetNamesSequenceElement != null) {
                                    for (int i16 = 0; i16 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subnetNamesSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubnetName").size(); i16 = i16 + 1) {
                                        org.w3c.dom.Element subnetNamesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(subnetNamesSequenceElement, "http://schemas.microsoft.com/windowsazure", "SubnetName").get(i16));
                                        configurationSetInstance.getSubnetNames().add(subnetNamesElement.getTextContent());
                                    }
                                }
                                
                                Element staticVirtualNetworkIPAddressElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                if (staticVirtualNetworkIPAddressElement != null) {
                                    String staticVirtualNetworkIPAddressInstance;
                                    staticVirtualNetworkIPAddressInstance = staticVirtualNetworkIPAddressElement.getTextContent();
                                    configurationSetInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance);
                                }
                                
                                Element publicIPsSequenceElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "PublicIPs");
                                if (publicIPsSequenceElement2 != null) {
                                    for (int i17 = 0; i17 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "PublicIP").size(); i17 = i17 + 1) {
                                        org.w3c.dom.Element publicIPsElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicIPsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "PublicIP").get(i17));
                                        ConfigurationSet.PublicIP publicIPInstance2 = new ConfigurationSet.PublicIP();
                                        configurationSetInstance.getPublicIPs().add(publicIPInstance2);
                                        
                                        Element nameElement8 = XmlUtility.getElementByTagNameNS(publicIPsElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement8 != null) {
                                            String nameInstance8;
                                            nameInstance8 = nameElement8.getTextContent();
                                            publicIPInstance2.setName(nameInstance8);
                                        }
                                        
                                        Element idleTimeoutInMinutesElement4 = XmlUtility.getElementByTagNameNS(publicIPsElement2, "http://schemas.microsoft.com/windowsazure", "IdleTimeoutInMinutes");
                                        if (idleTimeoutInMinutesElement4 != null && (idleTimeoutInMinutesElement4.getTextContent() == null || idleTimeoutInMinutesElement4.getTextContent().isEmpty() == true) == false) {
                                            int idleTimeoutInMinutesInstance4;
                                            idleTimeoutInMinutesInstance4 = DatatypeConverter.parseInt(idleTimeoutInMinutesElement4.getTextContent());
                                            publicIPInstance2.setIdleTimeoutInMinutes(idleTimeoutInMinutesInstance4);
                                        }
                                    }
                                }
                                
                                Element networkInterfacesSequenceElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "NetworkInterfaces");
                                if (networkInterfacesSequenceElement2 != null) {
                                    for (int i18 = 0; i18 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement2, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").size(); i18 = i18 + 1) {
                                        org.w3c.dom.Element networkInterfacesElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(networkInterfacesSequenceElement2, "http://schemas.microsoft.com/windowsazure", "NetworkInterface").get(i18));
                                        NetworkInterface networkInterfaceInstance2 = new NetworkInterface();
                                        configurationSetInstance.getNetworkInterfaces().add(networkInterfaceInstance2);
                                        
                                        Element nameElement9 = XmlUtility.getElementByTagNameNS(networkInterfacesElement2, "http://schemas.microsoft.com/windowsazure", "Name");
                                        if (nameElement9 != null) {
                                            String nameInstance9;
                                            nameInstance9 = nameElement9.getTextContent();
                                            networkInterfaceInstance2.setName(nameInstance9);
                                        }
                                        
                                        Element iPConfigurationsSequenceElement2 = XmlUtility.getElementByTagNameNS(networkInterfacesElement2, "http://schemas.microsoft.com/windowsazure", "IPConfigurations");
                                        if (iPConfigurationsSequenceElement2 != null) {
                                            for (int i19 = 0; i19 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").size(); i19 = i19 + 1) {
                                                org.w3c.dom.Element iPConfigurationsElement2 = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(iPConfigurationsSequenceElement2, "http://schemas.microsoft.com/windowsazure", "IPConfiguration").get(i19));
                                                IPConfiguration iPConfigurationInstance2 = new IPConfiguration();
                                                networkInterfaceInstance2.getIPConfigurations().add(iPConfigurationInstance2);
                                                
                                                Element subnetNameElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement2, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                                                if (subnetNameElement2 != null) {
                                                    String subnetNameInstance2;
                                                    subnetNameInstance2 = subnetNameElement2.getTextContent();
                                                    iPConfigurationInstance2.setSubnetName(subnetNameInstance2);
                                                }
                                                
                                                Element staticVirtualNetworkIPAddressElement2 = XmlUtility.getElementByTagNameNS(iPConfigurationsElement2, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                                                if (staticVirtualNetworkIPAddressElement2 != null) {
                                                    String staticVirtualNetworkIPAddressInstance2;
                                                    staticVirtualNetworkIPAddressInstance2 = staticVirtualNetworkIPAddressElement2.getTextContent();
                                                    iPConfigurationInstance2.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance2);
                                                }
                                            }
                                        }
                                    }
                                }
                                
                                Element networkSecurityGroupElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "NetworkSecurityGroup");
                                if (networkSecurityGroupElement != null) {
                                    String networkSecurityGroupInstance;
                                    networkSecurityGroupInstance = networkSecurityGroupElement.getTextContent();
                                    configurationSetInstance.setNetworkSecurityGroup(networkSecurityGroupInstance);
                                }
                                
                                Element computerNameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ComputerName");
                                if (computerNameElement != null) {
                                    String computerNameInstance;
                                    computerNameInstance = computerNameElement.getTextContent();
                                    configurationSetInstance.setComputerName(computerNameInstance);
                                }
                                
                                Element adminPasswordElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "AdminPassword");
                                if (adminPasswordElement != null) {
                                    String adminPasswordInstance;
                                    adminPasswordInstance = adminPasswordElement.getTextContent();
                                    configurationSetInstance.setAdminPassword(adminPasswordInstance);
                                }
                                
                                Element resetPasswordOnFirstLogonElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "ResetPasswordOnFirstLogon");
                                if (resetPasswordOnFirstLogonElement != null && (resetPasswordOnFirstLogonElement.getTextContent() == null || resetPasswordOnFirstLogonElement.getTextContent().isEmpty() == true) == false) {
                                    boolean resetPasswordOnFirstLogonInstance;
                                    resetPasswordOnFirstLogonInstance = DatatypeConverter.parseBoolean(resetPasswordOnFirstLogonElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setResetPasswordOnFirstLogon(resetPasswordOnFirstLogonInstance);
                                }
                                
                                Element enableAutomaticUpdatesElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "EnableAutomaticUpdates");
                                if (enableAutomaticUpdatesElement != null && (enableAutomaticUpdatesElement.getTextContent() == null || enableAutomaticUpdatesElement.getTextContent().isEmpty() == true) == false) {
                                    boolean enableAutomaticUpdatesInstance;
                                    enableAutomaticUpdatesInstance = DatatypeConverter.parseBoolean(enableAutomaticUpdatesElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setEnableAutomaticUpdates(enableAutomaticUpdatesInstance);
                                }
                                
                                Element timeZoneElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "TimeZone");
                                if (timeZoneElement != null) {
                                    String timeZoneInstance;
                                    timeZoneInstance = timeZoneElement.getTextContent();
                                    configurationSetInstance.setTimeZone(timeZoneInstance);
                                }
                                
                                Element domainJoinElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "DomainJoin");
                                if (domainJoinElement != null) {
                                    DomainJoinSettings domainJoinInstance = new DomainJoinSettings();
                                    configurationSetInstance.setDomainJoin(domainJoinInstance);
                                    
                                    Element credentialsElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "Credentials");
                                    if (credentialsElement != null) {
                                        DomainJoinCredentials credentialsInstance = new DomainJoinCredentials();
                                        domainJoinInstance.setCredentials(credentialsInstance);
                                        
                                        Element domainElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Domain");
                                        if (domainElement != null) {
                                            String domainInstance;
                                            domainInstance = domainElement.getTextContent();
                                            credentialsInstance.setDomain(domainInstance);
                                        }
                                        
                                        Element usernameElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Username");
                                        if (usernameElement != null) {
                                            String usernameInstance;
                                            usernameInstance = usernameElement.getTextContent();
                                            credentialsInstance.setUserName(usernameInstance);
                                        }
                                        
                                        Element passwordElement = XmlUtility.getElementByTagNameNS(credentialsElement, "http://schemas.microsoft.com/windowsazure", "Password");
                                        if (passwordElement != null) {
                                            String passwordInstance;
                                            passwordInstance = passwordElement.getTextContent();
                                            credentialsInstance.setPassword(passwordInstance);
                                        }
                                    }
                                    
                                    Element joinDomainElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "JoinDomain");
                                    if (joinDomainElement != null) {
                                        String joinDomainInstance;
                                        joinDomainInstance = joinDomainElement.getTextContent();
                                        domainJoinInstance.setDomainToJoin(joinDomainInstance);
                                    }
                                    
                                    Element machineObjectOUElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "MachineObjectOU");
                                    if (machineObjectOUElement != null) {
                                        String machineObjectOUInstance;
                                        machineObjectOUInstance = machineObjectOUElement.getTextContent();
                                        domainJoinInstance.setLdapMachineObjectOU(machineObjectOUInstance);
                                    }
                                    
                                    Element provisioningElement = XmlUtility.getElementByTagNameNS(domainJoinElement, "http://schemas.microsoft.com/windowsazure", "Provisioning");
                                    if (provisioningElement != null) {
                                        DomainJoinProvisioning provisioningInstance = new DomainJoinProvisioning();
                                        domainJoinInstance.setProvisioning(provisioningInstance);
                                        
                                        Element accountDataElement = XmlUtility.getElementByTagNameNS(provisioningElement, "http://schemas.microsoft.com/windowsazure", "AccountData");
                                        if (accountDataElement != null) {
                                            String accountDataInstance;
                                            accountDataInstance = accountDataElement.getTextContent();
                                            provisioningInstance.setAccountData(accountDataInstance);
                                        }
                                    }
                                }
                                
                                Element storedCertificateSettingsSequenceElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "StoredCertificateSettings");
                                if (storedCertificateSettingsSequenceElement != null) {
                                    for (int i20 = 0; i20 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storedCertificateSettingsSequenceElement, "http://schemas.microsoft.com/windowsazure", "CertificateSetting").size(); i20 = i20 + 1) {
                                        org.w3c.dom.Element storedCertificateSettingsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(storedCertificateSettingsSequenceElement, "http://schemas.microsoft.com/windowsazure", "CertificateSetting").get(i20));
                                        StoredCertificateSettings certificateSettingInstance = new StoredCertificateSettings();
                                        configurationSetInstance.getStoredCertificateSettings().add(certificateSettingInstance);
                                        
                                        Element storeLocationElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "StoreLocation");
                                        if (storeLocationElement != null) {
                                        }
                                        
                                        Element storeNameElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "StoreName");
                                        if (storeNameElement != null) {
                                            String storeNameInstance;
                                            storeNameInstance = storeNameElement.getTextContent();
                                            certificateSettingInstance.setStoreName(storeNameInstance);
                                        }
                                        
                                        Element thumbprintElement = XmlUtility.getElementByTagNameNS(storedCertificateSettingsElement, "http://schemas.microsoft.com/windowsazure", "Thumbprint");
                                        if (thumbprintElement != null) {
                                            String thumbprintInstance;
                                            thumbprintInstance = thumbprintElement.getTextContent();
                                            certificateSettingInstance.setThumbprint(thumbprintInstance);
                                        }
                                    }
                                }
                                
                                Element winRMElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "WinRM");
                                if (winRMElement != null) {
                                    WindowsRemoteManagementSettings winRMInstance = new WindowsRemoteManagementSettings();
                                    configurationSetInstance.setWindowsRemoteManagement(winRMInstance);
                                    
                                    Element listenersSequenceElement = XmlUtility.getElementByTagNameNS(winRMElement, "http://schemas.microsoft.com/windowsazure", "Listeners");
                                    if (listenersSequenceElement != null) {
                                        for (int i21 = 0; i21 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(listenersSequenceElement, "http://schemas.microsoft.com/windowsazure", "Listener").size(); i21 = i21 + 1) {
                                            org.w3c.dom.Element listenersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(listenersSequenceElement, "http://schemas.microsoft.com/windowsazure", "Listener").get(i21));
                                            WindowsRemoteManagementListener listenerInstance = new WindowsRemoteManagementListener();
                                            winRMInstance.getListeners().add(listenerInstance);
                                            
                                            Element protocolElement4 = XmlUtility.getElementByTagNameNS(listenersElement, "http://schemas.microsoft.com/windowsazure", "Protocol");
                                            if (protocolElement4 != null) {
                                                VirtualMachineWindowsRemoteManagementListenerType protocolInstance4;
                                                protocolInstance4 = VirtualMachineWindowsRemoteManagementListenerType.valueOf(protocolElement4.getTextContent());
                                                listenerInstance.setListenerType(protocolInstance4);
                                            }
                                            
                                            Element certificateThumbprintElement = XmlUtility.getElementByTagNameNS(listenersElement, "http://schemas.microsoft.com/windowsazure", "CertificateThumbprint");
                                            if (certificateThumbprintElement != null) {
                                                String certificateThumbprintInstance;
                                                certificateThumbprintInstance = certificateThumbprintElement.getTextContent();
                                                listenerInstance.setCertificateThumbprint(certificateThumbprintInstance);
                                            }
                                        }
                                    }
                                }
                                
                                Element adminUsernameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "AdminUsername");
                                if (adminUsernameElement != null) {
                                    String adminUsernameInstance;
                                    adminUsernameInstance = adminUsernameElement.getTextContent();
                                    configurationSetInstance.setAdminUserName(adminUsernameInstance);
                                }
                                
                                Element hostNameElement2 = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "HostName");
                                if (hostNameElement2 != null) {
                                    String hostNameInstance2;
                                    hostNameInstance2 = hostNameElement2.getTextContent();
                                    configurationSetInstance.setHostName(hostNameInstance2);
                                }
                                
                                Element userNameElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "UserName");
                                if (userNameElement != null) {
                                    String userNameInstance;
                                    userNameInstance = userNameElement.getTextContent();
                                    configurationSetInstance.setUserName(userNameInstance);
                                }
                                
                                Element userPasswordElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "UserPassword");
                                if (userPasswordElement != null) {
                                    String userPasswordInstance;
                                    userPasswordInstance = userPasswordElement.getTextContent();
                                    configurationSetInstance.setUserPassword(userPasswordInstance);
                                }
                                
                                Element disableSshPasswordAuthenticationElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "DisableSshPasswordAuthentication");
                                if (disableSshPasswordAuthenticationElement != null && (disableSshPasswordAuthenticationElement.getTextContent() == null || disableSshPasswordAuthenticationElement.getTextContent().isEmpty() == true) == false) {
                                    boolean disableSshPasswordAuthenticationInstance;
                                    disableSshPasswordAuthenticationInstance = DatatypeConverter.parseBoolean(disableSshPasswordAuthenticationElement.getTextContent().toLowerCase());
                                    configurationSetInstance.setDisableSshPasswordAuthentication(disableSshPasswordAuthenticationInstance);
                                }
                                
                                Element sSHElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "SSH");
                                if (sSHElement != null) {
                                    SshSettings sSHInstance = new SshSettings();
                                    configurationSetInstance.setSshSettings(sSHInstance);
                                    
                                    Element publicKeysSequenceElement = XmlUtility.getElementByTagNameNS(sSHElement, "http://schemas.microsoft.com/windowsazure", "PublicKeys");
                                    if (publicKeysSequenceElement != null) {
                                        for (int i22 = 0; i22 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicKeysSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicKey").size(); i22 = i22 + 1) {
                                            org.w3c.dom.Element publicKeysElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(publicKeysSequenceElement, "http://schemas.microsoft.com/windowsazure", "PublicKey").get(i22));
                                            SshSettingPublicKey publicKeyInstance = new SshSettingPublicKey();
                                            sSHInstance.getPublicKeys().add(publicKeyInstance);
                                            
                                            Element fingerprintElement = XmlUtility.getElementByTagNameNS(publicKeysElement, "http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                            if (fingerprintElement != null) {
                                                String fingerprintInstance;
                                                fingerprintInstance = fingerprintElement.getTextContent();
                                                publicKeyInstance.setFingerprint(fingerprintInstance);
                                            }
                                            
                                            Element pathElement2 = XmlUtility.getElementByTagNameNS(publicKeysElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement2 != null) {
                                                String pathInstance2;
                                                pathInstance2 = pathElement2.getTextContent();
                                                publicKeyInstance.setPath(pathInstance2);
                                            }
                                        }
                                    }
                                    
                                    Element keyPairsSequenceElement = XmlUtility.getElementByTagNameNS(sSHElement, "http://schemas.microsoft.com/windowsazure", "KeyPairs");
                                    if (keyPairsSequenceElement != null) {
                                        for (int i23 = 0; i23 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(keyPairsSequenceElement, "http://schemas.microsoft.com/windowsazure", "KeyPair").size(); i23 = i23 + 1) {
                                            org.w3c.dom.Element keyPairsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(keyPairsSequenceElement, "http://schemas.microsoft.com/windowsazure", "KeyPair").get(i23));
                                            SshSettingKeyPair keyPairInstance = new SshSettingKeyPair();
                                            sSHInstance.getKeyPairs().add(keyPairInstance);
                                            
                                            Element fingerprintElement2 = XmlUtility.getElementByTagNameNS(keyPairsElement, "http://schemas.microsoft.com/windowsazure", "Fingerprint");
                                            if (fingerprintElement2 != null) {
                                                String fingerprintInstance2;
                                                fingerprintInstance2 = fingerprintElement2.getTextContent();
                                                keyPairInstance.setFingerprint(fingerprintInstance2);
                                            }
                                            
                                            Element pathElement3 = XmlUtility.getElementByTagNameNS(keyPairsElement, "http://schemas.microsoft.com/windowsazure", "Path");
                                            if (pathElement3 != null) {
                                                String pathInstance3;
                                                pathInstance3 = pathElement3.getTextContent();
                                                keyPairInstance.setPath(pathInstance3);
                                            }
                                        }
                                    }
                                }
                                
                                Element customDataElement = XmlUtility.getElementByTagNameNS(configurationSetsElement, "http://schemas.microsoft.com/windowsazure", "CustomData");
                                if (customDataElement != null) {
                                    String customDataInstance;
                                    customDataInstance = customDataElement.getTextContent();
                                    configurationSetInstance.setCustomData(customDataInstance);
                                }
                            }
                        }
                        
                        Element resourceExtensionReferencesSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReferences");
                        if (resourceExtensionReferencesSequenceElement != null) {
                            for (int i24 = 0; i24 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionReferencesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference").size(); i24 = i24 + 1) {
                                org.w3c.dom.Element resourceExtensionReferencesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionReferencesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionReference").get(i24));
                                ResourceExtensionReference resourceExtensionReferenceInstance = new ResourceExtensionReference();
                                roleInstance.getResourceExtensionReferences().add(resourceExtensionReferenceInstance);
                                
                                Element referenceNameElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "ReferenceName");
                                if (referenceNameElement != null) {
                                    String referenceNameInstance;
                                    referenceNameInstance = referenceNameElement.getTextContent();
                                    resourceExtensionReferenceInstance.setReferenceName(referenceNameInstance);
                                }
                                
                                Element publisherElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Publisher");
                                if (publisherElement != null) {
                                    String publisherInstance;
                                    publisherInstance = publisherElement.getTextContent();
                                    resourceExtensionReferenceInstance.setPublisher(publisherInstance);
                                }
                                
                                Element nameElement10 = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Name");
                                if (nameElement10 != null) {
                                    String nameInstance10;
                                    nameInstance10 = nameElement10.getTextContent();
                                    resourceExtensionReferenceInstance.setName(nameInstance10);
                                }
                                
                                Element versionElement2 = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "Version");
                                if (versionElement2 != null) {
                                    String versionInstance2;
                                    versionInstance2 = versionElement2.getTextContent();
                                    resourceExtensionReferenceInstance.setVersion(versionInstance2);
                                }
                                
                                Element resourceExtensionParameterValuesSequenceElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValues");
                                if (resourceExtensionParameterValuesSequenceElement != null) {
                                    for (int i25 = 0; i25 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionParameterValuesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue").size(); i25 = i25 + 1) {
                                        org.w3c.dom.Element resourceExtensionParameterValuesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(resourceExtensionParameterValuesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ResourceExtensionParameterValue").get(i25));
                                        ResourceExtensionParameterValue resourceExtensionParameterValueInstance = new ResourceExtensionParameterValue();
                                        resourceExtensionReferenceInstance.getResourceExtensionParameterValues().add(resourceExtensionParameterValueInstance);
                                        
                                        Element keyElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Key");
                                        if (keyElement != null) {
                                            String keyInstance;
                                            keyInstance = keyElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setKey(keyInstance);
                                        }
                                        
                                        Element valueElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Value");
                                        if (valueElement != null) {
                                            String valueInstance;
                                            valueInstance = valueElement.getTextContent() != null ? new String(Base64.decode(valueElement.getTextContent())) : null;
                                            resourceExtensionParameterValueInstance.setValue(valueInstance);
                                        }
                                        
                                        Element typeElement = XmlUtility.getElementByTagNameNS(resourceExtensionParameterValuesElement, "http://schemas.microsoft.com/windowsazure", "Type");
                                        if (typeElement != null) {
                                            String typeInstance;
                                            typeInstance = typeElement.getTextContent();
                                            resourceExtensionParameterValueInstance.setType(typeInstance);
                                        }
                                    }
                                }
                                
                                Element stateElement = XmlUtility.getElementByTagNameNS(resourceExtensionReferencesElement, "http://schemas.microsoft.com/windowsazure", "State");
                                if (stateElement != null) {
                                    String stateInstance;
                                    stateInstance = stateElement.getTextContent();
                                    resourceExtensionReferenceInstance.setState(stateInstance);
                                }
                            }
                        }
                        
                        Element vMImageNameElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "VMImageName");
                        if (vMImageNameElement != null) {
                            String vMImageNameInstance;
                            vMImageNameInstance = vMImageNameElement.getTextContent();
                            roleInstance.setVMImageName(vMImageNameInstance);
                        }
                        
                        Element mediaLocationElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "MediaLocation");
                        if (mediaLocationElement != null) {
                            URI mediaLocationInstance;
                            mediaLocationInstance = new URI(mediaLocationElement.getTextContent());
                            roleInstance.setMediaLocation(mediaLocationInstance);
                        }
                        
                        Element availabilitySetNameElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "AvailabilitySetName");
                        if (availabilitySetNameElement != null) {
                            String availabilitySetNameInstance;
                            availabilitySetNameInstance = availabilitySetNameElement.getTextContent();
                            roleInstance.setAvailabilitySetName(availabilitySetNameInstance);
                        }
                        
                        Element dataVirtualHardDisksSequenceElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisks");
                        if (dataVirtualHardDisksSequenceElement != null) {
                            for (int i26 = 0; i26 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dataVirtualHardDisksSequenceElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk").size(); i26 = i26 + 1) {
                                org.w3c.dom.Element dataVirtualHardDisksElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dataVirtualHardDisksSequenceElement, "http://schemas.microsoft.com/windowsazure", "DataVirtualHardDisk").get(i26));
                                DataVirtualHardDisk dataVirtualHardDiskInstance = new DataVirtualHardDisk();
                                roleInstance.getDataVirtualHardDisks().add(dataVirtualHardDiskInstance);
                                
                                Element hostCachingElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "HostCaching");
                                if (hostCachingElement != null) {
                                    String hostCachingInstance;
                                    hostCachingInstance = hostCachingElement.getTextContent();
                                    dataVirtualHardDiskInstance.setHostCaching(hostCachingInstance);
                                }
                                
                                Element diskLabelElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "DiskLabel");
                                if (diskLabelElement != null) {
                                    String diskLabelInstance;
                                    diskLabelInstance = diskLabelElement.getTextContent();
                                    dataVirtualHardDiskInstance.setLabel(diskLabelInstance);
                                }
                                
                                Element diskNameElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "DiskName");
                                if (diskNameElement != null) {
                                    String diskNameInstance;
                                    diskNameInstance = diskNameElement.getTextContent();
                                    dataVirtualHardDiskInstance.setName(diskNameInstance);
                                }
                                
                                Element lunElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "Lun");
                                if (lunElement != null && (lunElement.getTextContent() == null || lunElement.getTextContent().isEmpty() == true) == false) {
                                    int lunInstance;
                                    lunInstance = DatatypeConverter.parseInt(lunElement.getTextContent());
                                    dataVirtualHardDiskInstance.setLogicalUnitNumber(lunInstance);
                                }
                                
                                Element logicalDiskSizeInGBElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "LogicalDiskSizeInGB");
                                if (logicalDiskSizeInGBElement != null && (logicalDiskSizeInGBElement.getTextContent() == null || logicalDiskSizeInGBElement.getTextContent().isEmpty() == true) == false) {
                                    int logicalDiskSizeInGBInstance;
                                    logicalDiskSizeInGBInstance = DatatypeConverter.parseInt(logicalDiskSizeInGBElement.getTextContent());
                                    dataVirtualHardDiskInstance.setLogicalDiskSizeInGB(logicalDiskSizeInGBInstance);
                                }
                                
                                Element mediaLinkElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                                if (mediaLinkElement != null) {
                                    URI mediaLinkInstance;
                                    mediaLinkInstance = new URI(mediaLinkElement.getTextContent());
                                    dataVirtualHardDiskInstance.setMediaLink(mediaLinkInstance);
                                }
                                
                                Element sourceMediaLinkElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "SourceMediaLink");
                                if (sourceMediaLinkElement != null) {
                                    URI sourceMediaLinkInstance;
                                    sourceMediaLinkInstance = new URI(sourceMediaLinkElement.getTextContent());
                                    dataVirtualHardDiskInstance.setSourceMediaLink(sourceMediaLinkInstance);
                                }
                                
                                Element iOTypeElement = XmlUtility.getElementByTagNameNS(dataVirtualHardDisksElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                                if (iOTypeElement != null) {
                                    String iOTypeInstance;
                                    iOTypeInstance = iOTypeElement.getTextContent();
                                    dataVirtualHardDiskInstance.setIOType(iOTypeInstance);
                                }
                            }
                        }
                        
                        Element labelElement2 = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "Label");
                        if (labelElement2 != null) {
                            String labelInstance2;
                            labelInstance2 = labelElement2.getTextContent();
                            roleInstance.setLabel(labelInstance2);
                        }
                        
                        Element oSVirtualHardDiskElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "OSVirtualHardDisk");
                        if (oSVirtualHardDiskElement != null) {
                            OSVirtualHardDisk oSVirtualHardDiskInstance = new OSVirtualHardDisk();
                            roleInstance.setOSVirtualHardDisk(oSVirtualHardDiskInstance);
                            
                            Element hostCachingElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "HostCaching");
                            if (hostCachingElement2 != null) {
                                String hostCachingInstance2;
                                hostCachingInstance2 = hostCachingElement2.getTextContent();
                                oSVirtualHardDiskInstance.setHostCaching(hostCachingInstance2);
                            }
                            
                            Element diskLabelElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskLabel");
                            if (diskLabelElement2 != null) {
                                String diskLabelInstance2;
                                diskLabelInstance2 = diskLabelElement2.getTextContent();
                                oSVirtualHardDiskInstance.setLabel(diskLabelInstance2);
                            }
                            
                            Element diskNameElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "DiskName");
                            if (diskNameElement2 != null) {
                                String diskNameInstance2;
                                diskNameInstance2 = diskNameElement2.getTextContent();
                                oSVirtualHardDiskInstance.setName(diskNameInstance2);
                            }
                            
                            Element mediaLinkElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "MediaLink");
                            if (mediaLinkElement2 != null) {
                                URI mediaLinkInstance2;
                                mediaLinkInstance2 = new URI(mediaLinkElement2.getTextContent());
                                oSVirtualHardDiskInstance.setMediaLink(mediaLinkInstance2);
                            }
                            
                            Element sourceImageNameElement = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "SourceImageName");
                            if (sourceImageNameElement != null) {
                                String sourceImageNameInstance;
                                sourceImageNameInstance = sourceImageNameElement.getTextContent();
                                oSVirtualHardDiskInstance.setSourceImageName(sourceImageNameInstance);
                            }
                            
                            Element osElement = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "OS");
                            if (osElement != null) {
                                String osInstance;
                                osInstance = osElement.getTextContent();
                                oSVirtualHardDiskInstance.setOperatingSystem(osInstance);
                            }
                            
                            Element iOTypeElement2 = XmlUtility.getElementByTagNameNS(oSVirtualHardDiskElement, "http://schemas.microsoft.com/windowsazure", "IOType");
                            if (iOTypeElement2 != null) {
                                String iOTypeInstance2;
                                iOTypeInstance2 = iOTypeElement2.getTextContent();
                                oSVirtualHardDiskInstance.setIOType(iOTypeInstance2);
                            }
                        }
                        
                        Element roleSizeElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "RoleSize");
                        if (roleSizeElement != null) {
                            String roleSizeInstance;
                            roleSizeInstance = roleSizeElement.getTextContent();
                            roleInstance.setRoleSize(roleSizeInstance);
                        }
                        
                        Element defaultWinRmCertificateThumbprintElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "DefaultWinRmCertificateThumbprint");
                        if (defaultWinRmCertificateThumbprintElement != null) {
                            String defaultWinRmCertificateThumbprintInstance;
                            defaultWinRmCertificateThumbprintInstance = defaultWinRmCertificateThumbprintElement.getTextContent();
                            roleInstance.setDefaultWinRmCertificateThumbprint(defaultWinRmCertificateThumbprintInstance);
                        }
                        
                        Element provisionGuestAgentElement = XmlUtility.getElementByTagNameNS(roleListElement, "http://schemas.microsoft.com/windowsazure", "ProvisionGuestAgent");
                        if (provisionGuestAgentElement != null && (provisionGuestAgentElement.getTextContent() == null || provisionGuestAgentElement.getTextContent().isEmpty() == true) == false) {
                            boolean provisionGuestAgentInstance;
                            provisionGuestAgentInstance = DatatypeConverter.parseBoolean(provisionGuestAgentElement.getTextContent().toLowerCase());
                            roleInstance.setProvisionGuestAgent(provisionGuestAgentInstance);
                        }
                    }
                }
                
                Element sdkVersionElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "SdkVersion");
                if (sdkVersionElement != null) {
                    String sdkVersionInstance;
                    sdkVersionInstance = sdkVersionElement.getTextContent();
                    result.setSdkVersion(sdkVersionInstance);
                }
                
                Element lockedElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Locked");
                if (lockedElement != null && (lockedElement.getTextContent() == null || lockedElement.getTextContent().isEmpty() == true) == false) {
                    boolean lockedInstance;
                    lockedInstance = DatatypeConverter.parseBoolean(lockedElement.getTextContent().toLowerCase());
                    result.setLocked(lockedInstance);
                }
                
                Element rollbackAllowedElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "RollbackAllowed");
                if (rollbackAllowedElement != null && (rollbackAllowedElement.getTextContent() == null || rollbackAllowedElement.getTextContent().isEmpty() == true) == false) {
                    boolean rollbackAllowedInstance;
                    rollbackAllowedInstance = DatatypeConverter.parseBoolean(rollbackAllowedElement.getTextContent().toLowerCase());
                    result.setRollbackAllowed(rollbackAllowedInstance);
                }
                
                Element virtualNetworkNameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "VirtualNetworkName");
                if (virtualNetworkNameElement != null) {
                    String virtualNetworkNameInstance;
                    virtualNetworkNameInstance = virtualNetworkNameElement.getTextContent();
                    result.setVirtualNetworkName(virtualNetworkNameInstance);
                }
                
                Element createdTimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "CreatedTime");
                if (createdTimeElement != null) {
                    Calendar createdTimeInstance;
                    createdTimeInstance = DatatypeConverter.parseDateTime(createdTimeElement.getTextContent());
                    result.setCreatedTime(createdTimeInstance);
                }
                
                Element lastModifiedTimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "LastModifiedTime");
                if (lastModifiedTimeElement != null) {
                    Calendar lastModifiedTimeInstance;
                    lastModifiedTimeInstance = DatatypeConverter.parseDateTime(lastModifiedTimeElement.getTextContent());
                    result.setLastModifiedTime(lastModifiedTimeInstance);
                }
                
                Element extendedPropertiesSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperties");
                if (extendedPropertiesSequenceElement != null) {
                    for (int i27 = 0; i27 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").size(); i27 = i27 + 1) {
                        org.w3c.dom.Element extendedPropertiesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extendedPropertiesSequenceElement, "http://schemas.microsoft.com/windowsazure", "ExtendedProperty").get(i27));
                        String extendedPropertiesKey = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Name").getTextContent();
                        String extendedPropertiesValue = XmlUtility.getElementByTagNameNS(extendedPropertiesElement, "http://schemas.microsoft.com/windowsazure", "Value").getTextContent();
                        result.getExtendedProperties().put(extendedPropertiesKey, extendedPropertiesValue);
                    }
                }
                
                Element dnsElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "Dns");
                if (dnsElement != null) {
                    DnsSettings dnsInstance = new DnsSettings();
                    result.setDnsSettings(dnsInstance);
                    
                    Element dnsServersSequenceElement = XmlUtility.getElementByTagNameNS(dnsElement, "http://schemas.microsoft.com/windowsazure", "DnsServers");
                    if (dnsServersSequenceElement != null) {
                        for (int i28 = 0; i28 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dnsServersSequenceElement, "http://schemas.microsoft.com/windowsazure", "DnsServer").size(); i28 = i28 + 1) {
                            org.w3c.dom.Element dnsServersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(dnsServersSequenceElement, "http://schemas.microsoft.com/windowsazure", "DnsServer").get(i28));
                            DnsServer dnsServerInstance = new DnsServer();
                            dnsInstance.getDnsServers().add(dnsServerInstance);
                            
                            Element nameElement11 = XmlUtility.getElementByTagNameNS(dnsServersElement, "http://schemas.microsoft.com/windowsazure", "Name");
                            if (nameElement11 != null) {
                                String nameInstance11;
                                nameInstance11 = nameElement11.getTextContent();
                                dnsServerInstance.setName(nameInstance11);
                            }
                            
                            Element addressElement3 = XmlUtility.getElementByTagNameNS(dnsServersElement, "http://schemas.microsoft.com/windowsazure", "Address");
                            if (addressElement3 != null) {
                                InetAddress addressInstance3;
                                addressInstance3 = InetAddress.getByName(addressElement3.getTextContent());
                                dnsServerInstance.setAddress(addressInstance3);
                            }
                        }
                    }
                }
                
                Element persistentVMDowntimeElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "PersistentVMDowntime");
                if (persistentVMDowntimeElement != null) {
                    PersistentVMDowntime persistentVMDowntimeInstance = new PersistentVMDowntime();
                    result.setPersistentVMDowntime(persistentVMDowntimeInstance);
                    
                    Element startTimeElement = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "StartTime");
                    if (startTimeElement != null) {
                        Calendar startTimeInstance;
                        startTimeInstance = DatatypeConverter.parseDateTime(startTimeElement.getTextContent());
                        persistentVMDowntimeInstance.setStartTime(startTimeInstance);
                    }
                    
                    Element endTimeElement = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "EndTime");
                    if (endTimeElement != null) {
                        Calendar endTimeInstance;
                        endTimeInstance = DatatypeConverter.parseDateTime(endTimeElement.getTextContent());
                        persistentVMDowntimeInstance.setEndTime(endTimeInstance);
                    }
                    
                    Element statusElement6 = XmlUtility.getElementByTagNameNS(persistentVMDowntimeElement, "http://schemas.microsoft.com/windowsazure", "Status");
                    if (statusElement6 != null) {
                        String statusInstance6;
                        statusInstance6 = statusElement6.getTextContent();
                        persistentVMDowntimeInstance.setStatus(statusInstance6);
                    }
                }
                
                Element virtualIPsSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "VirtualIPs");
                if (virtualIPsSequenceElement != null) {
                    for (int i29 = 0; i29 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(virtualIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "VirtualIP").size(); i29 = i29 + 1) {
                        org.w3c.dom.Element virtualIPsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(virtualIPsSequenceElement, "http://schemas.microsoft.com/windowsazure", "VirtualIP").get(i29));
                        VirtualIPAddress virtualIPInstance = new VirtualIPAddress();
                        result.getVirtualIPAddresses().add(virtualIPInstance);
                        
                        Element addressElement4 = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "Address");
                        if (addressElement4 != null) {
                            InetAddress addressInstance4;
                            addressInstance4 = InetAddress.getByName(addressElement4.getTextContent());
                            virtualIPInstance.setAddress(addressInstance4);
                        }
                        
                        Element nameElement12 = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement12 != null) {
                            String nameInstance12;
                            nameInstance12 = nameElement12.getTextContent();
                            virtualIPInstance.setName(nameInstance12);
                        }
                        
                        Element isDnsProgrammedElement = XmlUtility.getElementByTagNameNS(virtualIPsElement, "http://schemas.microsoft.com/windowsazure", "IsDnsProgrammed");
                        if (isDnsProgrammedElement != null && (isDnsProgrammedElement.getTextContent() == null || isDnsProgrammedElement.getTextContent().isEmpty() == true) == false) {
                            boolean isDnsProgrammedInstance;
                            isDnsProgrammedInstance = DatatypeConverter.parseBoolean(isDnsProgrammedElement.getTextContent().toLowerCase());
                            virtualIPInstance.setIsDnsProgrammed(isDnsProgrammedInstance);
                        }
                    }
                }
                
                Element extensionConfigurationElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ExtensionConfiguration");
                if (extensionConfigurationElement != null) {
                    ExtensionConfiguration extensionConfigurationInstance = new ExtensionConfiguration();
                    result.setExtensionConfiguration(extensionConfigurationInstance);
                    
                    Element allRolesSequenceElement = XmlUtility.getElementByTagNameNS(extensionConfigurationElement, "http://schemas.microsoft.com/windowsazure", "AllRoles");
                    if (allRolesSequenceElement != null) {
                        for (int i30 = 0; i30 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(allRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").size(); i30 = i30 + 1) {
                            org.w3c.dom.Element allRolesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(allRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").get(i30));
                            ExtensionConfiguration.Extension extensionInstance = new ExtensionConfiguration.Extension();
                            extensionConfigurationInstance.getAllRoles().add(extensionInstance);
                            
                            Element idElement = XmlUtility.getElementByTagNameNS(allRolesElement, "http://schemas.microsoft.com/windowsazure", "Id");
                            if (idElement != null) {
                                String idInstance;
                                idInstance = idElement.getTextContent();
                                extensionInstance.setId(idInstance);
                            }
                        }
                    }
                    
                    Element namedRolesSequenceElement = XmlUtility.getElementByTagNameNS(extensionConfigurationElement, "http://schemas.microsoft.com/windowsazure", "NamedRoles");
                    if (namedRolesSequenceElement != null) {
                        for (int i31 = 0; i31 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(namedRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").size(); i31 = i31 + 1) {
                            org.w3c.dom.Element namedRolesElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(namedRolesSequenceElement, "http://schemas.microsoft.com/windowsazure", "Role").get(i31));
                            ExtensionConfiguration.NamedRole roleInstance2 = new ExtensionConfiguration.NamedRole();
                            extensionConfigurationInstance.getNamedRoles().add(roleInstance2);
                            
                            Element roleNameElement3 = XmlUtility.getElementByTagNameNS(namedRolesElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                            if (roleNameElement3 != null) {
                                String roleNameInstance3;
                                roleNameInstance3 = roleNameElement3.getTextContent();
                                roleInstance2.setRoleName(roleNameInstance3);
                            }
                            
                            Element extensionsSequenceElement = XmlUtility.getElementByTagNameNS(namedRolesElement, "http://schemas.microsoft.com/windowsazure", "Extensions");
                            if (extensionsSequenceElement != null) {
                                for (int i32 = 0; i32 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extensionsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").size(); i32 = i32 + 1) {
                                    org.w3c.dom.Element extensionsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(extensionsSequenceElement, "http://schemas.microsoft.com/windowsazure", "Extension").get(i32));
                                    ExtensionConfiguration.Extension extensionInstance2 = new ExtensionConfiguration.Extension();
                                    roleInstance2.getExtensions().add(extensionInstance2);
                                    
                                    Element idElement2 = XmlUtility.getElementByTagNameNS(extensionsElement, "http://schemas.microsoft.com/windowsazure", "Id");
                                    if (idElement2 != null) {
                                        String idInstance2;
                                        idInstance2 = idElement2.getTextContent();
                                        extensionInstance2.setId(idInstance2);
                                    }
                                }
                            }
                        }
                    }
                }
                
                Element reservedIPNameElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "ReservedIPName");
                if (reservedIPNameElement != null) {
                    String reservedIPNameInstance;
                    reservedIPNameInstance = reservedIPNameElement.getTextContent();
                    result.setReservedIPName(reservedIPNameInstance);
                }
                
                Element loadBalancersSequenceElement = XmlUtility.getElementByTagNameNS(deploymentElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancers");
                if (loadBalancersSequenceElement != null) {
                    for (int i33 = 0; i33 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(loadBalancersSequenceElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancer").size(); i33 = i33 + 1) {
                        org.w3c.dom.Element loadBalancersElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(loadBalancersSequenceElement, "http://schemas.microsoft.com/windowsazure", "LoadBalancer").get(i33));
                        LoadBalancer loadBalancerInstance = new LoadBalancer();
                        result.getLoadBalancers().add(loadBalancerInstance);
                        
                        Element nameElement13 = XmlUtility.getElementByTagNameNS(loadBalancersElement, "http://schemas.microsoft.com/windowsazure", "Name");
                        if (nameElement13 != null) {
                            String nameInstance13;
                            nameInstance13 = nameElement13.getTextContent();
                            loadBalancerInstance.setName(nameInstance13);
                        }
                        
                        Element frontendIpConfigurationElement = XmlUtility.getElementByTagNameNS(loadBalancersElement, "http://schemas.microsoft.com/windowsazure", "FrontendIpConfiguration");
                        if (frontendIpConfigurationElement != null) {
                            FrontendIPConfiguration frontendIpConfigurationInstance = new FrontendIPConfiguration();
                            loadBalancerInstance.setFrontendIPConfiguration(frontendIpConfigurationInstance);
                            
                            Element typeElement2 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "Type");
                            if (typeElement2 != null) {
                                String typeInstance2;
                                typeInstance2 = typeElement2.getTextContent();
                                frontendIpConfigurationInstance.setType(typeInstance2);
                            }
                            
                            Element subnetNameElement3 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "SubnetName");
                            if (subnetNameElement3 != null) {
                                String subnetNameInstance3;
                                subnetNameInstance3 = subnetNameElement3.getTextContent();
                                frontendIpConfigurationInstance.setSubnetName(subnetNameInstance3);
                            }
                            
                            Element staticVirtualNetworkIPAddressElement3 = XmlUtility.getElementByTagNameNS(frontendIpConfigurationElement, "http://schemas.microsoft.com/windowsazure", "StaticVirtualNetworkIPAddress");
                            if (staticVirtualNetworkIPAddressElement3 != null) {
                                InetAddress staticVirtualNetworkIPAddressInstance3;
                                staticVirtualNetworkIPAddressInstance3 = InetAddress.getByName(staticVirtualNetworkIPAddressElement3.getTextContent());
                                frontendIpConfigurationInstance.setStaticVirtualNetworkIPAddress(staticVirtualNetworkIPAddressInstance3);
                            }
                        }
                    }
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Get Package By Name operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Name operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> getPackageByNameAsync(final String serviceName, final String deploymentName, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return getPackageByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Get Package By Name operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Name operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse getPackageByName(String serviceName, String deploymentName, DeploymentGetPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getPackageByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginGettingPackageByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Get Package By Slot operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Slot operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> getPackageBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentGetPackageParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return getPackageBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Get Package By Slot operation retrieves a cloud service package for a
    * deployment and stores the package files in Azure Blob storage. The
    * following package files are placed in storage: the cloud service
    * configuration file (.cscfg), providing configuration settings for the
    * cloud service and individual roles, including the number of role
    * instances; and the service package (.cspkg), containing the application
    * code and the service definition file.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/jj154121.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Get Package By
    * Slot operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse getPackageBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentGetPackageParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "getPackageBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginGettingPackageBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * Identifies the list of reboot events due to planned maintenance that
    * impacted a deployment in the optionally provided timeframe.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param startTime Required. Datetime in UTC representing the start time of
    * the query.
    * @param endTime Required. Datetime in UTC representing the end time of the
    * query.
    * @return Identifies the list of reboot events due to planned maintenance
    * that impacted a deployment in the optionally provided timeframe.
    */
    @Override
    public Future<DeploymentEventListResponse> listEventsAsync(final String serviceName, final String deploymentName, final Calendar startTime, final Calendar endTime) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentEventListResponse>() { 
            @Override
            public DeploymentEventListResponse call() throws Exception {
                return listEvents(serviceName, deploymentName, startTime, endTime);
            }
         });
    }
    
    /**
    * Identifies the list of reboot events due to planned maintenance that
    * impacted a deployment in the optionally provided timeframe.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of the deployment.
    * @param startTime Required. Datetime in UTC representing the start time of
    * the query.
    * @param endTime Required. Datetime in UTC representing the end time of the
    * query.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Identifies the list of reboot events due to planned maintenance
    * that impacted a deployment in the optionally provided timeframe.
    */
    @Override
    public DeploymentEventListResponse listEvents(String serviceName, String deploymentName, Calendar startTime, Calendar endTime) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("startTime", startTime);
            tracingParameters.put("endTime", endTime);
            CloudTracing.enter(invocationId, this, "listEventsAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/events" + "?";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        url = url + "starttime=" + URLEncoder.encode(simpleDateFormat.format(startTime.getTime()), "UTF-8");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        url = url + "&" + "endtime=" + URLEncoder.encode(simpleDateFormat2.format(endTime.getTime()), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentEventListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DeploymentEventListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element deploymentEventCollectionElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "DeploymentEventCollection");
            if (deploymentEventCollectionElement != null) {
                Element rebootEventsSequenceElement = XmlUtility.getElementByTagNameNS(deploymentEventCollectionElement, "http://schemas.microsoft.com/windowsazure", "RebootEvents");
                if (rebootEventsSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rebootEventsSequenceElement, "http://schemas.microsoft.com/windowsazure", "RebootEvent").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element rebootEventsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rebootEventsSequenceElement, "http://schemas.microsoft.com/windowsazure", "RebootEvent").get(i1));
                        RebootEvent rebootEventInstance = new RebootEvent();
                        result.getDeploymentEvents().add(rebootEventInstance);
                        
                        Element roleNameElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement != null) {
                            String roleNameInstance;
                            roleNameInstance = roleNameElement.getTextContent();
                            rebootEventInstance.setRoleName(roleNameInstance);
                        }
                        
                        Element instanceNameElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "InstanceName");
                        if (instanceNameElement != null) {
                            String instanceNameInstance;
                            instanceNameInstance = instanceNameElement.getTextContent();
                            rebootEventInstance.setInstanceName(instanceNameInstance);
                        }
                        
                        Element rebootReasonElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RebootReason");
                        if (rebootReasonElement != null) {
                            String rebootReasonInstance;
                            rebootReasonInstance = rebootReasonElement.getTextContent();
                            rebootEventInstance.setRebootReason(rebootReasonInstance);
                        }
                        
                        Element rebootStartTimeElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RebootStartTime");
                        if (rebootStartTimeElement != null && (rebootStartTimeElement.getTextContent() == null || rebootStartTimeElement.getTextContent().isEmpty() == true) == false) {
                            Calendar rebootStartTimeInstance;
                            rebootStartTimeInstance = DatatypeConverter.parseDateTime(rebootStartTimeElement.getTextContent());
                            rebootEventInstance.setRebootStartTime(rebootStartTimeInstance);
                        }
                    }
                }
                
                Element continuationTokenElement = XmlUtility.getElementByTagNameNS(deploymentEventCollectionElement, "http://schemas.microsoft.com/windowsazure", "ContinuationToken");
                if (continuationTokenElement != null) {
                    String continuationTokenInstance;
                    continuationTokenInstance = continuationTokenElement.getTextContent();
                    result.setContinuationToken(continuationTokenInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * Identifies the list of reboot events due to planned maintenance that
    * impacted a deployment in the optionally provided timeframe.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param startTime Required. Datetime in UTC representing the start time of
    * the query.
    * @param endTime Required. Datetime in UTC representing the end time of the
    * query.
    * @return Identifies the list of reboot events due to planned maintenance
    * that impacted a deployment in the optionally provided timeframe.
    */
    @Override
    public Future<DeploymentEventListResponse> listEventsBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final Calendar startTime, final Calendar endTime) {
        return this.getClient().getExecutorService().submit(new Callable<DeploymentEventListResponse>() { 
            @Override
            public DeploymentEventListResponse call() throws Exception {
                return listEventsBySlot(serviceName, deploymentSlot, startTime, endTime);
            }
         });
    }
    
    /**
    * Identifies the list of reboot events due to planned maintenance that
    * impacted a deployment in the optionally provided timeframe.
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param startTime Required. Datetime in UTC representing the start time of
    * the query.
    * @param endTime Required. Datetime in UTC representing the end time of the
    * query.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws ParserConfigurationException Thrown if there was a serious
    * configuration error with the document parser.
    * @throws SAXException Thrown if there was an error parsing the XML
    * response.
    * @return Identifies the list of reboot events due to planned maintenance
    * that impacted a deployment in the optionally provided timeframe.
    */
    @Override
    public DeploymentEventListResponse listEventsBySlot(String serviceName, DeploymentSlot deploymentSlot, Calendar startTime, Calendar endTime) throws IOException, ServiceException, ParserConfigurationException, SAXException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("startTime", startTime);
            tracingParameters.put("endTime", endTime);
            CloudTracing.enter(invocationId, this, "listEventsBySlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/events" + "?";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        url = url + "starttime=" + URLEncoder.encode(simpleDateFormat.format(startTime.getTime()), "UTF-8");
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
        simpleDateFormat2.setTimeZone(TimeZone.getTimeZone("UTC"));
        url = url + "&" + "endtime=" + URLEncoder.encode(simpleDateFormat2.format(endTime.getTime()), "UTF-8");
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpGet httpRequest = new HttpGet(url);
        
        // Set Headers
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, null, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            DeploymentEventListResponse result = null;
            // Deserialize Response
            InputStream responseContent = httpResponse.getEntity().getContent();
            result = new DeploymentEventListResponse();
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document responseDoc = documentBuilder.parse(new BOMInputStream(responseContent));
            
            Element deploymentEventCollectionElement = XmlUtility.getElementByTagNameNS(responseDoc, "http://schemas.microsoft.com/windowsazure", "DeploymentEventCollection");
            if (deploymentEventCollectionElement != null) {
                Element rebootEventsSequenceElement = XmlUtility.getElementByTagNameNS(deploymentEventCollectionElement, "http://schemas.microsoft.com/windowsazure", "RebootEvents");
                if (rebootEventsSequenceElement != null) {
                    for (int i1 = 0; i1 < com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rebootEventsSequenceElement, "http://schemas.microsoft.com/windowsazure", "RebootEvent").size(); i1 = i1 + 1) {
                        org.w3c.dom.Element rebootEventsElement = ((org.w3c.dom.Element) com.microsoft.windowsazure.core.utils.XmlUtility.getElementsByTagNameNS(rebootEventsSequenceElement, "http://schemas.microsoft.com/windowsazure", "RebootEvent").get(i1));
                        RebootEvent rebootEventInstance = new RebootEvent();
                        result.getDeploymentEvents().add(rebootEventInstance);
                        
                        Element roleNameElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RoleName");
                        if (roleNameElement != null) {
                            String roleNameInstance;
                            roleNameInstance = roleNameElement.getTextContent();
                            rebootEventInstance.setRoleName(roleNameInstance);
                        }
                        
                        Element instanceNameElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "InstanceName");
                        if (instanceNameElement != null) {
                            String instanceNameInstance;
                            instanceNameInstance = instanceNameElement.getTextContent();
                            rebootEventInstance.setInstanceName(instanceNameInstance);
                        }
                        
                        Element rebootReasonElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RebootReason");
                        if (rebootReasonElement != null) {
                            String rebootReasonInstance;
                            rebootReasonInstance = rebootReasonElement.getTextContent();
                            rebootEventInstance.setRebootReason(rebootReasonInstance);
                        }
                        
                        Element rebootStartTimeElement = XmlUtility.getElementByTagNameNS(rebootEventsElement, "http://schemas.microsoft.com/windowsazure", "RebootStartTime");
                        if (rebootStartTimeElement != null && (rebootStartTimeElement.getTextContent() == null || rebootStartTimeElement.getTextContent().isEmpty() == true) == false) {
                            Calendar rebootStartTimeInstance;
                            rebootStartTimeInstance = DatatypeConverter.parseDateTime(rebootStartTimeElement.getTextContent());
                            rebootEventInstance.setRebootStartTime(rebootStartTimeInstance);
                        }
                    }
                }
                
                Element continuationTokenElement = XmlUtility.getElementByTagNameNS(deploymentEventCollectionElement, "http://schemas.microsoft.com/windowsazure", "ContinuationToken");
                if (continuationTokenElement != null) {
                    String continuationTokenInstance;
                    continuationTokenInstance = continuationTokenElement.getTextContent();
                    result.setContinuationToken(continuationTokenInstance);
                }
            }
            
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Reboot Role Instance By Deployment Name operation requests a reboot
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> rebootRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return rebootRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
         });
    }
    
    /**
    * The Reboot Role Instance By Deployment Name operation requests a reboot
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse rebootRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "rebootRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginRebootingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Reboot Role Instance By Deployment Slot operation requests a reboot
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> rebootRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return rebootRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
         });
    }
    
    /**
    * The Reboot Role Instance By Deployment Slot operation requests a reboot
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441298.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse rebootRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "rebootRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginRebootingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> rebuildRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return rebuildRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName, resources);
            }
         });
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse rebuildRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName, String resources) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter(invocationId, this, "rebuildRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginRebuildingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName, resources).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> rebuildRoleInstanceByDeploymentSlotAsync(final String serviceName, final String deploymentSlot, final String roleInstanceName, final String resources) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return rebuildRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName, resources);
            }
         });
    }
    
    /**
    * The Rebuild Role Instance asynchronous operation reinstalls the operating
    * system on instances of web roles or worker roles and initializes the
    * storage resources that are used by them. If you do not want to
    * initialize storage resources, you can use Reimage Role Instance
    * athttp://msdn.microsoft.com/en-us/library/azure/gg441292.aspx.For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/azure/dn627518.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @param resources Required. Specifies the resources that must be rebuilt.
    * Currently, the only supported value is 'allLocalDrives'.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse rebuildRoleInstanceByDeploymentSlot(String serviceName, String deploymentSlot, String roleInstanceName, String resources) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            tracingParameters.put("resources", resources);
            CloudTracing.enter(invocationId, this, "rebuildRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginRebuildingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName, resources).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Reimage Role Instance By Deployment Name operation requests a reimage
    * of a role instance that is running in a deployment.This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> reimageRoleInstanceByDeploymentNameAsync(final String serviceName, final String deploymentName, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return reimageRoleInstanceByDeploymentName(serviceName, deploymentName, roleInstanceName);
            }
         });
    }
    
    /**
    * The Reimage Role Instance By Deployment Name operation requests a reimage
    * of a role instance that is running in a deployment.This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse reimageRoleInstanceByDeploymentName(String serviceName, String deploymentName, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "reimageRoleInstanceByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginReimagingRoleInstanceByDeploymentNameAsync(serviceName, deploymentName, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Reimage Role Instance By Deployment Slot operation requests a reimage
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> reimageRoleInstanceByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final String roleInstanceName) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return reimageRoleInstanceByDeploymentSlot(serviceName, deploymentSlot, roleInstanceName);
            }
         });
    }
    
    /**
    * The Reimage Role Instance By Deployment Slot operation requests a reimage
    * of a role instance that is running in a deployment. This operation is an
    * asynchronous operation. To determine whether the Management service has
    * finished processing the request, call Get Operation Status. For more
    * information on asynchronous operations, see Tracking Asynchronous
    * Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/gg441292.aspx
    * for more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param roleInstanceName Required. The name of your role instance.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse reimageRoleInstanceByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, String roleInstanceName) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("roleInstanceName", roleInstanceName);
            CloudTracing.enter(invocationId, this, "reimageRoleInstanceByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginReimagingRoleInstanceByDeploymentSlotAsync(serviceName, deploymentSlot, roleInstanceName).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Rollback Update Or Upgrade By Deployment Name operation cancels an
    * in-progress configuration update and returns the deployment to its state
    * before the update was started. This operation can only be called when an
    * update is in progress on the deployment. The deployment status can be
    * detected by calling the Get Deployment operation or Get Hosted Service
    * Properties operation and inspecting the RollbackAllowed element. If the
    * value returned is true a rollback can be performed.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403977.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Rollback Update Or
    * Upgrade By Deployment Name operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> rollbackUpdateOrUpgradeByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentRollbackUpdateOrUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return rollbackUpdateOrUpgradeByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Rollback Update Or Upgrade By Deployment Name operation cancels an
    * in-progress configuration update and returns the deployment to its state
    * before the update was started. This operation can only be called when an
    * update is in progress on the deployment. The deployment status can be
    * detected by calling the Get Deployment operation or Get Hosted Service
    * Properties operation and inspecting the RollbackAllowed element. If the
    * value returned is true a rollback can be performed.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403977.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Rollback Update Or
    * Upgrade By Deployment Name operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse rollbackUpdateOrUpgradeByDeploymentName(String serviceName, String deploymentName, DeploymentRollbackUpdateOrUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (deploymentName == null) {
            throw new NullPointerException("deploymentName");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "rollbackUpdateOrUpgradeByDeploymentNameAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deployments/" + deploymentName.trim() + "/" + "?" + "comp=rollback";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element rollbackUpdateOrUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RollbackUpdateOrUpgrade");
        requestDoc.appendChild(rollbackUpdateOrUpgradeElement);
        
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        rollbackUpdateOrUpgradeElement.appendChild(modeElement);
        
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        rollbackUpdateOrUpgradeElement.appendChild(forceElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Rollback Update Or Upgrade By Deployment Slot operation cancels an
    * in-progress configuration update and returns the deployment to its state
    * before the update was started. This operation can only be called when an
    * update is in progress on the deployment. The deployment status can be
    * detected by calling the Get Deployment operation or Get Hosted Service
    * Properties operation and inspecting the RollbackAllowed element. If the
    * value returned is true a rollback can be performed.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403977.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Rollback Update Or
    * Upgrade By Deployment Slot operation.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public Future<OperationResponse> rollbackUpdateOrUpgradeByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentRollbackUpdateOrUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationResponse>() { 
            @Override
            public OperationResponse call() throws Exception {
                return rollbackUpdateOrUpgradeByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Rollback Update Or Upgrade By Deployment Slot operation cancels an
    * in-progress configuration update and returns the deployment to its state
    * before the update was started. This operation can only be called when an
    * update is in progress on the deployment. The deployment status can be
    * detected by calling the Get Deployment operation or Get Hosted Service
    * Properties operation and inspecting the RollbackAllowed element. If the
    * value returned is true a rollback can be performed.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh403977.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Rollback Update Or
    * Upgrade By Deployment Slot operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    @Override
    public OperationResponse rollbackUpdateOrUpgradeByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentRollbackUpdateOrUpgradeParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException {
        // Validate
        if (serviceName == null) {
            throw new NullPointerException("serviceName");
        }
        // TODO: Validate serviceName is a valid DNS name.
        if (parameters == null) {
            throw new NullPointerException("parameters");
        }
        
        // Tracing
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "rollbackUpdateOrUpgradeByDeploymentSlotAsync", tracingParameters);
        }
        
        // Construct URL
        String url = "/" + (this.getClient().getCredentials().getSubscriptionId() != null ? this.getClient().getCredentials().getSubscriptionId().trim() : "") + "/services/hostedservices/" + serviceName.trim() + "/deploymentslots/" + deploymentSlot + "/" + "?" + "comp=rollback";
        String baseUrl = this.getClient().getBaseUri().toString();
        // Trim '/' character from the end of baseUrl and beginning of url.
        if (baseUrl.charAt(baseUrl.length() - 1) == '/') {
            baseUrl = baseUrl.substring(0, (baseUrl.length() - 1) + 0);
        }
        if (url.charAt(0) == '/') {
            url = url.substring(1);
        }
        url = baseUrl + "/" + url;
        url = url.replace(" ", "%20");
        
        // Create HTTP transport objects
        HttpPost httpRequest = new HttpPost(url);
        
        // Set Headers
        httpRequest.setHeader("Content-Type", "application/xml");
        httpRequest.setHeader("x-ms-version", "2014-10-01");
        
        // Serialize Request
        String requestContent = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document requestDoc = documentBuilder.newDocument();
        
        Element rollbackUpdateOrUpgradeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "RollbackUpdateOrUpgrade");
        requestDoc.appendChild(rollbackUpdateOrUpgradeElement);
        
        Element modeElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Mode");
        modeElement.appendChild(requestDoc.createTextNode(parameters.getMode().toString()));
        rollbackUpdateOrUpgradeElement.appendChild(modeElement);
        
        Element forceElement = requestDoc.createElementNS("http://schemas.microsoft.com/windowsazure", "Force");
        forceElement.appendChild(requestDoc.createTextNode(Boolean.toString(parameters.isForce()).toLowerCase()));
        rollbackUpdateOrUpgradeElement.appendChild(forceElement);
        
        DOMSource domSource = new DOMSource(requestDoc);
        StringWriter stringWriter = new StringWriter();
        StreamResult streamResult = new StreamResult(stringWriter);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.transform(domSource, streamResult);
        requestContent = stringWriter.toString();
        StringEntity entity = new StringEntity(requestContent);
        httpRequest.setEntity(entity);
        httpRequest.setHeader("Content-Type", "application/xml");
        
        // Send Request
        HttpResponse httpResponse = null;
        try {
            if (shouldTrace) {
                CloudTracing.sendRequest(invocationId, httpRequest);
            }
            httpResponse = this.getClient().getHttpClient().execute(httpRequest);
            if (shouldTrace) {
                CloudTracing.receiveResponse(invocationId, httpResponse);
            }
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_ACCEPTED) {
                ServiceException ex = ServiceException.createFromXml(httpRequest, requestContent, httpResponse, httpResponse.getEntity());
                if (shouldTrace) {
                    CloudTracing.error(invocationId, ex);
                }
                throw ex;
            }
            
            // Create Result
            OperationResponse result = null;
            result = new OperationResponse();
            result.setStatusCode(statusCode);
            if (httpResponse.getHeaders("x-ms-request-id").length > 0) {
                result.setRequestId(httpResponse.getFirstHeader("x-ms-request-id").getValue());
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            return result;
        } finally {
            if (httpResponse != null && httpResponse.getEntity() != null) {
                httpResponse.getEntity().getContent().close();
            }
        }
    }
    
    /**
    * The Swap Deployment operation initiates a virtual IP address swap between
    * the staging and production deployment environments for a service. If the
    * service is currently running in the staging environment, it will be
    * swapped to the production environment. If it is running in the
    * production environment, it will be swapped to staging. For more
    * information on this type of upgrade, see Performing Virtual IP Swap
    * Upgrades at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee517253.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460814.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param parameters Required. Parameters supplied to the Swap Deployment
    * operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> swapAsync(final String serviceName, final DeploymentSwapParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return swap(serviceName, parameters);
            }
         });
    }
    
    /**
    * The Swap Deployment operation initiates a virtual IP address swap between
    * the staging and production deployment environments for a service. If the
    * service is currently running in the staging environment, it will be
    * swapped to the production environment. If it is running in the
    * production environment, it will be swapped to staging. For more
    * information on this type of upgrade, see Performing Virtual IP Swap
    * Upgrades at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee517253.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460814.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param parameters Required. Parameters supplied to the Swap Deployment
    * operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse swap(String serviceName, DeploymentSwapParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "swapAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginSwappingAsync(serviceName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Update Deployment Status By Deployment Name operation initiates a
    * change in the running status of a deployment. The status of a deployment
    * can be running or suspended. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Update Deployment
    * Status By Deployment Name operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> updateStatusByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return updateStatusByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Update Deployment Status By Deployment Name operation initiates a
    * change in the running status of a deployment. The status of a deployment
    * can be running or suspended. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Update Deployment
    * Status By Deployment Name operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse updateStatusByDeploymentName(String serviceName, String deploymentName, DeploymentUpdateStatusParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateStatusByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginUpdatingStatusByDeploymentNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Update Deployment Status By Deployment Slot operation initiates a
    * change in the running status of a deployment. The status of a deployment
    * can be running or suspended. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Update Deployment
    * Status By Deployment Slot operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> updateStatusByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpdateStatusParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return updateStatusByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Update Deployment Status By Deployment Slot operation initiates a
    * change in the running status of a deployment. The status of a deployment
    * can be running or suspended. This operation is an asynchronous
    * operation. To determine whether the Management service has finished
    * processing the request, call Get Operation Status. For more information
    * on asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * (see http://msdn.microsoft.com/en-us/library/windowsazure/ee460808.aspx
    * for more information)
    *
    * @param serviceName Required. The cloud service to swap deployments for.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Update Deployment
    * Status By Deployment Slot operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse updateStatusByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpdateStatusParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "updateStatusByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginUpdatingStatusByDeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Upgrade Deployment By Name operation initiates an update of role
    * instances in a deployment using the package and configuration that you
    * specify. For more information about updating role instances, see Update
    * an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentName Required. The deployment to upgrade.
    * @param parameters Required. Parameters supplied to the Upgrade Deployment
    * By Name operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> upgradeByNameAsync(final String serviceName, final String deploymentName, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return upgradeByName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Upgrade Deployment By Name operation initiates an update of role
    * instances in a deployment using the package and configuration that you
    * specify. For more information about updating role instances, see Update
    * an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentName Required. The deployment to upgrade.
    * @param parameters Required. Parameters supplied to the Upgrade Deployment
    * By Name operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse upgradeByName(String serviceName, String deploymentName, DeploymentUpgradeParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "upgradeByNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginUpgradingByNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Upgrade Deployment By Slot operation initiates an update of role
    * instances in a deployment using the package and configuration that you
    * specify. For more information about updating role instances, see Update
    * an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentSlot Required. The slot to upgrade.
    * @param parameters Required. Parameters supplied to the Upgrade Deployment
    * By Slot operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> upgradeBySlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentUpgradeParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return upgradeBySlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Upgrade Deployment By Slot operation initiates an update of role
    * instances in a deployment using the package and configuration that you
    * specify. For more information about updating role instances, see Update
    * an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the request
    * has been processed, call Get Operation Status. For more information on
    * asynchronous operations, see Tracking Asynchronous Service Management
    * Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx. To
    * perform an automatic update of a deployment, call Upgrade Deployment or
    * Change Deployment Configuration with the Mode element set to automatic.
    * The update proceeds from that point without a need for further input.
    * You can call Get Operation Status to determine when the update is
    * complete. To perform a manual update, first call Upgrade Deployment with
    * the Mode element set to manual. Next, call Walk Upgrade Domain to update
    * each domain within the deployment. You should make sure that the
    * operation is complete by calling Get Operation Status before updating
    * the next domain. Important: An update that adds or removes role
    * instances will result in a configuration update to all roles that are
    * deployed in the cloud service. Existing role instances need to be
    * notified of new role instances so that all role instances can
    * communicate together in the cloud service. By default, a cloud service
    * is deployed with five update domains, which are updated one at a time
    * during an in-place update. For information on modifying the number of
    * update domains in the service definition file, see the Azure Service
    * Definition Schema (.csdef File). To determine the update domain in which
    * a particular instance is running in Windows Azure, use the UpdateDomain
    * property of the RoleInstance class. See the Azure Managed Library
    * Reference at
    * http://msdn.microsoft.com/en-us/library/windowsazure/dd179380.aspx for
    * more information.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460793.aspx for
    * more information)
    *
    * @param serviceName Required. The cloud service to upgrade.
    * @param deploymentSlot Required. The slot to upgrade.
    * @param parameters Required. Parameters supplied to the Upgrade Deployment
    * By Slot operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse upgradeBySlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentUpgradeParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "upgradeBySlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginUpgradingBySlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Walk Upgrade Domain By Deployment Name operation specifies an update
    * domain in which a role instance must be updated. For more information
    * about updating role instances, see Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Walk Upgrade
    * Domain By Deployment Name operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> walkUpgradeDomainByDeploymentNameAsync(final String serviceName, final String deploymentName, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return walkUpgradeDomainByDeploymentName(serviceName, deploymentName, parameters);
            }
         });
    }
    
    /**
    * The Walk Upgrade Domain By Deployment Name operation specifies an update
    * domain in which a role instance must be updated. For more information
    * about updating role instances, see Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentName Required. The name of your deployment.
    * @param parameters Required. Parameters supplied to the Walk Upgrade
    * Domain By Deployment Name operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse walkUpgradeDomainByDeploymentName(String serviceName, String deploymentName, DeploymentWalkUpgradeDomainParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentName", deploymentName);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "walkUpgradeDomainByDeploymentNameAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginWalkingUpgradeDomainByDeploymentNameAsync(serviceName, deploymentName, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
    
    /**
    * The Walk Upgrade Domain By Deployment Slot operation specifies an update
    * domain in which a role instance must be updated. For more information
    * about updating role instances, see Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Walk Upgrade
    * Domain By Deployment Slot operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public Future<OperationStatusResponse> walkUpgradeDomainByDeploymentSlotAsync(final String serviceName, final DeploymentSlot deploymentSlot, final DeploymentWalkUpgradeDomainParameters parameters) {
        return this.getClient().getExecutorService().submit(new Callable<OperationStatusResponse>() { 
            @Override
            public OperationStatusResponse call() throws Exception {
                return walkUpgradeDomainByDeploymentSlot(serviceName, deploymentSlot, parameters);
            }
         });
    }
    
    /**
    * The Walk Upgrade Domain By Deployment Slot operation specifies an update
    * domain in which a role instance must be updated. For more information
    * about updating role instances, see Update an Azure Service at
    * http://msdn.microsoft.com/en-us/library/windowsazure/hh472157.aspx. This
    * operation is an asynchronous operation. To determine whether the
    * Management service has finished processing the request, call Get
    * Operation Status. For more information on asynchronous operations, see
    * Tracking Asynchronous Service Management Requests at
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460791.aspx.
    * Prior to calling the Walk Upgrade Domain operation you must have called
    * Upgrade Deployment, Change Deployment Configuration, or Rollback Update
    * Or Upgrade. By default, a service is deployed with five update domains,
    * which are updated one at a time during an in-place update. For
    * information on modifying the number of update domains in the service
    * definition file, see the Azure Service Definition Schema (.csdef File).
    * To perform a manual update of your deployment, proceed in this order:
    * Call Upgrade Deployment with the Mode element set to manual. Call Walk
    * Upgrade Domain to update each domain within the deployment. Update
    * domains must be updated in order. For example, begin with domain 0,
    * proceed to domain 1, and so on. Important: An update that adds or
    * removes role instances will result in a configuration update to all
    * roles that are deployed in the cloud service. Existing role instances
    * need to be notified of new role instances so that all role instances can
    * communicate together in the cloud service. While an update is in
    * progress, call Get Deployment to determine its status. If the update is
    * in progress, Get Deployment returns an UpgradeStatus element that
    * contains information about the update. If the update is complete, or if
    * no update is in progress, then the UpgradeStatus element is null.  (see
    * http://msdn.microsoft.com/en-us/library/windowsazure/ee460800.aspx for
    * more information)
    *
    * @param serviceName Required. The name of the cloud service.
    * @param deploymentSlot Required. The deployment slot.
    * @param parameters Required. Parameters supplied to the Walk Upgrade
    * Domain By Deployment Slot operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    @Override
    public OperationStatusResponse walkUpgradeDomainByDeploymentSlot(String serviceName, DeploymentSlot deploymentSlot, DeploymentWalkUpgradeDomainParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException {
        ComputeManagementClient client2 = this.getClient();
        boolean shouldTrace = CloudTracing.getIsEnabled();
        String invocationId = null;
        if (shouldTrace) {
            invocationId = Long.toString(CloudTracing.getNextInvocationId());
            HashMap<String, Object> tracingParameters = new HashMap<String, Object>();
            tracingParameters.put("serviceName", serviceName);
            tracingParameters.put("deploymentSlot", deploymentSlot);
            tracingParameters.put("parameters", parameters);
            CloudTracing.enter(invocationId, this, "walkUpgradeDomainByDeploymentSlotAsync", tracingParameters);
        }
        try {
            if (shouldTrace) {
                client2 = this.getClient().withRequestFilterLast(new ClientRequestTrackingHandler(invocationId)).withResponseFilterLast(new ClientRequestTrackingHandler(invocationId));
            }
            
            OperationResponse response = client2.getDeploymentsOperations().beginWalkingUpgradeDomainByDeploymentSlotAsync(serviceName, deploymentSlot, parameters).get();
            OperationStatusResponse result = client2.getOperationStatusAsync(response.getRequestId()).get();
            int delayInSeconds = 30;
            if (client2.getLongRunningOperationInitialTimeout() >= 0) {
                delayInSeconds = client2.getLongRunningOperationInitialTimeout();
            }
            while ((result.getStatus() != OperationStatus.InProgress) == false) {
                Thread.sleep(delayInSeconds * 1000);
                result = client2.getOperationStatusAsync(response.getRequestId()).get();
                delayInSeconds = 30;
                if (client2.getLongRunningOperationRetryTimeout() >= 0) {
                    delayInSeconds = client2.getLongRunningOperationRetryTimeout();
                }
            }
            
            if (shouldTrace) {
                CloudTracing.exit(invocationId, result);
            }
            
            if (result.getStatus() != OperationStatus.Succeeded) {
                if (result.getError() != null) {
                    ServiceException ex = new ServiceException(result.getError().getCode() + " : " + result.getError().getMessage());
                    ex.setErrorCode(result.getError().getCode());
                    ex.setErrorMessage(result.getError().getMessage());
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                } else {
                    ServiceException ex = new ServiceException("");
                    if (shouldTrace) {
                        CloudTracing.error(invocationId, ex);
                    }
                    throw ex;
                }
            }
            
            return result;
        } finally {
            if (client2 != null && shouldTrace) {
                client2.close();
            }
        }
    }
}
