/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute;

import com.microsoft.windowsazure.core.OperationResponse;
import com.microsoft.windowsazure.core.OperationStatusResponse;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerCreateParameters;
import com.microsoft.windowsazure.management.compute.models.LoadBalancerUpdateParameters;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

/**
* The Compute Management API includes operations for managing the load
* balancers for your subscription.
*/
public interface LoadBalancerOperations {
    /**
    * Add an internal load balancer to a an existing deployment. When used by
    * an input endpoint, the internal load balancer will provide an additional
    * private VIP that can be used for load balancing to the roles in this
    * deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Create Load
    * Balancer operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginCreating(String serviceName, String deploymentName, LoadBalancerCreateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Add an internal load balancer to a an existing deployment. When used by
    * an input endpoint, the internal load balancer will provide an additional
    * private VIP that can be used for load balancing to the roles in this
    * deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Create Load
    * Balancer operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginCreatingAsync(String serviceName, String deploymentName, LoadBalancerCreateParameters parameters);
    
    /**
    * Delete an internal load balancer from the deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the load balancer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginDeleting(String serviceName, String deploymentName, String loadBalancerName) throws IOException, ServiceException;
    
    /**
    * Delete an internal load balancer from the deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the load balancer.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginDeletingAsync(String serviceName, String deploymentName, String loadBalancerName);
    
    /**
    * Updates an internal load balancer associated with an existing deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balancer operation.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse beginUpdating(String serviceName, String deploymentName, String loadBalancerName, LoadBalancerUpdateParameters parameters) throws ParserConfigurationException, SAXException, TransformerException, IOException, ServiceException;
    
    /**
    * Updates an internal load balancer associated with an existing deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balancer operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> beginUpdatingAsync(String serviceName, String deploymentName, String loadBalancerName, LoadBalancerUpdateParameters parameters);
    
    /**
    * Add an internal load balancer to a an existing deployment. When used by
    * an input endpoint, the internal load balancer will provide an additional
    * private VIP that can be used for load balancing to the roles in this
    * deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Create Load
    * Balancer operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse create(String serviceName, String deploymentName, LoadBalancerCreateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * Add an internal load balancer to a an existing deployment. When used by
    * an input endpoint, the internal load balancer will provide an additional
    * private VIP that can be used for load balancing to the roles in this
    * deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param parameters Required. Parameters supplied to the Create Load
    * Balancer operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> createAsync(String serviceName, String deploymentName, LoadBalancerCreateParameters parameters);
    
    /**
    * Delete an internal load balancer from the deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the load balancer.
    * @throws IOException Signals that an I/O exception of some sort has
    * occurred. This class is the general class of exceptions produced by
    * failed or interrupted I/O operations.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    OperationResponse delete(String serviceName, String deploymentName, String loadBalancerName) throws IOException, ServiceException, InterruptedException, ExecutionException;
    
    /**
    * Delete an internal load balancer from the deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the load balancer.
    * @return A standard service response including an HTTP status code and
    * request ID.
    */
    Future<OperationResponse> deleteAsync(String serviceName, String deploymentName, String loadBalancerName);
    
    /**
    * Updates an internal load balancer associated with an existing deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balancer operation.
    * @throws InterruptedException Thrown when a thread is waiting, sleeping,
    * or otherwise occupied, and the thread is interrupted, either before or
    * during the activity. Occasionally a method may wish to test whether the
    * current thread has been interrupted, and if so, to immediately throw
    * this exception. The following code can be used to achieve this effect:
    * @throws ExecutionException Thrown when attempting to retrieve the result
    * of a task that aborted by throwing an exception. This exception can be
    * inspected using the Throwable.getCause() method.
    * @throws ServiceException Thrown if the server returned an error for the
    * request.
    * @throws IOException Thrown if there was an error setting up tracing for
    * the request.
    * @throws ParserConfigurationException Thrown if there was an error
    * configuring the parser for the response body.
    * @throws SAXException Thrown if there was an error parsing the response
    * body.
    * @throws TransformerException Thrown if there was an error creating the
    * DOM transformer.
    * @throws ServiceException Thrown if an unexpected response is found.
    * @throws URISyntaxException Thrown if there was an error parsing a URI in
    * the response.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    OperationStatusResponse update(String serviceName, String deploymentName, String loadBalancerName, LoadBalancerUpdateParameters parameters) throws InterruptedException, ExecutionException, ServiceException, IOException, ParserConfigurationException, SAXException, TransformerException, URISyntaxException;
    
    /**
    * Updates an internal load balancer associated with an existing deployment.
    *
    * @param serviceName Required. The name of the service.
    * @param deploymentName Required. The name of the deployment.
    * @param loadBalancerName Required. The name of the loadBalancer.
    * @param parameters Required. Parameters supplied to the Update Load
    * Balancer operation.
    * @return The response body contains the status of the specified
    * asynchronous operation, indicating whether it has succeeded, is
    * inprogress, or has failed. Note that this status is distinct from the
    * HTTP status code returned for the Get Operation Status operation itself.
    * If the asynchronous operation succeeded, the response body includes the
    * HTTP status code for the successful request. If the asynchronous
    * operation failed, the response body includes the HTTP status code for
    * the failed request and error information regarding the failure.
    */
    Future<OperationStatusResponse> updateAsync(String serviceName, String deploymentName, String loadBalancerName, LoadBalancerUpdateParameters parameters);
}
