/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

/**
* Parameters supplied to the Walk Upgrade Domain operation.
*/
public class DeploymentWalkUpgradeDomainParameters {
    private int upgradeDomain;
    
    /**
    * Required. An integer value that identifies the update domain to update.
    * Update domains are identified with a zero-based index: the first update
    * domain has an ID of 0, the second has an ID of 1, and so on.
    * @return The UpgradeDomain value.
    */
    public int getUpgradeDomain() {
        return this.upgradeDomain;
    }
    
    /**
    * Required. An integer value that identifies the update domain to update.
    * Update domains are identified with a zero-based index: the first update
    * domain has an ID of 0, the second has an ID of 1, and so on.
    * @param upgradeDomainValue The UpgradeDomain value.
    */
    public void setUpgradeDomain(final int upgradeDomainValue) {
        this.upgradeDomain = upgradeDomainValue;
    }
    
    /**
    * Initializes a new instance of the DeploymentWalkUpgradeDomainParameters
    * class.
    *
    */
    public DeploymentWalkUpgradeDomainParameters() {
    }
    
    /**
    * Initializes a new instance of the DeploymentWalkUpgradeDomainParameters
    * class with required arguments.
    *
    */
    public DeploymentWalkUpgradeDomainParameters(int upgradeDomain) {
        this.setUpgradeDomain(upgradeDomain);
    }
}
