/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import com.microsoft.windowsazure.core.LazyArrayList;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;

/**
* The Extension Image.
*/
public class ExtensionImage {
    private Boolean blockRoleUponFailure;
    
    /**
    * Optional. Optional. Its value has to be 'true' or 'false'
    * (case-sensitive) When set to 'true', the role startup will be blocked
    * till the extension installation completes. This flag should be set to
    * 'true' when the role cannot start without the extension being installed.
    * If set to 'false' (default value), the role will be started without
    * waiting for the extension installation to complete. Supported on WebRole
    * or WorkerRole, but ignored on VmRole.
    * @return The BlockRoleUponFailure value.
    */
    public Boolean isBlockRoleUponFailure() {
        return this.blockRoleUponFailure;
    }
    
    /**
    * Optional. Optional. Its value has to be 'true' or 'false'
    * (case-sensitive) When set to 'true', the role startup will be blocked
    * till the extension installation completes. This flag should be set to
    * 'true' when the role cannot start without the extension being installed.
    * If set to 'false' (default value), the role will be started without
    * waiting for the extension installation to complete. Supported on WebRole
    * or WorkerRole, but ignored on VmRole.
    * @param blockRoleUponFailureValue The BlockRoleUponFailure value.
    */
    public void setBlockRoleUponFailure(final Boolean blockRoleUponFailureValue) {
        this.blockRoleUponFailure = blockRoleUponFailureValue;
    }
    
    private ExtensionCertificateConfiguration certificate;
    
    /**
    * Optional. Optional. Parameters of the the certificate for encrypting the
    * private configuration data. Supported on WebRole or WorkerRole, but
    * ignored on VmRole.
    * @return The Certificate value.
    */
    public ExtensionCertificateConfiguration getCertificate() {
        return this.certificate;
    }
    
    /**
    * Optional. Optional. Parameters of the the certificate for encrypting the
    * private configuration data. Supported on WebRole or WorkerRole, but
    * ignored on VmRole.
    * @param certificateValue The Certificate value.
    */
    public void setCertificate(final ExtensionCertificateConfiguration certificateValue) {
        this.certificate = certificateValue;
    }
    
    private String companyName;
    
    /**
    * Optional. String property containing the name of the company/organization
    * who publishes the extension.
    * @return The CompanyName value.
    */
    public String getCompanyName() {
        return this.companyName;
    }
    
    /**
    * Optional. String property containing the name of the company/organization
    * who publishes the extension.
    * @param companyNameValue The CompanyName value.
    */
    public void setCompanyName(final String companyNameValue) {
        this.companyName = companyNameValue;
    }
    
    private String description;
    
    /**
    * Optional. Required. Detailed description of the extension.
    * @return The Description value.
    */
    public String getDescription() {
        return this.description;
    }
    
    /**
    * Optional. Required. Detailed description of the extension.
    * @param descriptionValue The Description value.
    */
    public void setDescription(final String descriptionValue) {
        this.description = descriptionValue;
    }
    
    private Boolean disallowMajorVersionUpgrade;
    
    /**
    * Optional. Optional. If this is set to 'true' the extension version cannot
    * be upgraded to from other major versions in active deployments. If the
    * value is 'false' or nor present, the extension version can be upgraded
    * to from any other version. Downgrade is not supported. The value has to
    * be 'true' or 'false' (case-sensitive) if present.
    * @return The DisallowMajorVersionUpgrade value.
    */
    public Boolean isDisallowMajorVersionUpgrade() {
        return this.disallowMajorVersionUpgrade;
    }
    
    /**
    * Optional. Optional. If this is set to 'true' the extension version cannot
    * be upgraded to from other major versions in active deployments. If the
    * value is 'false' or nor present, the extension version can be upgraded
    * to from any other version. Downgrade is not supported. The value has to
    * be 'true' or 'false' (case-sensitive) if present.
    * @param disallowMajorVersionUpgradeValue The DisallowMajorVersionUpgrade
    * value.
    */
    public void setDisallowMajorVersionUpgrade(final Boolean disallowMajorVersionUpgradeValue) {
        this.disallowMajorVersionUpgrade = disallowMajorVersionUpgradeValue;
    }
    
    private URI eula;
    
    /**
    * Optional. Optional. URL string pointing to the EULA (End User License
    * Agreement) of this version of extension. This is optionally specified by
    * the third-party publishing the extension instead of Windows Azure. If
    * the software requires any additional EULAs, a link to the EULA should be
    * provided.
    * @return The Eula value.
    */
    public URI getEula() {
        return this.eula;
    }
    
    /**
    * Optional. Optional. URL string pointing to the EULA (End User License
    * Agreement) of this version of extension. This is optionally specified by
    * the third-party publishing the extension instead of Windows Azure. If
    * the software requires any additional EULAs, a link to the EULA should be
    * provided.
    * @param eulaValue The Eula value.
    */
    public void setEula(final URI eulaValue) {
        this.eula = eulaValue;
    }
    
    private ExtensionEndpointConfiguration extensionEndpoints;
    
    /**
    * Optional. Optional. Declared endpoints to automatically add to each
    * deployment with this extension added.
    * @return The ExtensionEndpoints value.
    */
    public ExtensionEndpointConfiguration getExtensionEndpoints() {
        return this.extensionEndpoints;
    }
    
    /**
    * Optional. Optional. Declared endpoints to automatically add to each
    * deployment with this extension added.
    * @param extensionEndpointsValue The ExtensionEndpoints value.
    */
    public void setExtensionEndpoints(final ExtensionEndpointConfiguration extensionEndpointsValue) {
        this.extensionEndpoints = extensionEndpointsValue;
    }
    
    private URI homepageUri;
    
    /**
    * Optional. Optional. URL string pointing to homepage of this version of
    * extension. This is optionally specified by the third-party publishing
    * the extension instead of Azure. The homepage should have usage
    * information and contact information for customer support.
    * @return The HomepageUri value.
    */
    public URI getHomepageUri() {
        return this.homepageUri;
    }
    
    /**
    * Optional. Optional. URL string pointing to homepage of this version of
    * extension. This is optionally specified by the third-party publishing
    * the extension instead of Azure. The homepage should have usage
    * information and contact information for customer support.
    * @param homepageUriValue The HomepageUri value.
    */
    public void setHomepageUri(final URI homepageUriValue) {
        this.homepageUri = homepageUriValue;
    }
    
    private String hostingResources;
    
    /**
    * Optional. Required. The supported hosting resources. It must contain
    * 'WebRole' and/or 'WorkerRole'. E.g. 'WebRole|WorkerRole' or
    * 'WebRole|WorkerRole|VmRole'.
    * @return The HostingResources value.
    */
    public String getHostingResources() {
        return this.hostingResources;
    }
    
    /**
    * Optional. Required. The supported hosting resources. It must contain
    * 'WebRole' and/or 'WorkerRole'. E.g. 'WebRole|WorkerRole' or
    * 'WebRole|WorkerRole|VmRole'.
    * @param hostingResourcesValue The HostingResources value.
    */
    public void setHostingResources(final String hostingResourcesValue) {
        this.hostingResources = hostingResourcesValue;
    }
    
    private Boolean isInternalExtension;
    
    /**
    * Optional. Optional. If this is set to 'true' the extension is not visible
    * for public use, i.e. being returned from list API's. It can be still
    * accessed by referring to the ProviderNamespace, Type & Version combo.
    * Therefore an internal extension is intended only for testing purpose.
    * Its value has to be 'true' or 'false' (case-sensitive) if present.
    * @return The IsInternalExtension value.
    */
    public Boolean isInternalExtension() {
        return this.isInternalExtension;
    }
    
    /**
    * Optional. Optional. If this is set to 'true' the extension is not visible
    * for public use, i.e. being returned from list API's. It can be still
    * accessed by referring to the ProviderNamespace, Type & Version combo.
    * Therefore an internal extension is intended only for testing purpose.
    * Its value has to be 'true' or 'false' (case-sensitive) if present.
    * @param isInternalExtensionValue The IsInternalExtension value.
    */
    public void setIsInternalExtension(final Boolean isInternalExtensionValue) {
        this.isInternalExtension = isInternalExtensionValue;
    }
    
    private Boolean isJsonExtension;
    
    /**
    * Optional. Optional. If this is set to 'true' the extension is expected to
    * receive JSON based configuration. If this is set to 'false' the
    * extension is expected to receive XML based configuration. Its value has
    * to be 'true' or 'false' (case-sensitive) if present.
    * @return The IsJsonExtension value.
    */
    public Boolean isJsonExtension() {
        return this.isJsonExtension;
    }
    
    /**
    * Optional. Optional. If this is set to 'true' the extension is expected to
    * receive JSON based configuration. If this is set to 'false' the
    * extension is expected to receive XML based configuration. Its value has
    * to be 'true' or 'false' (case-sensitive) if present.
    * @param isJsonExtensionValue The IsJsonExtension value.
    */
    public void setIsJsonExtension(final Boolean isJsonExtensionValue) {
        this.isJsonExtension = isJsonExtensionValue;
    }
    
    private String label;
    
    /**
    * Optional. Required. A one line label of the extension.
    * @return The Label value.
    */
    public String getLabel() {
        return this.label;
    }
    
    /**
    * Optional. Required. A one line label of the extension.
    * @param labelValue The Label value.
    */
    public void setLabel(final String labelValue) {
        this.label = labelValue;
    }
    
    private ArrayList<ExtensionLocalResourceConfiguration> localResources;
    
    /**
    * Optional. Declared local resources used inside guest VM by the extension.
    * Optional.
    * @return The LocalResources value.
    */
    public ArrayList<ExtensionLocalResourceConfiguration> getLocalResources() {
        return this.localResources;
    }
    
    /**
    * Optional. Declared local resources used inside guest VM by the extension.
    * Optional.
    * @param localResourcesValue The LocalResources value.
    */
    public void setLocalResources(final ArrayList<ExtensionLocalResourceConfiguration> localResourcesValue) {
        this.localResources = localResourcesValue;
    }
    
    private URI mediaLink;
    
    /**
    * Optional. Required. URI string pointing to the ZIP package of the
    * extension. The ZIP package has to include the extension executable and
    * other supporting files, and the PluginManifest.xml manifest. MediaLink
    * value must point to a URL (either Http or Https) in a Azure blob storage
    * and is downloadable. Windows Azure will copy the extension package from
    * this source location and replicate it to all regions. The typical time
    * for replication to complete is 20 minutes.
    * @return The MediaLink value.
    */
    public URI getMediaLink() {
        return this.mediaLink;
    }
    
    /**
    * Optional. Required. URI string pointing to the ZIP package of the
    * extension. The ZIP package has to include the extension executable and
    * other supporting files, and the PluginManifest.xml manifest. MediaLink
    * value must point to a URL (either Http or Https) in a Azure blob storage
    * and is downloadable. Windows Azure will copy the extension package from
    * this source location and replicate it to all regions. The typical time
    * for replication to complete is 20 minutes.
    * @param mediaLinkValue The MediaLink value.
    */
    public void setMediaLink(final URI mediaLinkValue) {
        this.mediaLink = mediaLinkValue;
    }
    
    private URI privacyUri;
    
    /**
    * Optional. Optional. URL string pointing to privacy document of this
    * version of extension. This is optionally specified by the third-party
    * publishing the extension instead of Azure. If the software collects any
    * data and transfers out the guest VM, then an additional privacy document
    * might be needed.
    * @return The PrivacyUri value.
    */
    public URI getPrivacyUri() {
        return this.privacyUri;
    }
    
    /**
    * Optional. Optional. URL string pointing to privacy document of this
    * version of extension. This is optionally specified by the third-party
    * publishing the extension instead of Azure. If the software collects any
    * data and transfers out the guest VM, then an additional privacy document
    * might be needed.
    * @param privacyUriValue The PrivacyUri value.
    */
    public void setPrivacyUri(final URI privacyUriValue) {
        this.privacyUri = privacyUriValue;
    }
    
    private String privateConfigurationSchema;
    
    /**
    * Optional. Optional. The XSD schema of private configuration data.
    * @return The PrivateConfigurationSchema value.
    */
    public String getPrivateConfigurationSchema() {
        return this.privateConfigurationSchema;
    }
    
    /**
    * Optional. Optional. The XSD schema of private configuration data.
    * @param privateConfigurationSchemaValue The PrivateConfigurationSchema
    * value.
    */
    public void setPrivateConfigurationSchema(final String privateConfigurationSchemaValue) {
        this.privateConfigurationSchema = privateConfigurationSchemaValue;
    }
    
    private String providerNameSpace;
    
    /**
    * Required. Required. The provider namespace of the extension.
    * @return The ProviderNameSpace value.
    */
    public String getProviderNameSpace() {
        return this.providerNameSpace;
    }
    
    /**
    * Required. Required. The provider namespace of the extension.
    * @param providerNameSpaceValue The ProviderNameSpace value.
    */
    public void setProviderNameSpace(final String providerNameSpaceValue) {
        this.providerNameSpace = providerNameSpaceValue;
    }
    
    private String publicConfigurationSchema;
    
    /**
    * Optional. Optional. The XSD schema of public configuration data.
    * @return The PublicConfigurationSchema value.
    */
    public String getPublicConfigurationSchema() {
        return this.publicConfigurationSchema;
    }
    
    /**
    * Optional. Optional. The XSD schema of public configuration data.
    * @param publicConfigurationSchemaValue The PublicConfigurationSchema value.
    */
    public void setPublicConfigurationSchema(final String publicConfigurationSchemaValue) {
        this.publicConfigurationSchema = publicConfigurationSchemaValue;
    }
    
    private Calendar publishedDate;
    
    /**
    * Optional. Publisher can set it to any arbitrary date, and this is only
    * for display purpose. If not specified by publisher, Azure will
    * automatically assign the UTC time when the extension request was
    * received.
    * @return The PublishedDate value.
    */
    public Calendar getPublishedDate() {
        return this.publishedDate;
    }
    
    /**
    * Optional. Publisher can set it to any arbitrary date, and this is only
    * for display purpose. If not specified by publisher, Azure will
    * automatically assign the UTC time when the extension request was
    * received.
    * @param publishedDateValue The PublishedDate value.
    */
    public void setPublishedDate(final Calendar publishedDateValue) {
        this.publishedDate = publishedDateValue;
    }
    
    private String publisherName;
    
    /**
    * Optional. Optional. Publisher name text.
    * @return The PublisherName value.
    */
    public String getPublisherName() {
        return this.publisherName;
    }
    
    /**
    * Optional. Optional. Publisher name text.
    * @param publisherNameValue The PublisherName value.
    */
    public void setPublisherName(final String publisherNameValue) {
        this.publisherName = publisherNameValue;
    }
    
    private Boolean replicationCompleted;
    
    /**
    * Optional. Indicates whether this version of extension has been replicated
    * to all regions or not. If true, then the given extension version can be
    * used in creating or updating deployments. Otherwise, the given extension
    * version might cause failure in creating or updating deployments. The
    * typical time is 20 minutes for a newly-registered or newly-updated
    * extension to replicate completely by Azure.
    * @return The ReplicationCompleted value.
    */
    public Boolean isReplicationCompleted() {
        return this.replicationCompleted;
    }
    
    /**
    * Optional. Indicates whether this version of extension has been replicated
    * to all regions or not. If true, then the given extension version can be
    * used in creating or updating deployments. Otherwise, the given extension
    * version might cause failure in creating or updating deployments. The
    * typical time is 20 minutes for a newly-registered or newly-updated
    * extension to replicate completely by Azure.
    * @param replicationCompletedValue The ReplicationCompleted value.
    */
    public void setReplicationCompleted(final Boolean replicationCompletedValue) {
        this.replicationCompleted = replicationCompletedValue;
    }
    
    private String sampleConfig;
    
    /**
    * Optional. Optional. A sample configuration for the extension. It can be
    * downloaded by users, and the user can replace with customized input
    * parameters. The sample configuration should be sufficiently commented.
    * If configuration data are in XML format, then the XML document-level
    * element must be 'Configuration', and the optional public configuration
    * data corresponds to a child element of 'PublicConfig', and the optional
    * private configuration data corresponds to a child element of
    * 'PrivateConfig'. The sample configuration data should be validated
    * against public and private configuration schema by the publisher.
    * @return The SampleConfig value.
    */
    public String getSampleConfig() {
        return this.sampleConfig;
    }
    
    /**
    * Optional. Optional. A sample configuration for the extension. It can be
    * downloaded by users, and the user can replace with customized input
    * parameters. The sample configuration should be sufficiently commented.
    * If configuration data are in XML format, then the XML document-level
    * element must be 'Configuration', and the optional public configuration
    * data corresponds to a child element of 'PublicConfig', and the optional
    * private configuration data corresponds to a child element of
    * 'PrivateConfig'. The sample configuration data should be validated
    * against public and private configuration schema by the publisher.
    * @param sampleConfigValue The SampleConfig value.
    */
    public void setSampleConfig(final String sampleConfigValue) {
        this.sampleConfig = sampleConfigValue;
    }
    
    private String supportedOS;
    
    /**
    * Optional. String property indicating the OS which the extension supports.
    * Current values are 'Windows' or 'Linux'.
    * @return The SupportedOS value.
    */
    public String getSupportedOS() {
        return this.supportedOS;
    }
    
    /**
    * Optional. String property indicating the OS which the extension supports.
    * Current values are 'Windows' or 'Linux'.
    * @param supportedOSValue The SupportedOS value.
    */
    public void setSupportedOS(final String supportedOSValue) {
        this.supportedOS = supportedOSValue;
    }
    
    private String type;
    
    /**
    * Required. Required. The type of the extension.
    * @return The Type value.
    */
    public String getType() {
        return this.type;
    }
    
    /**
    * Required. Required. The type of the extension.
    * @param typeValue The Type value.
    */
    public void setType(final String typeValue) {
        this.type = typeValue;
    }
    
    private String version;
    
    /**
    * Required. Required. The version of the extension.
    * @return The Version value.
    */
    public String getVersion() {
        return this.version;
    }
    
    /**
    * Required. Required. The version of the extension.
    * @param versionValue The Version value.
    */
    public void setVersion(final String versionValue) {
        this.version = versionValue;
    }
    
    /**
    * Initializes a new instance of the ExtensionImage class.
    *
    */
    public ExtensionImage() {
        this.setLocalResources(new LazyArrayList<ExtensionLocalResourceConfiguration>());
    }
    
    /**
    * Initializes a new instance of the ExtensionImage class with required
    * arguments.
    *
    */
    public ExtensionImage(String providerNameSpace, String type, String version) {
        this();
        if (providerNameSpace == null) {
            throw new NullPointerException("providerNameSpace");
        }
        if (type == null) {
            throw new NullPointerException("type");
        }
        if (version == null) {
            throw new NullPointerException("version");
        }
        this.setProviderNameSpace(providerNameSpace);
        this.setType(type);
        this.setVersion(version);
    }
}
