/**
 * 
 * Copyright (c) Microsoft and contributors.  All rights reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * 
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 */

// Warning: This code was generated by a tool.
// 
// Changes to this file may cause incorrect behavior and will be lost if the
// code is regenerated.

package com.microsoft.windowsazure.management.compute.models;

import java.net.InetAddress;

/**
* Objects that provide instance endpoint details.
*/
public class InstanceEndpoint {
    private Integer idleTimeoutInMinutes;
    
    /**
    * Optional. The idle timeout in minutes for this endpoint.
    * @return The IdleTimeoutInMinutes value.
    */
    public Integer getIdleTimeoutInMinutes() {
        return this.idleTimeoutInMinutes;
    }
    
    /**
    * Optional. The idle timeout in minutes for this endpoint.
    * @param idleTimeoutInMinutesValue The IdleTimeoutInMinutes value.
    */
    public void setIdleTimeoutInMinutes(final Integer idleTimeoutInMinutesValue) {
        this.idleTimeoutInMinutes = idleTimeoutInMinutesValue;
    }
    
    private Integer localPort;
    
    /**
    * Optional. Specifies the internal port on which the virtual machine is
    * listening to serve the endpoint. This element is only listed for Virtual
    * Machine deployments.
    * @return The LocalPort value.
    */
    public Integer getLocalPort() {
        return this.localPort;
    }
    
    /**
    * Optional. Specifies the internal port on which the virtual machine is
    * listening to serve the endpoint. This element is only listed for Virtual
    * Machine deployments.
    * @param localPortValue The LocalPort value.
    */
    public void setLocalPort(final Integer localPortValue) {
        this.localPort = localPortValue;
    }
    
    private String name;
    
    /**
    * Optional. Specifies the name for the external endpoint. This element is
    * only listed for Virtual Machine deployments.
    * @return The Name value.
    */
    public String getName() {
        return this.name;
    }
    
    /**
    * Optional. Specifies the name for the external endpoint. This element is
    * only listed for Virtual Machine deployments.
    * @param nameValue The Name value.
    */
    public void setName(final String nameValue) {
        this.name = nameValue;
    }
    
    private int port;
    
    /**
    * Optional. The external port of the role instance endpoint.
    * @return The Port value.
    */
    public int getPort() {
        return this.port;
    }
    
    /**
    * Optional. The external port of the role instance endpoint.
    * @param portValue The Port value.
    */
    public void setPort(final int portValue) {
        this.port = portValue;
    }
    
    private String protocol;
    
    /**
    * Optional. Specifies the transport protocol for the endpoint.
    * @return The Protocol value.
    */
    public String getProtocol() {
        return this.protocol;
    }
    
    /**
    * Optional. Specifies the transport protocol for the endpoint.
    * @param protocolValue The Protocol value.
    */
    public void setProtocol(final String protocolValue) {
        this.protocol = protocolValue;
    }
    
    private InetAddress virtualIPAddress;
    
    /**
    * Optional. The Virtual IP of the role endpoint.
    * @return The VirtualIPAddress value.
    */
    public InetAddress getVirtualIPAddress() {
        return this.virtualIPAddress;
    }
    
    /**
    * Optional. The Virtual IP of the role endpoint.
    * @param virtualIPAddressValue The VirtualIPAddress value.
    */
    public void setVirtualIPAddress(final InetAddress virtualIPAddressValue) {
        this.virtualIPAddress = virtualIPAddressValue;
    }
}
