/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class CustomPropertiesMapper {
    private static final String RFC_1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";

    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> type = value.getClass();
        if (type == Byte.class) {
            return value.toString();
        }
        if (type == Short.class) {
            return value.toString();
        }
        if (type == Integer.class) {
            return value.toString();
        }
        if (type == Long.class) {
            return value.toString();
        }
        if (type == Float.class) {
            return value.toString();
        }
        if (type == Double.class) {
            return value.toString();
        }
        if (type == Boolean.class) {
            return value.toString();
        }
        if (Calendar.class.isAssignableFrom(type)) {
            SimpleDateFormat format = new SimpleDateFormat(RFC_1123, Locale.US);
            Calendar calendar = (Calendar)value;
            format.setTimeZone(calendar.getTimeZone());
            String formatted = format.format(calendar.getTime());
            return "\"" + formatted + "\"";
        }
        if (Date.class.isAssignableFrom(type)) {
            SimpleDateFormat format = new SimpleDateFormat(RFC_1123, Locale.US);
            format.setTimeZone(TimeZone.getTimeZone("GMT"));
            String formatted = format.format((Date)value);
            return "\"" + formatted + "\"";
        }
        return "\"" + value.toString() + "\"";
    }

    public Object fromString(String value) throws ParseException {
        if (value == null) {
            return null;
        }
        if (value.startsWith("\"") && value.endsWith("\"")) {
            String text = value.substring(1, value.length() - 1);
            if (this.isRFC1123(text)) {
                SimpleDateFormat format = new SimpleDateFormat(RFC_1123, Locale.US);
                return format.parse(text);
            }
            return text;
        }
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        if (this.isInteger(value)) {
            return Integer.parseInt(value);
        }
        return Double.parseDouble(value);
    }

    private boolean isRFC1123(String text) {
        if (text.length() != RFC_1123.length()) {
            return false;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(RFC_1123, Locale.US);
            format.parse(text);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private boolean isInteger(String value) {
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

