/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.servicebus.implementation;

import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceResponseFilter;
import com.microsoft.windowsazure.core.pipeline.jersey.ServiceFilter;
import com.microsoft.windowsazure.exception.ServiceException;
import com.microsoft.windowsazure.exception.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.servicebus.ServiceBusContract;
import com.microsoft.windowsazure.services.servicebus.implementation.ServiceBusRestProxy;
import com.microsoft.windowsazure.services.servicebus.models.BrokeredMessage;
import com.microsoft.windowsazure.services.servicebus.models.CreateQueueResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateRuleResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateSubscriptionResult;
import com.microsoft.windowsazure.services.servicebus.models.CreateTopicResult;
import com.microsoft.windowsazure.services.servicebus.models.GetQueueResult;
import com.microsoft.windowsazure.services.servicebus.models.GetRuleResult;
import com.microsoft.windowsazure.services.servicebus.models.GetSubscriptionResult;
import com.microsoft.windowsazure.services.servicebus.models.GetTopicResult;
import com.microsoft.windowsazure.services.servicebus.models.ListQueuesOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListQueuesResult;
import com.microsoft.windowsazure.services.servicebus.models.ListRulesOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListRulesResult;
import com.microsoft.windowsazure.services.servicebus.models.ListSubscriptionsOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListSubscriptionsResult;
import com.microsoft.windowsazure.services.servicebus.models.ListTopicsOptions;
import com.microsoft.windowsazure.services.servicebus.models.ListTopicsResult;
import com.microsoft.windowsazure.services.servicebus.models.QueueInfo;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveMessageOptions;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveQueueMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.ReceiveSubscriptionMessageResult;
import com.microsoft.windowsazure.services.servicebus.models.RuleInfo;
import com.microsoft.windowsazure.services.servicebus.models.SubscriptionInfo;
import com.microsoft.windowsazure.services.servicebus.models.TopicInfo;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.UniformInterfaceException;
import javax.inject.Inject;
import javax.ws.rs.WebApplicationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ServiceBusExceptionProcessor
implements ServiceBusContract {
    private final ServiceBusContract next;
    private static Log log = LogFactory.getLog(ServiceBusContract.class);

    public ServiceBusExceptionProcessor(ServiceBusContract next) {
        this.next = next;
    }

    @Inject
    public ServiceBusExceptionProcessor(ServiceBusRestProxy next) {
        this.next = next;
    }

    public ServiceBusContract withFilter(ServiceFilter filter) {
        return new ServiceBusExceptionProcessor((ServiceBusContract)this.next.withFilter(filter));
    }

    public ServiceBusContract withRequestFilterFirst(ServiceRequestFilter serviceRequestFilter) {
        return new ServiceBusExceptionProcessor((ServiceBusContract)this.next.withRequestFilterFirst(serviceRequestFilter));
    }

    public ServiceBusContract withRequestFilterLast(ServiceRequestFilter serviceRequestFilter) {
        return new ServiceBusExceptionProcessor((ServiceBusContract)this.next.withRequestFilterLast(serviceRequestFilter));
    }

    public ServiceBusContract withResponseFilterFirst(ServiceResponseFilter serviceResponseFilter) {
        return new ServiceBusExceptionProcessor((ServiceBusContract)this.next.withResponseFilterFirst(serviceResponseFilter));
    }

    public ServiceBusContract withResponseFilterLast(ServiceResponseFilter serviceResponseFilter) {
        return new ServiceBusExceptionProcessor((ServiceBusContract)this.next.withResponseFilterLast(serviceResponseFilter));
    }

    private ServiceException processCatch(ServiceException e) {
        log.warn((Object)e.getMessage(), e.getCause());
        return ServiceExceptionFactory.process((String)"serviceBus", (ServiceException)e);
    }

    @Override
    public void sendQueueMessage(String path, BrokeredMessage message) throws ServiceException {
        try {
            this.next.sendQueueMessage(path, message);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveQueueMessageResult receiveQueueMessage(String queueName) throws ServiceException {
        try {
            return this.next.receiveQueueMessage(queueName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveQueueMessageResult receiveQueueMessage(String queueName, ReceiveMessageOptions options) throws ServiceException {
        try {
            return this.next.receiveQueueMessage(queueName, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void sendTopicMessage(String path, BrokeredMessage message) throws ServiceException {
        try {
            this.next.sendTopicMessage(path, message);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveSubscriptionMessageResult receiveSubscriptionMessage(String topicName, String subscriptionName) throws ServiceException {
        try {
            return this.next.receiveSubscriptionMessage(topicName, subscriptionName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveSubscriptionMessageResult receiveSubscriptionMessage(String topicName, String subscriptionName, ReceiveMessageOptions options) throws ServiceException {
        try {
            return this.next.receiveSubscriptionMessage(topicName, subscriptionName, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void unlockMessage(BrokeredMessage message) throws ServiceException {
        try {
            this.next.unlockMessage(message);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void deleteMessage(BrokeredMessage message) throws ServiceException {
        try {
            this.next.deleteMessage(message);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public CreateQueueResult createQueue(QueueInfo queue) throws ServiceException {
        try {
            return this.next.createQueue(queue);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void deleteQueue(String queuePath) throws ServiceException {
        try {
            this.next.deleteQueue(queuePath);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public GetQueueResult getQueue(String queuePath) throws ServiceException {
        try {
            return this.next.getQueue(queuePath);
        }
        catch (WebApplicationException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListQueuesResult listQueues() throws ServiceException {
        try {
            return this.next.listQueues();
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public QueueInfo updateQueue(QueueInfo queueInfo) throws ServiceException {
        try {
            return this.next.updateQueue(queueInfo);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public CreateTopicResult createTopic(TopicInfo topic) throws ServiceException {
        try {
            return this.next.createTopic(topic);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void deleteTopic(String topicPath) throws ServiceException {
        try {
            this.next.deleteTopic(topicPath);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public GetTopicResult getTopic(String topicPath) throws ServiceException {
        try {
            return this.next.getTopic(topicPath);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListTopicsResult listTopics() throws ServiceException {
        try {
            return this.next.listTopics();
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public TopicInfo updateTopic(TopicInfo topicInfo) throws ServiceException {
        try {
            return this.next.updateTopic(topicInfo);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public CreateSubscriptionResult createSubscription(String topicPath, SubscriptionInfo subscription) throws ServiceException {
        try {
            return this.next.createSubscription(topicPath, subscription);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void deleteSubscription(String topicPath, String subscriptionName) throws ServiceException {
        try {
            this.next.deleteSubscription(topicPath, subscriptionName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public GetSubscriptionResult getSubscription(String topicPath, String subscriptionName) throws ServiceException {
        try {
            return this.next.getSubscription(topicPath, subscriptionName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String topicPath) throws ServiceException {
        try {
            return this.next.listSubscriptions(topicPath);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public SubscriptionInfo updateSubscription(String topicName, SubscriptionInfo subscriptionInfo) throws ServiceException {
        try {
            return this.next.updateSubscription(topicName, subscriptionInfo);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public CreateRuleResult createRule(String topicPath, String subscriptionName, RuleInfo rule) throws ServiceException {
        try {
            return this.next.createRule(topicPath, subscriptionName, rule);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void deleteRule(String topicPath, String subscriptionName, String ruleName) throws ServiceException {
        try {
            this.next.deleteRule(topicPath, subscriptionName, ruleName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public GetRuleResult getRule(String topicPath, String subscriptionName, String ruleName) throws ServiceException {
        try {
            return this.next.getRule(topicPath, subscriptionName, ruleName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListRulesResult listRules(String topicPath, String subscriptionName) throws ServiceException {
        try {
            return this.next.listRules(topicPath, subscriptionName);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesOptions options) throws ServiceException {
        try {
            return this.next.listQueues(options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListTopicsResult listTopics(ListTopicsOptions options) throws ServiceException {
        try {
            return this.next.listTopics(options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListSubscriptionsResult listSubscriptions(String topicName, ListSubscriptionsOptions options) throws ServiceException {
        try {
            return this.next.listSubscriptions(topicName, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ListRulesResult listRules(String topicName, String subscriptionName, ListRulesOptions options) throws ServiceException {
        try {
            return this.next.listRules(topicName, subscriptionName, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void sendMessage(String path, BrokeredMessage message) throws ServiceException {
        try {
            this.next.sendMessage(path, message);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(String path) throws ServiceException {
        try {
            return this.next.receiveMessage(path);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public ReceiveMessageResult receiveMessage(String path, ReceiveMessageOptions options) throws ServiceException {
        try {
            return this.next.receiveMessage(path, options);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void renewQueueLock(String queueName, String messageId, String lockToken) throws ServiceException {
        try {
            this.next.renewQueueLock(queueName, messageId, lockToken);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }

    @Override
    public void renewSubscriptionLock(String topicName, String subscriptionName, String messageId, String lockToken) throws ServiceException {
        try {
            this.next.renewSubscriptionLock(topicName, subscriptionName, messageId, lockToken);
        }
        catch (UniformInterfaceException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
        catch (ClientHandlerException e) {
            throw this.processCatch(new ServiceException((Throwable)e));
        }
    }
}

