/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.ReusablePointer;
import org.bridj.Pointer;
import org.bridj.TypedPointer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class CLAbstractEntity {
    private long entityPeer;
    private final boolean nullable;

    protected CLAbstractEntity(long entityPeer) {
        this(entityPeer, false);
    }

    protected CLAbstractEntity(long entityPeer, boolean nullable) {
        this.nullable = nullable;
        this.entityPeer = entityPeer;
        this.checkNullity(entityPeer);
    }

    private void checkNullity(long entityPeer) {
        if (!this.nullable && entityPeer == 0L) {
            throw new IllegalArgumentException("Null OpenCL " + this.getClass().getSimpleName() + " !");
        }
    }

    protected void setEntity(long entityPeer) {
        this.checkNullity(entityPeer);
        this.entityPeer = entityPeer;
    }

    static <T> Pointer<T> copyNonNullEntities(CLAbstractEntity[] entities, int[] countOut, ReusablePointer tmp) {
        int n;
        if (entities == null || (n = entities.length) == 0) {
            countOut[0] = 0;
            return null;
        }
        Pointer out = null;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            long pointer;
            CLAbstractEntity entity = entities[i];
            if (entity == null || entity == CLEvent.FIRE_AND_FORGET || (pointer = entity.getEntity()) == 0L) continue;
            if (out == null) {
                out = tmp.allocatedBytes(Pointer.SIZE * (n - i));
            }
            out.setSizeTAtOffset((long)(Pointer.SIZE * count), pointer);
            ++count;
        }
        countOut[0] = count;
        return out;
    }

    public synchronized void release() {
        if (this.entityPeer == 0L) {
            if (!this.nullable) {
                throw new RuntimeException("This " + this.getClass().getSimpleName() + " has already been released ! Besides, keep in mind that manual release is not necessary, as it will automatically be done by the garbage collector.");
            }
            return;
        }
        this.doRelease();
    }

    public static <E extends TypedPointer, A extends CLAbstractEntity> Pointer<E> getEntities(A[] objects, Pointer<E> out) {
        int len = objects.length;
        for (int i = 0; i < len; ++i) {
            out.setSizeTAtOffset((long)(i * Pointer.SIZE), ((CLAbstractEntity)objects[i]).getEntity());
        }
        return out;
    }

    private void checkNullity() {
        if (this.entityPeer == 0L && !this.nullable) {
            throw new RuntimeException("This " + this.getClass().getSimpleName() + " has been manually released and can't be used anymore !");
        }
    }

    synchronized long getEntity() {
        this.checkNullity();
        return this.entityPeer;
    }

    synchronized void doRelease() {
        if (this.entityPeer != 0L) {
            this.clear();
            this.entityPeer = 0L;
        }
    }

    protected void finalize() throws Throwable {
        this.doRelease();
    }

    protected abstract void clear();

    public int hashCode() {
        return this.entityPeer == 0L ? 0 : Long.valueOf(this.entityPeer).hashCode();
    }

    public boolean equals(Object obj) {
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        CLAbstractEntity e = (CLAbstractEntity)obj;
        return this.getEntity() == e.getEntity();
    }
}

