/*
 * Decompiled with CFR 0.152.
 */
package com.nativelibs4java.opencl;

import com.nativelibs4java.opencl.CLAbstractEntity;
import com.nativelibs4java.opencl.CLContext;
import com.nativelibs4java.opencl.CLEvent;
import com.nativelibs4java.opencl.CLException;
import com.nativelibs4java.opencl.CLInfoGetter;
import com.nativelibs4java.opencl.CLQueue;
import com.nativelibs4java.opencl.JavaCL;
import com.nativelibs4java.opencl.ReusablePointers;
import com.nativelibs4java.opencl.library.OpenCLLibrary;
import com.nativelibs4java.util.EnumValues;
import com.nativelibs4java.util.ValuedEnum;
import java.util.EnumSet;
import org.bridj.BridJ;
import org.bridj.Pointer;
import org.bridj.SizeT;

public abstract class CLMem
extends CLAbstractEntity {
    protected final CLContext context;
    protected long byteCount = -1L;
    boolean isGL;
    protected static CLInfoGetter infos = new CLInfoGetter(){

        @Override
        protected int getInfo(long entity, int infoTypeEnum, long size, Pointer out, Pointer<SizeT> sizeOut) {
            return JavaCL.CL.clGetImageInfo(entity, infoTypeEnum, size, Pointer.getPeer(out), Pointer.getPeer(sizeOut));
        }
    };

    CLMem(CLContext context, long byteCount, long entityPeer) {
        super(entityPeer);
        this.byteCount = byteCount;
        this.context = context;
    }

    public CLContext getContext() {
        return this.context;
    }

    public void setDestructorCallback(final DestructorCallback callback) {
        OpenCLLibrary.clSetMemObjectDestructorCallback_arg1_callback cb = new OpenCLLibrary.clSetMemObjectDestructorCallback_arg1_callback(){

            public void apply(OpenCLLibrary.cl_mem mem, Pointer userData) {
                callback.callback(CLMem.this);
            }
        };
        BridJ.protectFromGC(cb);
        CLException.error(JavaCL.CL.clSetMemObjectDestructorCallback(this.getEntity(), Pointer.getPeer(Pointer.pointerTo(cb)), 0L));
    }

    public CLEvent acquireGLObject(CLQueue queue, CLEvent ... eventsToWaitFor) {
        return queue.enqueueAcquireGLObjects(new CLMem[]{this}, eventsToWaitFor);
    }

    public CLEvent releaseGLObject(CLQueue queue, CLEvent ... eventsToWaitFor) {
        return queue.enqueueReleaseGLObjects(new CLMem[]{this}, eventsToWaitFor);
    }

    public long getByteCount() {
        if (this.byteCount < 0L) {
            try {
                this.byteCount = infos.getIntOrLong(this.getEntity(), 4354);
            }
            catch (CLException.InvalidMemObject ex) {
                if (this.isGL) {
                    return -1L;
                }
                throw ex;
            }
        }
        return this.byteCount;
    }

    public GLObjectInfo getGLObjectInfo() {
        ReusablePointers ptrs = ReusablePointers.get();
        Pointer<Integer> typeRef = ptrs.int1;
        Pointer<Integer> nameRef = ptrs.int2;
        JavaCL.CL.clGetGLObjectInfo(this.getEntity(), Pointer.getPeer(typeRef), Pointer.getPeer(nameRef));
        return new GLObjectInfo(GLObjectType.getEnum(typeRef.getInt()), nameRef.getInt());
    }

    protected void clear() {
        CLException.error(JavaCL.CL.clReleaseMemObject(this.getEntity()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MapFlags implements ValuedEnum
    {
        Read(1L),
        Write(2L),
        ReadWrite(3L);

        long value;

        private MapFlags(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static MapFlags getEnum(long v) {
            return EnumValues.getEnum(v, MapFlags.class);
        }
    }

    public static class GLObjectInfo {
        final GLObjectType type;
        final int name;

        public GLObjectInfo(GLObjectType type, int name) {
            this.type = type;
            this.name = name;
        }

        public GLObjectType getType() {
            return this.type;
        }

        public int getName() {
            return this.name;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GLObjectType implements ValuedEnum
    {
        Buffer(8192L),
        RenderBuffer(8195L),
        Texture2D(8193L),
        Texture3D(8194L);

        long value;

        private GLObjectType(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static GLObjectType getEnum(long v) {
            return EnumValues.getEnum(v, GLObjectType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectType implements ValuedEnum
    {
        Buffer(4336L),
        Image2D(4337L),
        Image3D(4338L);

        long value;

        private ObjectType(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static ObjectType getEnum(long v) {
            return EnumValues.getEnum(v, ObjectType.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Flags implements ValuedEnum
    {
        ReadWrite(1L),
        WriteOnly(2L),
        ReadOnly(4L),
        UseHostPtr(8L),
        AllocHostPtr(16L),
        CopyHostPtr(32L);

        long value;

        private Flags(long value) {
            this.value = value;
        }

        @Override
        public long value() {
            return this.value;
        }

        public static long getValue(EnumSet<Flags> set) {
            return EnumValues.getValue(set);
        }

        public static EnumSet<Flags> getEnumSet(long v) {
            return EnumValues.getEnumSet(v, Flags.class);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Usage {
        Input(4, Flags.ReadOnly),
        Output(2, Flags.WriteOnly),
        InputOutput(1, Flags.ReadWrite);

        private int intFlags;
        private Flags flags;

        private Usage(int intFlags, Flags flags) {
            this.intFlags = intFlags;
            this.flags = flags;
        }

        public int getIntFlags() {
            return this.intFlags;
        }

        public Flags getFlags() {
            return this.flags;
        }
    }

    public static interface DestructorCallback {
        public void callback(CLMem var1);
    }
}

