/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.generator;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nepxion.discovery.common.property.DiscoveryProperties;
import com.nepxion.discovery.common.util.JsonUtil;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.util.FileContextUtil;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;

public class GitGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(GitGenerator.class);
    @Autowired
    private ApplicationContext applicationContext;
    private String generatorPath;
    private String versionKey;
    private String text;
    private Map<String, String> map;

    @PostConstruct
    public void initialize() {
        this.generatorPath = PluginContextAware.getGitGeneratorPath(this.applicationContext.getEnvironment());
        this.versionKey = PluginContextAware.getGitVersionKey(this.applicationContext.getEnvironment());
        this.initializeText();
        this.initializeJsonMap();
        this.initializePropertiesMap();
        String version = this.getVersion();
        LOG.info("--------------------------------------------------");
        if (StringUtils.isNotEmpty((CharSequence)version)) {
            LOG.info("Use {}={} as metadata version", (Object)this.versionKey, (Object)version);
        } else {
            LOG.error("Not found value of {}, use default metadata version setting", (Object)this.versionKey);
        }
        LOG.info("--------------------------------------------------");
    }

    private void initializeText() {
        this.text = FileContextUtil.getText(this.applicationContext, this.generatorPath);
    }

    private void initializeJsonMap() {
        if (StringUtils.isEmpty((CharSequence)this.text)) {
            return;
        }
        if (MapUtils.isNotEmpty(this.map)) {
            return;
        }
        try {
            this.map = (Map)JsonUtil.fromJson((String)this.text, (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initializePropertiesMap() {
        if (StringUtils.isEmpty((CharSequence)this.text)) {
            return;
        }
        if (MapUtils.isNotEmpty(this.map)) {
            return;
        }
        try {
            DiscoveryProperties properties = new DiscoveryProperties(this.text, "UTF-8");
            this.map = properties.getMap();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getVersionKey() {
        return this.versionKey;
    }

    public String getGeneratorPath() {
        return this.generatorPath;
    }

    public String getText() {
        return this.text;
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public String getVersion() {
        if (MapUtils.isEmpty(this.map)) {
            return null;
        }
        return this.match(this.versionKey, this.map);
    }

    private String match(String versionKey, Map<String, String> map) {
        String value = new String(versionKey);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String regex = "\\{" + entry.getKey() + "\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(value);
            value = matcher.replaceAll(entry.getValue());
        }
        return value;
    }
}

