/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;

public class ZoneFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Value(value="${spring.application.zone.route.enabled:true}")
    protected Boolean zoneRouteEnabled;

    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        this.applyZoneFilter(serviceId, servers);
    }

    private void applyZoneFilter(String providerServiceId, List<? extends Server> servers) {
        String zone = this.pluginAdapter.getZone();
        if (StringUtils.equals((CharSequence)zone, (CharSequence)"default")) {
            return;
        }
        boolean validated = this.validate(servers, zone);
        Iterator<? extends Server> iterator = servers.iterator();
        while (iterator.hasNext()) {
            Server server = iterator.next();
            String serverZone = this.pluginAdapter.getServerZone(server);
            if (validated) {
                if (StringUtils.equals((CharSequence)serverZone, (CharSequence)zone)) continue;
                iterator.remove();
                continue;
            }
            if (this.zoneRouteEnabled.booleanValue() || StringUtils.equals((CharSequence)serverZone, (CharSequence)zone)) continue;
            iterator.remove();
        }
    }

    private boolean validate(List<? extends Server> servers, String zone) {
        for (Server server : servers) {
            String serverZone = this.pluginAdapter.getServerZone(server);
            if (!StringUtils.equals((CharSequence)serverZone, (CharSequence)zone)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getOrder() {
        return -2147483645;
    }
}

