/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.monitor;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.context.StrategyContextHolder;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyLogger;
import com.nepxion.discovery.plugin.strategy.monitor.StrategyMonitorContext;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class DefaultStrategyLogger
implements StrategyLogger {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    protected StrategyContextHolder strategyContextHolder;
    @Autowired
    protected StrategyMonitorContext strategyMonitorContext;
    @Value(value="${spring.application.strategy.logger.enabled:false}")
    protected Boolean loggerEnabled;
    @Value(value="${spring.application.strategy.logger.mdc.key.shown:true}")
    protected Boolean loggerMdcKeyShown;
    @Value(value="${spring.application.strategy.logger.debug.enabled:false}")
    protected Boolean loggerDebugEnabled;

    @Override
    public void loggerOutput() {
        if (!this.loggerEnabled.booleanValue()) {
            return;
        }
        Map<String, String> customizationMap = this.strategyMonitorContext.getCustomizationMap();
        if (MapUtils.isNotEmpty(customizationMap)) {
            for (Map.Entry<String, String> entry : customizationMap.entrySet()) {
                MDC.put((String)entry.getKey(), (String)((this.loggerMdcKeyShown != false ? entry.getKey() + "=" : "") + entry.getValue()));
            }
        }
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        MDC.put((String)"trace-id", (String)((this.loggerMdcKeyShown != false ? "trace-id=" : "") + (StringUtils.isNotEmpty((CharSequence)traceId) ? traceId : "")));
        MDC.put((String)"span-id", (String)((this.loggerMdcKeyShown != false ? "span-id=" : "") + (StringUtils.isNotEmpty((CharSequence)spanId) ? spanId : "")));
        MDC.put((String)"n-d-service-group", (String)((this.loggerMdcKeyShown != false ? "n-d-service-group=" : "") + this.pluginAdapter.getGroup()));
        MDC.put((String)"n-d-service-type", (String)((this.loggerMdcKeyShown != false ? "n-d-service-type=" : "") + this.pluginAdapter.getServiceType()));
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            MDC.put((String)"n-d-service-app-id", (String)((this.loggerMdcKeyShown != false ? "n-d-service-app-id=" : "") + serviceAppId));
        }
        MDC.put((String)"n-d-service-id", (String)((this.loggerMdcKeyShown != false ? "n-d-service-id=" : "") + this.pluginAdapter.getServiceId()));
        MDC.put((String)"n-d-service-address", (String)((this.loggerMdcKeyShown != false ? "n-d-service-address=" : "") + this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort()));
        MDC.put((String)"n-d-service-version", (String)((this.loggerMdcKeyShown != false ? "n-d-service-version=" : "") + this.pluginAdapter.getVersion()));
        MDC.put((String)"n-d-service-region", (String)((this.loggerMdcKeyShown != false ? "n-d-service-region=" : "") + this.pluginAdapter.getRegion()));
        MDC.put((String)"n-d-service-env", (String)((this.loggerMdcKeyShown != false ? "n-d-service-env=" : "") + this.pluginAdapter.getEnvironment()));
        MDC.put((String)"n-d-service-zone", (String)((this.loggerMdcKeyShown != false ? "n-d-service-zone=" : "") + this.pluginAdapter.getZone()));
    }

    @Override
    public void loggerClear() {
        if (!this.loggerEnabled.booleanValue()) {
            return;
        }
        MDC.clear();
    }

    @Override
    public void loggerDebug() {
        Map<String, String> customizationMap;
        String addressBlacklist;
        String idBlacklist;
        String routeRegionWeight;
        String routeVersionWeight;
        String routeAddress;
        String routeEnvironment;
        String routeRegion;
        if (!this.loggerDebugEnabled.booleanValue()) {
            return;
        }
        System.out.println("------------------ Logger Debug ------------------");
        String traceId = this.strategyMonitorContext.getTraceId();
        String spanId = this.strategyMonitorContext.getSpanId();
        System.out.println("trace-id=" + (StringUtils.isNotEmpty((CharSequence)traceId) ? traceId : ""));
        System.out.println("span-id=" + (StringUtils.isNotEmpty((CharSequence)spanId) ? spanId : ""));
        System.out.println("n-d-service-group=" + this.pluginAdapter.getGroup());
        System.out.println("n-d-service-type=" + this.pluginAdapter.getServiceType());
        String serviceAppId = this.pluginAdapter.getServiceAppId();
        if (StringUtils.isNotEmpty((CharSequence)serviceAppId)) {
            System.out.println("n-d-service-app-id=" + serviceAppId);
        }
        System.out.println("n-d-service-id=" + this.pluginAdapter.getServiceId());
        System.out.println("n-d-service-address=" + this.pluginAdapter.getHost() + ":" + this.pluginAdapter.getPort());
        System.out.println("n-d-service-version=" + this.pluginAdapter.getVersion());
        System.out.println("n-d-service-region=" + this.pluginAdapter.getRegion());
        System.out.println("n-d-service-env=" + this.pluginAdapter.getEnvironment());
        System.out.println("n-d-service-zone=" + this.pluginAdapter.getZone());
        String routeVersion = this.strategyContextHolder.getHeader("n-d-version");
        if (StringUtils.isNotEmpty((CharSequence)routeVersion)) {
            System.out.println("n-d-version=" + routeVersion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegion = this.strategyContextHolder.getHeader("n-d-region")))) {
            System.out.println("n-d-region=" + routeRegion);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeEnvironment = this.strategyContextHolder.getHeader("n-d-env")))) {
            System.out.println("n-d-env=" + routeEnvironment);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeAddress = this.strategyContextHolder.getHeader("n-d-address")))) {
            System.out.println("n-d-address=" + routeAddress);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeVersionWeight = this.strategyContextHolder.getHeader("n-d-version-weight")))) {
            System.out.println("n-d-version-weight=" + routeVersionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(routeRegionWeight = this.strategyContextHolder.getHeader("n-d-region-weight")))) {
            System.out.println("n-d-region-weight=" + routeRegionWeight);
        }
        if (StringUtils.isNotEmpty((CharSequence)(idBlacklist = this.strategyContextHolder.getHeader("n-d-id-blacklist")))) {
            System.out.println("n-d-id-blacklist=" + idBlacklist);
        }
        if (StringUtils.isNotEmpty((CharSequence)(addressBlacklist = this.strategyContextHolder.getHeader("n-d-address-blacklist")))) {
            System.out.println("n-d-address-blacklist=" + addressBlacklist);
        }
        if (MapUtils.isNotEmpty(customizationMap = this.strategyMonitorContext.getCustomizationMap())) {
            for (Map.Entry<String, String> entry : customizationMap.entrySet()) {
                System.out.println(entry.getKey() + "=" + entry.getValue());
            }
        }
        System.out.println("--------------------------------------------------");
    }
}

