/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPException;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;

public class LDAPCompareAttrNames
implements Comparator {
    private String[] sortByNames;
    private boolean[] sortAscending;
    private Locale location = Locale.getDefault();
    private Collator collator = Collator.getInstance();

    public LDAPCompareAttrNames(String string) {
        this.sortByNames = new String[1];
        this.sortByNames[0] = string;
        this.sortAscending = new boolean[1];
        this.sortAscending[0] = true;
    }

    public LDAPCompareAttrNames(String string, boolean bl) {
        this.sortByNames = new String[1];
        this.sortByNames[0] = string;
        this.sortAscending = new boolean[1];
        this.sortAscending[0] = bl;
    }

    public LDAPCompareAttrNames(String[] stringArray) {
        this.sortByNames = new String[stringArray.length];
        this.sortAscending = new boolean[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortByNames[i] = stringArray[i];
            this.sortAscending[i] = true;
        }
    }

    public LDAPCompareAttrNames(String[] stringArray, boolean[] blArray) throws LDAPException {
        if (stringArray.length != blArray.length) {
            throw new LDAPException("UNEQUAL_LENGTHS", 18, null);
        }
        this.sortByNames = new String[stringArray.length];
        this.sortAscending = new boolean[blArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.sortByNames[i] = stringArray[i];
            this.sortAscending[i] = blArray[i];
        }
    }

    public Locale getLocale() {
        return this.location;
    }

    public void setLocale(Locale locale) {
        this.collator = Collator.getInstance(locale);
        this.location = locale;
    }

    public int compare(Object object, Object object2) {
        int n;
        LDAPEntry lDAPEntry = (LDAPEntry)object;
        LDAPEntry lDAPEntry2 = (LDAPEntry)object2;
        int n2 = 0;
        if (this.collator == null) {
            this.collator = Collator.getInstance();
        }
        do {
            LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(this.sortByNames[n2]);
            LDAPAttribute lDAPAttribute2 = lDAPEntry2.getAttribute(this.sortByNames[n2]);
            if (lDAPAttribute != null && lDAPAttribute2 != null) {
                String[] stringArray = lDAPAttribute.getStringValueArray();
                String[] stringArray2 = lDAPAttribute2.getStringValueArray();
                n = this.collator.compare(stringArray[0], stringArray2[0]);
                continue;
            }
            n = lDAPAttribute != null ? -1 : (lDAPAttribute2 != null ? 1 : 0);
        } while (n == 0 && ++n2 < this.sortByNames.length);
        if (this.sortAscending[n2 - 1]) {
            return n;
        }
        return -n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LDAPCompareAttrNames)) {
            return false;
        }
        LDAPCompareAttrNames lDAPCompareAttrNames = (LDAPCompareAttrNames)object;
        if (lDAPCompareAttrNames.sortByNames.length != this.sortByNames.length || lDAPCompareAttrNames.sortAscending.length != this.sortAscending.length) {
            return false;
        }
        for (int i = 0; i < this.sortByNames.length; ++i) {
            if (lDAPCompareAttrNames.sortAscending[i] != this.sortAscending[i]) {
                return false;
            }
            if (lDAPCompareAttrNames.sortByNames[i].equalsIgnoreCase(this.sortByNames[i])) continue;
            return false;
        }
        return true;
    }
}

