/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap;

import com.novell.ldap.LDAPControl;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPMessage;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.rfc2251.RfcAttributeDescription;
import com.novell.ldap.rfc2251.RfcAttributeDescriptionList;
import com.novell.ldap.rfc2251.RfcControls;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcLDAPMessage;
import com.novell.ldap.rfc2251.RfcSearchRequest;
import java.io.IOException;
import java.util.Iterator;

public class LDAPSearchRequest
extends LDAPMessage {
    public static final int AND = 0;
    public static final int OR = 1;
    public static final int NOT = 2;
    public static final int EQUALITY_MATCH = 3;
    public static final int SUBSTRINGS = 4;
    public static final int GREATER_OR_EQUAL = 5;
    public static final int LESS_OR_EQUAL = 6;
    public static final int PRESENT = 7;
    public static final int APPROX_MATCH = 8;
    public static final int EXTENSIBLE_MATCH = 9;
    public static final int INITIAL = 0;
    public static final int ANY = 1;
    public static final int FINAL = 2;

    public LDAPSearchRequest() {
        super(3);
    }

    public LDAPSearchRequest(String string, int n, String string2, String[] stringArray, int n2, int n3, int n4, boolean bl, LDAPControl[] lDAPControlArray) throws LDAPException {
        super(3, new RfcSearchRequest(new RfcLDAPDN(string), new ASN1Enumerated(n), new ASN1Enumerated(n2), new ASN1Integer(n3), new ASN1Integer(n4), new ASN1Boolean(bl), new RfcFilter(string2), new RfcAttributeDescriptionList(stringArray)), lDAPControlArray);
    }

    public LDAPSearchRequest(String string, int n, RfcFilter rfcFilter, String[] stringArray, int n2, int n3, int n4, boolean bl, LDAPControl[] lDAPControlArray) {
        super(3, new RfcSearchRequest(new RfcLDAPDN(string), new ASN1Enumerated(n), new ASN1Enumerated(n2), new ASN1Integer(n3), new ASN1Integer(n4), new ASN1Boolean(bl), rfcFilter, new RfcAttributeDescriptionList(stringArray)), lDAPControlArray);
    }

    public String getDN() {
        return this.getASN1Object().getRequestDN();
    }

    public int getScope() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(1)).intValue();
    }

    public int getDereference() {
        return ((ASN1Enumerated)((RfcSearchRequest)this.getASN1Object().get(1)).get(2)).intValue();
    }

    public int getMaxResults() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(3)).intValue();
    }

    public int getServerTimeLimit() {
        return ((ASN1Integer)((RfcSearchRequest)this.getASN1Object().get(1)).get(4)).intValue();
    }

    public boolean isTypesOnly() {
        return ((ASN1Boolean)((RfcSearchRequest)this.getASN1Object().get(1)).get(5)).booleanValue();
    }

    public String[] getAttributes() {
        RfcAttributeDescriptionList rfcAttributeDescriptionList = (RfcAttributeDescriptionList)((RfcSearchRequest)this.getASN1Object().get(1)).get(7);
        String[] stringArray = new String[rfcAttributeDescriptionList.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = ((RfcAttributeDescription)rfcAttributeDescriptionList.get(i)).stringValue();
        }
        return stringArray;
    }

    public String getStringFilter() {
        return this.getRfcFilter().filterToString();
    }

    private RfcFilter getRfcFilter() {
        return (RfcFilter)((RfcSearchRequest)this.getASN1Object().get(1)).get(6);
    }

    public Iterator getSearchFilter() {
        return this.getRfcFilter().getFilterIterator();
    }

    protected void setDeserializedValues(LDAPMessage lDAPMessage, RfcControls rfcControls) throws IOException, ClassNotFoundException {
        if (!(lDAPMessage instanceof LDAPSearchRequest)) {
            throw new ClassNotFoundException("Error occured while deserializing LDAPSearchRequest object");
        }
        try {
            LDAPSearchRequest lDAPSearchRequest = (LDAPSearchRequest)lDAPMessage;
            String string = lDAPSearchRequest.getDN();
            int n = lDAPSearchRequest.getScope();
            String string2 = lDAPSearchRequest.getStringFilter();
            String[] stringArray = lDAPSearchRequest.getAttributes();
            int n2 = lDAPSearchRequest.getDereference();
            int n3 = lDAPSearchRequest.getMaxResults();
            int n4 = lDAPSearchRequest.getServerTimeLimit();
            boolean bl = lDAPSearchRequest.isTypesOnly();
            lDAPSearchRequest = null;
            RfcSearchRequest rfcSearchRequest = null;
            rfcSearchRequest = new RfcSearchRequest(new RfcLDAPDN(string), new ASN1Enumerated(n), new ASN1Enumerated(n2), new ASN1Integer(n3), new ASN1Integer(n4), new ASN1Boolean(bl), new RfcFilter(string2), new RfcAttributeDescriptionList(stringArray));
            this.message = new RfcLDAPMessage(rfcSearchRequest, rfcControls);
        }
        catch (LDAPException lDAPException) {
            throw new IOException("LDAPException occured while de-serializing the stored object. There is a corruption in stored object. Restore it beforeusing this feature." + lDAPException);
        }
        lDAPMessage = null;
    }
}

