/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.resources;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourcesHandler {
    private static ResourceBundle defaultResultCodes = null;
    private static ResourceBundle defaultMessages = null;
    private static String pkg = "com.novell.ldap.resources.";
    private static Locale defaultLocale = Locale.getDefault();

    private ResourcesHandler() {
    }

    public static String getMessage(String string, Object[] objectArray) {
        return ResourcesHandler.getMessage(string, objectArray, null);
    }

    public static String getMessage(String string, Object[] objectArray, Locale locale) {
        String string2;
        ResourceBundle resourceBundle = null;
        if (string == null) {
            string = "";
        }
        try {
            if (locale == null || defaultLocale.equals(locale)) {
                locale = defaultLocale;
                if (defaultMessages == null) {
                    defaultMessages = ResourceBundle.getBundle(pkg + "ExceptionMessages", defaultLocale);
                }
                resourceBundle = defaultMessages;
            } else {
                resourceBundle = ResourceBundle.getBundle(pkg + "ExceptionMessages", locale);
            }
            string2 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = string;
        }
        if (objectArray != null) {
            MessageFormat messageFormat = new MessageFormat(string2);
            messageFormat.setLocale(locale);
            messageFormat.applyPattern(string2);
            string2 = messageFormat.format(objectArray);
        }
        return string2;
    }

    public static String getResultString(int n) {
        return ResourcesHandler.getResultString(n, null);
    }

    public static String getResultString(int n, Locale locale) {
        String string;
        try {
            ResourceBundle resourceBundle;
            if (locale == null || defaultLocale.equals(locale)) {
                locale = defaultLocale;
                if (defaultResultCodes == null) {
                    defaultResultCodes = ResourceBundle.getBundle(pkg + "ResultCodeMessages", defaultLocale);
                }
                resourceBundle = defaultResultCodes;
            } else {
                resourceBundle = ResourceBundle.getBundle(pkg + "ResultCodeMessages", locale);
            }
            string = resourceBundle.getString(Integer.toString(n));
        }
        catch (MissingResourceException missingResourceException) {
            string = ResourcesHandler.getMessage("UNKNOWN_RESULT", new Object[]{new Integer(n)}, locale);
        }
        return string;
    }
}

