/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.text;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.sql.SQLException;
import oracle.i18n.text.OraCharset;

class OraCharsetDecoder
extends CharsetDecoder {
    OraCharsetDecoder(OraCharset oraCharset, float f, float f2) {
        super(oraCharset, f, f2);
    }

    @Override
    public CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        int n2 = byteBuffer.remaining();
        if (n2 == 0) {
            return CoderResult.UNDERFLOW;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        try {
            CodingErrorAction codingErrorAction = this.malformedInputAction();
            String string = CodingErrorAction.REPLACE == this.unmappableCharacterAction() ? ((OraCharset)this.charset()).toStringWithReplacement(byArray, 0, byArray.length) : ((OraCharset)this.charset()).toString(byArray, 0, byArray.length);
            int n3 = charBuffer.remaining();
            if (n3 < string.length()) {
                byteBuffer.position(n);
                return CoderResult.OVERFLOW;
            }
            charBuffer.put(string);
        }
        catch (SQLException sQLException) {
            byteBuffer.position(n);
            return CoderResult.unmappableForLength(n2);
        }
        return CoderResult.UNDERFLOW;
    }
}

