/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.stream.buffer;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.TestCase;

public abstract class BaseBufferTestCase
extends TestCase {
    protected BaseBufferTestCase() {
    }

    protected BaseBufferTestCase(String name) {
        super(name);
    }

    public int next(XMLStreamReader reader) throws XMLStreamException {
        int readerEvent = reader.next();
        while (readerEvent != 8) {
            switch (readerEvent) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 12: {
                    return readerEvent;
                }
            }
            readerEvent = reader.next();
        }
        return readerEvent;
    }

    public int nextElementContent(XMLStreamReader reader) throws XMLStreamException {
        int state = this.nextContent(reader);
        if (state == 4) {
            throw new XMLStreamException("Unexpected Character Content: " + reader.getText());
        }
        return state;
    }

    public int nextContent(XMLStreamReader reader) throws XMLStreamException {
        while (true) {
            int state = this.next(reader);
            switch (state) {
                case 1: 
                case 2: 
                case 8: {
                    return state;
                }
                case 4: {
                    if (reader.isWhiteSpace()) break;
                    return 4;
                }
            }
        }
    }

    public void verifyReaderState(XMLStreamReader reader, int expectedState) throws XMLStreamException {
        int state = reader.getEventType();
        if (state != expectedState) {
            throw new XMLStreamException("Unexpected State: " + BaseBufferTestCase.getStateName(expectedState) + " " + BaseBufferTestCase.getStateName(state));
        }
    }

    public static void verifyTag(XMLStreamReader reader, String namespaceURI, String localName) throws XMLStreamException {
        if (localName != reader.getLocalName() || namespaceURI != reader.getNamespaceURI()) {
            throw new XMLStreamException("Expected: {" + namespaceURI + "}" + localName + " " + "But found: " + "{" + reader.getNamespaceURI() + "}" + reader.getLocalName());
        }
    }

    public static String getStateName(int state) {
        switch (state) {
            case 10: {
                return "ATTRIBUTE";
            }
            case 12: {
                return "CDATA";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 11: {
                return "DTD";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 1: {
                return "START_ELEMENT";
            }
        }
        return "UNKNOWN";
    }
}

