/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiUtil {
    static final Logger LOG = LoggerFactory.getLogger(ApiUtil.class);
    static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public static final Date str2date(String date) {
        if (date == null || "".equals(date)) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat(DATE_FORMAT);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            LOG.error(date + "-" + e.getMessage(), e.fillInStackTrace());
            return null;
        }
    }

    public static final String urlEncode(String text, String charset) {
        if (charset == null || "".equals(charset)) {
            charset = "utf-8";
        }
        try {
            return URLEncoder.encode(text, charset);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
            return text;
        }
    }

    public static final String urlEncodeAndLink(String charset, String seperator, String ... text) {
        if (text.length == 0) {
            return "";
        }
        if (charset == null || "".equals(charset)) {
            charset = "utf-8";
        }
        if (seperator == null) {
            seperator = ",";
        }
        int len = 0;
        for (String t : text) {
            len += t.length();
        }
        StringBuilder buf = new StringBuilder(len + text.length - 1);
        try {
            buf.append(URLEncoder.encode(text[0], charset));
            for (int i = 1; i < text.length; ++i) {
                buf.append(seperator);
                buf.append(URLEncoder.encode(text[i], charset));
            }
        }
        catch (UnsupportedEncodingException e) {
            LOG.error(e.getMessage(), e.fillInStackTrace());
        }
        return buf.toString();
    }
}

