/*
 * Decompiled with CFR 0.152.
 */
package de.thetaphi.forbiddenapis;

import de.thetaphi.forbiddenapis.AsmUtils;
import de.thetaphi.forbiddenapis.ClassPatternRule;
import de.thetaphi.forbiddenapis.ClassScanner;
import de.thetaphi.forbiddenapis.ClassSignature;
import de.thetaphi.forbiddenapis.Constants;
import de.thetaphi.forbiddenapis.ForbiddenApiException;
import de.thetaphi.forbiddenapis.ForbiddenViolation;
import de.thetaphi.forbiddenapis.Logger;
import de.thetaphi.forbiddenapis.ParseException;
import de.thetaphi.forbiddenapis.RelatedClassLookup;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import de.thetaphi.forbiddenapis.WrapperRuntimeException;
import de.thetaphi.forbiddenapis.asm.ClassReader;
import de.thetaphi.forbiddenapis.asm.Type;
import de.thetaphi.forbiddenapis.asm.commons.Method;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Checker
implements RelatedClassLookup,
Constants {
    public final boolean isSupportedJDK;
    private final long start;
    private final NavigableSet<String> runtimePaths;
    final Logger logger;
    final ClassLoader loader;
    final java.lang.reflect.Method method_Class_getModule;
    final java.lang.reflect.Method method_Module_getName;
    final EnumSet<Option> options;
    final Map<String, ClassSignature> classesToCheck = new HashMap<String, ClassSignature>();
    final Map<String, ClassSignature> classpathClassCache = new HashMap<String, ClassSignature>();
    private boolean forbidNonPortableRuntime = false;
    final Map<String, String> forbiddenFields = new HashMap<String, String>();
    final Map<String, String> forbiddenMethods = new HashMap<String, String>();
    final Map<String, String> forbiddenClasses = new HashMap<String, String>();
    final Set<ClassPatternRule> forbiddenClassPatterns = new LinkedHashSet<ClassPatternRule>();
    final Set<String> suppressAnnotations = new LinkedHashSet<String>();
    private static final String BUNDLED_PREFIX = "@includeBundled ";
    private static final String DEFAULT_MESSAGE_PREFIX = "@defaultMessage ";
    private static final String IGNORE_UNRESOLVABLE_LINE = "@ignoreUnresolvable";

    public Checker(Logger logger, ClassLoader loader, Option ... options) {
        this(logger, loader, options.length == 0 ? EnumSet.noneOf(Option.class) : EnumSet.copyOf(Arrays.asList(options)));
    }

    public Checker(Logger logger, ClassLoader loader, EnumSet<Option> options) {
        java.lang.reflect.Method method_Module_getName;
        java.lang.reflect.Method method_Class_getModule;
        this.logger = logger;
        this.loader = loader;
        this.options = options;
        this.start = System.currentTimeMillis();
        this.addSuppressAnnotation(SuppressForbidden.class);
        boolean isSupportedJDK = false;
        try {
            method_Class_getModule = Class.class.getMethod("getModule", new Class[0]);
            method_Module_getName = method_Class_getModule.getReturnType().getMethod("getName", new Class[0]);
            isSupportedJDK = true;
        }
        catch (NoSuchMethodException e) {
            method_Module_getName = null;
            method_Class_getModule = null;
        }
        this.method_Class_getModule = method_Class_getModule;
        this.method_Module_getName = method_Module_getName;
        TreeSet<String> runtimePaths = new TreeSet<String>();
        if (!isSupportedJDK) {
            try {
                URL objectClassURL = loader.getResource(AsmUtils.getClassResourceName(Object.class.getName()));
                if (objectClassURL != null && "jrt".equalsIgnoreCase(objectClassURL.getProtocol())) {
                    isSupportedJDK = true;
                } else {
                    RuntimeMXBean rb;
                    String javaHome = System.getProperty("java.home");
                    if (javaHome != null) {
                        if (!(javaHome = new File(javaHome).getCanonicalPath()).endsWith(File.separator)) {
                            javaHome = javaHome + File.separator;
                        }
                        runtimePaths.add(javaHome);
                    }
                    if ((rb = ManagementFactory.getRuntimeMXBean()).isBootClassPathSupported()) {
                        String cp = rb.getBootClassPath();
                        StringTokenizer st = new StringTokenizer(cp, File.pathSeparator);
                        while (st.hasMoreTokens()) {
                            File f = new File(st.nextToken().trim());
                            if (f.isFile()) {
                                f = f.getParentFile();
                            }
                            if (!f.exists()) continue;
                            String fp = f.getCanonicalPath();
                            if (!fp.endsWith(File.separator)) {
                                fp = fp + File.separator;
                            }
                            runtimePaths.add(fp);
                        }
                    }
                    boolean bl = isSupportedJDK = !runtimePaths.isEmpty();
                    if (!isSupportedJDK) {
                        logger.warn("Boot classpath appears to be empty or ${java.home} not defined; marking runtime as not suppported.");
                    }
                }
            }
            catch (IOException ioe) {
                logger.warn("Cannot scan boot classpath and ${java.home} due to IO exception; marking runtime as not suppported: " + ioe);
                isSupportedJDK = false;
                runtimePaths.clear();
            }
        }
        this.runtimePaths = runtimePaths;
        if (isSupportedJDK) {
            try {
                isSupportedJDK = this.getClassFromClassLoader((String)Object.class.getName()).isRuntimeClass;
                if (!isSupportedJDK) {
                    logger.warn("Bytecode of java.lang.Object does not seem to come from runtime library; marking runtime as not suppported.");
                }
            }
            catch (IllegalArgumentException iae) {
                logger.warn("Bundled version of ASM cannot parse bytecode of java.lang.Object class; marking runtime as not suppported.");
                isSupportedJDK = false;
            }
            catch (ClassNotFoundException cnfe) {
                logger.warn("Bytecode or Class<?> instance of java.lang.Object not found; marking runtime as not suppported.");
                isSupportedJDK = false;
            }
            catch (IOException ioe) {
                logger.warn("IOException while loading java.lang.Object class from classloader; marking runtime as not suppported: " + ioe);
                isSupportedJDK = false;
            }
        }
        this.isSupportedJDK = isSupportedJDK;
    }

    private ClassSignature loadClassFromJigsaw(String classname) throws IOException {
        String moduleName;
        Class<?> clazz;
        if (this.method_Class_getModule == null || this.method_Module_getName == null) {
            return null;
        }
        try {
            clazz = Class.forName(classname, false, this.loader);
            Object module = this.method_Class_getModule.invoke(clazz, new Object[0]);
            moduleName = (String)this.method_Module_getName.invoke(module, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        return new ClassSignature(clazz, AsmUtils.isRuntimeModule(moduleName));
    }

    private boolean isRuntimePath(URL url) throws IOException {
        if (!"file".equalsIgnoreCase(url.getProtocol())) {
            return false;
        }
        try {
            String path = new File(url.toURI()).getCanonicalPath();
            String lookup = this.runtimePaths.floor(path);
            return lookup != null && path.startsWith(lookup);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private boolean isRuntimeClass(URLConnection conn) throws IOException {
        URL url = conn.getURL();
        if (this.isRuntimePath(url)) {
            return true;
        }
        if ("jar".equalsIgnoreCase(url.getProtocol()) && conn instanceof JarURLConnection) {
            URL jarUrl = ((JarURLConnection)conn).getJarFileURL();
            return this.isRuntimePath(jarUrl);
        }
        if ("jrt".equalsIgnoreCase(url.getProtocol())) {
            return AsmUtils.isRuntimeModule(AsmUtils.getModuleName(url));
        }
        return false;
    }

    private ClassSignature getClassFromClassLoader(String clazz) throws ClassNotFoundException, IOException {
        if (this.classpathClassCache.containsKey(clazz)) {
            ClassSignature c = this.classpathClassCache.get(clazz);
            if (c == null) {
                throw new ClassNotFoundException(clazz);
            }
            return c;
        }
        URL url = this.loader.getResource(AsmUtils.getClassResourceName(clazz));
        if (url != null) {
            ClassReader cr;
            URLConnection conn = url.openConnection();
            boolean isRuntimeClass = this.isRuntimeClass(conn);
            if (!isRuntimeClass && this.options.contains((Object)Option.DISABLE_CLASSLOADING_CACHE)) {
                conn.setUseCaches(false);
            }
            InputStream in = conn.getInputStream();
            try {
                cr = AsmUtils.readAndPatchClass(in);
            }
            catch (IllegalArgumentException iae) {
                ClassSignature c;
                if (isRuntimeClass && (c = this.loadClassFromJigsaw(clazz)) != null) {
                    this.classpathClassCache.put(clazz, c);
                    ClassSignature classSignature = c;
                    return classSignature;
                }
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The class file format of '%s' is too recent to be parsed by ASM.", clazz));
            }
            finally {
                in.close();
            }
            ClassSignature c = new ClassSignature(cr, isRuntimeClass, false);
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        ClassSignature c = this.loadClassFromJigsaw(clazz);
        if (c != null) {
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        c = this.classesToCheck.get(clazz);
        if (c != null) {
            this.classpathClassCache.put(clazz, c);
            return c;
        }
        this.classpathClassCache.put(clazz, null);
        throw new ClassNotFoundException(clazz);
    }

    @Override
    public ClassSignature lookupRelatedClass(String internalName) {
        Type type = Type.getObjectType(internalName);
        if (type.getSort() != 10) {
            return null;
        }
        try {
            return this.getClassFromClassLoader(type.getClassName());
        }
        catch (ClassNotFoundException cnfe) {
            if (this.options.contains((Object)Option.FAIL_ON_MISSING_CLASSES)) {
                throw new WrapperRuntimeException(cnfe);
            }
            this.logger.warn(String.format(Locale.ENGLISH, "The referenced class '%s' cannot be loaded. Please fix the classpath!", type.getClassName()));
            return null;
        }
        catch (IOException ioe) {
            throw new WrapperRuntimeException(ioe);
        }
    }

    private void addSignature(String line, String defaultMessage, UnresolvableReporting report) throws ParseException, IOException {
        String printout;
        String field;
        Method method;
        String clazz;
        String signature;
        String message = null;
        int p = line.indexOf(64);
        if (p >= 0) {
            signature = line.substring(0, p).trim();
            message = line.substring(p + 1).trim();
        } else {
            signature = line;
            message = defaultMessage;
        }
        p = signature.indexOf(35);
        if (p >= 0) {
            clazz = signature.substring(0, p);
            String s = signature.substring(p + 1);
            if ((p = s.indexOf(40)) >= 0) {
                if (p == 0) {
                    throw new ParseException("Invalid method signature (method name missing): " + signature);
                }
                try {
                    method = Method.getMethod("void " + s, true);
                }
                catch (IllegalArgumentException iae) {
                    throw new ParseException("Invalid method signature: " + signature);
                }
                field = null;
            } else {
                field = s;
                method = null;
            }
        } else {
            clazz = signature;
            method = null;
            field = null;
        }
        if (message != null && message.isEmpty()) {
            message = null;
        }
        String string = printout = message != null ? signature + " [" + message + "]" : signature;
        if (AsmUtils.isGlob(clazz)) {
            if (method != null || field != null) {
                throw new ParseException(String.format(Locale.ENGLISH, "Class level glob pattern cannot be combined with methods/fields: %s", signature));
            }
            this.forbiddenClassPatterns.add(new ClassPatternRule(clazz, message));
        } else {
            ClassSignature c;
            try {
                c = this.getClassFromClassLoader(clazz);
            }
            catch (ClassNotFoundException cnfe) {
                report.parseFailed(this.logger, String.format(Locale.ENGLISH, "Class '%s' not found on classpath", cnfe.getMessage()), signature);
                return;
            }
            if (method != null) {
                assert (field == null);
                boolean found = false;
                for (Method m : c.methods) {
                    if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getArgumentTypes(), method.getArgumentTypes())) continue;
                    found = true;
                    this.forbiddenMethods.put(c.className + '\u0000' + m, printout);
                }
                if (!found) {
                    report.parseFailed(this.logger, "Method not found", signature);
                    return;
                }
            } else if (field != null) {
                assert (method == null);
                if (!c.fields.contains(field)) {
                    report.parseFailed(this.logger, "Field not found", signature);
                    return;
                }
                this.forbiddenFields.put(c.className + '\u0000' + field, printout);
            } else {
                assert (field == null && method == null);
                this.forbiddenClasses.put(c.className, printout);
            }
        }
    }

    public void addBundledSignatures(String name, String jdkTargetVersion) throws IOException, ParseException {
        this.addBundledSignatures(name, jdkTargetVersion, true);
    }

    public static String fixTargetVersion(String name) throws ParseException {
        Matcher m = JDK_SIG_PATTERN.matcher(name);
        if (m.matches()) {
            if (m.group(4) == null) {
                int minor;
                String prefix = m.group(1);
                int major = Integer.parseInt(m.group(2));
                int n = minor = m.group(3) != null ? Integer.parseInt(m.group(3).substring(1)) : 0;
                if (major == 1 && minor >= 1 && minor < 9) {
                    return prefix + "1." + minor;
                }
                if (major > 1 && major < 9) {
                    if (minor == 0) {
                        return prefix + "1." + major;
                    }
                } else {
                    if (major >= 9 && minor > 0) {
                        return prefix + major + "." + minor;
                    }
                    if (major >= 9 && minor == 0) {
                        return prefix + major;
                    }
                }
            }
            throw new ParseException("Invalid bundled signature reference (JDK version is invalid): " + name);
        }
        return name;
    }

    private void addBundledSignatures(String name, String jdkTargetVersion, boolean logging) throws IOException, ParseException {
        if (!name.matches("[A-Za-z0-9\\-\\.]+")) {
            throw new ParseException("Invalid bundled signature reference: " + name);
        }
        if ("jdk-non-portable".equals(name)) {
            if (logging) {
                this.logger.info("Reading bundled API signatures: " + name);
            }
            this.forbidNonPortableRuntime = true;
            return;
        }
        name = Checker.fixTargetVersion(name);
        InputStream in = Checker.class.getResourceAsStream("signatures/" + name + ".txt");
        if (in == null && jdkTargetVersion != null && name.startsWith("jdk-") && !name.matches(".*?\\-\\d+(\\.\\d+)*")) {
            name = name + "-" + jdkTargetVersion;
            name = Checker.fixTargetVersion(name);
            in = Checker.class.getResourceAsStream("signatures/" + name + ".txt");
        }
        if (in == null) {
            throw new FileNotFoundException("Bundled signatures resource not found: " + name);
        }
        if (logging) {
            this.logger.info("Reading bundled API signatures: " + name);
        }
        this.parseSignaturesFile(in, true);
    }

    public void parseSignaturesFile(InputStream in, String name) throws IOException, ParseException {
        this.logger.info("Reading API signatures: " + name);
        this.parseSignaturesFile(in, false);
    }

    public void parseSignaturesFile(URL url) throws IOException, ParseException {
        this.parseSignaturesFile(url.openStream(), url.toString());
    }

    public void parseSignaturesFile(File f) throws IOException, ParseException {
        this.parseSignaturesFile((InputStream)new FileInputStream(f), f.toString());
    }

    public void parseSignaturesString(String signatures) throws IOException, ParseException {
        this.logger.info("Reading inline API signatures...");
        this.parseSignaturesFile(new StringReader(signatures), false);
    }

    private void parseSignaturesFile(InputStream in, boolean allowBundled) throws IOException, ParseException {
        this.parseSignaturesFile(new InputStreamReader(in, "UTF-8"), allowBundled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseSignaturesFile(Reader reader, boolean isBundled) throws IOException, ParseException {
        BufferedReader r = new BufferedReader(reader);
        try {
            String line;
            UnresolvableReporting reporter;
            String defaultMessage = null;
            UnresolvableReporting unresolvableReporting = reporter = this.options.contains((Object)Option.FAIL_ON_UNRESOLVABLE_SIGNATURES) ? UnresolvableReporting.FAIL : UnresolvableReporting.WARNING;
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                if (line.startsWith("@")) {
                    if (isBundled && line.startsWith(BUNDLED_PREFIX)) {
                        String name = line.substring(BUNDLED_PREFIX.length()).trim();
                        this.addBundledSignatures(name, null, false);
                        continue;
                    }
                    if (line.startsWith(DEFAULT_MESSAGE_PREFIX)) {
                        defaultMessage = line.substring(DEFAULT_MESSAGE_PREFIX.length()).trim();
                        if (defaultMessage.length() != 0) continue;
                        defaultMessage = null;
                        continue;
                    }
                    if (line.equals(IGNORE_UNRESOLVABLE_LINE)) {
                        reporter = isBundled ? UnresolvableReporting.SILENT : UnresolvableReporting.WARNING;
                        continue;
                    }
                    throw new ParseException("Invalid line in signature file: " + line);
                }
                this.addSignature(line, defaultMessage, reporter);
            }
        }
        finally {
            r.close();
        }
    }

    public void addClassToCheck(InputStream in, String name) throws IOException {
        ClassReader reader;
        try {
            reader = AsmUtils.readAndPatchClass(in);
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "The class file format of '%s' is too recent to be parsed by ASM.", name));
        }
        finally {
            in.close();
        }
        String binaryName = Type.getObjectType(reader.getClassName()).getClassName();
        this.classesToCheck.put(binaryName, new ClassSignature(reader, false, true));
    }

    public void addClassToCheck(File f) throws IOException {
        this.addClassToCheck(new FileInputStream(f), f.toString());
    }

    public void addClassesToCheck(Iterable<File> files) throws IOException {
        this.logger.info("Loading classes to check...");
        for (File f : files) {
            this.addClassToCheck(f);
        }
    }

    public void addClassesToCheck(File ... files) throws IOException {
        this.addClassesToCheck(Arrays.asList(files));
    }

    public void addClassesToCheck(File basedir, Iterable<String> relativeNames) throws IOException {
        this.logger.info("Loading classes to check...");
        for (String f : relativeNames) {
            this.addClassToCheck(new File(basedir, f));
        }
    }

    public void addClassesToCheck(File basedir, String ... relativeNames) throws IOException {
        this.addClassesToCheck(basedir, Arrays.asList(relativeNames));
    }

    public boolean hasNoSignatures() {
        return 0 == this.forbiddenMethods.size() + this.forbiddenFields.size() + this.forbiddenClasses.size() + this.forbiddenClassPatterns.size() + (this.forbidNonPortableRuntime ? 1 : 0);
    }

    public void addSuppressAnnotation(Class<? extends Annotation> anno) {
        this.suppressAnnotations.add(anno.getName());
    }

    public void addSuppressAnnotation(String annoName) {
        this.suppressAnnotations.add(annoName);
    }

    private int checkClass(ClassReader reader, Pattern suppressAnnotationsPattern) {
        String className = Type.getObjectType(reader.getClassName()).getClassName();
        ClassScanner scanner = new ClassScanner(this, this.forbiddenClasses, this.forbiddenClassPatterns, this.forbiddenMethods, this.forbiddenFields, suppressAnnotationsPattern, this.forbidNonPortableRuntime);
        reader.accept(scanner, 4);
        List<ForbiddenViolation> violations = scanner.getSortedViolations();
        Pattern splitter = Pattern.compile(Pattern.quote("\n"));
        for (ForbiddenViolation v : violations) {
            for (String line : splitter.split(v.format(className, scanner.getSourceFile()))) {
                this.logger.error(line);
            }
        }
        return violations.size();
    }

    public void run() throws ForbiddenApiException {
        this.logger.info("Scanning classes for violations...");
        int errors = 0;
        Pattern suppressAnnotationsPattern = AsmUtils.glob2Pattern(this.suppressAnnotations.toArray(new String[this.suppressAnnotations.size()]));
        try {
            for (ClassSignature c : this.classesToCheck.values()) {
                errors += this.checkClass(c.getReader(), suppressAnnotationsPattern);
            }
        }
        catch (WrapperRuntimeException wre) {
            Throwable cause = wre.getCause();
            if (cause != null) {
                throw new ForbiddenApiException("Check for forbidden API calls failed: " + cause.toString(), cause);
            }
            throw new ForbiddenApiException("Check for forbidden API calls failed.");
        }
        String message = String.format(Locale.ENGLISH, "Scanned %d class file(s) for forbidden API invocations (in %.2fs), %d error(s).", this.classesToCheck.size(), (double)(System.currentTimeMillis() - this.start) / 1000.0, errors);
        if (this.options.contains((Object)Option.FAIL_ON_VIOLATION) && errors > 0) {
            this.logger.error(message);
            throw new ForbiddenApiException("Check for forbidden API calls failed, see log.");
        }
        this.logger.info(message);
    }

    private static enum UnresolvableReporting {
        FAIL{

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                throw new ParseException(String.format(Locale.ENGLISH, "%s while parsing signature: %s", message, signature));
            }
        }
        ,
        WARNING{

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
                logger.warn(String.format(Locale.ENGLISH, "%s while parsing signature: %s [signature ignored]", message, signature));
            }
        }
        ,
        SILENT{

            @Override
            public void parseFailed(Logger logger, String message, String signature) throws ParseException {
            }
        };


        public abstract void parseFailed(Logger var1, String var2, String var3) throws ParseException;
    }

    public static enum Option {
        FAIL_ON_MISSING_CLASSES,
        FAIL_ON_VIOLATION,
        FAIL_ON_UNRESOLVABLE_SIGNATURES,
        DISABLE_CLASSLOADING_CACHE;

    }
}

