/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf;

import fr.opensagres.poi.xwpf.converter.core.AbstractXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.IXWPFConverter;
import fr.opensagres.poi.xwpf.converter.core.XWPFConverterException;
import fr.opensagres.poi.xwpf.converter.pdf.PdfOptions;
import fr.opensagres.poi.xwpf.converter.pdf.internal.PdfMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class PdfConverter
extends AbstractXWPFConverter<PdfOptions> {
    private static final IXWPFConverter<PdfOptions> INSTANCE = new PdfConverter();

    public static IXWPFConverter<PdfOptions> getInstance() {
        return INSTANCE;
    }

    protected void doConvert(XWPFDocument document, OutputStream out, Writer writer, PdfOptions options) throws XWPFConverterException, IOException {
        try {
            ByteArrayOutputStream tempOut = new ByteArrayOutputStream();
            PdfMapper mapper = new PdfMapper(document, tempOut, options, null);
            mapper.start();
            if (mapper.useTotalPageField()) {
                Integer actualPageCount = mapper.getPageCount();
                mapper = new PdfMapper(document, out, options, actualPageCount);
                mapper.start();
            } else {
                out.write(tempOut.toByteArray());
            }
        }
        catch (Exception e) {
            throw new XWPFConverterException((Throwable)e);
        }
    }
}

