/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.strategy;

import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.List;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.HiveMind;
import org.apache.hivemind.ServiceImplementationFactory;
import org.apache.hivemind.ServiceImplementationFactoryParameters;
import org.apache.hivemind.lib.strategy.StrategyContribution;
import org.apache.hivemind.lib.strategy.StrategyMessages;
import org.apache.hivemind.lib.strategy.StrategyParameter;
import org.apache.hivemind.lib.util.StrategyRegistry;
import org.apache.hivemind.lib.util.StrategyRegistryImpl;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;

public class StrategyFactory
implements ServiceImplementationFactory {
    private ClassFactory _classFactory;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$apache$hivemind$lib$util$StrategyRegistry;

    public Object createCoreServiceImplementation(ServiceImplementationFactoryParameters factoryParameters) {
        StrategyRegistryImpl ar = new StrategyRegistryImpl();
        this.buildRegistry(factoryParameters, ar);
        Class implClass = this.buildImplementationClass(factoryParameters);
        try {
            Constructor<?> c = implClass.getConstructors()[0];
            return c.newInstance(ar);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(ex.getMessage(), HiveMind.getLocation((Object)factoryParameters.getFirstParameter()), (Throwable)ex);
        }
    }

    void buildRegistry(ServiceImplementationFactoryParameters factoryParameters, StrategyRegistry ar) {
        Class serviceInterface = factoryParameters.getServiceInterface();
        StrategyParameter p = (StrategyParameter)((Object)factoryParameters.getFirstParameter());
        List contributions = p.getContributions();
        Iterator i = contributions.iterator();
        while (i.hasNext()) {
            StrategyContribution c = (StrategyContribution)((Object)i.next());
            try {
                Object adapter = c.getStrategy();
                if (!serviceInterface.isAssignableFrom(adapter.getClass())) {
                    throw new ClassCastException(StrategyMessages.strategyWrongInterface(adapter, c.getRegisterClass(), serviceInterface));
                }
                ar.register(c.getRegisterClass(), adapter);
            }
            catch (Exception ex) {
                factoryParameters.getErrorLog().error(ex.getMessage(), c.getLocation(), (Throwable)ex);
            }
        }
    }

    private Class buildImplementationClass(ServiceImplementationFactoryParameters factoryParameters) {
        String name = ClassFabUtils.generateClassName((Class)factoryParameters.getServiceInterface());
        return this.buildImplementationClass(factoryParameters, name);
    }

    Class buildImplementationClass(ServiceImplementationFactoryParameters factoryParameters, String name) {
        Class serviceInterface = factoryParameters.getServiceInterface();
        ClassFab cf = this._classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = StrategyFactory.class$("java.lang.Object")) : class$java$lang$Object);
        cf.addInterface(serviceInterface);
        cf.addField("_registry", class$org$apache$hivemind$lib$util$StrategyRegistry == null ? (class$org$apache$hivemind$lib$util$StrategyRegistry = StrategyFactory.class$("org.apache.hivemind.lib.util.StrategyRegistry")) : class$org$apache$hivemind$lib$util$StrategyRegistry);
        cf.addConstructor(new Class[]{class$org$apache$hivemind$lib$util$StrategyRegistry == null ? (class$org$apache$hivemind$lib$util$StrategyRegistry = StrategyFactory.class$("org.apache.hivemind.lib.util.StrategyRegistry")) : class$org$apache$hivemind$lib$util$StrategyRegistry}, null, "_registry = $1;");
        cf.addMethod(2, new MethodSignature(serviceInterface, "_getStrategy", new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = StrategyFactory.class$("java.lang.Object")) : class$java$lang$Object}, null), "return (" + serviceInterface.getName() + ") _registry.getStrategy($1.getClass());");
        MethodIterator i = new MethodIterator(serviceInterface);
        while (i.hasNext()) {
            MethodSignature sig = i.next();
            if (this.proper(sig)) {
                this.addAdaptedMethod(cf, sig);
                continue;
            }
            ClassFabUtils.addNoOpMethod((ClassFab)cf, (MethodSignature)sig);
            factoryParameters.getErrorLog().error(StrategyMessages.improperServiceMethod(sig), HiveMind.getLocation((Object)factoryParameters.getFirstParameter()), null);
        }
        if (!i.getToString()) {
            ClassFabUtils.addToStringMethod((ClassFab)cf, (String)StrategyMessages.toString(factoryParameters.getServiceId(), serviceInterface));
        }
        return cf.createClass();
    }

    private void addAdaptedMethod(ClassFab cf, MethodSignature sig) {
        String body = "return ($r) _getStrategy($1)." + sig.getName() + "($$);";
        cf.addMethod(1, sig, body);
    }

    private boolean proper(MethodSignature sig) {
        Class[] parameterTypes = sig.getParameterTypes();
        return parameterTypes != null && parameterTypes.length > 0 && !parameterTypes[0].isPrimitive();
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

