/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.function;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.JmesPathType;
import io.burt.jmespath.function.ArgumentConstraints;
import io.burt.jmespath.function.BaseFunction;
import io.burt.jmespath.function.FunctionArgument;
import java.util.Iterator;
import java.util.List;

public abstract class TransformByFunction
extends BaseFunction {
    public TransformByFunction() {
        super(ArgumentConstraints.arrayOf(ArgumentConstraints.typeOf(JmesPathType.OBJECT)), ArgumentConstraints.expression());
    }

    @Override
    protected <T> T callFunction(Adapter<T> runtime, List<FunctionArgument<T>> arguments) {
        List<T> elementsList = runtime.toList(arguments.get(0).value());
        Iterator<T> elements = elementsList.iterator();
        Expression<T> expression = arguments.get(1).expression();
        if (elements.hasNext()) {
            T element = elements.next();
            T elementValue = expression.search(element);
            JmesPathType elementValueType = runtime.typeOf(elementValue);
            boolean expectNumbers = true;
            if (elementValueType == JmesPathType.STRING) {
                expectNumbers = false;
            } else if (elementValueType != JmesPathType.NUMBER) {
                return runtime.handleArgumentTypeError(this, "number or string", elementValueType.toString());
            }
            Aggregator<T> aggregator = this.createAggregator(runtime, elementsList.size(), element, elementValue);
            while (elements.hasNext()) {
                T candidate = elements.next();
                T candidateValue = expression.search(candidate);
                if (this.checkType(runtime, candidateValue, expectNumbers)) {
                    aggregator.aggregate(candidate, candidateValue);
                    continue;
                }
                return runtime.handleArgumentTypeError(this, expectNumbers ? "number" : "string", runtime.typeOf(candidateValue).toString());
            }
            return aggregator.result();
        }
        return this.createNullValue(runtime);
    }

    protected abstract <T> Aggregator<T> createAggregator(Adapter<T> var1, int var2, T var3, T var4);

    protected abstract <T> T createNullValue(Adapter<T> var1);

    private <T> boolean checkType(Adapter<T> runtime, T candidateValue, boolean expectNumbers) {
        JmesPathType candidateType = runtime.typeOf(candidateValue);
        return expectNumbers && candidateType == JmesPathType.NUMBER || !expectNumbers && candidateType == JmesPathType.STRING;
    }

    public static abstract class Aggregator<V> {
        protected final Adapter<V> runtime;

        public Aggregator(Adapter<V> runtime) {
            this.runtime = runtime;
        }

        protected abstract void aggregate(V var1, V var2);

        protected abstract V result();
    }
}

