/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.docker.util;

import com.google.common.collect.ImmutableSet;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.config.RunImageConfiguration;
import io.fabric8.maven.docker.model.Container;
import io.fabric8.maven.docker.util.FormatParameterReplacer;
import io.fabric8.maven.docker.util.ImageName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ContainerNamingUtil {
    private static final String INDEX_PLACEHOLDER = "%i";
    public static final String DEFAULT_CONTAINER_NAME_PATTERN = "%n-%i";

    private ContainerNamingUtil() {
    }

    public static String formatContainerName(ImageConfiguration image, String defaultContainerNamePattern, Date buildTimestamp, Collection<Container> existingContainers) {
        String containerNamePattern = ContainerNamingUtil.extractContainerNamePattern(image, defaultContainerNamePattern);
        Set<String> existingContainersNames = ContainerNamingUtil.extractContainerNames(existingContainers);
        String partiallyApplied = ContainerNamingUtil.replacePlaceholders(containerNamePattern, image.getName(), image.getAlias(), buildTimestamp);
        if (partiallyApplied.contains(INDEX_PLACEHOLDER)) {
            for (long i = 1L; i < Long.MAX_VALUE; ++i) {
                String withIndexApplied = partiallyApplied.replaceAll(INDEX_PLACEHOLDER, String.valueOf(i));
                if (existingContainersNames.contains(withIndexApplied)) continue;
                return withIndexApplied;
            }
            throw new IllegalStateException("Could not find any free container name for pattern " + partiallyApplied);
        }
        return partiallyApplied;
    }

    public static Collection<Container> getContainersToStop(ImageConfiguration image, String defaultContainerNamePattern, Date buildTimestamp, Collection<Container> containers) {
        String containerNamePattern = ContainerNamingUtil.extractContainerNamePattern(image, defaultContainerNamePattern);
        if (!containerNamePattern.contains(INDEX_PLACEHOLDER)) {
            return containers;
        }
        String partiallyApplied = ContainerNamingUtil.replacePlaceholders(containerNamePattern, image.getName(), image.getAlias(), buildTimestamp);
        return ContainerNamingUtil.keepOnlyLastIndexedContainer(containers, partiallyApplied);
    }

    private static String replacePlaceholders(String containerNamePattern, String imageName, String nameAlias, Date buildTimestamp) {
        HashMap<String, FormatParameterReplacer.Lookup> lookups = new HashMap<String, FormatParameterReplacer.Lookup>();
        lookups.put("a", () -> nameAlias);
        lookups.put("n", () -> ContainerNamingUtil.cleanImageName(imageName));
        lookups.put("t", () -> String.valueOf(buildTimestamp.getTime()));
        lookups.put("i", () -> INDEX_PLACEHOLDER);
        return new FormatParameterReplacer(lookups).replace(containerNamePattern);
    }

    private static Collection<Container> keepOnlyLastIndexedContainer(Collection<Container> existingContainers, String partiallyApplied) {
        ArrayList<Container> result = new ArrayList<Container>(existingContainers);
        if (!partiallyApplied.contains(INDEX_PLACEHOLDER)) {
            return result;
        }
        Map containerMap = existingContainers.stream().collect(Collectors.toMap(Container::getName, Function.identity()));
        Container last = null;
        for (long i = 1L; i < Long.MAX_VALUE; ++i) {
            String withIndexApplied = partiallyApplied.replaceAll(INDEX_PLACEHOLDER, String.valueOf(i));
            Container mapped = (Container)containerMap.get(withIndexApplied);
            if (mapped == null) {
                if (last != null) {
                    result.add(last);
                }
                return result;
            }
            result.remove(mapped);
            last = mapped;
        }
        throw new IllegalStateException("Internal error: Cannot find a free container index slot in " + existingContainers);
    }

    private static Set<String> extractContainerNames(Collection<Container> existingContainers) {
        ImmutableSet.Builder containerNamesBuilder = ImmutableSet.builder();
        for (Container container : existingContainers) {
            containerNamesBuilder.add((Object)container.getName());
        }
        return containerNamesBuilder.build();
    }

    private static String extractContainerNamePattern(ImageConfiguration image, String defaultContainerNamePattern) {
        RunImageConfiguration runConfig = image.getRunConfiguration();
        if (runConfig != null) {
            if (runConfig.getContainerNamePattern() != null) {
                return runConfig.getContainerNamePattern();
            }
            if (runConfig.getNamingStrategy() == RunImageConfiguration.NamingStrategy.alias) {
                return "%a";
            }
        }
        return defaultContainerNamePattern != null ? defaultContainerNamePattern : DEFAULT_CONTAINER_NAME_PATTERN;
    }

    private static String cleanImageName(String imageName) {
        return new ImageName(imageName).getSimpleName().replaceAll("[^a-zA-Z0-9_.-]+", "_");
    }
}

