/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.udp;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFactory;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.resolver.AddressResolverGroup;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Supplier;
import reactor.netty.channel.ChannelMetricsRecorder;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.channel.MicrometerChannelMetricsRecorder;
import reactor.netty.resources.ConnectionProvider;
import reactor.netty.resources.LoopResources;
import reactor.netty.transport.ClientTransportConfig;
import reactor.netty.transport.logging.AdvancedByteBufFormat;
import reactor.netty.udp.UdpClient;
import reactor.netty.udp.UdpOperations;
import reactor.netty.udp.UdpResources;
import reactor.util.annotation.Nullable;

public final class UdpClientConfig
extends ClientTransportConfig<UdpClientConfig> {
    InternetProtocolFamily family;
    static final ChannelOperations.OnSetup DEFAULT_OPS = (ch, c, msg) -> new UdpOperations(ch, c);
    static final LoggingHandler LOGGING_HANDLER = AdvancedByteBufFormat.HEX_DUMP.toLoggingHandler(UdpClient.class.getName(), LogLevel.DEBUG, Charset.defaultCharset());

    @Override
    public final ChannelOperations.OnSetup channelOperationsProvider() {
        return DEFAULT_OPS;
    }

    @Nullable
    public final InternetProtocolFamily family() {
        return this.family;
    }

    UdpClientConfig(ConnectionProvider connectionProvider, Map<ChannelOption<?>, ?> options, Supplier<? extends SocketAddress> remoteAddress) {
        super(connectionProvider, options, remoteAddress);
    }

    UdpClientConfig(UdpClientConfig parent) {
        super(parent);
        this.family = parent.family;
    }

    @Override
    protected Class<? extends Channel> channelType(boolean isDomainSocket) {
        if (isDomainSocket) {
            throw new UnsupportedOperationException();
        }
        return DatagramChannel.class;
    }

    @Override
    protected ChannelFactory<? extends Channel> connectionFactory(EventLoopGroup elg, boolean isDomainSocket) {
        if (isDomainSocket) {
            throw new UnsupportedOperationException();
        }
        if (this.isPreferNative()) {
            return () -> this.loopResources().onChannel(DatagramChannel.class, elg);
        }
        return () -> new NioDatagramChannel(this.family());
    }

    @Override
    protected AddressResolverGroup<?> defaultAddressResolverGroup() {
        return UdpResources.get().getOrCreateDefaultResolver();
    }

    @Override
    protected LoggingHandler defaultLoggingHandler() {
        return LOGGING_HANDLER;
    }

    @Override
    protected LoopResources defaultLoopResources() {
        return UdpResources.get();
    }

    @Override
    protected ChannelMetricsRecorder defaultMetricsRecorder() {
        return MicrometerUdpClientMetricsRecorder.INSTANCE;
    }

    static final class MicrometerUdpClientMetricsRecorder
    extends MicrometerChannelMetricsRecorder {
        static final MicrometerUdpClientMetricsRecorder INSTANCE = new MicrometerUdpClientMetricsRecorder();

        MicrometerUdpClientMetricsRecorder() {
            super("reactor.netty.udp.client", "udp");
        }
    }
}

