/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.amazon.ses.runtime;

import io.quarkus.arc.DefaultBean;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.Produces;
import software.amazon.awssdk.services.ses.SesAsyncClient;
import software.amazon.awssdk.services.ses.SesAsyncClientBuilder;
import software.amazon.awssdk.services.ses.SesClient;
import software.amazon.awssdk.services.ses.SesClientBuilder;

@ApplicationScoped
public class SesClientProducer {
    private final SesClient syncClient;
    private final SesAsyncClient asyncClient;

    SesClientProducer(Instance<SesClientBuilder> syncClientBuilderInstance, Instance<SesAsyncClientBuilder> asyncClientBuilderInstance) {
        this.syncClient = syncClientBuilderInstance.isResolvable() ? (SesClient)((SesClientBuilder)syncClientBuilderInstance.get()).build() : null;
        this.asyncClient = asyncClientBuilderInstance.isResolvable() ? (SesAsyncClient)((SesAsyncClientBuilder)asyncClientBuilderInstance.get()).build() : null;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SesClient client() {
        if (this.syncClient == null) {
            throw new IllegalStateException("The SesClient is required but has not been detected/configured.");
        }
        return this.syncClient;
    }

    @DefaultBean
    @Produces
    @ApplicationScoped
    public SesAsyncClient asyncClient() {
        if (this.asyncClient == null) {
            throw new IllegalStateException("The SesAsyncClient is required but has not been detected/configured.");
        }
        return this.asyncClient;
    }

    @PreDestroy
    public void destroy() {
        if (this.syncClient != null) {
            this.syncClient.close();
        }
        if (this.asyncClient != null) {
            this.asyncClient.close();
        }
    }
}

