/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.reactivemessaging.http.runtime.serializers;

import io.quarkus.reactivemessaging.http.runtime.serializers.BufferSerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.CollectionSerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.JsonArraySerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.JsonObjectSerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.NumberSerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.ObjectSerializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.Serializer;
import io.quarkus.reactivemessaging.http.runtime.serializers.StringSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public abstract class SerializerFactoryBase {
    private static final Logger log = Logger.getLogger(SerializerFactoryBase.class);
    private final Map<String, Serializer<?>> serializersByClassName = new HashMap();
    private final List<Serializer<?>> predefinedSerializers = new ArrayList();

    protected SerializerFactoryBase() {
        this.predefinedSerializers.add(new JsonObjectSerializer());
        this.predefinedSerializers.add(new JsonArraySerializer());
        this.predefinedSerializers.add(new StringSerializer());
        this.predefinedSerializers.add(new BufferSerializer());
        this.predefinedSerializers.add(new ObjectSerializer());
        this.predefinedSerializers.add(new CollectionSerializer());
        this.predefinedSerializers.add(new NumberSerializer());
        this.predefinedSerializers.sort(Comparator.comparingInt(Serializer::getPriority));
        Collections.reverse(this.predefinedSerializers);
        this.initAdditionalSerializers();
    }

    protected abstract void initAdditionalSerializers();

    public <T> Serializer<T> getSerializer(String name, T payload) {
        if (payload == null) {
            throw new IllegalArgumentException("Payload cannot be null");
        }
        if (name != null) {
            Serializer<?> serializer = this.serializersByClassName.get(name);
            if (serializer == null) {
                throw new IllegalArgumentException("No serializer class found for name: " + name);
            }
            if (serializer.handles(payload)) {
                return serializer;
            }
            log.warnf("Specified serializer (%s) does not handle the payload type %s", (Object)name, payload.getClass());
        }
        for (Serializer<?> serializer : this.predefinedSerializers) {
            if (!serializer.handles(payload)) continue;
            return serializer;
        }
        throw new IllegalArgumentException("No predefined serializer found matching class: " + payload.getClass());
    }

    public void addSerializer(String className, Serializer<?> serializer) {
        this.serializersByClassName.put(className, serializer);
    }
}

