/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.ComputingCache;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;

abstract class AbstractSharedContext
implements InjectableContext,
InjectableContext.ContextState {
    protected final ComputingCache<String, ContextInstanceHandle<?>> instances = new ComputingCache();

    public <T> T get(Contextual<T> contextual, final CreationalContext<T> creationalContext) {
        final InjectableBean bean = (InjectableBean)contextual;
        return this.instances.computeIfAbsent(bean.getIdentifier(), new Supplier<ContextInstanceHandle<?>>(){

            @Override
            public ContextInstanceHandle<?> get() {
                return AbstractSharedContext.createInstanceHandle(bean, creationalContext);
            }
        }).get();
    }

    public <T> T get(Contextual<T> contextual) {
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle<?> handle = this.instances.getValueIfPresent(bean.getIdentifier());
        return handle != null ? (T)handle.get() : null;
    }

    @Override
    public InjectableContext.ContextState getState() {
        return this;
    }

    @Override
    public Map<InjectableBean<?>, Object> getContextualInstances() {
        return this.instances.getPresentValues().stream().collect(Collectors.toMap(InstanceHandle::getBean, InstanceHandle::get));
    }

    public boolean isActive() {
        return true;
    }

    public void destroy(Contextual<?> contextual) {
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle<?> handle = this.instances.remove(bean.getIdentifier());
        if (handle != null) {
            handle.destroy();
        }
    }

    @Override
    public synchronized void destroy() {
        Set<ContextInstanceHandle<?>> values = this.instances.getPresentValues();
        Iterator<ContextInstanceHandle<?>> iterator = values.iterator();
        while (iterator.hasNext()) {
            ContextInstanceHandle<?> instanceHandle = iterator.next();
            if (instanceHandle.getBean().getDeclaringBean() == null) continue;
            instanceHandle.destroy();
            iterator.remove();
        }
        for (ContextInstanceHandle<?> instanceHandle : values) {
            instanceHandle.destroy();
        }
        this.instances.clear();
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (state != this) {
            throw new IllegalArgumentException("Invalid state: " + state.getClass().getName());
        }
        this.destroy();
    }

    private static <T> ContextInstanceHandle createInstanceHandle(InjectableBean<T> bean, CreationalContext<T> creationalContext) {
        return new ContextInstanceHandleImpl<Object>(bean, bean.create(creationalContext), creationalContext);
    }
}

