/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.processor.bcextensions;

import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.DisposerInfo;
import io.quarkus.arc.processor.InjectionPointInfo;
import io.quarkus.arc.processor.InterceptorInfo;
import io.quarkus.arc.processor.StereotypeInfo;
import io.quarkus.arc.processor.bcextensions.AllAnnotationOverlays;
import io.quarkus.arc.processor.bcextensions.AnnotationInfoImpl;
import io.quarkus.arc.processor.bcextensions.ClassInfoImpl;
import io.quarkus.arc.processor.bcextensions.DisposerInfoImpl;
import io.quarkus.arc.processor.bcextensions.FieldInfoImpl;
import io.quarkus.arc.processor.bcextensions.InjectionPointInfoImpl;
import io.quarkus.arc.processor.bcextensions.InterceptorInfoImpl;
import io.quarkus.arc.processor.bcextensions.MethodInfoImpl;
import io.quarkus.arc.processor.bcextensions.ScopeInfoImpl;
import io.quarkus.arc.processor.bcextensions.StereotypeInfoImpl;
import io.quarkus.arc.processor.bcextensions.TypeImpl;
import jakarta.enterprise.inject.build.compatible.spi.ScopeInfo;
import jakarta.enterprise.lang.model.AnnotationInfo;
import jakarta.enterprise.lang.model.declarations.ClassInfo;
import jakarta.enterprise.lang.model.declarations.FieldInfo;
import jakarta.enterprise.lang.model.declarations.MethodInfo;
import jakarta.enterprise.lang.model.types.Type;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.IndexView;

class BeanInfoImpl
implements jakarta.enterprise.inject.build.compatible.spi.BeanInfo {
    final IndexView jandexIndex;
    final AllAnnotationOverlays annotationOverlays;
    final BeanInfo arcBeanInfo;

    static BeanInfoImpl create(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, BeanInfo arcBeanInfo) {
        if (arcBeanInfo.isInterceptor()) {
            return new InterceptorInfoImpl(jandexIndex, annotationOverlays, (InterceptorInfo)arcBeanInfo);
        }
        return new BeanInfoImpl(jandexIndex, annotationOverlays, arcBeanInfo);
    }

    BeanInfoImpl(IndexView jandexIndex, AllAnnotationOverlays annotationOverlays, BeanInfo arcBeanInfo) {
        this.jandexIndex = jandexIndex;
        this.annotationOverlays = annotationOverlays;
        this.arcBeanInfo = arcBeanInfo;
    }

    public ScopeInfo scope() {
        return new ScopeInfoImpl(this.jandexIndex, this.annotationOverlays, this.arcBeanInfo.getScope());
    }

    public Collection<Type> types() {
        return this.arcBeanInfo.getTypes().stream().map(it -> TypeImpl.fromJandexType(this.jandexIndex, this.annotationOverlays, it)).collect(Collectors.toUnmodifiableSet());
    }

    public Collection<AnnotationInfo> qualifiers() {
        return this.arcBeanInfo.getQualifiers().stream().map(it -> new AnnotationInfoImpl(this.jandexIndex, this.annotationOverlays, (AnnotationInstance)it)).collect(Collectors.toUnmodifiableList());
    }

    public ClassInfo declaringClass() {
        org.jboss.jandex.ClassInfo beanClass = this.jandexIndex.getClassByName(this.arcBeanInfo.getBeanClass());
        return new ClassInfoImpl(this.jandexIndex, this.annotationOverlays, beanClass);
    }

    public boolean isClassBean() {
        return this.arcBeanInfo.isClassBean();
    }

    public boolean isProducerMethod() {
        return this.arcBeanInfo.isProducerMethod();
    }

    public boolean isProducerField() {
        return this.arcBeanInfo.isProducerField();
    }

    public boolean isSynthetic() {
        return this.arcBeanInfo.isSynthetic();
    }

    public MethodInfo producerMethod() {
        if (this.arcBeanInfo.isProducerMethod()) {
            return new MethodInfoImpl(this.jandexIndex, this.annotationOverlays, this.arcBeanInfo.getTarget().get().asMethod());
        }
        return null;
    }

    public FieldInfo producerField() {
        if (this.arcBeanInfo.isProducerField()) {
            return new FieldInfoImpl(this.jandexIndex, this.annotationOverlays, this.arcBeanInfo.getTarget().get().asField());
        }
        return null;
    }

    public boolean isAlternative() {
        return this.arcBeanInfo.isAlternative();
    }

    public Integer priority() {
        return this.arcBeanInfo.getPriority();
    }

    public String name() {
        return this.arcBeanInfo.getName();
    }

    public jakarta.enterprise.inject.build.compatible.spi.DisposerInfo disposer() {
        DisposerInfo disposer = this.arcBeanInfo.getDisposer();
        return disposer != null ? new DisposerInfoImpl(this.jandexIndex, this.annotationOverlays, disposer) : null;
    }

    public Collection<jakarta.enterprise.inject.build.compatible.spi.StereotypeInfo> stereotypes() {
        return this.arcBeanInfo.getStereotypes().stream().map(it -> new StereotypeInfoImpl(this.jandexIndex, this.annotationOverlays, (StereotypeInfo)it)).collect(Collectors.toUnmodifiableList());
    }

    public Collection<jakarta.enterprise.inject.build.compatible.spi.InjectionPointInfo> injectionPoints() {
        return this.arcBeanInfo.getAllInjectionPoints().stream().map(it -> new InjectionPointInfoImpl(this.jandexIndex, this.annotationOverlays, (InjectionPointInfo)it)).collect(Collectors.toUnmodifiableList());
    }

    public String toString() {
        return this.arcBeanInfo.toString();
    }
}

