/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.BytecodeCreatorImpl;
import java.util.Objects;

public class ResultHandle {
    static final ResultHandle NULL = new ResultHandle("Ljava/lang/Object;", null, null);
    private int no;
    private final String type;
    private final BytecodeCreatorImpl owner;
    private final Object constant;
    private ResultType resultType;

    ResultHandle(String type, BytecodeCreatorImpl owner) {
        this.type = type;
        this.owner = owner;
        this.constant = null;
        this.resultType = ResultType.UNUSED;
        this.verifyType(type);
    }

    ResultHandle(String type, BytecodeCreatorImpl owner, Object constant) {
        if (owner != null) {
            Objects.requireNonNull(constant);
        }
        this.type = type;
        this.no = -1;
        this.owner = owner;
        this.constant = constant;
        this.resultType = ResultType.CONSTANT;
        this.verifyType(type);
    }

    private void verifyType(String current) {
        if (current.length() == 0) {
            throw new RuntimeException("Invalid type " + this.type);
        }
        if (current.length() == 1) {
            switch (current.charAt(0)) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': {
                    return;
                }
            }
            throw new RuntimeException("Invalid type " + this.type);
        }
        if (current.charAt(0) == '[') {
            this.verifyType(current.substring(1));
        } else if (!current.startsWith("L") || !current.endsWith(";")) {
            throw new RuntimeException("Invalid type " + this.type);
        }
    }

    public void setNo(int no) {
        this.no = no;
        this.resultType = ResultType.LOCAL_VARIABLE;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    int getNo() {
        if (this.resultType != ResultType.LOCAL_VARIABLE) {
            throw new IllegalStateException("Cannot call getNo on a non-var ResultHandle");
        }
        return this.no;
    }

    void markSingleUse() {
        this.resultType = ResultType.SINGLE_USE;
    }

    String getType() {
        return this.type;
    }

    BytecodeCreatorImpl getOwner() {
        return this.owner;
    }

    public String toString() {
        return "ResultHandle{no=" + this.no + ", type='" + this.type + '\'' + ", owner=" + this.owner + '}';
    }

    public Object getConstant() {
        return this.constant;
    }

    static enum ResultType {
        LOCAL_VARIABLE,
        CONSTANT,
        SINGLE_USE,
        UNUSED;

    }
}

