/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BranchResult;
import io.quarkus.gizmo.BranchResultImpl;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.DescriptorUtils;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.FunctionCreator;
import io.quarkus.gizmo.FunctionCreatorImpl;
import io.quarkus.gizmo.MethodCreatorImpl;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.gizmo.TryBlock;
import io.quarkus.gizmo.TryBlockImpl;
import io.quarkus.gizmo.WhileLoop;
import io.quarkus.gizmo.WhileLoopImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class BytecodeCreatorImpl
implements BytecodeCreator {
    private static final MethodDescriptor THREAD_CURRENT_THREAD = MethodDescriptor.ofMethod(Thread.class, "currentThread", Thread.class, new Class[0]);
    private static final MethodDescriptor THREAD_GET_TCCL = MethodDescriptor.ofMethod(Thread.class, "getContextClassLoader", ClassLoader.class, new Class[0]);
    private static final MethodDescriptor CL_FOR_NAME = MethodDescriptor.ofMethod(Class.class, "forName", Class.class, String.class, Boolean.TYPE, ClassLoader.class);
    private static final boolean DEBUG_SCOPES = Boolean.getBoolean("io.quarkus.gizmo.debug-scopes");
    private static final Map<String, AtomicInteger> functionCountersByClass = new ConcurrentHashMap<String, AtomicInteger>();
    private static final String FUNCTION = "$$function$$";
    protected final List<Operation> operations = new ArrayList<Operation>();
    private final MethodCreatorImpl method;
    private final BytecodeCreatorImpl owner;
    private final Label top = new Label();
    private final Label bottom = new Label();
    private final StackTraceElement[] stack;
    private static final Map<String, String> boxingMap;
    private static final Map<String, String> boxingMethodMap;
    private ResultHandle cachedTccl;

    Label getTop() {
        return this.top;
    }

    Label getBottom() {
        return this.bottom;
    }

    BytecodeCreatorImpl(BytecodeCreatorImpl enclosing, MethodCreatorImpl methodCreator) {
        this.method = methodCreator;
        this.owner = enclosing;
        this.stack = DEBUG_SCOPES ? new Throwable().getStackTrace() : null;
    }

    BytecodeCreatorImpl(BytecodeCreatorImpl enclosing, boolean useThisMethod) {
        this.method = useThisMethod ? (MethodCreatorImpl)this : enclosing.getMethod();
        this.owner = enclosing;
        this.stack = DEBUG_SCOPES ? new Throwable().getStackTrace() : null;
    }

    BytecodeCreatorImpl(BytecodeCreatorImpl enclosing) {
        this(enclosing, enclosing.getMethod());
    }

    @Override
    public ResultHandle getThis() {
        ResultHandle resultHandle = new ResultHandle("L" + this.getMethod().getDeclaringClassName().replace('.', '/') + ";", this);
        resultHandle.setNo(0);
        return resultHandle;
    }

    @Override
    public ResultHandle invokeVirtualMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(object);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(object)), this.resolve(this.checkScope(args)), false, false));
        return ret;
    }

    @Override
    public ResultHandle invokeInterfaceMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(object);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(object)), this.resolve(this.checkScope(args)), true, false));
        return ret;
    }

    @Override
    public ResultHandle invokeStaticMethod(MethodDescriptor descriptor, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(args)), false));
        return ret;
    }

    @Override
    public ResultHandle invokeStaticInterfaceMethod(MethodDescriptor descriptor, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(args)), true));
        return ret;
    }

    @Override
    public ResultHandle invokeSpecialMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(object);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(object)), this.resolve(this.checkScope(args)), false, true));
        return ret;
    }

    @Override
    public ResultHandle invokeSpecialInterfaceMethod(MethodDescriptor descriptor, ResultHandle object, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        Objects.requireNonNull(object);
        ResultHandle ret = this.allocateResult(descriptor.getReturnType());
        this.operations.add(new InvokeOperation(ret, descriptor, this.resolve(this.checkScope(object)), this.resolve(this.checkScope(args)), true, true));
        return ret;
    }

    @Override
    public ResultHandle newInstance(MethodDescriptor descriptor, ResultHandle ... args) {
        Objects.requireNonNull(descriptor);
        ResultHandle ret = this.allocateResult("L" + descriptor.getDeclaringClass() + ";");
        this.operations.add(new NewInstanceOperation(ret, descriptor, this.resolve(this.checkScope(args))));
        return ret;
    }

    @Override
    public ResultHandle newArray(String type, ResultHandle length) {
        Objects.requireNonNull(length);
        String resultType = !type.startsWith("[") ? "[" + DescriptorUtils.objectToDescriptor(type) : DescriptorUtils.objectToDescriptor(type);
        if (resultType.startsWith("[[")) {
            throw new RuntimeException("Multidimensional arrays not supported yet");
        }
        final ResultHandle resolvedLength = this.resolve(this.checkScope(length));
        char typeChar = resultType.charAt(1);
        if (typeChar != 'L') {
            int opcode;
            switch (typeChar) {
                case 'Z': {
                    opcode = 4;
                    break;
                }
                case 'B': {
                    opcode = 8;
                    break;
                }
                case 'C': {
                    opcode = 5;
                    break;
                }
                case 'S': {
                    opcode = 9;
                    break;
                }
                case 'I': {
                    opcode = 10;
                    break;
                }
                case 'J': {
                    opcode = 11;
                    break;
                }
                case 'F': {
                    opcode = 6;
                    break;
                }
                case 'D': {
                    opcode = 7;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown type " + type);
                }
            }
            final ResultHandle ret = this.allocateResult(resultType);
            this.operations.add(new Operation(){

                @Override
                public void writeBytecode(MethodVisitor methodVisitor) {
                    BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedLength, BytecodeCreatorImpl.this, "I");
                    methodVisitor.visitIntInsn(188, opcode);
                    BytecodeCreatorImpl.storeResultHandle(methodVisitor, ret);
                }

                @Override
                Set<ResultHandle> getInputResultHandles() {
                    return Collections.singleton(resolvedLength);
                }

                @Override
                ResultHandle getTopResultHandle() {
                    return resolvedLength;
                }

                @Override
                ResultHandle getOutgoingResultHandle() {
                    return ret;
                }
            });
            return ret;
        }
        final String arrayType = resultType.substring(2, resultType.length() - 1);
        final ResultHandle ret = this.allocateResult(resultType);
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedLength, BytecodeCreatorImpl.this, "I");
                methodVisitor.visitTypeInsn(189, arrayType);
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, ret);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedLength);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedLength;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return ret;
            }
        });
        return ret;
    }

    @Override
    public ResultHandle load(String val) {
        Objects.requireNonNull(val);
        if (val.length() > 65535) {
            throw new IllegalArgumentException("Cannot load strings larger than 65535 bytes");
        }
        return new ResultHandle("Ljava/lang/String;", this, val);
    }

    @Override
    public ResultHandle load(byte val) {
        return new ResultHandle("B", this, val);
    }

    @Override
    public ResultHandle load(short val) {
        return new ResultHandle("S", this, val);
    }

    @Override
    public ResultHandle load(char val) {
        return new ResultHandle("C", this, Character.valueOf(val));
    }

    @Override
    public ResultHandle load(int val) {
        return new ResultHandle("I", this, val);
    }

    @Override
    public ResultHandle load(long val) {
        return new ResultHandle("J", this, val);
    }

    @Override
    public ResultHandle load(float val) {
        return new ResultHandle("F", this, Float.valueOf(val));
    }

    @Override
    public ResultHandle load(double val) {
        return new ResultHandle("D", this, val);
    }

    @Override
    public ResultHandle load(boolean val) {
        return new ResultHandle("Z", this, val);
    }

    @Override
    public ResultHandle loadClass(String className) {
        return this.loadClass(className, false);
    }

    @Override
    public ResultHandle loadClassFromTCCL(String className) {
        return this.loadClass(className, true);
    }

    private ResultHandle loadClass(String className, boolean useTccl) {
        Objects.requireNonNull(className);
        Class<?> primitiveType = this.matchPossiblyPrimitive(className);
        if (primitiveType == null) {
            if (useTccl && !className.startsWith("java.")) {
                if (this.cachedTccl == null) {
                    ResultHandle currentThread = this.invokeStaticMethod(THREAD_CURRENT_THREAD, new ResultHandle[0]);
                    this.cachedTccl = this.invokeVirtualMethod(THREAD_GET_TCCL, currentThread, new ResultHandle[0]);
                }
                return this.invokeStaticMethod(CL_FOR_NAME, this.load(className), this.load(false), this.cachedTccl);
            }
            return new ResultHandle("Ljava/lang/Class;", this, Type.getObjectType((String)className.replace('.', '/')));
        }
        final Class<?> pt = primitiveType;
        final ResultHandle ret = new ResultHandle("Ljava/lang/Class;", this);
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                methodVisitor.visitFieldInsn(178, Type.getInternalName((Class)pt), "TYPE", "Ljava/lang/Class;");
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, ret);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.emptySet();
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return ret;
            }
        });
        return ret;
    }

    private Class<?> matchPossiblyPrimitive(String className) {
        switch (className) {
            case "boolean": {
                return Boolean.class;
            }
            case "byte": {
                return Byte.class;
            }
            case "char": {
                return Character.class;
            }
            case "short": {
                return Short.class;
            }
            case "int": {
                return Integer.class;
            }
            case "long": {
                return Long.class;
            }
            case "float": {
                return Float.class;
            }
            case "double": {
                return Double.class;
            }
            case "void": {
                return Void.class;
            }
        }
        return null;
    }

    @Override
    public ResultHandle loadNull() {
        return ResultHandle.NULL;
    }

    @Override
    public void writeInstanceField(final FieldDescriptor fieldDescriptor, ResultHandle instance, ResultHandle value) {
        Objects.requireNonNull(instance);
        Objects.requireNonNull(value);
        final ResultHandle resolvedInstance = this.resolve(this.checkScope(instance));
        final ResultHandle resolvedValue = this.resolve(this.checkScope(value));
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedInstance, BytecodeCreatorImpl.this, "L" + fieldDescriptor.getDeclaringClass() + ";");
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedValue, BytecodeCreatorImpl.this, fieldDescriptor.getType());
                methodVisitor.visitFieldInsn(181, fieldDescriptor.getDeclaringClass(), fieldDescriptor.getName(), fieldDescriptor.getType());
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return new LinkedHashSet<ResultHandle>(Arrays.asList(resolvedInstance, resolvedValue));
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedInstance;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }
        });
    }

    @Override
    public ResultHandle readInstanceField(final FieldDescriptor fieldDescriptor, ResultHandle instance) {
        Objects.requireNonNull(fieldDescriptor);
        Objects.requireNonNull(instance);
        final ResultHandle resultHandle = this.allocateResult(fieldDescriptor.getType());
        final ResultHandle resolvedInstance = this.resolve(this.checkScope(instance));
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedInstance, BytecodeCreatorImpl.this, "L" + fieldDescriptor.getDeclaringClass() + ";");
                methodVisitor.visitFieldInsn(180, fieldDescriptor.getDeclaringClass(), fieldDescriptor.getName(), fieldDescriptor.getType());
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, resultHandle);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedInstance);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedInstance;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return resultHandle;
            }
        });
        return resultHandle;
    }

    @Override
    public void writeStaticField(final FieldDescriptor fieldDescriptor, ResultHandle value) {
        Objects.requireNonNull(fieldDescriptor);
        Objects.requireNonNull(value);
        final ResultHandle resolvedValue = this.resolve(this.checkScope(value));
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedValue, BytecodeCreatorImpl.this, fieldDescriptor.getType());
                methodVisitor.visitFieldInsn(179, fieldDescriptor.getDeclaringClass(), fieldDescriptor.getName(), fieldDescriptor.getType());
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedValue);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedValue;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }
        });
    }

    @Override
    public ResultHandle readStaticField(final FieldDescriptor fieldDescriptor) {
        Objects.requireNonNull(fieldDescriptor);
        final ResultHandle result = this.allocateResult(fieldDescriptor.getType());
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                methodVisitor.visitFieldInsn(178, fieldDescriptor.getDeclaringClass(), fieldDescriptor.getName(), fieldDescriptor.getType());
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, result);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.emptySet();
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return result;
            }
        });
        return result;
    }

    @Override
    public ResultHandle arrayLength(ResultHandle array) {
        final ResultHandle result = new ResultHandle("I", this);
        final ResultHandle resolvedArray = this.resolve(this.checkScope(array));
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedArray, BytecodeCreatorImpl.this, resolvedArray.getType());
                methodVisitor.visitInsn(190);
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, result);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedArray);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedArray;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return result;
            }
        });
        return result;
    }

    @Override
    public ResultHandle readArrayValue(ResultHandle array, ResultHandle index) {
        if (!array.getType().startsWith("[")) {
            throw new IllegalArgumentException("Not array type: " + array.getType());
        }
        final ResultHandle result = this.allocateResult(array.getType().substring(1));
        final ResultHandle resolvedArray = this.resolve(this.checkScope(array));
        final ResultHandle resolvedIndex = this.resolve(this.checkScope(index));
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedArray, BytecodeCreatorImpl.this, resolvedArray.getType());
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedIndex, BytecodeCreatorImpl.this, "I");
                switch (result.getType()) {
                    case "I": {
                        methodVisitor.visitInsn(46);
                        break;
                    }
                    case "J": {
                        methodVisitor.visitInsn(47);
                        break;
                    }
                    case "F": {
                        methodVisitor.visitInsn(48);
                        break;
                    }
                    case "D": {
                        methodVisitor.visitInsn(49);
                        break;
                    }
                    case "B": 
                    case "Z": {
                        methodVisitor.visitInsn(51);
                        break;
                    }
                    case "C": {
                        methodVisitor.visitInsn(52);
                        break;
                    }
                    case "S": {
                        methodVisitor.visitInsn(53);
                        break;
                    }
                    default: {
                        methodVisitor.visitInsn(50);
                    }
                }
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, result);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return new LinkedHashSet<ResultHandle>(Arrays.asList(resolvedArray, resolvedIndex));
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedArray;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return result;
            }
        });
        return result;
    }

    @Override
    public void writeArrayValue(ResultHandle array, ResultHandle index, ResultHandle value) {
        final ResultHandle resolvedArray = this.resolve(this.checkScope(array));
        final ResultHandle resolvedIndex = this.resolve(this.checkScope(index));
        final ResultHandle resolvedValue = this.resolve(this.checkScope(value));
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedArray, BytecodeCreatorImpl.this, resolvedArray.getType());
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedIndex, BytecodeCreatorImpl.this, "I");
                String arrayType = resolvedArray.getType().substring(1);
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedValue, BytecodeCreatorImpl.this, arrayType);
                if (arrayType.equals("Z") || arrayType.equals("B")) {
                    methodVisitor.visitInsn(84);
                } else if (arrayType.equals("S")) {
                    methodVisitor.visitInsn(86);
                } else if (arrayType.equals("I")) {
                    methodVisitor.visitInsn(79);
                } else if (arrayType.equals("C")) {
                    methodVisitor.visitInsn(85);
                } else if (arrayType.equals("J")) {
                    methodVisitor.visitInsn(80);
                } else if (arrayType.equals("F")) {
                    methodVisitor.visitInsn(81);
                } else if (arrayType.equals("D")) {
                    methodVisitor.visitInsn(82);
                } else {
                    methodVisitor.visitInsn(83);
                }
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return new LinkedHashSet<ResultHandle>(Arrays.asList(resolvedArray, resolvedIndex, resolvedValue));
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedArray;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }
        });
    }

    @Override
    public AssignableResultHandle createVariable(String typeDescr) {
        Objects.requireNonNull(typeDescr);
        return new AssignableResultHandle(typeDescr, this);
    }

    @Override
    public void assign(AssignableResultHandle target, ResultHandle value) {
        Objects.requireNonNull(target);
        Objects.requireNonNull(value);
        ResultHandle resolvedTarget = this.resolve((ResultHandle)this.checkScope(target));
        ResultHandle resolvedValue = this.resolve(this.checkScope(value));
        if (!(resolvedTarget instanceof AssignableResultHandle)) {
            throw new IllegalArgumentException("Cannot assign to captured variables");
        }
        this.operations.add(new AssignOperation(resolvedValue, resolvedTarget));
    }

    @Override
    public ResultHandle checkCast(ResultHandle resultHandle, String castTarget) {
        Objects.requireNonNull(resultHandle);
        Objects.requireNonNull(castTarget);
        String intName = castTarget.replace('.', '/');
        final ResultHandle result = intName.startsWith("[") || intName.endsWith(";") ? this.allocateResult(intName) : this.allocateResult("L" + intName + ";");
        final ResultHandle resolvedResultHandle = this.resolve(this.checkScope(resultHandle));
        assert (result != null);
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedResultHandle, BytecodeCreatorImpl.this, result.getType());
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, result);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedResultHandle);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedResultHandle;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return result;
            }
        });
        return result;
    }

    @Override
    public boolean isScopedWithin(BytecodeCreator other) {
        return other == this || this.owner != null && this.owner.isScopedWithin(other);
    }

    @Override
    public void continueScope(BytecodeCreator scope) {
        if (!this.isScopedWithin(scope)) {
            throw new IllegalArgumentException("Cannot continue non-enclosing scope");
        }
        this.operations.add(new JumpOperation(((BytecodeCreatorImpl)scope).top));
    }

    @Override
    public void breakScope(BytecodeCreator scope) {
        if (!this.isScopedWithin(scope)) {
            throw new IllegalArgumentException("Cannot break non-enclosing scope");
        }
        this.operations.add(new JumpOperation(((BytecodeCreatorImpl)scope).bottom));
    }

    @Override
    public BytecodeCreator createScope() {
        BytecodeCreatorImpl enclosed = new BytecodeCreatorImpl(this);
        this.operations.add(new BlockOperation(enclosed));
        return enclosed;
    }

    static void storeResultHandle(MethodVisitor methodVisitor, ResultHandle handle) {
        if (handle.getResultType() == ResultHandle.ResultType.UNUSED) {
            if (handle.getType().equals("J") || handle.getType().equals("D")) {
                methodVisitor.visitInsn(88);
            } else {
                methodVisitor.visitInsn(87);
            }
        } else if (handle.getResultType() == ResultHandle.ResultType.LOCAL_VARIABLE) {
            if (handle.getType().equals("S") || handle.getType().equals("Z") || handle.getType().equals("I") || handle.getType().equals("B") || handle.getType().equals("C")) {
                methodVisitor.visitVarInsn(54, handle.getNo());
            } else if (handle.getType().equals("J")) {
                methodVisitor.visitVarInsn(55, handle.getNo());
            } else if (handle.getType().equals("F")) {
                methodVisitor.visitVarInsn(56, handle.getNo());
            } else if (handle.getType().equals("D")) {
                methodVisitor.visitVarInsn(57, handle.getNo());
            } else {
                methodVisitor.visitVarInsn(58, handle.getNo());
            }
        }
    }

    void loadResultHandle(MethodVisitor methodVisitor, ResultHandle handle, BytecodeCreatorImpl bc, String expectedType) {
        this.loadResultHandle(methodVisitor, handle, bc, expectedType, false);
    }

    void loadResultHandle(MethodVisitor methodVisitor, ResultHandle handle, BytecodeCreatorImpl bc, String expectedType, boolean dontCast) {
        if (handle.getResultType() == ResultHandle.ResultType.CONSTANT) {
            if (handle.getConstant() == null) {
                methodVisitor.visitInsn(1);
            } else {
                methodVisitor.visitLdcInsn(handle.getConstant());
                if (!dontCast && !expectedType.equals(handle.getType())) {
                    if (expectedType.length() > 1 && handle.getType().length() > 1) {
                        if (!expectedType.equals("Ljava/lang/Object;")) {
                            methodVisitor.visitTypeInsn(192, DescriptorUtils.getTypeStringFromDescriptorFormat(expectedType));
                        }
                    } else if (expectedType.length() != 1 || handle.getType().length() != 1) {
                        if (expectedType.length() == 1) {
                            String type = boxingMap.get(expectedType);
                            if (type == null) {
                                throw new RuntimeException("Unknown primitive type " + expectedType);
                            }
                            methodVisitor.visitTypeInsn(192, type);
                            methodVisitor.visitMethodInsn(182, type, boxingMethodMap.get(expectedType), "()" + expectedType, false);
                        } else {
                            String type = boxingMap.get(handle.getType());
                            methodVisitor.visitMethodInsn(184, type, "valueOf", "(" + handle.getType() + ")L" + type + ";", false);
                        }
                    }
                }
            }
            return;
        }
        if (!this.isScopedWithin(handle.getOwner())) {
            // empty if block
        }
        if (handle.getResultType() != ResultHandle.ResultType.SINGLE_USE) {
            if (handle.getType().equals("S") || handle.getType().equals("Z") || handle.getType().equals("I") || handle.getType().equals("B") || handle.getType().equals("C")) {
                methodVisitor.visitVarInsn(21, handle.getNo());
            } else if (handle.getType().equals("J")) {
                methodVisitor.visitVarInsn(22, handle.getNo());
            } else if (handle.getType().equals("F")) {
                methodVisitor.visitVarInsn(23, handle.getNo());
            } else if (handle.getType().equals("D")) {
                methodVisitor.visitVarInsn(24, handle.getNo());
            } else {
                methodVisitor.visitVarInsn(25, handle.getNo());
            }
        }
        if (!dontCast && !expectedType.equals(handle.getType())) {
            if (expectedType.length() > 1 && handle.getType().length() > 1) {
                if (!expectedType.equals("Ljava/lang/Object;")) {
                    methodVisitor.visitTypeInsn(192, DescriptorUtils.getTypeStringFromDescriptorFormat(expectedType));
                }
            } else if (expectedType.length() != 1 || handle.getType().length() != 1) {
                if (expectedType.length() == 1) {
                    String type = boxingMap.get(expectedType);
                    if (type == null) {
                        throw new RuntimeException("Unknown primitive type " + expectedType);
                    }
                    methodVisitor.visitTypeInsn(192, type);
                    methodVisitor.visitMethodInsn(182, type, boxingMethodMap.get(expectedType), "()" + expectedType, false);
                } else {
                    String type = boxingMap.get(handle.getType());
                    methodVisitor.visitMethodInsn(184, type, "valueOf", "(" + handle.getType() + ")L" + type + ";", false);
                }
            }
        }
    }

    @Override
    public TryBlock tryBlock() {
        TryBlockImpl tryBlock = new TryBlockImpl(this);
        this.operations.add(new BlockOperation(tryBlock));
        return tryBlock;
    }

    @Override
    public BranchResult ifNonZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 154, "I");
    }

    @Override
    public BranchResult ifNull(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 198, "Ljava/lang/Object;");
    }

    @Override
    public BranchResult ifZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 153, "I");
    }

    @Override
    public BranchResult ifTrue(ResultHandle resultHandle) {
        return this.ifNonZero(resultHandle);
    }

    @Override
    public BranchResult ifFalse(ResultHandle resultHandle) {
        return this.ifZero(resultHandle);
    }

    @Override
    public BranchResult ifNotNull(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 199, "Ljava/lang/Object;");
    }

    @Override
    public BranchResult ifGreaterThanZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 157, "I");
    }

    @Override
    public BranchResult ifGreaterEqualZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 156, "I");
    }

    @Override
    public BranchResult ifLessThanZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 155, "I");
    }

    @Override
    public BranchResult ifLessEqualZero(ResultHandle resultHandle) {
        return this.ifValue(resultHandle, 158, "I");
    }

    @Override
    public BranchResult ifIntegerEqual(ResultHandle value1, ResultHandle value2) {
        return this.ifValues(value1, value2, 159, "I");
    }

    @Override
    public BranchResult ifIntegerGreaterThan(ResultHandle value1, ResultHandle value2) {
        return this.ifValues(value1, value2, 163, "I");
    }

    @Override
    public BranchResult ifIntegerGreaterEqual(ResultHandle value1, ResultHandle value2) {
        return this.ifValues(value1, value2, 162, "I");
    }

    @Override
    public BranchResult ifIntegerLessThan(ResultHandle value1, ResultHandle value2) {
        return this.ifValues(value1, value2, 161, "I");
    }

    @Override
    public ResultHandle instanceOf(final ResultHandle resultHandle, String castTarget) {
        Objects.requireNonNull(resultHandle);
        Objects.requireNonNull(castTarget);
        final ResultHandle result = this.allocateResult("I");
        final ResultHandle resolvedResultHandle = this.resolve(this.checkScope(resultHandle));
        assert (result != null);
        final String intName = castTarget.replace('.', '/');
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedResultHandle, BytecodeCreatorImpl.this, resultHandle.getType(), true);
                methodVisitor.visitTypeInsn(193, intName);
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, result);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedResultHandle);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedResultHandle;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return result;
            }
        });
        return result;
    }

    @Override
    public BranchResult ifIntegerLessEqual(ResultHandle value1, ResultHandle value2) {
        return this.ifValues(value1, value2, 164, "I");
    }

    @Override
    public BranchResult ifReferencesEqual(ResultHandle ref1, ResultHandle ref2) {
        return this.ifValues(ref1, ref2, 165, "Ljava/lang/Object;");
    }

    @Override
    public ResultHandle getMethodParam(int methodNo) {
        int count = (this.method.getModifiers() & 8) != 0 ? 0 : 1;
        for (int i = 0; i < methodNo; ++i) {
            String s = this.getMethod().getMethodDescriptor().getParameterTypes()[i];
            if (s.equals("J") || s.equals("D")) {
                count += 2;
                continue;
            }
            ++count;
        }
        ResultHandle resultHandle = new ResultHandle(this.getMethod().getMethodDescriptor().getParameterTypes()[methodNo], this);
        resultHandle.setNo(count);
        return resultHandle;
    }

    @Override
    public FunctionCreator createFunction(Class<?> functionalInterface) {
        if (!functionalInterface.isInterface()) {
            throw new IllegalArgumentException("Not an interface " + functionalInterface);
        }
        Method functionMethod = null;
        for (Method m : functionalInterface.getMethods()) {
            if (m.isDefault() || Modifier.isStatic(m.getModifiers())) continue;
            if (functionMethod != null) {
                throw new IllegalArgumentException("Not a functional interface " + functionalInterface);
            }
            functionMethod = m;
        }
        if (functionMethod == null) {
            throw new IllegalArgumentException("Could not find function method " + functionalInterface);
        }
        String declaringClassName = this.getMethod().getDeclaringClassName();
        AtomicInteger counter = functionCountersByClass.computeIfAbsent(declaringClassName, k -> new AtomicInteger());
        String functionName = declaringClassName + FUNCTION + counter.incrementAndGet();
        ResultHandle ret = new ResultHandle("L" + functionName.replace('.', '/') + ";", this);
        final ClassCreator cc = ClassCreator.builder().enclosing(this).classOutput(this.getMethod().getClassOutput()).className(functionName).interfaces(functionalInterface).build();
        MethodCreatorImpl mc = (MethodCreatorImpl)cc.getMethodCreator(functionMethod.getName(), functionMethod.getReturnType(), functionMethod.getParameterTypes());
        final FunctionCreatorImpl fc = mc.addFunctionBody(ret, cc, mc, this);
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                fc.writeCreateInstance(methodVisitor);
                cc.close();
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.emptySet();
            }

            @Override
            ResultHandle getTopResultHandle() {
                return null;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return fc.getInstance();
            }

            @Override
            public void findResultHandles(Set<ResultHandle> vc) {
                vc.addAll(fc.getCapturedResultHandles());
            }
        });
        return fc;
    }

    @Override
    public void returnValue(ResultHandle returnValue) {
        final ResultHandle resolvedReturnValue = this.resolve(this.checkScope(returnValue));
        final MethodDescriptor methodDescriptor = this.getMethod().getMethodDescriptor();
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                if (resolvedReturnValue == null || methodDescriptor.getReturnType().equals("V")) {
                    methodVisitor.visitInsn(177);
                } else {
                    BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedReturnValue, BytecodeCreatorImpl.this, methodDescriptor.getReturnType());
                    if (methodDescriptor.getReturnType().equals("S") || methodDescriptor.getReturnType().equals("Z") || methodDescriptor.getReturnType().equals("I") || methodDescriptor.getReturnType().equals("B") || methodDescriptor.getReturnType().equals("C")) {
                        methodVisitor.visitInsn(172);
                    } else if (methodDescriptor.getReturnType().equals("J")) {
                        methodVisitor.visitInsn(173);
                    } else if (methodDescriptor.getReturnType().equals("F")) {
                        methodVisitor.visitInsn(174);
                    } else if (methodDescriptor.getReturnType().equals("D")) {
                        methodVisitor.visitInsn(175);
                    } else {
                        methodVisitor.visitInsn(176);
                    }
                }
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                if (resolvedReturnValue == null) {
                    return Collections.emptySet();
                }
                return Collections.singleton(resolvedReturnValue);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedReturnValue;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }
        });
    }

    @Override
    public void throwException(ResultHandle exception) {
        Objects.requireNonNull(exception);
        final ResultHandle resolvedException = this.resolve(this.checkScope(exception));
        this.operations.add(new Operation(){

            @Override
            public void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, resolvedException, BytecodeCreatorImpl.this, "Ljava/lang/Throwable;");
                methodVisitor.visitInsn(191);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return Collections.singleton(resolvedException);
            }

            @Override
            ResultHandle getTopResultHandle() {
                return resolvedException;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return null;
            }
        });
    }

    @Override
    public WhileLoop whileLoop(Function<BytecodeCreator, BranchResult> conditionFun) {
        Objects.requireNonNull(conditionFun);
        WhileLoopImpl loop = new WhileLoopImpl(this, conditionFun);
        this.operations.add(new BlockOperation(loop));
        return loop;
    }

    @Override
    public ResultHandle add(final ResultHandle a1, final ResultHandle a2) {
        Objects.requireNonNull(a1);
        Objects.requireNonNull(a2);
        if (!a1.getType().equals(a2.getType())) {
            throw new RuntimeException("ResultHandles must be of the same type");
        }
        final ResultHandle ret = new ResultHandle(a1.getType(), this);
        this.operations.add(new Operation(){

            @Override
            void writeBytecode(MethodVisitor methodVisitor) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, a1, BytecodeCreatorImpl.this, a1.getType());
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, a2, BytecodeCreatorImpl.this, a2.getType());
                if (a1.getType().equals("Z")) {
                    methodVisitor.visitInsn(97);
                } else if (a1.getType().equals("D")) {
                    methodVisitor.visitInsn(99);
                } else if (a1.getType().equals("F")) {
                    methodVisitor.visitInsn(98);
                } else {
                    methodVisitor.visitInsn(96);
                }
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, ret);
            }

            @Override
            Set<ResultHandle> getInputResultHandles() {
                return new HashSet<ResultHandle>(Arrays.asList(a1, a2));
            }

            @Override
            ResultHandle getTopResultHandle() {
                return a1;
            }

            @Override
            ResultHandle getOutgoingResultHandle() {
                return ret;
            }
        });
        return ret;
    }

    private ResultHandle allocateResult(String returnType) {
        if (returnType.equals("V")) {
            return null;
        }
        return new ResultHandle(returnType, this);
    }

    protected int allocateLocalVariables(int localVarCount) {
        LinkedHashSet<ResultHandle> handlesToAllocate = new LinkedHashSet<ResultHandle>();
        this.findActiveResultHandles(handlesToAllocate);
        int vc = localVarCount;
        for (ResultHandle handle : handlesToAllocate) {
            if (handle.getResultType() == ResultHandle.ResultType.CONSTANT || handle.getResultType() == ResultHandle.ResultType.LOCAL_VARIABLE) continue;
            handle.setNo(vc);
            if (handle.getType().equals("J") || handle.getType().equals("D")) {
                vc += 2;
                continue;
            }
            ++vc;
        }
        return vc;
    }

    void findActiveResultHandles(Set<ResultHandle> handlesToAllocate) {
        Operation prev = null;
        for (int i = 0; i < this.operations.size(); ++i) {
            Operation op = this.operations.get(i);
            LinkedHashSet<ResultHandle> toAdd = new LinkedHashSet<ResultHandle>(op.getInputResultHandles());
            if (prev != null && prev.getOutgoingResultHandle() != null && prev.getOutgoingResultHandle() == op.getTopResultHandle()) {
                toAdd.remove(op.getTopResultHandle());
                if (op.getTopResultHandle().getResultType() == ResultHandle.ResultType.UNUSED) {
                    op.getTopResultHandle().markSingleUse();
                }
            }
            handlesToAllocate.addAll(toAdd);
            op.findResultHandles(handlesToAllocate);
            prev = op;
        }
    }

    protected void writeOperations(MethodVisitor visitor) {
        visitor.visitLabel(this.top);
        this.writeInteriorOperations(visitor);
        visitor.visitLabel(this.bottom);
    }

    protected void writeInteriorOperations(MethodVisitor visitor) {
        for (Operation op : this.operations) {
            op.doProcess(visitor);
        }
    }

    <R extends ResultHandle> R checkScope(R handle) {
        BytecodeCreatorImpl handleOwner;
        if (handle != null && (handleOwner = handle.getOwner()) != null && !this.isScopedWithin(handleOwner)) {
            StringBuilder trace = new StringBuilder();
            trace.append("Result handle ").append(handle).append(" used outside of its scope\n");
            trace.append("The handle's scope is:\n");
            handleOwner.dumpScope(trace);
            trace.append("The usage scope is:\n");
            this.dumpScope(trace);
            throw new IllegalArgumentException(trace.toString());
        }
        return handle;
    }

    private void dumpScope(StringBuilder builder) {
        builder.append("\tat ").append(this).append('\n');
        StackTraceElement[] stack = this.stack;
        if (stack != null) {
            int length = stack.length;
            for (int i = 0; i < 8 && i < length; ++i) {
                builder.append("\t\tat ").append(stack[i]).append('\n');
            }
            if (length > 8) {
                builder.append("\t\t...\n");
            }
        }
        if (this.owner != null) {
            this.owner.dumpScope(builder);
        }
    }

    ResultHandle[] checkScope(ResultHandle[] handles) {
        for (ResultHandle resultHandle : handles) {
            this.checkScope(resultHandle);
        }
        return handles;
    }

    final ResultHandle resolve(ResultHandle handle) {
        return this.resolve(handle, this);
    }

    ResultHandle resolve(ResultHandle handle, BytecodeCreator creator) {
        return this.owner.resolve(handle, creator);
    }

    ResultHandle[] resolve(BytecodeCreator creator, ResultHandle ... handles) {
        return this.owner.resolve(handles);
    }

    final ResultHandle[] resolve(ResultHandle ... handles) {
        return this.resolve(this, handles);
    }

    MethodCreatorImpl getMethod() {
        return this.method;
    }

    BytecodeCreatorImpl getOwner() {
        return this.owner;
    }

    private BranchResult ifValue(ResultHandle resultHandle, int opcode, String opType) {
        Objects.requireNonNull(resultHandle);
        Objects.requireNonNull(opType);
        ResultHandle resolvedResultHandle = this.resolve(this.checkScope(resultHandle));
        BytecodeCreatorImpl trueBranch = new BytecodeCreatorImpl(this);
        BytecodeCreatorImpl falseBranch = new BytecodeCreatorImpl(this);
        this.operations.add(new IfOperation(opcode, opType, resolvedResultHandle, trueBranch, falseBranch));
        return new BranchResultImpl(trueBranch, falseBranch);
    }

    private BranchResult ifValues(ResultHandle resultHandle1, ResultHandle resultHandle2, int opcode, String opType) {
        Objects.requireNonNull(resultHandle1);
        Objects.requireNonNull(resultHandle2);
        Objects.requireNonNull(opType);
        ResultHandle resolvedResultHandle1 = this.resolve(this.checkScope(resultHandle1));
        ResultHandle resolvedResultHandle2 = this.resolve(this.checkScope(resultHandle2));
        BytecodeCreatorImpl trueBranch = new BytecodeCreatorImpl(this);
        BytecodeCreatorImpl falseBranch = new BytecodeCreatorImpl(this);
        this.operations.add(new IfOperation(opcode, opType, resolvedResultHandle1, resolvedResultHandle2, trueBranch, falseBranch));
        return new BranchResultImpl(trueBranch, falseBranch);
    }

    Operation createNewInstanceOp(ResultHandle handle, MethodDescriptor descriptor, ResultHandle[] args) {
        return new NewInstanceOperation(handle, descriptor, args);
    }

    static {
        HashMap<String, String> b = new HashMap<String, String>();
        b.put("Z", Type.getInternalName(Boolean.class));
        b.put("B", Type.getInternalName(Byte.class));
        b.put("C", Type.getInternalName(Character.class));
        b.put("S", Type.getInternalName(Short.class));
        b.put("I", Type.getInternalName(Integer.class));
        b.put("J", Type.getInternalName(Long.class));
        b.put("F", Type.getInternalName(Float.class));
        b.put("D", Type.getInternalName(Double.class));
        boxingMap = Collections.unmodifiableMap(b);
        b = new HashMap();
        b.put("Z", "booleanValue");
        b.put("B", "byteValue");
        b.put("C", "charValue");
        b.put("S", "shortValue");
        b.put("I", "intValue");
        b.put("J", "longValue");
        b.put("F", "floatValue");
        b.put("D", "doubleValue");
        boxingMethodMap = Collections.unmodifiableMap(b);
    }

    class AssignOperation
    extends Operation {
        private final ResultHandle resolvedValue;
        private final ResultHandle resolvedTarget;

        public AssignOperation(ResultHandle resolvedValue, ResultHandle resolvedTarget) {
            this.resolvedValue = resolvedValue;
            this.resolvedTarget = resolvedTarget;
        }

        @Override
        void writeBytecode(MethodVisitor methodVisitor) {
            BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, this.resolvedValue, BytecodeCreatorImpl.this, this.resolvedTarget.getType());
            BytecodeCreatorImpl.storeResultHandle(methodVisitor, this.resolvedTarget);
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            return Collections.singleton(this.resolvedValue);
        }

        @Override
        ResultHandle getTopResultHandle() {
            return this.resolvedValue;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return this.resolvedTarget;
        }
    }

    static class BlockOperation
    extends Operation {
        private final BytecodeCreatorImpl block;

        BlockOperation(BytecodeCreatorImpl block) {
            this.block = block;
        }

        @Override
        void writeBytecode(MethodVisitor methodVisitor) {
            this.block.writeOperations(methodVisitor);
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            return Collections.emptySet();
        }

        @Override
        ResultHandle getTopResultHandle() {
            return null;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return null;
        }

        @Override
        public void findResultHandles(Set<ResultHandle> vc) {
            this.block.findActiveResultHandles(vc);
        }
    }

    class IfOperation
    extends Operation {
        private final int opcode;
        private final String opType;
        private final ResultHandle value1;
        private final ResultHandle value2;
        private final BytecodeCreatorImpl trueBranch;
        private final BytecodeCreatorImpl falseBranch;

        IfOperation(int opcode, String opType, ResultHandle value, BytecodeCreatorImpl trueBranch, BytecodeCreatorImpl falseBranch) {
            this(opcode, opType, value, null, trueBranch, falseBranch);
        }

        IfOperation(int opcode, String opType, ResultHandle value1, ResultHandle value2, BytecodeCreatorImpl trueBranch, BytecodeCreatorImpl falseBranch) {
            this.opcode = opcode;
            this.opType = opType;
            this.value1 = value1;
            this.value2 = value2;
            this.trueBranch = trueBranch;
            this.falseBranch = falseBranch;
        }

        @Override
        public void writeBytecode(MethodVisitor methodVisitor) {
            BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, this.value1, BytecodeCreatorImpl.this, this.opType);
            if (this.value2 != null) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, this.value2, BytecodeCreatorImpl.this, this.opType);
            }
            methodVisitor.visitJumpInsn(this.opcode, this.trueBranch.getTop());
            this.falseBranch.writeOperations(methodVisitor);
            methodVisitor.visitJumpInsn(167, this.trueBranch.getBottom());
            this.trueBranch.writeOperations(methodVisitor);
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            if (this.value2 != null) {
                HashSet<ResultHandle> ret = new HashSet<ResultHandle>(2);
                ret.add(this.value1);
                ret.add(this.value2);
                return ret;
            }
            return Collections.singleton(this.value1);
        }

        @Override
        ResultHandle getTopResultHandle() {
            return this.value1;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return null;
        }

        @Override
        public void findResultHandles(Set<ResultHandle> vc) {
            this.trueBranch.findActiveResultHandles(vc);
            this.falseBranch.findActiveResultHandles(vc);
        }
    }

    class NewInstanceOperation
    extends Operation {
        final ResultHandle resultHandle;
        final MethodDescriptor descriptor;
        final ResultHandle[] args;

        NewInstanceOperation(ResultHandle resultHandle, MethodDescriptor descriptor, ResultHandle[] args) {
            if (args.length != descriptor.getParameterTypes().length) {
                throw new RuntimeException("Wrong number of params " + Arrays.toString(descriptor.getParameterTypes()) + " vs " + Arrays.toString(args));
            }
            this.resultHandle = resultHandle;
            this.descriptor = descriptor;
            this.args = new ResultHandle[args.length];
            System.arraycopy(args, 0, this.args, 0, args.length);
        }

        @Override
        public void writeBytecode(MethodVisitor methodVisitor) {
            methodVisitor.visitTypeInsn(187, this.descriptor.getDeclaringClass());
            methodVisitor.visitInsn(89);
            for (int i = 0; i < this.args.length; ++i) {
                ResultHandle arg = this.args[i];
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, arg, BytecodeCreatorImpl.this, this.descriptor.getParameterTypes()[i]);
            }
            methodVisitor.visitMethodInsn(183, this.descriptor.getDeclaringClass(), this.descriptor.getName(), this.descriptor.getDescriptor(), false);
            BytecodeCreatorImpl.storeResultHandle(methodVisitor, this.resultHandle);
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            return new LinkedHashSet<ResultHandle>(Arrays.asList(this.args));
        }

        @Override
        ResultHandle getTopResultHandle() {
            return null;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return this.resultHandle;
        }
    }

    class InvokeOperation
    extends Operation {
        final ResultHandle resultHandle;
        final MethodDescriptor descriptor;
        final ResultHandle object;
        final ResultHandle[] args;
        final boolean staticMethod;
        final boolean interfaceMethod;
        final boolean specialMethod;

        InvokeOperation(ResultHandle resultHandle, MethodDescriptor descriptor, ResultHandle object, ResultHandle[] args, boolean interfaceMethod, boolean specialMethod) {
            if (args.length != descriptor.getParameterTypes().length) {
                throw new RuntimeException("Wrong number of params " + Arrays.toString(descriptor.getParameterTypes()) + " vs " + Arrays.toString(args));
            }
            this.resultHandle = resultHandle;
            this.descriptor = descriptor;
            this.object = object;
            this.args = (ResultHandle[])args.clone();
            this.interfaceMethod = interfaceMethod;
            this.specialMethod = specialMethod;
            this.staticMethod = false;
        }

        InvokeOperation(ResultHandle resultHandle, MethodDescriptor descriptor, ResultHandle[] args, boolean isInterface) {
            if (args.length != descriptor.getParameterTypes().length) {
                throw new RuntimeException("Wrong number of params " + Arrays.toString(descriptor.getParameterTypes()) + " vs " + Arrays.toString(args));
            }
            this.resultHandle = resultHandle;
            this.descriptor = descriptor;
            this.object = null;
            this.args = (ResultHandle[])args.clone();
            this.staticMethod = true;
            this.interfaceMethod = isInterface;
            this.specialMethod = false;
        }

        @Override
        public void writeBytecode(MethodVisitor methodVisitor) {
            if (this.object != null) {
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, this.object, BytecodeCreatorImpl.this, "L" + this.descriptor.getDeclaringClass() + ";", this.specialMethod);
            }
            for (int i = 0; i < this.args.length; ++i) {
                ResultHandle arg = this.args[i];
                BytecodeCreatorImpl.this.loadResultHandle(methodVisitor, arg, BytecodeCreatorImpl.this, this.descriptor.getParameterTypes()[i]);
            }
            if (this.staticMethod) {
                methodVisitor.visitMethodInsn(184, this.descriptor.getDeclaringClass(), this.descriptor.getName(), this.descriptor.getDescriptor(), this.interfaceMethod);
            } else if (this.specialMethod) {
                methodVisitor.visitMethodInsn(183, this.descriptor.getDeclaringClass(), this.descriptor.getName(), this.descriptor.getDescriptor(), this.interfaceMethod);
            } else if (this.interfaceMethod) {
                methodVisitor.visitMethodInsn(185, this.descriptor.getDeclaringClass(), this.descriptor.getName(), this.descriptor.getDescriptor(), true);
            } else {
                methodVisitor.visitMethodInsn(182, this.descriptor.getDeclaringClass(), this.descriptor.getName(), this.descriptor.getDescriptor(), false);
            }
            if (this.resultHandle != null) {
                BytecodeCreatorImpl.storeResultHandle(methodVisitor, this.resultHandle);
            }
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            LinkedHashSet<ResultHandle> ret = new LinkedHashSet<ResultHandle>();
            if (this.object != null) {
                ret.add(this.object);
            }
            ret.addAll(Arrays.asList(this.args));
            return ret;
        }

        @Override
        ResultHandle getTopResultHandle() {
            if (this.object != null) {
                return this.object;
            }
            if (this.args.length > 0) {
                return this.args[0];
            }
            return null;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return this.resultHandle;
        }
    }

    static class JumpOperation
    extends Operation {
        private final Label target;

        JumpOperation(Label target) {
            this.target = target;
        }

        @Override
        void writeBytecode(MethodVisitor methodVisitor) {
            methodVisitor.visitJumpInsn(167, this.target);
        }

        @Override
        Set<ResultHandle> getInputResultHandles() {
            return Collections.emptySet();
        }

        @Override
        ResultHandle getTopResultHandle() {
            return null;
        }

        @Override
        ResultHandle getOutgoingResultHandle() {
            return null;
        }
    }

    static abstract class Operation {
        private final Throwable errorPoint = Boolean.getBoolean("arc.debug") ? new RuntimeException("Error location") : null;

        Operation() {
        }

        public void doProcess(MethodVisitor visitor) {
            try {
                this.writeBytecode(visitor);
            }
            catch (Throwable e) {
                if (this.errorPoint == null) {
                    throw new RuntimeException(e);
                }
                RuntimeException ex = new RuntimeException("Exception generating bytecode", this.errorPoint);
                ex.addSuppressed(e);
                throw ex;
            }
        }

        abstract void writeBytecode(MethodVisitor var1);

        abstract Set<ResultHandle> getInputResultHandles();

        abstract ResultHandle getTopResultHandle();

        abstract ResultHandle getOutgoingResultHandle();

        public void findResultHandles(Set<ResultHandle> vc) {
        }
    }
}

