/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo;

import io.quarkus.gizmo.AssignableResultHandle;
import io.quarkus.gizmo.BytecodeCreator;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;

public final class Gizmo {
    public static final int ASM_API_VERSION = 589824;
    public static final MethodDescriptor TO_STRING = MethodDescriptor.ofMethod(Object.class, "toString", String.class, new Class[0]);
    public static final MethodDescriptor EQUALS = MethodDescriptor.ofMethod(Object.class, "equals", Boolean.TYPE, Object.class);
    public static final MethodDescriptor PRINTLN = MethodDescriptor.ofMethod(PrintStream.class, "println", Void.TYPE, String.class);
    public static final FieldDescriptor SYSTEM_OUT = FieldDescriptor.of(System.class, "out", PrintStream.class);
    public static final FieldDescriptor SYSTEM_ERR = FieldDescriptor.of(System.class, "err", PrintStream.class);

    private Gizmo() {
    }

    public static ResultHandle toString(BytecodeCreator target, ResultHandle obj) {
        return target.invokeVirtualMethod(TO_STRING, obj, new ResultHandle[0]);
    }

    public static ResultHandle equals(BytecodeCreator target, ResultHandle obj1, ResultHandle obj2) {
        return target.invokeVirtualMethod(EQUALS, obj1, obj2);
    }

    public static void systemOutPrintln(BytecodeCreator target, ResultHandle obj) {
        target.invokeVirtualMethod(PRINTLN, target.readStaticField(SYSTEM_OUT), obj);
    }

    public static void systemErrPrintln(BytecodeCreator target, ResultHandle obj) {
        target.invokeVirtualMethod(PRINTLN, target.readStaticField(SYSTEM_ERR), obj);
    }

    public static JdkList listOperations(BytecodeCreator target) {
        return new JdkList(target);
    }

    public static JdkCollection collectionOperations(BytecodeCreator target) {
        return new JdkCollection(target);
    }

    public static JdkSet setOperations(BytecodeCreator target) {
        return new JdkSet(target);
    }

    public static JdkOptional optionalOperations(BytecodeCreator target) {
        return new JdkOptional(target);
    }

    public static JdkIterable iterableOperations(BytecodeCreator target) {
        return new JdkIterable(target);
    }

    public static JdkIterator iteratorOperations(BytecodeCreator target) {
        return new JdkIterator(target);
    }

    public static JdkMap mapOperations(BytecodeCreator target) {
        return new JdkMap(target);
    }

    public static StringBuilderGenerator newStringBuilder(BytecodeCreator target) {
        return new StringBuilderGenerator(target);
    }

    public static void generateEquals(ClassCreator clazz, FieldDescriptor ... fields) {
        Gizmo.generateEquals(clazz, Arrays.asList(fields));
    }

    public static void generateEquals(ClassCreator clazz, Collection<FieldDescriptor> fields) {
        new EqualsHashCodeToStringGenerator(clazz, fields).generateEquals();
    }

    public static void generateEqualsAndHashCode(ClassCreator clazz, FieldDescriptor ... fields) {
        Gizmo.generateEqualsAndHashCode(clazz, Arrays.asList(fields));
    }

    public static void generateEqualsAndHashCode(ClassCreator clazz, Collection<FieldDescriptor> fields) {
        EqualsHashCodeToStringGenerator generator = new EqualsHashCodeToStringGenerator(clazz, fields);
        generator.generateEquals();
        generator.generateHashCode();
    }

    public static void generateNaiveToString(ClassCreator clazz, FieldDescriptor ... fields) {
        Gizmo.generateNaiveToString(clazz, Arrays.asList(fields));
    }

    public static void generateNaiveToString(ClassCreator clazz, Collection<FieldDescriptor> fields) {
        new EqualsHashCodeToStringGenerator(clazz, fields).generateToString();
    }

    public static ResultHandle newHashMap(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(HashMap.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newHashSet(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(HashSet.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newArrayList(BytecodeCreator target) {
        return target.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, new Class[0]), new ResultHandle[0]);
    }

    public static ResultHandle newArrayList(BytecodeCreator target, int initialCapacity) {
        return target.newInstance(MethodDescriptor.ofConstructor(ArrayList.class, Integer.TYPE), target.load(initialCapacity));
    }

    private static class EqualsHashCodeToStringGenerator {
        private static final MethodDescriptor FLOAT_TO_INT_BITS = MethodDescriptor.ofMethod(Float.class, "floatToIntBits", Integer.TYPE, Float.TYPE);
        private static final MethodDescriptor DOUBLE_TO_LONG_BITS = MethodDescriptor.ofMethod(Double.class, "doubleToLongBits", Long.TYPE, Double.TYPE);
        private static final MethodDescriptor BOOLEAN_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, boolean[].class, boolean[].class);
        private static final MethodDescriptor BYTE_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, byte[].class, byte[].class);
        private static final MethodDescriptor SHORT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, short[].class, short[].class);
        private static final MethodDescriptor INT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, int[].class, int[].class);
        private static final MethodDescriptor LONG_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, long[].class, long[].class);
        private static final MethodDescriptor FLOAT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, float[].class, float[].class);
        private static final MethodDescriptor DOUBLE_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, double[].class, double[].class);
        private static final MethodDescriptor CHAR_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, char[].class, char[].class);
        private static final MethodDescriptor OBJECT_EQUALS = MethodDescriptor.ofMethod(Objects.class, "equals", Boolean.TYPE, Object.class, Object.class);
        private static final MethodDescriptor OBJECT_ARRAY_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "equals", Boolean.TYPE, Object[].class, Object[].class);
        private static final MethodDescriptor ARRAY_DEEP_EQUALS = MethodDescriptor.ofMethod(Arrays.class, "deepEquals", Boolean.TYPE, Object[].class, Object[].class);
        private static final MethodDescriptor BOOLEAN_HASH_CODE = MethodDescriptor.ofMethod(Boolean.class, "hashCode", Integer.TYPE, Boolean.TYPE);
        private static final MethodDescriptor BOOLEAN_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, boolean[].class);
        private static final MethodDescriptor BYTE_HASH_CODE = MethodDescriptor.ofMethod(Byte.class, "hashCode", Integer.TYPE, Byte.TYPE);
        private static final MethodDescriptor BYTE_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, byte[].class);
        private static final MethodDescriptor SHORT_HASH_CODE = MethodDescriptor.ofMethod(Short.class, "hashCode", Integer.TYPE, Short.TYPE);
        private static final MethodDescriptor SHORT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, short[].class);
        private static final MethodDescriptor INT_HASH_CODE = MethodDescriptor.ofMethod(Integer.class, "hashCode", Integer.TYPE, Integer.TYPE);
        private static final MethodDescriptor INT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, int[].class);
        private static final MethodDescriptor LONG_HASH_CODE = MethodDescriptor.ofMethod(Long.class, "hashCode", Integer.TYPE, Long.TYPE);
        private static final MethodDescriptor LONG_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, long[].class);
        private static final MethodDescriptor FLOAT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, float[].class);
        private static final MethodDescriptor FLOAT_HASH_CODE = MethodDescriptor.ofMethod(Float.class, "hashCode", Integer.TYPE, Float.TYPE);
        private static final MethodDescriptor DOUBLE_HASH_CODE = MethodDescriptor.ofMethod(Double.class, "hashCode", Integer.TYPE, Double.TYPE);
        private static final MethodDescriptor DOUBLE_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, double[].class);
        private static final MethodDescriptor CHAR_HASH_CODE = MethodDescriptor.ofMethod(Character.class, "hashCode", Integer.TYPE, Character.TYPE);
        private static final MethodDescriptor CHAR_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, char[].class);
        private static final MethodDescriptor OBJECT_HASH_CODE = MethodDescriptor.ofMethod(Objects.class, "hashCode", Integer.TYPE, Object.class);
        private static final MethodDescriptor OBJECT_ARRAY_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "hashCode", Integer.TYPE, Object[].class);
        private static final MethodDescriptor ARRAY_DEEP_HASH_CODE = MethodDescriptor.ofMethod(Arrays.class, "deepHashCode", Integer.TYPE, Object[].class);
        private static final MethodDescriptor BOOLEAN_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, boolean[].class);
        private static final MethodDescriptor BYTE_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, byte[].class);
        private static final MethodDescriptor SHORT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, short[].class);
        private static final MethodDescriptor INT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, int[].class);
        private static final MethodDescriptor LONG_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, long[].class);
        private static final MethodDescriptor FLOAT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, float[].class);
        private static final MethodDescriptor DOUBLE_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, double[].class);
        private static final MethodDescriptor CHAR_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, char[].class);
        private static final MethodDescriptor OBJECT_ARRAY_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "toString", String.class, Object[].class);
        private static final MethodDescriptor ARRAY_DEEP_TO_STRING = MethodDescriptor.ofMethod(Arrays.class, "deepToString", String.class, Object[].class);
        private final ClassCreator clazz;
        private final Collection<FieldDescriptor> fields;

        private EqualsHashCodeToStringGenerator(ClassCreator clazz, Collection<FieldDescriptor> fields) {
            this.clazz = clazz;
            this.fields = fields;
        }

        private void generateEquals() {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((Object)this.clazz.getClassName(), "equals", Boolean.TYPE, Object.class);
            if (this.clazz.getExistingMethods().contains(descriptor)) {
                throw new IllegalStateException("Class already contains the 'equals' method: " + this.clazz.getClassName());
            }
            MethodCreator equals = this.clazz.getMethodCreator(descriptor);
            equals.ifReferencesNotEqual(equals.getThis(), equals.getMethodParam(0)).falseBranch().returnBoolean(true);
            equals.ifTrue(equals.instanceOf(equals.getMethodParam(0), this.clazz.getClassName())).falseBranch().returnBoolean(false);
            ResultHandle other = equals.checkCast(equals.getMethodParam(0), this.clazz.getClassName());
            block32: for (FieldDescriptor field : this.fields) {
                if (!this.clazz.getExistingFields().contains(field)) {
                    throw new IllegalArgumentException(field + " doesn't belong to " + this.clazz.getClassName());
                }
                ResultHandle thisValue = equals.readInstanceField(field, equals.getThis());
                ResultHandle thatValue = equals.readInstanceField(field, other);
                switch (field.getType()) {
                    case "Z": 
                    case "B": 
                    case "S": 
                    case "I": 
                    case "C": {
                        equals.ifIntegerEqual(thisValue, thatValue).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "J": {
                        equals.ifZero(equals.compareLong(thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "F": {
                        equals.ifIntegerEqual(equals.invokeStaticMethod(FLOAT_TO_INT_BITS, thisValue), equals.invokeStaticMethod(FLOAT_TO_INT_BITS, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "D": {
                        equals.ifZero(equals.compareLong(equals.invokeStaticMethod(DOUBLE_TO_LONG_BITS, thisValue), equals.invokeStaticMethod(DOUBLE_TO_LONG_BITS, thatValue))).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[Z": {
                        equals.ifTrue(equals.invokeStaticMethod(BOOLEAN_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[B": {
                        equals.ifTrue(equals.invokeStaticMethod(BYTE_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[S": {
                        equals.ifTrue(equals.invokeStaticMethod(SHORT_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[I": {
                        equals.ifTrue(equals.invokeStaticMethod(INT_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[J": {
                        equals.ifTrue(equals.invokeStaticMethod(LONG_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[F": {
                        equals.ifTrue(equals.invokeStaticMethod(FLOAT_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[D": {
                        equals.ifTrue(equals.invokeStaticMethod(DOUBLE_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                    case "[C": {
                        equals.ifTrue(equals.invokeStaticMethod(CHAR_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                        continue block32;
                    }
                }
                if (field.getType().startsWith("L")) {
                    equals.ifTrue(equals.invokeStaticMethod(OBJECT_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                    continue;
                }
                if (field.getType().startsWith("[L")) {
                    equals.ifTrue(equals.invokeStaticMethod(OBJECT_ARRAY_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                    continue;
                }
                if (field.getType().startsWith("[[")) {
                    equals.ifTrue(equals.invokeStaticMethod(ARRAY_DEEP_EQUALS, thisValue, thatValue)).falseBranch().returnBoolean(false);
                    continue;
                }
                throw new IllegalArgumentException("Don't know how to generate equality computation for field: " + field);
            }
            equals.returnBoolean(true);
        }

        private void generateHashCode() {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((Object)this.clazz.getClassName(), "hashCode", Integer.TYPE, new Object[0]);
            if (this.clazz.getExistingMethods().contains(descriptor)) {
                throw new IllegalStateException("Class already contains the 'hashCode' method: " + this.clazz.getClassName());
            }
            MethodCreator hashCode = this.clazz.getMethodCreator(descriptor);
            if (this.fields.isEmpty()) {
                hashCode.returnInt(0);
                return;
            }
            AssignableResultHandle result = hashCode.createVariable(Integer.TYPE);
            hashCode.assign(result, hashCode.load(1));
            for (FieldDescriptor field : this.fields) {
                ResultHandle componentHash;
                if (!this.clazz.getExistingFields().contains(field)) {
                    throw new IllegalArgumentException(field + " doesn't belong to " + this.clazz.getClassName());
                }
                ResultHandle value = hashCode.readInstanceField(field, hashCode.getThis());
                switch (field.getType()) {
                    case "Z": {
                        componentHash = hashCode.invokeStaticMethod(BOOLEAN_HASH_CODE, value);
                        break;
                    }
                    case "B": {
                        componentHash = hashCode.invokeStaticMethod(BYTE_HASH_CODE, value);
                        break;
                    }
                    case "S": {
                        componentHash = hashCode.invokeStaticMethod(SHORT_HASH_CODE, value);
                        break;
                    }
                    case "I": {
                        componentHash = hashCode.invokeStaticMethod(INT_HASH_CODE, value);
                        break;
                    }
                    case "J": {
                        componentHash = hashCode.invokeStaticMethod(LONG_HASH_CODE, value);
                        break;
                    }
                    case "F": {
                        componentHash = hashCode.invokeStaticMethod(FLOAT_HASH_CODE, value);
                        break;
                    }
                    case "D": {
                        componentHash = hashCode.invokeStaticMethod(DOUBLE_HASH_CODE, value);
                        break;
                    }
                    case "C": {
                        componentHash = hashCode.invokeStaticMethod(CHAR_HASH_CODE, value);
                        break;
                    }
                    case "[Z": {
                        componentHash = hashCode.invokeStaticMethod(BOOLEAN_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[B": {
                        componentHash = hashCode.invokeStaticMethod(BYTE_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[S": {
                        componentHash = hashCode.invokeStaticMethod(SHORT_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[I": {
                        componentHash = hashCode.invokeStaticMethod(INT_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[J": {
                        componentHash = hashCode.invokeStaticMethod(LONG_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[F": {
                        componentHash = hashCode.invokeStaticMethod(FLOAT_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[D": {
                        componentHash = hashCode.invokeStaticMethod(DOUBLE_ARRAY_HASH_CODE, value);
                        break;
                    }
                    case "[C": {
                        componentHash = hashCode.invokeStaticMethod(CHAR_ARRAY_HASH_CODE, value);
                        break;
                    }
                    default: {
                        if (field.getType().startsWith("L")) {
                            componentHash = hashCode.invokeStaticMethod(OBJECT_HASH_CODE, value);
                            break;
                        }
                        if (field.getType().startsWith("[L")) {
                            componentHash = hashCode.invokeStaticMethod(OBJECT_ARRAY_HASH_CODE, value);
                            break;
                        }
                        if (field.getType().startsWith("[[")) {
                            componentHash = hashCode.invokeStaticMethod(ARRAY_DEEP_HASH_CODE, value);
                            break;
                        }
                        throw new IllegalArgumentException("Don't know how to generate hash code computation for field: " + field);
                    }
                }
                hashCode.assign(result, hashCode.add(hashCode.multiply(hashCode.load(31), result), componentHash));
            }
            hashCode.returnValue(result);
        }

        private void generateToString() {
            MethodDescriptor descriptor = MethodDescriptor.ofMethod((Object)this.clazz.getClassName(), "toString", String.class, new Object[0]);
            if (this.clazz.getExistingMethods().contains(descriptor)) {
                throw new IllegalStateException("Class already contains the 'toString' method: " + this.clazz.getClassName());
            }
            MethodCreator toString = this.clazz.getMethodCreator(descriptor);
            StringBuilderGenerator str = Gizmo.newStringBuilder(toString);
            str.append(this.clazz.getSimpleClassName() + "(");
            boolean first = true;
            for (FieldDescriptor field : this.fields) {
                if (!this.clazz.getExistingFields().contains(field)) {
                    throw new IllegalArgumentException(field + " doesn't belong to " + this.clazz.getClassName());
                }
                if (first) {
                    str.append(field.getName() + "=");
                } else {
                    str.append(", " + field.getName() + "=");
                }
                ResultHandle value = toString.readInstanceField(field, toString.getThis());
                switch (field.getType()) {
                    case "[Z": {
                        str.append(toString.invokeStaticMethod(BOOLEAN_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[B": {
                        str.append(toString.invokeStaticMethod(BYTE_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[S": {
                        str.append(toString.invokeStaticMethod(SHORT_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[I": {
                        str.append(toString.invokeStaticMethod(INT_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[J": {
                        str.append(toString.invokeStaticMethod(LONG_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[F": {
                        str.append(toString.invokeStaticMethod(FLOAT_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[D": {
                        str.append(toString.invokeStaticMethod(DOUBLE_ARRAY_TO_STRING, value));
                        break;
                    }
                    case "[C": {
                        str.append(toString.invokeStaticMethod(CHAR_ARRAY_TO_STRING, value));
                        break;
                    }
                    default: {
                        if (field.getType().startsWith("[L")) {
                            str.append(toString.invokeStaticMethod(OBJECT_ARRAY_TO_STRING, value));
                            break;
                        }
                        if (field.getType().startsWith("[[")) {
                            str.append(toString.invokeStaticMethod(ARRAY_DEEP_TO_STRING, value));
                            break;
                        }
                        str.append(value);
                    }
                }
                first = false;
            }
            str.append(')');
            toString.returnValue(str.callToString());
        }
    }

    public static class StringBuilderGenerator {
        private static final MethodDescriptor CONSTRUCTOR = MethodDescriptor.ofConstructor(StringBuilder.class, new Class[0]);
        private static final MethodDescriptor APPEND_BOOLEAN = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Boolean.TYPE);
        private static final MethodDescriptor APPEND_INT = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Integer.TYPE);
        private static final MethodDescriptor APPEND_LONG = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Long.TYPE);
        private static final MethodDescriptor APPEND_FLOAT = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Float.TYPE);
        private static final MethodDescriptor APPEND_DOUBLE = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Double.TYPE);
        private static final MethodDescriptor APPEND_CHAR = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Character.TYPE);
        private static final MethodDescriptor APPEND_CHAR_ARRAY = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, char[].class);
        private static final MethodDescriptor APPEND_STRING = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, String.class);
        private static final MethodDescriptor APPEND_CHAR_SEQUENCE = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, CharSequence.class);
        private static final MethodDescriptor APPEND_OBJECT = MethodDescriptor.ofMethod(StringBuilder.class, "append", StringBuilder.class, Object.class);
        private static final MethodDescriptor TO_STRING = MethodDescriptor.ofMethod(StringBuilder.class, "toString", String.class, new Class[0]);
        private final BytecodeCreator bytecode;
        private final ResultHandle instance;

        private StringBuilderGenerator(BytecodeCreator bytecode) {
            this.bytecode = bytecode;
            this.instance = bytecode.newInstance(CONSTRUCTOR, new ResultHandle[0]);
        }

        public StringBuilderGenerator append(ResultHandle value) {
            switch (value.getType()) {
                case "Z": {
                    this.bytecode.invokeVirtualMethod(APPEND_BOOLEAN, this.instance, value);
                    break;
                }
                case "B": 
                case "S": 
                case "I": {
                    this.bytecode.invokeVirtualMethod(APPEND_INT, this.instance, value);
                    break;
                }
                case "J": {
                    this.bytecode.invokeVirtualMethod(APPEND_LONG, this.instance, value);
                    break;
                }
                case "F": {
                    this.bytecode.invokeVirtualMethod(APPEND_FLOAT, this.instance, value);
                    break;
                }
                case "D": {
                    this.bytecode.invokeVirtualMethod(APPEND_DOUBLE, this.instance, value);
                    break;
                }
                case "C": {
                    this.bytecode.invokeVirtualMethod(APPEND_CHAR, this.instance, value);
                    break;
                }
                case "[C": {
                    this.bytecode.invokeVirtualMethod(APPEND_CHAR_ARRAY, this.instance, value);
                    break;
                }
                case "Ljava/lang/String;": {
                    this.bytecode.invokeVirtualMethod(APPEND_STRING, this.instance, value);
                    break;
                }
                case "Ljava/lang/CharSequence;": {
                    this.bytecode.invokeVirtualMethod(APPEND_CHAR_SEQUENCE, this.instance, value);
                    break;
                }
                default: {
                    this.bytecode.invokeVirtualMethod(APPEND_OBJECT, this.instance, value);
                }
            }
            return this;
        }

        public StringBuilderGenerator append(char constant) {
            return this.append(this.bytecode.load(constant));
        }

        public StringBuilderGenerator append(String constant) {
            return this.append(this.bytecode.load(constant));
        }

        public ResultHandle callToString() {
            return this.bytecode.invokeVirtualMethod(TO_STRING, this.instance, new ResultHandle[0]);
        }

        public ResultHandle getInstance() {
            return this.instance;
        }
    }

    public static class JdkMap
    extends StaticInvocationGenerator {
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(Map.class, "get", Object.class, Object.class);
        public static final MethodDescriptor PUT = MethodDescriptor.ofMethod(Map.class, "put", Object.class, Object.class, Object.class);
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(Map.class, "of", Map.class, Object.class, Object.class);
        public static final MethodDescriptor SIZE = MethodDescriptor.ofMethod(Map.class, "size", Integer.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Map.class, "isEmpty", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor CONTAINS_KEY = MethodDescriptor.ofMethod(Map.class, "containsKey", Boolean.TYPE, Object.class);

        public JdkMap(BytecodeCreator target) {
            super(target);
        }

        @Deprecated
        public JdkMapInstance instance(ResultHandle map) {
            return new JdkMapInstance(map);
        }

        public JdkMapInstance on(ResultHandle map) {
            return new JdkMapInstance(map);
        }

        public ResultHandle of(ResultHandle k1, ResultHandle v1) {
            return this.target.invokeStaticInterfaceMethod(OF1, k1, v1);
        }

        public class JdkMapInstance
        extends InstanceInvocationGenerator {
            JdkMapInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle get(ResultHandle key) {
                return JdkMap.this.target.invokeInterfaceMethod(GET, this.instance, key);
            }

            public ResultHandle put(ResultHandle key, ResultHandle val) {
                return JdkMap.this.target.invokeInterfaceMethod(PUT, this.instance, key, val);
            }

            public ResultHandle size() {
                return JdkMap.this.target.invokeInterfaceMethod(SIZE, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkMap.this.target.invokeInterfaceMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle containsKey(ResultHandle key) {
                return JdkMap.this.target.invokeInterfaceMethod(CONTAINS_KEY, this.instance, key);
            }
        }
    }

    public static class JdkSet
    extends JdkCollection {
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class);
        public static final MethodDescriptor OF2 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class, Object.class);
        public static final MethodDescriptor OF3 = MethodDescriptor.ofMethod(Set.class, "of", Set.class, Object.class, Object.class, Object.class);

        public JdkSet(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkSetInstance on(ResultHandle set) {
            return new JdkSetInstance(set);
        }

        public ResultHandle of(ResultHandle e1) {
            return this.target.invokeStaticInterfaceMethod(OF1, e1);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2) {
            return this.target.invokeStaticInterfaceMethod(OF2, e1, e2);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2, ResultHandle e3) {
            return this.target.invokeStaticInterfaceMethod(OF3, e1, e2, e3);
        }

        public class JdkSetInstance
        extends JdkCollection.JdkCollectionInstance {
            JdkSetInstance(ResultHandle instance) {
                super(instance);
            }
        }
    }

    public static class JdkList
    extends JdkCollection {
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(List.class, "get", Object.class, Integer.TYPE);
        public static final MethodDescriptor OF1 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class);
        public static final MethodDescriptor OF2 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class, Object.class);
        public static final MethodDescriptor OF3 = MethodDescriptor.ofMethod(List.class, "of", List.class, Object.class, Object.class, Object.class);

        public JdkList(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkListInstance on(ResultHandle list) {
            return new JdkListInstance(list);
        }

        public ResultHandle of(ResultHandle e1) {
            return this.target.invokeStaticInterfaceMethod(OF1, e1);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2) {
            return this.target.invokeStaticInterfaceMethod(OF2, e1, e2);
        }

        public ResultHandle of(ResultHandle e1, ResultHandle e2, ResultHandle e3) {
            return this.target.invokeStaticInterfaceMethod(OF3, e1, e2, e3);
        }

        public class JdkListInstance
        extends JdkCollection.JdkCollectionInstance {
            JdkListInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle get(int index) {
                return this.get(JdkList.this.target.load(index));
            }

            public ResultHandle get(ResultHandle index) {
                return JdkList.this.target.invokeInterfaceMethod(GET, this.instance, index);
            }
        }
    }

    public static class JdkCollection
    extends JdkIterable {
        public static final MethodDescriptor SIZE = MethodDescriptor.ofMethod(Collection.class, "size", Integer.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Collection.class, "isEmpty", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor CONTAINS = MethodDescriptor.ofMethod(Collection.class, "contains", Boolean.TYPE, Object.class);
        public static final MethodDescriptor ADD = MethodDescriptor.ofMethod(Collection.class, "add", Boolean.TYPE, Object.class);
        public static final MethodDescriptor ADD_ALL = MethodDescriptor.ofMethod(Collection.class, "addAll", Boolean.TYPE, Collection.class);
        public static final MethodDescriptor CLEAR = MethodDescriptor.ofMethod(Collection.class, "clear", Void.TYPE, new Class[0]);

        public JdkCollection(BytecodeCreator target) {
            super(target);
        }

        @Override
        public JdkCollectionInstance on(ResultHandle list) {
            return new JdkCollectionInstance(list);
        }

        public class JdkCollectionInstance
        extends JdkIterable.JdkIterableInstance {
            JdkCollectionInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle size() {
                return JdkCollection.this.target.invokeInterfaceMethod(SIZE, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkCollection.this.target.invokeInterfaceMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle contains(ResultHandle obj) {
                return JdkCollection.this.target.invokeInterfaceMethod(CONTAINS, this.instance, obj);
            }

            public ResultHandle add(ResultHandle element) {
                return JdkCollection.this.target.invokeInterfaceMethod(ADD, this.instance, element);
            }

            public ResultHandle addAll(ResultHandle collection) {
                return JdkCollection.this.target.invokeInterfaceMethod(ADD_ALL, this.instance, collection);
            }

            public void clear() {
                JdkCollection.this.target.invokeInterfaceMethod(CLEAR, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkIterator
    extends StaticInvocationGenerator {
        public static final MethodDescriptor NEXT = MethodDescriptor.ofMethod(Iterator.class, "next", Object.class, new Class[0]);
        public static final MethodDescriptor HAS_NEXT = MethodDescriptor.ofMethod(Iterator.class, "hasNext", Boolean.TYPE, new Class[0]);

        public JdkIterator(BytecodeCreator target) {
            super(target);
        }

        public JdkIteratorInstance on(ResultHandle iterator) {
            return new JdkIteratorInstance(iterator);
        }

        public class JdkIteratorInstance
        extends InstanceInvocationGenerator {
            JdkIteratorInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle next() {
                return JdkIterator.this.target.invokeInterfaceMethod(NEXT, this.instance, new ResultHandle[0]);
            }

            public ResultHandle hasNext() {
                return JdkIterator.this.target.invokeInterfaceMethod(HAS_NEXT, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkIterable
    extends StaticInvocationGenerator {
        public static final MethodDescriptor ITERATOR = MethodDescriptor.ofMethod(Iterable.class, "iterator", Iterator.class, new Class[0]);

        public JdkIterable(BytecodeCreator target) {
            super(target);
        }

        public JdkIterableInstance on(ResultHandle iterable) {
            return new JdkIterableInstance(iterable);
        }

        public class JdkIterableInstance
        extends InstanceInvocationGenerator {
            JdkIterableInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle iterator() {
                return JdkIterable.this.target.invokeInterfaceMethod(ITERATOR, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class JdkOptional
    extends StaticInvocationGenerator {
        public static final MethodDescriptor OF = MethodDescriptor.ofMethod(Optional.class, "of", Optional.class, Object.class);
        public static final MethodDescriptor OF_NULLABLE = MethodDescriptor.ofMethod(Optional.class, "ofNullable", Optional.class, Object.class);
        public static final MethodDescriptor GET = MethodDescriptor.ofMethod(Optional.class, "get", Object.class, new Class[0]);
        public static final MethodDescriptor IS_PRESENT = MethodDescriptor.ofMethod(Optional.class, "isPresent", Boolean.TYPE, new Class[0]);
        public static final MethodDescriptor IS_EMPTY = MethodDescriptor.ofMethod(Optional.class, "isEmpty", Boolean.TYPE, new Class[0]);

        public JdkOptional(BytecodeCreator target) {
            super(target);
        }

        public JdkOptionalInstance on(ResultHandle optional) {
            return new JdkOptionalInstance(optional);
        }

        public ResultHandle of(ResultHandle value) {
            return this.target.invokeStaticMethod(OF, value);
        }

        public ResultHandle ofNullable(ResultHandle value) {
            return this.target.invokeStaticMethod(OF_NULLABLE, value);
        }

        public class JdkOptionalInstance
        extends InstanceInvocationGenerator {
            JdkOptionalInstance(ResultHandle instance) {
                super(instance);
            }

            public ResultHandle isPresent() {
                return JdkOptional.this.target.invokeVirtualMethod(IS_PRESENT, this.instance, new ResultHandle[0]);
            }

            public ResultHandle isEmpty() {
                return JdkOptional.this.target.invokeVirtualMethod(IS_EMPTY, this.instance, new ResultHandle[0]);
            }

            public ResultHandle get() {
                return JdkOptional.this.target.invokeVirtualMethod(GET, this.instance, new ResultHandle[0]);
            }
        }
    }

    public static class CustomInvocationGenerator
    extends StaticInvocationGenerator {
        private final BiFunction<BytecodeCreator, ResultHandle[], ResultHandle> fun;

        public CustomInvocationGenerator(BytecodeCreator target, BiFunction<BytecodeCreator, ResultHandle[], ResultHandle> fun) {
            super(target);
            this.fun = fun;
        }

        public ResultHandle invoke(ResultHandle ... args) {
            return this.fun.apply(this.target, args);
        }
    }

    public static abstract class InstanceInvocationGenerator {
        protected final ResultHandle instance;

        InstanceInvocationGenerator(ResultHandle instance) {
            this.instance = Objects.requireNonNull(instance);
        }
    }

    public static abstract class StaticInvocationGenerator {
        protected BytecodeCreator target;

        StaticInvocationGenerator(BytecodeCreator target) {
            this.setTarget(target);
        }

        void setTarget(BytecodeCreator target) {
            this.target = Objects.requireNonNull(target);
        }
    }
}

