/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.concurrent.EventExecutor;
import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.httpcore.BlockingHttpExchange;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.httpcore.CompletedListener;
import io.undertow.httpcore.HttpExchange;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.IoCallback;
import io.undertow.httpcore.OutputChannel;
import io.undertow.httpcore.PreCommitListener;
import io.undertow.httpcore.SSLSessionInfo;
import io.undertow.httpcore.UndertowOptionMap;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.httpcore.WriteFunction;
import io.undertow.security.api.SecurityContext;
import io.undertow.server.Connectors;
import io.undertow.server.DefaultResponseListener;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpContinue;
import io.undertow.server.HttpHandler;
import io.undertow.server.ResponseCommitListener;
import io.undertow.server.handlers.Cookie;
import io.undertow.util.AbstractAttachable;
import io.undertow.util.AttachmentKey;
import io.undertow.util.Bits;
import io.undertow.util.Cookies;
import io.undertow.util.NetworkUtils;
import io.undertow.util.Rfc6265CookieSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class HttpServerExchange
extends AbstractAttachable
implements BufferAllocator,
OutputChannel,
InputChannel,
CompletedListener,
PreCommitListener {
    private static final String HTTPS = "https";
    public static final AttachmentKey<Map<String, String>> REQUEST_ATTRIBUTES = AttachmentKey.create(Map.class);
    public static final AttachmentKey<Boolean> SECURE_REQUEST = AttachmentKey.create(Boolean.class);
    private int exchangeCompletionListenersCount = 0;
    private ExchangeCompletionListener[] exchangeCompleteListeners;
    private DefaultResponseListener[] defaultResponseListeners;
    private int responseCommitListenerCount;
    private ResponseCommitListener[] responseCommitListeners;
    private Map<String, Deque<String>> queryParameters;
    private Map<String, Deque<String>> pathParameters;
    private Map<String, Cookie> requestCookies;
    private Map<String, Cookie> responseCookies;
    private String protocol;
    private SecurityContext securityContext;
    private int state = 200;
    private String requestMethod;
    private String requestScheme;
    private String requestURI;
    private String requestPath;
    private String relativePath;
    private String resolvedPath = "";
    private String queryString = "";
    private long requestStartTime = -1L;
    private long maxEntitySize;
    private Runnable dispatchTask;
    private Executor dispatchExecutor;
    private static final int FLAG_RESPONSE_SENT = 1024;
    private static final int FLAG_PERSISTENT = 16384;
    private static final int FLAG_DISPATCHED = 32768;
    private static final int FLAG_URI_CONTAINS_HOST = 65536;
    private static final int FLAG_REQUEST_READ = 0x100000;
    private static final int FLAG_REQUEST_RESET = 0x200000;
    private static final int FLAG_LAST_DATA_QUEUED = 0x400000;
    private InetSocketAddress sourceAddress;
    private InetSocketAddress destinationAddress;
    private SSLSessionInfo sslSessionInfo;
    final HttpExchange delegate;
    private boolean executingHandlerChain;
    private static final AtomicLong REQUEST_ID_GENERATOR = new AtomicLong(0L);
    private final String requestId = Long.toString(REQUEST_ID_GENERATOR.incrementAndGet());

    public HttpServerExchange(HttpExchange delegate, long maxEntitySize) {
        this.maxEntitySize = maxEntitySize;
        this.delegate = delegate;
        delegate.setCompletedListener((CompletedListener)this);
        delegate.setPreCommitListener((PreCommitListener)this);
    }

    public String getProtocol() {
        if (this.protocol != null) {
            return this.protocol;
        }
        return this.delegate.getProtocol();
    }

    public HttpServerExchange protocol(String protocol) {
        this.protocol = protocol;
        return this;
    }

    public boolean isSecure() {
        Boolean secure = this.getAttachment(SECURE_REQUEST);
        if (secure != null && secure.booleanValue()) {
            return true;
        }
        String scheme = this.getRequestScheme();
        return scheme != null && scheme.equalsIgnoreCase(HTTPS);
    }

    public String getRequestMethod() {
        if (this.requestMethod == null) {
            return this.delegate.getRequestMethod();
        }
        return this.requestMethod;
    }

    public HttpServerExchange requestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public String getRequestScheme() {
        if (this.requestScheme == null) {
            return this.delegate.getRequestScheme();
        }
        return this.requestScheme;
    }

    public HttpServerExchange setRequestScheme(String requestScheme) {
        this.requestScheme = requestScheme;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String getRequestURI() {
        if (this.requestURI == null) {
            return this.delegate.getRequestURI();
        }
        return this.requestURI;
    }

    public HttpServerExchange setRequestURI(String requestURI) {
        this.requestURI = requestURI;
        return this;
    }

    public HttpServerExchange setRequestURI(String requestURI, boolean containsHost) {
        this.requestURI = requestURI;
        this.state = containsHost ? (this.state |= 0x10000) : (this.state &= 0xFFFEFFFF);
        return this;
    }

    public boolean isHostIncludedInRequestURI() {
        return Bits.anyAreSet(this.state, 65536);
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public HttpServerExchange setRequestPath(String requestPath) {
        this.requestPath = requestPath;
        return this;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public HttpServerExchange setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        return this;
    }

    public String getResolvedPath() {
        return this.resolvedPath;
    }

    public HttpServerExchange setResolvedPath(String resolvedPath) {
        this.resolvedPath = resolvedPath;
        return this;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public HttpServerExchange setQueryString(String queryString) {
        this.queryString = queryString;
        return this;
    }

    public String getRequestURL() {
        if (this.isHostIncludedInRequestURI()) {
            return this.getRequestURI();
        }
        return this.getRequestScheme() + "://" + this.getHostAndPort() + this.getRequestURI();
    }

    public long getRequestContentLength() {
        return this.delegate.getRequestContentLength();
    }

    public long getResponseContentLength() {
        return this.delegate.getResponseContentLength();
    }

    public String getHostName() {
        String host = this.getRequestHeader("Host");
        if (host == null) {
            host = this.getDestinationAddress().getHostString();
        } else if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        } else if (host.indexOf(58) != -1) {
            host = host.substring(0, host.indexOf(58));
        }
        return host;
    }

    public String getHostAndPort() {
        String host = this.getRequestHeader("Host");
        if (host == null) {
            InetSocketAddress address = this.getDestinationAddress();
            host = NetworkUtils.formatPossibleIpv6Address(address.getHostString());
            int port = address.getPort();
            if (!(this.getRequestScheme().equals("http") && port == 80 || this.getRequestScheme().equals(HTTPS) && port == 443)) {
                host = host + ":" + port;
            }
        }
        return host;
    }

    public HttpExchange getDelegate() {
        return this.delegate;
    }

    public int getHostPort() {
        String host = this.getRequestHeader("Host");
        if (host != null) {
            int colonIndex = host.startsWith("[") ? host.indexOf(58, host.indexOf(93)) : host.indexOf(58);
            if (colonIndex != -1) {
                try {
                    return Integer.parseInt(host.substring(colonIndex + 1));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (this.getRequestScheme().equals(HTTPS)) {
                return 443;
            }
            if (this.getRequestScheme().equals("http")) {
                return 80;
            }
        }
        return this.getDestinationAddress().getPort();
    }

    public boolean isPersistent() {
        return Bits.anyAreSet(this.state, 16384);
    }

    public boolean isInIoThread() {
        return this.getIoThread().inEventLoop();
    }

    public long getResponseBytesSent() {
        return this.delegate.getResponseBytesSent();
    }

    public HttpServerExchange setPersistent(boolean persistent) {
        this.state = persistent ? (this.state |= 0x4000) : (this.state &= 0xFFFFBFFF);
        return this;
    }

    public boolean isDispatched() {
        return Bits.anyAreSet(this.state, 32768);
    }

    public HttpServerExchange unDispatch() {
        this.state &= 0xFFFF7FFF;
        this.dispatchTask = null;
        return this;
    }

    public HttpServerExchange dispatch(Runnable runnable) {
        this.dispatch(null, runnable);
        return this;
    }

    public HttpServerExchange dispatch(Executor executor, Runnable runnable) {
        if (this.isExecutingHandlerChain()) {
            if (executor != null) {
                this.dispatchExecutor = executor;
            }
            this.state |= 0x8000;
            if (this.delegate.isIoOperationQueued()) {
                throw UndertowMessages.MESSAGES.resumedAndDispatched();
            }
            this.dispatchTask = runnable;
        } else if (executor == null) {
            this.delegate.getWorker().execute(runnable);
        } else {
            executor.execute(runnable);
        }
        return this;
    }

    boolean isExecutingHandlerChain() {
        return this.executingHandlerChain;
    }

    public HttpServerExchange dispatch(HttpHandler handler) {
        this.dispatch(null, handler);
        return this;
    }

    public HttpServerExchange dispatch(Executor executor, final HttpHandler handler) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Connectors.executeRootHandler(handler, HttpServerExchange.this);
            }
        };
        this.dispatch(executor, runnable);
        return this;
    }

    public HttpServerExchange setDispatchExecutor(Executor executor) {
        this.dispatchExecutor = executor == null ? null : executor;
        return this;
    }

    public Executor getDispatchExecutor() {
        return this.dispatchExecutor;
    }

    Runnable getDispatchTask() {
        return this.dispatchTask;
    }

    public HttpServerExchange addExchangeCompleteListener(ExchangeCompletionListener listener) {
        if (this.isComplete() || this.exchangeCompletionListenersCount == -1) {
            throw UndertowMessages.MESSAGES.exchangeAlreadyComplete();
        }
        int exchangeCompletionListenersCount = this.exchangeCompletionListenersCount++;
        ExchangeCompletionListener[] exchangeCompleteListeners = this.exchangeCompleteListeners;
        if (exchangeCompleteListeners == null || exchangeCompleteListeners.length == exchangeCompletionListenersCount) {
            ExchangeCompletionListener[] old = exchangeCompleteListeners;
            this.exchangeCompleteListeners = exchangeCompleteListeners = new ExchangeCompletionListener[exchangeCompletionListenersCount + 2];
            if (old != null) {
                System.arraycopy(old, 0, exchangeCompleteListeners, 0, exchangeCompletionListenersCount);
            }
        }
        exchangeCompleteListeners[exchangeCompletionListenersCount] = listener;
        return this;
    }

    public HttpServerExchange addDefaultResponseListener(DefaultResponseListener listener) {
        if (this.defaultResponseListeners == null) {
            this.defaultResponseListeners = new DefaultResponseListener[2];
        } else {
            int i;
            for (i = 0; i != this.defaultResponseListeners.length && this.defaultResponseListeners[i] != null; ++i) {
            }
            if (i == this.defaultResponseListeners.length) {
                DefaultResponseListener[] old = this.defaultResponseListeners;
                this.defaultResponseListeners = new DefaultResponseListener[this.defaultResponseListeners.length + 2];
                System.arraycopy(old, 0, this.defaultResponseListeners, 0, old.length);
            }
        }
        this.defaultResponseListeners[i] = listener;
        return this;
    }

    public InetSocketAddress getSourceAddress() {
        if (this.sourceAddress != null) {
            return this.sourceAddress;
        }
        return this.delegate.getSourceAddress();
    }

    public boolean isComplete() {
        return this.delegate.isComplete();
    }

    public boolean isRequestComplete() {
        return this.delegate.isRequestComplete();
    }

    public boolean isResponseComplete() {
        return this.delegate.isResponseComplete();
    }

    public HttpServerExchange setSourceAddress(InetSocketAddress sourceAddress) {
        this.sourceAddress = sourceAddress;
        return this;
    }

    public InetSocketAddress getDestinationAddress() {
        if (this.destinationAddress != null) {
            return this.destinationAddress;
        }
        return this.delegate.getDestinationAddress();
    }

    public HttpServerExchange setDestinationAddress(InetSocketAddress destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    public HttpServerExchange setResponseContentLength(long length) {
        if (length == -1L) {
            this.delegate.removeResponseHeader("Content-Length");
        } else {
            this.delegate.setResponseHeader("Content-Length", Long.toString(length));
        }
        return this;
    }

    public Map<String, Deque<String>> getQueryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        return this.queryParameters;
    }

    public HttpServerExchange addQueryParam(String name, String param) {
        Deque<String> list;
        if (this.queryParameters == null) {
            this.queryParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.queryParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.queryParameters.put(name, list);
        }
        list.add(param);
        return this;
    }

    public Map<String, Deque<String>> getPathParameters() {
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        return this.pathParameters;
    }

    public HttpServerExchange addPathParam(String name, String param) {
        Deque<String> list;
        if (this.pathParameters == null) {
            this.pathParameters = new TreeMap<String, Deque<String>>();
        }
        if ((list = this.pathParameters.get(name)) == null) {
            list = new ArrayDeque<String>(2);
            this.pathParameters.put(name, list);
        }
        list.add(param);
        return this;
    }

    public Map<String, Cookie> getRequestCookies() {
        if (this.requestCookies == null) {
            this.requestCookies = Cookies.parseRequestCookies((Integer)this.delegate.getUndertowOptions().get(UndertowOptions.MAX_COOKIES, (Object)200), this.delegate.getUndertowOptions().get(UndertowOptions.ALLOW_EQUALS_IN_COOKIE_VALUE, false), this.delegate.getRequestHeaders("Cookie"));
        }
        return this.requestCookies;
    }

    public HttpServerExchange setResponseCookie(Cookie cookie) {
        if (this.delegate.getUndertowOptions().get(UndertowOptions.ENABLE_RFC6265_COOKIE_VALIDATION, false)) {
            if (cookie.getValue() != null && !cookie.getValue().isEmpty()) {
                Rfc6265CookieSupport.validateCookieValue(cookie.getValue());
            }
            if (cookie.getPath() != null && !cookie.getPath().isEmpty()) {
                Rfc6265CookieSupport.validatePath(cookie.getPath());
            }
            if (cookie.getDomain() != null && !cookie.getDomain().isEmpty()) {
                Rfc6265CookieSupport.validateDomain(cookie.getDomain());
            }
        }
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        this.responseCookies.put(cookie.getName(), cookie);
        return this;
    }

    public Map<String, Cookie> getResponseCookies() {
        if (this.responseCookies == null) {
            this.responseCookies = new TreeMap<String, Cookie>();
        }
        return this.responseCookies;
    }

    Map<String, Cookie> getResponseCookiesInternal() {
        return this.responseCookies;
    }

    public boolean isResponseStarted() {
        return Bits.allAreSet(this.state, 1024);
    }

    public ByteBuf readBlocking() throws IOException {
        if (this.isRequestComplete()) {
            return null;
        }
        return this.delegate.getInputChannel().readBlocking();
    }

    public void send1ContinueIfRequired() {
        if (HttpContinue.requiresContinueResponse(this)) {
            this.delegate.sendContinue();
        }
    }

    public void writeAsync(String data) {
        this.writeAsync(Unpooled.copiedBuffer((CharSequence)data, (Charset)StandardCharsets.UTF_8), true, IoCallback.END_EXCHANGE, null);
    }

    public void writeAsync(String data, Charset charset) {
        this.writeAsync(Unpooled.copiedBuffer((CharSequence)data, (Charset)charset), true, IoCallback.END_EXCHANGE, null);
    }

    public <T> void writeAsync(String data, Charset charset, boolean last, IoCallback<T> callback, T context) {
        this.writeAsync(Unpooled.copiedBuffer((CharSequence)data, (Charset)charset), last, callback, context);
    }

    public <T> void writeAsync(ByteBuf data, boolean last, IoCallback<T> callback, T context) {
        if (data == null && !last) {
            throw new IllegalArgumentException("cannot call write with a null buffer and last being false");
        }
        if (this.isResponseComplete() || Bits.anyAreSet(this.state, 0x400000)) {
            if (last && data == null) {
                callback.onComplete(this.delegate, context);
                return;
            }
            callback.onException(this.delegate, context, new IOException(UndertowMessages.MESSAGES.responseComplete()));
            return;
        }
        if (last) {
            this.state |= 0x400000;
        }
        this.delegate.getOutputChannel().writeAsync(data, last, callback, context);
    }

    public void writeBlocking(ByteBuf data, boolean last) throws IOException {
        if (data == null && !last) {
            throw new IllegalArgumentException("cannot call write with a null buffer and last being false");
        }
        if (this.getIoThread().inEventLoop()) {
            throw UndertowMessages.MESSAGES.blockingIoFromIOThread();
        }
        if (this.isResponseComplete() || Bits.anyAreSet(this.state, 0x400000)) {
            if (last && data == null) {
                return;
            }
            throw UndertowMessages.MESSAGES.responseComplete();
        }
        if (last) {
            this.state |= 0x400000;
        }
        this.delegate.getOutputChannel().writeBlocking(data, last);
    }

    private void invokeExchangeCompleteListeners() {
        int count = this.exchangeCompletionListenersCount;
        this.exchangeCompletionListenersCount = -1;
        for (int i = count - 1; i >= 0; --i) {
            ExchangeCompletionListener next = this.exchangeCompleteListeners[i];
            next.exchangeEvent(this);
        }
    }

    public int getStatusCode() {
        return this.delegate.getStatusCode();
    }

    public String getRequestHeader(String name) {
        return this.delegate.getRequestHeader(name);
    }

    public List<String> getRequestHeaders(String name) {
        return this.delegate.getRequestHeaders(name);
    }

    public boolean containsRequestHeader(String name) {
        return this.delegate.containsRequestHeader(name);
    }

    public void removeRequestHeader(String name) {
        this.delegate.removeRequestHeader(name);
    }

    public void setRequestHeader(String name, String value) {
        this.delegate.setRequestHeader(name, value);
    }

    public Collection<String> getRequestHeaderNames() {
        return this.delegate.getRequestHeaderNames();
    }

    public void addRequestHeader(String name, String value) {
        this.delegate.addRequestHeader(name, value);
    }

    public void clearRequestHeaders() {
        this.delegate.clearRequestHeaders();
    }

    public void clearResponseHeaders() {
        this.delegate.clearResponseHeaders();
    }

    public String getResponseHeader(String name) {
        return this.delegate.getResponseHeader(name);
    }

    public List<String> getResponseHeaders(String name) {
        return this.delegate.getResponseHeaders(name);
    }

    public boolean containsResponseHeader(String name) {
        return this.delegate.containsResponseHeader(name);
    }

    public void removeResponseHeader(String name) {
        this.delegate.removeResponseHeader(name);
    }

    public void setResponseHeader(String name, String value) {
        this.delegate.setResponseHeader(name, value);
    }

    public Collection<String> getResponseHeaderNames() {
        return this.delegate.getResponseHeaderNames();
    }

    public void addResponseHeader(String name, String value) {
        this.delegate.addResponseHeader(name, value);
    }

    public HttpServerExchange setStatusCode(int statusCode) {
        if (statusCode < 0 || statusCode > 999) {
            throw new IllegalArgumentException("Invalid response code");
        }
        int oldVal = this.state;
        if (Bits.allAreSet(oldVal, 1024)) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        if (statusCode >= 500 && UndertowLogger.ERROR_RESPONSE.isDebugEnabled()) {
            UndertowLogger.ERROR_RESPONSE.debugf(new RuntimeException(), "Setting error code %s for exchange %s", statusCode, this);
        }
        this.delegate.setStatusCode(statusCode);
        return this;
    }

    public void startBlocking(BlockingHttpExchange httpExchange) {
        this.delegate.setBlockingHttpExchange(httpExchange);
    }

    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    public OutputStream getOutputStream() {
        return this.delegate.getOutputStream();
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    HttpServerExchange setRequestStartTime(long requestStartTime) {
        this.requestStartTime = requestStartTime;
        return this;
    }

    public HttpServerExchange endExchange() {
        if (this.defaultResponseListeners != null && !this.isResponseStarted()) {
            for (int i = this.defaultResponseListeners.length - 1; i >= 0; --i) {
                DefaultResponseListener listener = this.defaultResponseListeners[i];
                if (listener == null) continue;
                this.defaultResponseListeners[i] = null;
                try {
                    if (listener.handleDefaultResponse(this)) {
                        return this;
                    }
                    continue;
                }
                catch (Throwable e) {
                    UndertowLogger.REQUEST_LOGGER.debug("Exception running default response listener", e);
                }
            }
        }
        this.delegate.endExchange();
        return this;
    }

    public EventExecutor getIoThread() {
        return this.delegate.getIoThread();
    }

    public long getMaxEntitySize() {
        return this.maxEntitySize;
    }

    public HttpServerExchange setMaxEntitySize(long maxEntitySize) {
        if (Bits.anyAreSet(this.state, 0x100000)) {
            throw UndertowMessages.MESSAGES.requestChannelAlreadyProvided();
        }
        this.maxEntitySize = maxEntitySize;
        this.delegate.setMaxEntitySize(maxEntitySize);
        return this;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public void addResponseCommitListener(ResponseCommitListener listener) {
        if (this.isComplete() || this.responseCommitListenerCount == -1) {
            throw UndertowMessages.MESSAGES.responseAlreadyStarted();
        }
        int responseCommitListenerCount = this.responseCommitListenerCount++;
        ResponseCommitListener[] responseCommitListeners = this.responseCommitListeners;
        if (responseCommitListeners == null || responseCommitListeners.length == responseCommitListenerCount) {
            ResponseCommitListener[] old = responseCommitListeners;
            this.responseCommitListeners = responseCommitListeners = new ResponseCommitListener[responseCommitListenerCount + 2];
            if (old != null) {
                System.arraycopy(old, 0, responseCommitListeners, 0, responseCommitListenerCount);
            }
        }
        responseCommitListeners[responseCommitListenerCount] = listener;
    }

    public ByteBuf readAsync() throws IOException {
        return this.delegate.getInputChannel().readAsync();
    }

    public boolean isReadable() {
        return this.delegate.getInputChannel().isReadable();
    }

    public <T> void setReadHandler(BiConsumer<InputChannel, T> handler, T context) {
        this.delegate.getInputChannel().setReadHandler(handler, context);
    }

    public int readBytesAvailable() {
        return this.delegate.getInputChannel().readBytesAvailable();
    }

    public ByteBuf allocateBuffer() {
        return this.delegate.getBufferAllocator().allocateBuffer();
    }

    public ByteBuf allocateBuffer(boolean direct) {
        return this.delegate.getBufferAllocator().allocateBuffer(direct);
    }

    public ByteBuf allocateBuffer(int bufferSize) {
        return this.delegate.getBufferAllocator().allocateBuffer(bufferSize);
    }

    public ByteBuf allocateBuffer(boolean direct, int bufferSize) {
        return this.delegate.getBufferAllocator().allocateBuffer(direct, bufferSize);
    }

    public int getBufferSize() {
        return this.delegate.getBufferAllocator().getBufferSize();
    }

    public void discardRequest() {
        if (this.isRequestComplete()) {
            return;
        }
        this.delegate.discardRequest();
    }

    public HttpServerExchange upgradeChannel(Consumer<Object> listener) {
        if (!this.delegate.isUpgradeSupported()) {
            throw UndertowMessages.MESSAGES.upgradeNotSupported();
        }
        if (!this.delegate.containsRequestHeader("Upgrade")) {
            throw UndertowMessages.MESSAGES.notAnUpgradeRequest();
        }
        UndertowLogger.REQUEST_LOGGER.debugf("Upgrading request %s", this);
        this.setStatusCode(101);
        this.delegate.setResponseHeader("Connection", "Upgrade");
        this.delegate.setUpgradeListener(listener);
        return this;
    }

    public HttpServerExchange upgradeChannel(String productName, Consumer<Object> listener) {
        if (!this.delegate.isUpgradeSupported()) {
            throw UndertowMessages.MESSAGES.upgradeNotSupported();
        }
        UndertowLogger.REQUEST_LOGGER.debugf("Upgrading request %s", this);
        this.delegate.setUpgradeListener(listener);
        this.setStatusCode(101);
        this.delegate.setResponseHeader("Upgrade", productName);
        this.delegate.setResponseHeader("Connection", "Upgrade");
        return this;
    }

    public void resetRequestChannel() {
        this.state |= 0x200000;
    }

    public void setSslSessionInfo(SSLSessionInfo info) {
        this.sslSessionInfo = info;
    }

    public SSLSessionInfo getSslSessionInfo() {
        if (this.sslSessionInfo == null) {
            return this.delegate.getSslSessionInfo();
        }
        return this.sslSessionInfo;
    }

    public void close() {
        this.endExchange();
    }

    public Executor getWorker() {
        return this.delegate.getWorker();
    }

    public UndertowOptionMap getUndertowOptions() {
        return this.delegate.getUndertowOptions();
    }

    public boolean isPushSupported() {
        return this.delegate.isPushSupported();
    }

    public void pushResource(String path, String method, Map<String, List<String>> requestHeaders) {
        this.delegate.pushResource(path, method, requestHeaders);
    }

    public boolean isRequestTrailerFieldsSupported() {
        return this.delegate.isRequestTrailerFieldsSupported();
    }

    public void completed(HttpExchange exchange) {
        this.invokeExchangeCompleteListeners();
    }

    public void beginExecutingHandlerChain() {
        this.executingHandlerChain = true;
    }

    public void endExecutingHandlerChain() {
        this.executingHandlerChain = false;
    }

    public void runResumeReadWrite() {
    }

    public OutputChannel getOutputChannel() {
        return this;
    }

    public InputChannel getInputChannel() {
        return this;
    }

    public String toString() {
        return "HttpServerExchange{ " + this.getRequestMethod() + " " + this.getRequestURI() + " delegate " + this.delegate + '}';
    }

    public void preCommit(HttpExchange exchange) {
        for (int i = this.responseCommitListenerCount - 1; i >= 0; --i) {
            this.responseCommitListeners[i].beforeCommit(this);
        }
        this.state |= 0x400;
        Connectors.flattenCookies(this);
    }

    public void addWriteFunction(WriteFunction function) {
        this.delegate.addWriteFunction(function);
    }
}

