/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.undertow.UndertowLogger;
import io.undertow.UndertowMessages;
import io.undertow.httpcore.HttpHeaderNames;
import io.undertow.httpcore.InputChannel;
import io.undertow.httpcore.UndertowOptions;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.form.FormData;
import io.undertow.server.handlers.form.FormDataParser;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.server.handlers.form.MultipartParser;
import io.undertow.util.IoUtils;
import io.undertow.util.MalformedMessageException;
import io.undertow.util.SameThreadExecutor;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class MultiPartParserDefinition
implements FormParserFactory.ParserDefinition<MultiPartParserDefinition> {
    public static final String MULTIPART_FORM_DATA = "multipart/form-data";
    private Executor executor;
    private Path tempFileLocation;
    private String defaultEncoding = StandardCharsets.ISO_8859_1.displayName();
    private long maxIndividualFileSize = -1L;
    private long fileSizeThreshold;

    public MultiPartParserDefinition() {
        this.tempFileLocation = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    }

    public MultiPartParserDefinition(Path tempDir) {
        this.tempFileLocation = tempDir;
    }

    @Override
    public FormDataParser create(HttpServerExchange exchange) {
        String mimeType = exchange.getRequestHeader("Content-Type");
        if (mimeType != null && mimeType.startsWith(MULTIPART_FORM_DATA)) {
            String boundary = HttpHeaderNames.extractQuotedValueFromHeader((String)mimeType, (String)"boundary");
            if (boundary == null) {
                UndertowLogger.REQUEST_LOGGER.debugf("Could not find boundary in multipart request with ContentType: %s, multipart data will not be available", mimeType);
                return null;
            }
            final MultiPartUploadHandler parser = new MultiPartUploadHandler(exchange, boundary, this.maxIndividualFileSize, this.fileSizeThreshold, this.defaultEncoding);
            exchange.addExchangeCompleteListener(new ExchangeCompletionListener(){

                @Override
                public void exchangeEvent(HttpServerExchange exchange) {
                    IoUtils.safeClose((Closeable)parser);
                }
            });
            Long sizeLimit = (Long)exchange.getUndertowOptions().get(UndertowOptions.MULTIPART_MAX_ENTITY_SIZE);
            if (sizeLimit != null) {
                exchange.setMaxEntitySize(sizeLimit);
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Created multipart parser for %s", exchange);
            return parser;
        }
        return null;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public MultiPartParserDefinition setExecutor(Executor executor) {
        this.executor = executor;
        return this;
    }

    public Path getTempFileLocation() {
        return this.tempFileLocation;
    }

    public MultiPartParserDefinition setTempFileLocation(Path tempFileLocation) {
        this.tempFileLocation = tempFileLocation;
        return this;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public MultiPartParserDefinition setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
        return this;
    }

    public long getMaxIndividualFileSize() {
        return this.maxIndividualFileSize;
    }

    public void setMaxIndividualFileSize(long maxIndividualFileSize) {
        this.maxIndividualFileSize = maxIndividualFileSize;
    }

    public void setFileSizeThreshold(long fileSizeThreshold) {
        this.fileSizeThreshold = fileSizeThreshold;
    }

    public static class FileTooLargeException
    extends IOException {
        public FileTooLargeException() {
        }

        public FileTooLargeException(String message) {
            super(message);
        }

        public FileTooLargeException(String message, Throwable cause) {
            super(message, cause);
        }

        public FileTooLargeException(Throwable cause) {
            super(cause);
        }
    }

    private final class MultiPartUploadHandler
    implements FormDataParser,
    MultipartParser.PartHandler {
        private final HttpServerExchange exchange;
        private final FormData data;
        private final List<Path> createdFiles = new ArrayList<Path>();
        private final long maxIndividualFileSize;
        private final long fileSizeThreshold;
        private String defaultEncoding;
        private final ByteArrayOutputStream contentBytes = new ByteArrayOutputStream();
        private String currentName;
        private String fileName;
        private Path file;
        private FileChannel fileChannel;
        private HttpHeaders headers;
        private HttpHandler handler;
        private long currentFileSize;
        private final MultipartParser.ParseState parser;

        private MultiPartUploadHandler(HttpServerExchange exchange, String boundary, long maxIndividualFileSize, long fileSizeThreshold, String defaultEncoding) {
            String value;
            this.exchange = exchange;
            this.maxIndividualFileSize = maxIndividualFileSize;
            this.defaultEncoding = defaultEncoding;
            this.fileSizeThreshold = fileSizeThreshold;
            this.data = new FormData((Integer)exchange.getUndertowOptions().get(UndertowOptions.MAX_PARAMETERS, (Object)1000));
            String charset = defaultEncoding;
            String contentType = exchange.getRequestHeader("Content-Type");
            if (contentType != null && (value = HttpHeaderNames.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                charset = value;
            }
            this.parser = MultipartParser.beginParse(exchange, this, boundary.getBytes(StandardCharsets.US_ASCII), charset);
        }

        @Override
        public void parse(HttpHandler handler) throws Exception {
            if (this.exchange.getAttachment(FORM_DATA) != null) {
                handler.handleRequest(this.exchange);
                return;
            }
            this.handler = handler;
            NonBlockingParseTask task = MultiPartParserDefinition.this.executor == null ? new NonBlockingParseTask(this.exchange.getWorker()) : new NonBlockingParseTask(MultiPartParserDefinition.this.executor);
            this.exchange.dispatch(MultiPartParserDefinition.this.executor, task);
        }

        @Override
        public FormData parseBlocking() throws IOException {
            FormData existing = (FormData)this.exchange.getAttachment(FORM_DATA);
            if (existing != null) {
                return existing;
            }
            try {
                while (true) {
                    ByteBuf buf = this.exchange.readBlocking();
                    try {
                        if (buf == null) {
                            if (this.parser.isComplete()) break;
                            throw UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData();
                        }
                        this.parser.parse(buf);
                        continue;
                    }
                    finally {
                        if (buf == null) continue;
                        buf.release();
                        continue;
                    }
                    break;
                }
                this.exchange.putAttachment(FORM_DATA, this.data);
            }
            catch (MalformedMessageException e) {
                throw new IOException(e);
            }
            return (FormData)this.exchange.getAttachment(FORM_DATA);
        }

        @Override
        public void beginPart(HttpHeaders headers) {
            this.currentFileSize = 0L;
            this.headers = headers;
            String disposition = headers.get("Content-Disposition");
            if (disposition != null && disposition.startsWith("form-data")) {
                this.currentName = HttpHeaderNames.extractQuotedValueFromHeader((String)disposition, (String)"name");
                this.fileName = HttpHeaderNames.extractQuotedValueFromHeaderWithEncoding((String)disposition, (String)"filename");
                if (this.fileName != null && this.fileSizeThreshold == 0L) {
                    try {
                        this.file = MultiPartParserDefinition.this.tempFileLocation != null ? Files.createTempFile(MultiPartParserDefinition.this.tempFileLocation, "undertow", "upload", new FileAttribute[0]) : Files.createTempFile("undertow", "upload", new FileAttribute[0]);
                        this.createdFiles.add(this.file);
                        this.fileChannel = FileChannel.open(this.file, StandardOpenOption.READ, StandardOpenOption.WRITE);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }

        @Override
        public void data(ByteBuf buffer) throws IOException {
            this.currentFileSize += (long)buffer.readableBytes();
            if (this.maxIndividualFileSize > 0L && this.currentFileSize > this.maxIndividualFileSize) {
                throw UndertowMessages.MESSAGES.maxFileSizeExceeded(this.maxIndividualFileSize);
            }
            if (this.file == null && this.fileName != null && this.fileSizeThreshold < this.currentFileSize) {
                try {
                    this.file = MultiPartParserDefinition.this.tempFileLocation != null ? Files.createTempFile(MultiPartParserDefinition.this.tempFileLocation, "undertow", "upload", new FileAttribute[0]) : Files.createTempFile("undertow", "upload", new FileAttribute[0]);
                    this.createdFiles.add(this.file);
                    FileOutputStream fileOutputStream = new FileOutputStream(this.file.toFile());
                    this.contentBytes.writeTo(fileOutputStream);
                    this.fileChannel = fileOutputStream.getChannel();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.file == null) {
                while (buffer.isReadable()) {
                    this.contentBytes.write(0xFF & buffer.readByte());
                }
            } else {
                this.fileChannel.write(buffer.nioBuffer());
            }
        }

        @Override
        public void endPart() {
            if (this.file != null) {
                this.data.add(this.currentName, this.file, this.fileName, this.headers);
                this.file = null;
                this.contentBytes.reset();
                try {
                    this.fileChannel.close();
                    this.fileChannel = null;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.fileName != null) {
                this.data.add(this.currentName, Arrays.copyOf(this.contentBytes.toByteArray(), this.contentBytes.size()), this.fileName, this.headers);
                this.contentBytes.reset();
            } else {
                try {
                    String cs;
                    String charset = this.defaultEncoding;
                    String contentType = this.headers.get("Content-Type");
                    if (contentType != null && (cs = HttpHeaderNames.extractQuotedValueFromHeader((String)contentType, (String)"charset")) != null) {
                        charset = cs;
                    }
                    this.data.add(this.currentName, new String(this.contentBytes.toByteArray(), charset), this.headers);
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
                this.contentBytes.reset();
            }
        }

        public List<Path> getCreatedFiles() {
            return this.createdFiles;
        }

        @Override
        public void close() throws IOException {
            IoUtils.safeClose((Closeable)this.fileChannel);
            final ArrayList<Path> files = new ArrayList<Path>(this.getCreatedFiles());
            this.exchange.getWorker().execute(new Runnable(){

                @Override
                public void run() {
                    for (Path file : files) {
                        if (!Files.exists(file, new LinkOption[0])) continue;
                        try {
                            Files.delete(file);
                        }
                        catch (NoSuchFileException noSuchFileException) {
                        }
                        catch (IOException e) {
                            UndertowLogger.REQUEST_LOGGER.cannotRemoveUploadedFile(file);
                        }
                    }
                }
            });
        }

        @Override
        public void setCharacterEncoding(String encoding) {
            this.defaultEncoding = encoding;
            this.parser.setCharacterEncoding(encoding);
        }

        private final class NonBlockingParseTask
        implements BiConsumer<InputChannel, HttpServerExchange>,
        Runnable {
            private final Executor executor;

            private NonBlockingParseTask(Executor executor) {
                this.executor = executor;
            }

            @Override
            public void run() {
                while (MultiPartUploadHandler.this.exchange.isReadable()) {
                    try {
                        ByteBuf buffer = MultiPartUploadHandler.this.exchange.readAsync();
                        if (buffer == null) {
                            if (MultiPartUploadHandler.this.parser.isComplete()) {
                                MultiPartUploadHandler.this.exchange.putAttachment(FormDataParser.FORM_DATA, MultiPartUploadHandler.this.data);
                                MultiPartUploadHandler.this.exchange.dispatch(SameThreadExecutor.INSTANCE, MultiPartUploadHandler.this.handler);
                            } else {
                                UndertowLogger.REQUEST_IO_LOGGER.ioException(UndertowMessages.MESSAGES.connectionTerminatedReadingMultiPartData());
                                MultiPartUploadHandler.this.exchange.setStatusCode(500);
                                MultiPartUploadHandler.this.exchange.endExchange();
                            }
                            return;
                        }
                        MultiPartUploadHandler.this.parser.parse(buffer);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        MultiPartUploadHandler.this.exchange.setStatusCode(500);
                        MultiPartUploadHandler.this.exchange.endExchange();
                    }
                }
                MultiPartUploadHandler.this.exchange.setReadHandler(this, MultiPartUploadHandler.this.exchange);
            }

            @Override
            public void accept(InputChannel input, HttpServerExchange exchange) {
                exchange.dispatch(this.executor, this);
            }
        }
    }
}

