/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.form;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.undertow.httpcore.BufferAllocator;
import io.undertow.util.FlexBase64;
import io.undertow.util.MalformedMessageException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class MultipartParser {
    public static final byte HTAB = 9;
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte SP = 32;
    public static final byte DASH = 45;
    private static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};

    public static ParseState beginParse(BufferAllocator bufferPool, PartHandler handler, byte[] boundary, String requestCharset) {
        byte[] boundaryToken = new byte[boundary.length + BOUNDARY_PREFIX.length];
        System.arraycopy(BOUNDARY_PREFIX, 0, boundaryToken, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(boundary, 0, boundaryToken, BOUNDARY_PREFIX.length, boundary.length);
        return new ParseState(bufferPool, handler, requestCharset, boundaryToken);
    }

    private static class QuotedPrintableEncoding
    implements Encoding {
        private final BufferAllocator bufferPool;
        boolean equalsSeen;
        byte firstCharacter;

        private QuotedPrintableEncoding(BufferAllocator bufferPool) {
            this.bufferPool = bufferPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuf rawData) throws IOException {
            boolean equalsSeen = this.equalsSeen;
            byte firstCharacter = this.firstCharacter;
            ByteBuf buf = this.bufferPool.allocateBuffer();
            try {
                while (rawData.isReadable()) {
                    byte b = rawData.readByte();
                    if (equalsSeen) {
                        if (firstCharacter == 0) {
                            if (b == 10 || b == 13) {
                                equalsSeen = false;
                                continue;
                            }
                            firstCharacter = b;
                            continue;
                        }
                        int result = Character.digit((char)firstCharacter, 16);
                        result <<= 4;
                        buf.writeByte((int)((byte)(result += Character.digit((char)b, 16))));
                        equalsSeen = false;
                        firstCharacter = 0;
                        continue;
                    }
                    if (b == 61) {
                        equalsSeen = true;
                        continue;
                    }
                    buf.writeByte((int)b);
                    if (buf.isWritable()) continue;
                    handler.data(buf);
                    buf.clear();
                }
                handler.data(buf);
            }
            finally {
                buf.release();
                this.equalsSeen = equalsSeen;
                this.firstCharacter = firstCharacter;
            }
        }
    }

    private static class Base64Encoding
    implements Encoding {
        private final FlexBase64.Decoder decoder = FlexBase64.createDecoder();
        private final BufferAllocator bufferPool;

        private Base64Encoding(BufferAllocator bufferPool) {
            this.bufferPool = bufferPool;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(PartHandler handler, ByteBuf rawData) throws IOException {
            ByteBuf buf = this.bufferPool.allocateBuffer();
            try {
                do {
                    buf.clear();
                    try {
                        this.decoder.decode(rawData, buf);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    handler.data(buf);
                } while (rawData.isReadable());
            }
            finally {
                buf.release();
            }
        }
    }

    private static class IdentityEncoding
    implements Encoding {
        private IdentityEncoding() {
        }

        @Override
        public void handle(PartHandler handler, ByteBuf rawData) throws IOException {
            handler.data(rawData);
            rawData.clear();
        }
    }

    private static interface Encoding {
        public void handle(PartHandler var1, ByteBuf var2) throws IOException;
    }

    public static class ParseState {
        private final BufferAllocator bufferPool;
        private final PartHandler partHandler;
        private String requestCharset;
        private final byte[] boundary;
        private int state = 0;
        private int subState = Integer.MAX_VALUE;
        private ByteArrayOutputStream currentString = null;
        private String currentHeaderName = null;
        private HttpHeaders headers;
        private Encoding encodingHandler;

        public ParseState(BufferAllocator bufferPool, PartHandler partHandler, String requestCharset, byte[] boundary) {
            this.bufferPool = bufferPool;
            this.partHandler = partHandler;
            this.requestCharset = requestCharset;
            this.boundary = boundary;
        }

        public void setCharacterEncoding(String encoding) {
            this.requestCharset = encoding;
        }

        public void parse(ByteBuf buffer) throws IOException {
            block7: while (buffer.isReadable()) {
                switch (this.state) {
                    case 0: {
                        this.preamble(buffer);
                        continue block7;
                    }
                    case 1: {
                        this.headerName(buffer);
                        continue block7;
                    }
                    case 2: {
                        this.headerValue(buffer);
                        continue block7;
                    }
                    case 3: {
                        this.entity(buffer);
                        continue block7;
                    }
                    case -1: {
                        return;
                    }
                }
                throw new IllegalStateException("" + this.state);
            }
        }

        private void preamble(ByteBuf buffer) {
            while (buffer.isReadable()) {
                byte b = buffer.readByte();
                if (this.subState >= 0) {
                    if (this.subState == Integer.MAX_VALUE) {
                        this.subState = this.boundary[2] == b ? 2 : 0;
                    }
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        this.subState = 1;
                        continue;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b != 13) continue;
                    this.subState = -2;
                    continue;
                }
                if (this.subState != -2) continue;
                if (b == 10) {
                    this.subState = 0;
                    this.state = 1;
                    this.headers = new DefaultHttpHeaders();
                    return;
                }
                this.subState = -1;
            }
        }

        private void headerName(ByteBuf buffer) throws MalformedMessageException, UnsupportedEncodingException {
            while (buffer.isReadable()) {
                byte b = buffer.readByte();
                if (b == 58) {
                    if (this.currentString == null || this.subState != 0) {
                        throw new MalformedMessageException();
                    }
                    this.currentHeaderName = new String(this.currentString.toByteArray(), this.requestCharset);
                    this.currentString.reset();
                    this.subState = 0;
                    this.state = 2;
                    return;
                }
                if (b == 13) {
                    if (this.currentString != null) {
                        throw new MalformedMessageException();
                    }
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.currentString != null || this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.state = 3;
                    this.subState = 0;
                    this.partHandler.beginPart(this.headers);
                    String encoding = this.headers.get("Content-Transfer-Encoding");
                    this.encodingHandler = encoding == null ? new IdentityEncoding() : (encoding.equalsIgnoreCase("base64") ? new Base64Encoding(this.bufferPool) : (encoding.equalsIgnoreCase("quoted-printable") ? new QuotedPrintableEncoding(this.bufferPool) : new IdentityEncoding()));
                    this.headers = null;
                    return;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                if (this.currentString == null) {
                    this.currentString = new ByteArrayOutputStream();
                }
                this.currentString.write(b);
            }
        }

        private void headerValue(ByteBuf buffer) throws MalformedMessageException, UnsupportedEncodingException {
            while (buffer.isReadable()) {
                byte b = buffer.readByte();
                if (this.subState == 2) {
                    if (b == 13) {
                        this.headers.set(this.currentHeaderName.trim(), (Object)new String(this.currentString.toByteArray(), this.requestCharset).trim());
                        this.state = 1;
                        this.subState = 1;
                        this.currentString = null;
                        return;
                    }
                    if (b == 32 || b == 9) {
                        this.currentString.write(b);
                        this.subState = 0;
                        continue;
                    }
                    this.headers.set(this.currentHeaderName.trim(), (Object)new String(this.currentString.toByteArray(), this.requestCharset).trim());
                    this.state = 1;
                    this.subState = 0;
                    this.currentString = new ByteArrayOutputStream();
                    this.currentString.write(b);
                    return;
                }
                if (b == 13) {
                    this.subState = 1;
                    continue;
                }
                if (b == 10) {
                    if (this.subState != 1) {
                        throw new MalformedMessageException();
                    }
                    this.subState = 2;
                    continue;
                }
                if (this.subState != 0) {
                    throw new MalformedMessageException();
                }
                this.currentString.write(b);
            }
        }

        private void entity(ByteBuf buffer) throws IOException {
            int startingSubState = this.subState;
            int pos = buffer.readerIndex();
            while (buffer.isReadable()) {
                byte b = buffer.readByte();
                if (this.subState >= 0) {
                    if (b == this.boundary[this.subState]) {
                        ++this.subState;
                        if (this.subState != this.boundary.length) continue;
                        startingSubState = 0;
                        ByteBuf retBuffer = buffer.slice(pos, Math.max(buffer.readerIndex() - pos - this.boundary.length, 0));
                        this.encodingHandler.handle(this.partHandler, retBuffer);
                        this.partHandler.endPart();
                        this.subState = -1;
                        continue;
                    }
                    if (b == this.boundary[0]) {
                        if (startingSubState > 0) {
                            this.encodingHandler.handle(this.partHandler, Unpooled.wrappedBuffer((byte[])this.boundary, (int)0, (int)startingSubState));
                            startingSubState = 0;
                        }
                        this.subState = 1;
                        continue;
                    }
                    if (startingSubState > 0) {
                        this.encodingHandler.handle(this.partHandler, Unpooled.wrappedBuffer((byte[])this.boundary, (int)0, (int)startingSubState));
                        startingSubState = 0;
                    }
                    this.subState = 0;
                    continue;
                }
                if (this.subState == -1) {
                    if (b == 13) {
                        this.subState = -2;
                        continue;
                    }
                    if (b != 45) continue;
                    this.subState = -3;
                    continue;
                }
                if (this.subState == -2) {
                    if (b == 10) {
                        this.subState = 0;
                        this.state = 1;
                        this.headers = new DefaultHttpHeaders();
                        return;
                    }
                    if (b == 45) {
                        this.subState = -3;
                        continue;
                    }
                    this.subState = -1;
                    continue;
                }
                if (this.subState != -3) continue;
                if (b == 45) {
                    this.state = -1;
                    return;
                }
                this.subState = -1;
            }
            ByteBuf retBuffer = buffer.slice(pos, buffer.readerIndex() - pos);
            if (this.subState == 0) {
                this.encodingHandler.handle(this.partHandler, retBuffer);
            } else if (retBuffer.readableBytes() > this.subState && this.subState > 0) {
                retBuffer.writerIndex(retBuffer.writerIndex() - this.subState);
                this.encodingHandler.handle(this.partHandler, retBuffer);
            }
        }

        public boolean isComplete() {
            return this.state == -1;
        }
    }

    public static interface PartHandler {
        public void beginPart(HttpHeaders var1);

        public void data(ByteBuf var1) throws IOException;

        public void endPart();
    }
}

