/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.utilities.MojoUtils;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoExecutionException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CreateUtils {
    public static final String GRADLE_WRAPPER_PATH = "gradle-wrapper";
    public static final String[] GRADLE_WRAPPER_FILES = new String[]{"gradlew", "gradlew.bat", "gradle/wrapper/gradle-wrapper.properties", "gradle/wrapper/gradle-wrapper.jar"};

    private CreateUtils() {
    }

    public static String getDerivedPath(String className) {
        String[] resourceClassName = StringUtils.splitByCharacterTypeCamelCase((String)className.substring(className.lastIndexOf(".") + 1));
        return "/" + resourceClassName[0].toLowerCase();
    }

    public static Plugin resolvePluginInfo(Class<?> cls) throws MojoExecutionException {
        Plugin plugin;
        block9: {
            Path classOrigin = MojoUtils.getClassOrigin(cls);
            if (Files.isDirectory(classOrigin, new LinkOption[0])) {
                return CreateUtils.resolvePluginInfo(classOrigin.resolve("META-INF").resolve("maven").resolve("plugin.xml"));
            }
            FileSystem fs = ZipUtils.newFileSystem((Path)classOrigin);
            try {
                plugin = CreateUtils.resolvePluginInfo(fs.getPath("META-INF", "maven", "plugin.xml"));
                if (fs == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("Failed to resolve maven plugin version containing " + cls, e);
                }
            }
            fs.close();
        }
        return plugin;
    }

    private static Plugin resolvePluginInfo(Path pluginXml) throws MojoExecutionException {
        Plugin plugin;
        block9: {
            if (!Files.exists(pluginXml, new LinkOption[0])) {
                throw new MojoExecutionException("Failed to locate " + pluginXml);
            }
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputStream is = Files.newInputStream(pluginXml, new OpenOption[0]);
            try {
                Document doc = db.parse(is);
                Node pluginNode = CreateUtils.getElement(doc.getChildNodes(), "plugin");
                Plugin plugin2 = new Plugin();
                plugin2.setGroupId(CreateUtils.getChildElementTextValue(pluginNode, "groupId"));
                plugin2.setArtifactId(CreateUtils.getChildElementTextValue(pluginNode, "artifactId"));
                plugin2.setVersion(CreateUtils.getChildElementTextValue(pluginNode, "version"));
                plugin = plugin2;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    throw new MojoExecutionException("Failed to parse " + pluginXml, t);
                }
            }
            is.close();
        }
        return plugin;
    }

    private static String getChildElementTextValue(Node parentNode, String childName) throws MojoExecutionException {
        Node node = CreateUtils.getElement(parentNode.getChildNodes(), childName);
        String text = CreateUtils.getText(node);
        if (text.isEmpty()) {
            throw new MojoExecutionException("The " + parentNode.getNodeName() + " element description is missing child " + childName);
        }
        return text;
    }

    private static Node getElement(NodeList nodeList, String name) throws MojoExecutionException {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node item = nodeList.item(i);
            if (item.getNodeType() != 1 || !name.equals(item.getNodeName()) && !name.equals(item.getLocalName())) continue;
            return item;
        }
        throw new MojoExecutionException("Failed to locate element " + name);
    }

    private static String getText(Node node) {
        if (!node.hasChildNodes()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        NodeList list = node.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subnode = list.item(i);
            if (subnode.getNodeType() == 3) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() == 4) {
                result.append(subnode.getNodeValue());
                continue;
            }
            if (subnode.getNodeType() != 5) continue;
            result.append(CreateUtils.getText(subnode));
        }
        return result.toString();
    }
}

