/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBundleBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeBuild;
import io.quarkus.runtime.LocalesBuildTimeConfig;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Locale;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class LocaleProcessor {
    private static final Logger log = Logger.getLogger(LocaleProcessor.class);
    public static final String DEPRECATED_USER_LANGUAGE_WARNING = "Your application is setting the deprecated 'quarkus.native.user-language' configuration property. Please, consider using only 'quarkus.default-locale' configuration property instead.";
    public static final String DEPRECATED_USER_COUNTRY_WARNING = "Your application is setting the deprecated 'quarkus.native.user-country' configuration property. Please, consider using only 'quarkus.default-locale' configuration property instead.";

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    void nativeResources(BuildProducer<NativeImageResourceBundleBuildItem> resources) {
        resources.produce(new NativeImageResourceBundleBuildItem("sun.util.resources.LocaleNames"));
        resources.produce(new NativeImageResourceBundleBuildItem("sun.util.resources.CurrencyNames"));
    }

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    ReflectiveClassBuildItem setupReflectionClasses() {
        return new ReflectiveClassBuildItem(false, false, "sun.util.resources.provider.SupplementaryLocaleDataProvider", "sun.util.resources.provider.LocaleDataProvider");
    }

    @BuildStep(onlyIf={NativeBuild.class, NonDefaultLocale.class})
    void servicesResource(BuildProducer<NativeImageResourceBuildItem> nativeImageResources, BuildProducer<GeneratedResourceBuildItem> generatedResources) {
        String r1 = "META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider";
        String r2 = "META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider";
        nativeImageResources.produce(new NativeImageResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider", "META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider"));
        generatedResources.produce(new GeneratedResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$SupplementaryResourceBundleProvider", "sun.util.resources.provider.SupplementaryLocaleDataProvider".getBytes(StandardCharsets.UTF_8)));
        generatedResources.produce(new GeneratedResourceBuildItem("META-INF/services/sun.util.resources.LocaleData$CommonResourceBundleProvider", "sun.util.resources.provider.LocaleDataProvider".getBytes(StandardCharsets.UTF_8)));
    }

    public static String nativeImageUserLanguage(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        String language = localesBuildTimeConfig.defaultLocale.getLanguage();
        if (nativeConfig.userLanguage.isPresent()) {
            log.warn((Object)DEPRECATED_USER_LANGUAGE_WARNING);
            language = nativeConfig.userLanguage.get();
        }
        return language;
    }

    public static String nativeImageUserCountry(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        String country = localesBuildTimeConfig.defaultLocale.getCountry();
        if (nativeConfig.userCountry.isPresent()) {
            log.warn((Object)DEPRECATED_USER_COUNTRY_WARNING);
            country = nativeConfig.userCountry.get();
        }
        return country;
    }

    public static String nativeImageIncludeLocales(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
        HashSet additionalLocales = new HashSet(localesBuildTimeConfig.locales);
        additionalLocales.remove(localesBuildTimeConfig.defaultLocale);
        if (nativeConfig.userCountry.isPresent() && nativeConfig.userLanguage.isPresent()) {
            additionalLocales.remove(new Locale(nativeConfig.userLanguage.get(), nativeConfig.userCountry.get()));
        } else if (nativeConfig.userLanguage.isPresent()) {
            additionalLocales.remove(new Locale(nativeConfig.userLanguage.get()));
        }
        return additionalLocales.stream().filter(l -> !Locale.getDefault().equals(l)).map(l -> l.getLanguage() + (String)(l.getCountry().isEmpty() ? "" : "-" + l.getCountry())).collect(Collectors.joining(","));
    }

    static final class NonDefaultLocale
    implements BooleanSupplier {
        private final NativeConfig nativeConfig;
        private final LocalesBuildTimeConfig localesBuildTimeConfig;

        public NonDefaultLocale(NativeConfig nativeConfig, LocalesBuildTimeConfig localesBuildTimeConfig) {
            this.nativeConfig = nativeConfig;
            this.localesBuildTimeConfig = localesBuildTimeConfig;
        }

        @Override
        public boolean getAsBoolean() {
            return this.nativeConfig.userLanguage.isPresent() && !Locale.getDefault().getLanguage().equals(this.nativeConfig.userLanguage.get()) || this.nativeConfig.userCountry.isPresent() && !Locale.getDefault().getCountry().equals(this.nativeConfig.userCountry.get()) || !Locale.getDefault().equals(this.localesBuildTimeConfig.defaultLocale) || this.localesBuildTimeConfig.locales.stream().anyMatch(l -> !Locale.getDefault().equals(l));
        }
    }
}

